<?php
 /**
 * Jamroom Like It module
 *
 * copyright 2021 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * quota_config
 */
function jrLike_quota_config()
{
    // Allow Self Likings
    $_tmp = array(
        'name'     => 'allow_self_likings',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'label'    => 'Allow Self Likings',
        'help'     => 'Allow users in this quota to like/dislike their own items.',
        'default'  => 'on',
        'section'  => 'permissions',
        'order'    => 1
    );
    jrProfile_register_quota_setting('jrLike', $_tmp);

    // Show like/dislike on Item Detail pages
    $_tmp = array(
        'name'     => 'show_detail',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'Show on Detail Pages',
        'help'     => 'If this option is checked, a like/dislike section will show at the bottom of Item Detail Pages for profiles in this quota.',
        'section'  => 'permissions',
        'order'    => 2
    );
    jrProfile_register_quota_setting('jrLike', $_tmp);
    return true;
}
