<?php
 /**
 * Jamroom Like It module
 *
 * copyright 2021 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

//----------------------------------
// get_like_users
//----------------------------------
function view_jrLike_get_like_users($_post, $_user, $_conf)
{
    jrCore_validate_location_url();
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        return 'error: invalid module';
    }
    if (!isset($_post['i']) || !jrCore_checktype($_post['i'], 'number_nz')) {
        return 'error: invalid item_id';
    }
    if (!isset($_post['t']) || ($_post['t'] != 'like' && $_post['t'] != 'dislike')) {
        return 'error: invalid type';
    }
    $mod = jrCore_db_escape($_post['m']);
    $iid = (int) $_post['i'];
    $tbl = jrCore_db_table_name('jrLike', 'likes');
    $req = "SELECT like_user_id FROM {$tbl}
             WHERE like_item_id = {$iid}
               AND like_module = '{$mod}'
               AND like_action = '{$_post['t']}'
             ORDER BY like_id DESC";
    $_rt = jrCore_db_query($req, 'like_user_id', false, 'like_user_id');
    $cnt = count($_rt);
    if ($_rt && is_array($_rt)) {
        $_ln = jrUser_load_lang_strings();
        $_sp = array(
            'search'                 => array(
                '_item_id in ' . implode(',', $_rt)
            ),
            'include_jrProfile_keys' => true,
            'limit'                  => $cnt
        );
        $_rt = jrCore_db_search_items('jrUser', $_sp);
        if ($_post['t'] == 'like') {
            $_rt['_params']['action'] = $_ln['jrLike'][8];
        }
        else {
            $_rt['_params']['action'] = $_ln['jrLike'][9];
        }
        $_rt['likers_count'] = $cnt;
        return jrCore_parse_template('likers.tpl', $_rt, 'jrLike');
    }
    return jrCore_parse_template('likers.tpl', array(), 'jrLike');
}

//------------------------------
// (dis)liked_items
//------------------------------
function view_jrLike_liked_items($_post, $_user, $_conf)
{
    // Must be logged
    jrUser_session_require_login();
    jrUser_check_quota_access('jrLike');
    $_ln = jrUser_load_lang_strings();

    // Banner
    jrCore_page_banner(10);

    // Get all items liked
    $uid = (int) $_user['_user_id'];
    $tbl = jrCore_db_table_name('jrLike', 'likes');
    $req = "SELECT like_item_id AS i, like_module AS m FROM {$tbl}
             WHERE like_user_id = {$uid}
               AND like_action != 'neutral'
             ORDER BY like_id DESC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if ($_rt && is_array($_rt)) {

        // Sort likes into module groups
        $_likes = array();
        foreach ($_rt as $rt) {
            if (!jrCore_module_is_active($rt['m'])) {
                continue;
            }
            if (!isset($_likes["{$rt['m']}"])) {
                $_likes["{$rt['m']}"] = array();
            }
            $_likes["{$rt['m']}"][] = (int) $rt['i'];
        }
        unset($_rt);
        ksort($_likes);
        if (!isset($_post['_1']) || !jrCore_module_is_active($_post['_1'])) {
            $_post['_1'] = jrCore_get_config_value('jrLike', 'like_default', 'jrBlog');
        }
        if (!isset($_likes["{$_post['_1']}"])) {
            $tmp         = array_keys($_likes);
            $_post['_1'] = reset($tmp);
        }

        // Tab Bar
        $_tabs = array();
        foreach ($_likes as $mod => $_v) {
            if (!empty($_ln[$mod]['menu'])) {
                $md = ucfirst($_ln[$mod]['menu']);
            }
            else {
                $_mta = jrCore_module_meta_data($mod);
                $md   = $_mta['name'];
            }
            if (!isset($_tabs[$mod])) {
                $_tabs[$mod] = array();
            }
            $_tabs[$mod]['label'] = $md;
            $_tabs[$mod]['url']   = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/liked_items/{$mod}";
        }
        $_tabs["{$_post['_1']}"]['active'] = true;
        jrCore_page_tab_bar($_tabs);

        if (isset($_post['_1']) && jrCore_module_is_active($_post['_1'])) {
            // We are just showing likes for a specific module
            $tpl = 'item_list.tpl';
            if ($_post['_1'] == 'jrGallery') {
                $tpl = 'item_image_list.tpl';
            }
            if (isset($_likes["{$_post['_1']}"])) {
                $_s = array(
                    "search"    => array(
                        '_item_id in ' . implode(',', $_likes["{$_post['_1']}"])
                    ),
                    'page'      => (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) ? intval($_post['p']) : 1,
                    'pagebreak' => 12
                );
                if ($_post['_1'] == 'jrForum') {
                    $_s['quota_check'] = false;
                }
                $_rt  = jrCore_db_search_items($_post['_1'], $_s);
                $html = jrCore_parse_template($tpl, $_rt, $_post['_1']);
                $html .= jrCore_parse_template('list_pager.tpl', $_rt, 'jrCore');
                jrCore_page_custom($html);
            }
        }
    }
    else {
        jrCore_page_note($_ln['jrLike'][11]);
    }
    jrCore_page_display();
}

//------------------------------
// Rebuild Counts
//------------------------------
function view_jrLike_rebuild_counts($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrLike');
    jrCore_page_banner('Rebuild Counts');

    // Form init
    $_tmp = array(
        'submit_value'  => 'Rebuild Counts',
        'cancel'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'submit_prompt' => 'Rebuild like and dislike counts?',
        'submit_modal'  => 'update',
        'modal_width'   => 600,
        'modal_height'  => 400,
        'modal_note'    => 'Please be patient while the counts are rebuilt'
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'  => 'dummy',
        'value' => 'off',
        'type'  => 'hidden'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_note("The <b>Rebuild Counts</b> tool rebuilds like and dislike counts based the on the existing Like database.<br>If you think that like and dislike variables may have be &quot;out of sync&quot; this tool may help.<br>Note: on large systems this could take some time to run - please be patient");
    jrCore_page_display();
}

//------------------------------
// Rebuild Counts Save
//------------------------------
function view_jrLike_rebuild_counts_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    @ini_set('max_execution_time', 86400); // 24 hours max
    @ini_set('memory_limit', '2048M');
    jrCore_logger('INF', 'rebuild of like counts started');

    // First up - get ALL datastore modules and reset ALL like and dislike keys
    jrCore_form_modal_notice('update', "deleting existing like and dislike counts...");
    $_mds = jrCore_get_datastore_modules();
    foreach ($_mds as $mod => $pfx) {
        $tbl = jrCore_db_table_name($mod, 'item_key');
        $req = "DELETE FROM {$tbl} WHERE `key` IN('{$pfx}_like_count','{$pfx}_dislike_count')";
        $cnt = jrCore_db_query($req, 'COUNT');
        if ($cnt > 0) {
            jrCore_form_modal_notice('update', "deleted " . jrCore_number_format($cnt) . " existing like counts for: " . $_mods[$mod]['module_name']);
        }
    }

    // User counts
    $tbl = jrCore_db_table_name('jrUser', 'item_key');
    $req = "DELETE FROM {$tbl} WHERE `key` LIKE 'user_jrLike_%'";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt > 0) {
        jrCore_form_modal_notice('update', "deleted " . jrCore_number_format($cnt) . " like counts for: " . $_mods['jrUser']['module_name']);
    }

    // Profile Counts
    $tbl = jrCore_db_table_name('jrProfile', 'item_key');
    $req = "DELETE FROM {$tbl} WHERE `key` LIKE 'profile_jrLike_%'";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt > 0) {
        jrCore_form_modal_notice('update', "deleted " . jrCore_number_format($cnt) . " like counts for: " . $_mods['jrProfile']['module_name']);
    }

    // Process Like DB
    $ttl = 0;
    $lid = 0;
    while (true) {

        $tbl = jrCore_db_table_name('jrLike', 'likes');
        $req = "SELECT * FROM {$tbl} WHERE like_id > {$lid} ORDER BY like_id ASC LIMIT 500";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt) && count($_rt) > 0) {

            // First - we need to get all PROFILE_IDs for the liked items
            $_pr = array();
            $_us = array();
            foreach ($_rt as $rt) {
                $lid = (int) $rt['like_id'];
                $iid = (int) $rt['like_item_id'];
                if ($iid > 0) {
                    $mod = $rt['like_module'];
                    if (!isset($_pr[$mod])) {
                        $_pr[$mod] = array();
                    }
                    $_pr[$mod][$iid] = $iid;

                    $uid       = (int) $rt['like_user_id'];
                    $_us[$uid] = $uid;
                }
            }
            if (count($_pr) > 0) {
                foreach ($_pr as $mod => $_ids) {
                    $_pr[$mod] = jrCore_db_get_multiple_items($mod, $_ids, array('_profile_id'), true, '_item_id');
                }
            }
            if (count($_us) > 0) {
                $_us = jrCore_db_get_multiple_items('jrUser', $_us, array('_profile_id'), true, '_item_id');
            }

            $_u = array();
            $_p = array();
            $_i = array();
            foreach ($_rt as $rt) {

                $act = $rt['like_action'];
                if ($act == 'like' || $act == 'dislike') {

                    $mod = $rt['like_module'];
                    $iid = $rt['like_item_id'];
                    $uid = $rt['like_user_id'];

                    // User counts (the total number of likes/dislikes a user has made)
                    if (!isset($_u["user_jrLike_{$act}_count"])) {
                        $_u["user_jrLike_{$act}_count"] = array();
                    }
                    if (!isset($_u["user_jrLike_{$act}_count"][$uid])) {
                        $_u["user_jrLike_{$act}_count"][$uid] = 0;
                    }
                    $_u["user_jrLike_{$act}_count"][$uid]++;

                    // Profile counts (number of likes/dislikes on profile items)
                    if (!empty($_pr[$mod][$iid]['_profile_id'])) {
                        $pid = (int) $_pr[$mod][$iid]['_profile_id'];
                        if (!isset($_p["profile_jrLike_{$act}_home_item_count"])) {
                            $_p["profile_jrLike_{$act}_home_item_count"] = array();
                        }
                        if (!isset($_p["profile_jrLike_{$act}_home_item_count"][$pid])) {
                            $_p["profile_jrLike_{$act}_home_item_count"][$pid] = 0;
                        }
                        $_p["profile_jrLike_{$act}_home_item_count"][$pid]++;
                    }

                    // Item counts - like counts on actual ITEM in DS
                    if ($pfx = jrCore_db_get_prefix($mod)) {
                        if (!isset($_i[$mod])) {
                            $_i[$mod] = array();
                        }
                        if (!isset($_i[$mod][$iid])) {
                            $_i[$mod][$iid] = array();
                        }
                        if (!isset($_i[$mod][$iid]["{$pfx}_{$act}_count"])) {
                            $_i[$mod][$iid]["{$pfx}_{$act}_count"] = 0;
                        }
                        $_i[$mod][$iid]["{$pfx}_{$act}_count"]++;
                    }
                    $ttl++;
                }
            }

            // Update user counts
            if (count($_u) > 0) {
                $_in = array();
                foreach ($_u as $key => $_counts) {
                    foreach ($_counts as $uid => $count) {
                        $pid = 0;
                        if (!empty($_us[$uid]['_profile_id'])) {
                            $pid = (int) $_us[$uid]['_profile_id'];
                        }
                        $_in[] = "({$uid},{$pid},'{$key}',0,'{$count}')";
                    }
                }
                if (count($_in) > 0) {
                    $tbl = jrCore_db_table_name('jrUser', 'item_key');
                    $req = "INSERT INTO {$tbl} (`_item_id`, `_profile_id`, `key`, `index`, `value`) VALUES " . implode(',', $_in) . " ON DUPLICATE KEY UPDATE `value` = (`value` + VALUES(`value`))";
                    jrCore_db_query($req);
                }
            }

            // Update profile counts
            if (count($_p) > 0) {
                $_in = array();
                foreach ($_p as $key => $_counts) {
                    foreach ($_counts as $pid => $count) {
                        $_in[] = "({$pid},{$pid},'{$key}',0,'{$count}')";
                    }
                }
                if (count($_in) > 0) {
                    $tbl = jrCore_db_table_name('jrProfile', 'item_key');
                    $req = "INSERT INTO {$tbl} (`_item_id`, `_profile_id`, `key`, `index`, `value`) VALUES " . implode(',', $_in) . " ON DUPLICATE KEY UPDATE `value` = (`value` + VALUES(`value`))";
                    jrCore_db_query($req);
                }
            }

            // Update item counts
            if (count($_i) > 0) {
                foreach ($_i as $mod => $_ids) {
                    $_in = array();
                    foreach ($_ids as $iid => $_keys) {
                        foreach ($_keys as $key => $count) {
                            $pid = 0;
                            if (!empty($_pr[$mod][$iid]['_profile_id'])) {
                                $pid = (int) $_pr[$mod][$iid]['_profile_id'];
                            }
                            $_in[] = "({$iid},{$pid},'{$key}',0,'{$count}')";
                        }
                    }
                    if (count($_in) > 0) {
                        $tbl = jrCore_db_table_name($mod, 'item_key');
                        $req = "INSERT INTO {$tbl} (`_item_id`, `_profile_id`, `key`, `index`, `value`) VALUES " . implode(',', $_in) . " ON DUPLICATE KEY UPDATE `value` = (`value` + VALUES(`value`))";
                        jrCore_db_query($req);
                    }
                }
            }
            jrCore_form_modal_notice('update', "verified " . jrCore_number_format($ttl) . " like counts");
            usleep(100000);  // Max 5,000 per second
        }
        else {
            // No more items
            break;
        }
    }

    jrCore_logger('INF', 'rebuild of like counts completed');
    jrCore_form_modal_notice('complete', 'Like database counts successfully rebuilt');
}
