// Jamroom Graph Module Javascript
// @copyright 2003-2014 by Talldude Networks LLC
var __ds = [];
var __do = {};

/**
 * Display a graph in a modal window
 * @param {string} id DOM ID of modal window
 * @param {string} murl Module URL
 * @param {string} name Registered Graph name
 * @param {object} args Additional JSON for graph config
 * @returns {bool}
 */
function jrGraph_modal_graph(id, murl, name, args)
{
    var u = core_system_url + '/' + murl + '/graph/' + name;
    $.get(u, args, function(r) {
        if (r.indexOf('plothover') !== -1) {
            $(id).empty().html(r).modal({containerId: 'graph-modal-container'});
        }
        else {
            jrCore_alert(r);
        }
    });
    return false;
}

/**
 * Load a graph in the graph modal window
 * @param id DOM ID
 * @param d base64 encoded/JSON encoded graph params
 * @param v selected "days" value
 * @returns {boolean}
 */
function jrGraph_load_graph(id, d, v)
{
    var u = core_system_url + '/' + jrGraph_url + '/load/config=' + d;
    $.get(u, {days: v}, function(r) {
        if (typeof r.error !== 'undefined') {
            jrCore_alert(r.error);
        }
        else {
            __ds = r.data_set;
            __do = r.options;
            jrGraph_create_modal_graph(id);
        }
    });
    return false;
}

/**
 * Create a graph
 */
function jrGraph_create_modal_graph(id)
{
    $.plot('#g' + id, __ds, __do);
}