<?php
 /**
 * Jamroom Google Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: experiment_modify
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrGoogleAnalytics_experiment_modify($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrGoogleAnalytics', 'experiment_browse');

    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid experiment id');
        jrCore_location('referrer');
    }
    $eid = (int) $_post['_1'];
    $tbl = jrCore_db_table_name('jrGoogleAnalytics', 'experiment');
    $req = "SELECT * FROM {$tbl} WHERE e_id = '{$eid}'";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid experiment id - no data found');
        jrCore_location('referrer');
    }

    jrCore_page_banner('Update Experiment');
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => 'save changes',
        'cancel'           => 'referrer',
        'form_ajax_submit' => false,
        'values'           => $_rt
    );
    jrCore_form_create($_tmp);

    // ID
    $_tmp = array(
        'name'  => 'e_id',
        'type'  => 'hidden',
        'value' => $eid
    );
    jrCore_form_field_create($_tmp);

    // Active
    $_tmp = array(
        'name'     => 'e_active',
        'label'    => 'Experiment is Active',
        'help'     => 'If this option is checked, this experiment is ACTIVE and will be processed on matched URL views',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Original URL
    $_tmp = array(
        'name'     => 'e_urlone',
        'label'    => 'Original URL',
        'help'     => 'Enter the Original URL that you want to run the A/B test on - the "A" URL',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Variant URL
    $_tmp = array(
        'name'     => 'e_urltwo',
        'label'    => 'Variant URL',
        'help'     => 'Enter the Variant URL that you want to run the A/B test on - the "B" URL',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Experiment Key
    $_tmp = array(
        'name'     => 'e_key',
        'label'    => 'Experiment Key',
        'help'     => 'Enter the Google Analytics Experiment Key that was created for this experiment.<br><br><b>NOTE:</b> The Experiment Key <b>must</b> already have been created in your Google Analytics -> Experiments section AND be enabled for A/B testing to work.',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
