<?php
 /**
 * Jamroom Google Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * meta
 */
function jrGoogleAnalytics_meta()
{
    return array(
        'name'        => 'Google Analytics',
        'url'         => 'googleanalytics',
        'version'     => '1.5.0',
        'developer'   => 'The Jamroom Network, &copy;' . date('Y'),
        'description' => 'Add Google Analytics to your site pages and profiles',
        'doc_url'     => 'https://www.jamroom.net/the-jamroom-network/documentation/modules/2923/google-analytics',
        'license'     => 'mpl',
        'category'    => 'site'
    );
}

/**
 * init
 */
function jrGoogleAnalytics_init()
{
    // We listen for our various page display triggers
    jrCore_register_event_listener('jrCore', 'view_results', 'jrGoogleAnalytics_view_results_listener');

    // A/B Testing Tool
    jrCore_register_module_feature('jrCore', 'tool_view', 'jrGoogleAnalytics', 'experiment_browse', array('A/B Testing', 'Create A/B Tests using Google Analytics Experiments'));
    jrCore_register_module_feature('jrCore', 'admin_tab', 'jrGoogleAnalytics', 'experiment_browse', 'A/B Testing');
    return true;
}

//-------------------------------
// EVENT LISTENERS
//-------------------------------

/**
 * Insert Google Analytics experiment code - A/B Testing
 * @param $_data string incoming HTML
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return string
 */
function jrGoogleAnalytics_view_results_listener($_data, $_user, $_conf, $_args, $event)
{
    global $_post;
    if (jrGoogleAnalytics_can_insert_tracking()) {

        // Don't add analytics to non-session views
        if ($_tmp = jrCore_get_registered_module_features('jrUser', 'skip_session')) {
            foreach ($_tmp as $mod => $_opts) {
                if (isset($_post['option']) && isset($_post['module']) && isset($_opts["{$_post['option']}"]) && ($mod == $_post['module'] || $_opts["{$_post['option']}"] == 'magic_view')) {
                    return $_data;
                }
            }
        }

        $script = trim(jrCore_parse_template('global.tpl', $_post, 'jrGoogleAnalytics'));
        $_data  = str_replace('</head>', "{$script}\n</head>", $_data);

        // Are experiments enabled and do we have a page match?
        if (isset($_conf['jrGoogleAnalytics_ab_enabled']) && $_conf['jrGoogleAnalytics_ab_enabled'] == 'on') {
            if (empty($_post['_uri'])) {
                $uri = '/';
            }
            else {
                $uri = trim(trim($_post['_uri']), '/');
                if (strlen("{$uri}") === 0) {
                    $uri = '/';
                }
            }
            if ($_url = jrGoogleAnalytics_get_experiment_url($uri)) {
                if ($_url['e_active'] == 'on') {
                    // We have an experiment - insert code
                    $ptemp = jrCore_parse_template('experiment.tpl', $_url, 'jrGoogleAnalytics');
                    if (strlen("{$ptemp}") > 9) {
                        $_data = str_replace('</head>', "\n{$ptemp}\n</head>", $_data);
                    }
                }
            }
        }

    }
    return $_data;
}

//-------------------------------
// FUNCTIONS
//-------------------------------

/**
 * Returns TRUE if GA is configured AND enabled
 * @return bool
 */
function jrGoogleAnalytics_is_enabled()
{
    if (jrCore_get_config_value('jrGoogleAnalytics', 'account', false)) {
        if (jrCore_get_config_value('jrGoogleAnalytics', 'enabled', 'off') == 'on') {
            return true;
        }
    }
    return false;
}

/**
 * Return TRUE of we can insert tracking into the current page
 * @return bool
 */
function jrGoogleAnalytics_can_insert_tracking()
{
    if (jrCore_get_config_value('jrGoogleAnalytics', 'exclude_admins', 'on') == 'on' && jrUser_is_admin()) {
        return false;
    }
    if (jrCore_is_view_request() && jrGoogleAnalytics_is_enabled()) {
        return true;
    }
    return false;
}

/**
 * Get our URI from a given URL
 * @param string $url
 * @return string
 */
function jrGoogleAnalytics_get_uri($url)
{
    $url = trim(trim($url), '/');
    $tmp = jrCore_get_base_url();
    if (strpos($url, $tmp) === 0) {
        $url = str_replace($tmp, '', $url);
    }
    if (strpos($url, '?')) {
        $url = substr($url, 0, strpos($url, '?'));
    }
    $url = trim(trim($url), '/');
    if (strlen("{$url}") === 0) {
        $url = '/';
    }
    return $url;
}

/**
 * Get an experiment URL for a URI
 * @param $url string URL to get forward URL for
 * @return array|false
 */
function jrGoogleAnalytics_get_experiment_url($url)
{
    // Special handling of root URL
    $tbl = jrCore_db_table_name('jrGoogleAnalytics', 'experiment');
    if ($url == '/') {
        $req = "SELECT * FROM {$tbl} WHERE e_urlone = '/' LIMIT 1";
        $_rt = jrCore_db_query($req, 'SINGLE');
        if ($_rt && is_array($_rt)) {
            return $_rt;
        }
        return false;
    }

    // When a URI comes in, we match from the MOST specific to the LEAST specific
    // if there are rules with wildcards in them
    if (strpos($url, '?')) {
        $url = substr($url, 0, strpos($url, '?'));
    }
    $_ur = explode('/', trim($url));
    if ($_ur && is_array($_ur)) {
        $_pc = array();
        foreach ($_ur as $k => $v) {
            $add = true;
            if (strpos($v, '?')) {
                // We are into the URL params
                list($v,) = explode('?', $v, 2);
                $add = false;
            }
            if (strlen("{$v}") > 0 && $v != '/') {
                $idx = ($k - 1);
                if (isset($_pc[$idx])) {
                    $_pc[$k] = jrCore_db_escape(substr($_pc[$idx], 0, strlen("{$_pc[$idx]}") - 2) . "/${v}");
                }
                else {
                    $_pc[$k] = jrCore_db_escape("/${v}");
                }
                if ($add) {
                    $_pc[$k] .= '/*';
                }
            }
        }
        if (count($_pc) > 0) {
            $_pc[] = jrCore_db_escape($url);
            $req   = "SELECT * FROM {$tbl} WHERE e_urlone IN('" . implode("','", $_pc) . "') ORDER BY LENGTH(e_urlone) DESC LIMIT 1";
            $_rt   = jrCore_db_query($req, 'SINGLE');
            if ($_rt && is_array($_rt)) {
                return $_rt;
            }
        }
    }
    return false;
}
