<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_update_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }

    // Make sure we get a good _item_id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid item id');
        jrCore_form_result();
    }

    // Get data
    $_rt = jrCore_db_get_item('jrForum', $_post['id']);
    if (!$_rt || !is_array($_rt)) {
        // Item does not exist....
        jrCore_set_form_notice('error', 'invalid item id - data not found');
        jrCore_form_result();
    }
    // Make sure the calling user has permission to edit this item
    if (!jrUser_is_admin() && !jrProfile_is_profile_owner($_rt['forum_profile_id']) && $_rt['_user_id'] != $_user['_user_id']) {
        jrUser_not_authorized();
    }

    // Is edit protection enabled?
    if (!jrUser_is_admin() && jrCore_checktype($_conf['jrForum_edit_protect'], 'number_nz') && $_rt['_created'] < (time() - $_conf['jrForum_edit_protect'])) {
        // Past timer - block edit
        jrUser_not_authorized();
    }

    $apd = (int) $_rt['forum_profile_id'];
    jrForum_check_for_blocked_user($_user['user_name'], $apd);

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_sv = jrCore_form_get_save_data('jrForum', 'update', $_post);

    // See if this topic is being moved to a different category
    $upd = false;
    $old = false;
    if ((jrUser_is_admin() || jrProfile_is_profile_owner($_rt['forum_profile_id'])) && isset($_sv['forum_cat_url']) && $_sv['forum_cat_url'] != $_rt['forum_cat_url']) {
        // We've changed categories
        $tbl = jrCore_db_table_name('jrForum', 'category');
        $req = "SELECT cat_title FROM {$tbl} WHERE cat_profile_id = '{$apd}' AND cat_title_url = '" . jrCore_db_escape($_sv['forum_cat_url']) . "'";
        $_ct = jrCore_db_query($req, 'SINGLE');
        if (isset($_ct['cat_title'])) {
            // We had a good cat change - move
            $_sv['forum_cat'] = $_ct['cat_title'];
            // We need to update forum count
            $upd = $_sv['forum_cat_url'];
            $old = $_rt['forum_cat_url'];
        }
        else {
            unset($_sv['forum_cat_url']);
        }
    }

    if (isset($_rt['forum_group_id']) && $_rt['forum_group_id'] == $_rt['_item_id']) {
        // Add in our SEO URL name
        $_sv['forum_title_url'] = jrCore_url_string($_sv['forum_title']);
    }

    // If this is an admin user updating a post that is NOT their post,
    // we want to be sure and update the _updated time so it does not show
    // the user as having updated the item
    $_cr = null;
    if (jrUser_is_admin() && $_rt['_user_id'] != $_user['_user_id']) {
        $_cr = array('_updated' => $_rt['_updated']);
    }
    // Save all updated fields to the Data Store
    jrCore_db_update_item('jrForum', $_post['id'], $_sv, $_cr);

    // Save any uploaded media file
    // If this is an ADMIN user modifying a post by another user, we need to make
    // sure the profile_id is set to the proper profile_id
    if (jrUser_is_admin() || (isset($_user['quota_jrForum_file_attachments']) && $_user['quota_jrForum_file_attachments'] == 'on')) {
        if (jrUser_is_admin() && $_rt['_profile_id'] != jrUser_get_profile_home_key('_profile_id')) {
            jrCore_save_all_media_files('jrForum', 'update', $_rt['_profile_id'], $_post['id'], $_rt);
        }
        else {
            jrCore_save_all_media_files('jrForum', 'update', jrUser_get_profile_home_key('_profile_id'), $_post['id'], $_rt);
        }
    }

    jrCore_form_delete_session();
    jrProfile_reset_cache($apd, 'jrForum');

    // clear the cache of the current user so updated images show
    $p = jrUser_get_profile_home_key('_profile_id');
    jrProfile_reset_cache($p, 'jrForum');

    // moving cats
    $cat = '';
    if ($upd) {
        jrForum_update_category_last_user_info($apd, $upd);
        jrForum_update_category_counts($apd, $upd);
        jrForum_update_category_last_user_info($apd, $old);
        jrForum_update_category_counts($apd, $old);

        // Update all view ids
        $tbl = jrCore_db_table_name('jrForum', 'view');
        $req = "UPDATE IGNORE {$tbl} SET view_cat_url = '" . jrCore_db_escape($upd) . "' WHERE view_cat_url = '" . jrCore_db_escape($old) . "' AND view_topic_id = '{$_post['id']}'";
        jrCore_db_query($req);

        unset($_SESSION['jrforum_index_page_num']);
        $cat = "/{$upd}";
    }

    $add = '';
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $add = "/p={$_post['p']}";
    }
    $url = jrCore_db_get_item_key('jrProfile', $apd, 'profile_url');
    if (isset($_rt['forum_group_id']) && $_rt['forum_group_id'] == $_rt['_item_id']) {
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/{$_post['module_url']}{$cat}/{$_post['id']}/{$_sv['forum_title_url']}{$add}");
    }
    // We need to get the info about the parent
    $_rt = jrCore_db_get_item('jrForum', $_rt['forum_group_id'], true);
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/{$_post['module_url']}{$cat}/{$_rt['_item_id']}/{$_rt['forum_title_url']}{$add}#r{$_post['id']}");
}
