<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_update($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }

    // We should get an id on the URL
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid topic id');
    }
    $_rt = jrCore_db_get_item('jrForum', $_post['id'], false, true);
    if (!$_rt) {
        jrCore_notice_page('error', 'invalid topic id');
    }
    // Make sure the calling user has permission to edit this item
    if (!jrUser_is_admin() && !jrProfile_is_profile_owner($_rt['forum_profile_id']) && $_rt['_user_id'] != $_user['_user_id']) {
        jrUser_not_authorized();
    }
    jrForum_check_for_blocked_user($_user['user_name'], $_rt['forum_profile_id']);

    // Is edit protection enabled?
    if (!jrUser_is_admin() && jrCore_checktype($_conf['jrForum_edit_protect'], 'number_nz') && $_rt['_created'] < (time() - $_conf['jrForum_edit_protect'])) {
        // Past timer - block edit
        jrUser_not_authorized();
    }

    // Start our create form
    jrCore_page_banner(21);

    // Form init
    $_tmp = array(
        'submit_value' => 21,
        'cancel'       => jrCore_is_profile_referrer(),
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // See if we have a page num we are coming from
    if (isset($_conf['jrForum_post_pagebreak']) && jrCore_checktype($_conf['jrForum_post_pagebreak'], 'number_nz')) {
        $num = 0;
        $url = jrCore_get_local_referrer();
        if (strpos($url, '/p=')) {
            $_tmp = explode('/', $url);
            foreach ($_tmp as $part) {
                if (strpos($part, 'p=') === 0) {
                    list(, $num) = explode('=', $part);
                    $num = (int) $num;
                    break;
                }
            }
        }
        if ($num > 0) {
            $_tmp = array(
                'name'  => 'p',
                'type'  => 'hidden',
                'value' => $num
            );
            jrCore_form_field_create($_tmp);
        }
    }

    // ID
    $_tmp = array(
        'name'  => 'id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // We only show title, attachment, pinned on the topic title post
    if (isset($_rt['forum_group_id']) && $_rt['forum_group_id'] == $_rt['_item_id']) {
        // Title
        $_tmp = array(
            'name'          => 'forum_title',
            'label'         => 1,
            'help'          => 3,
            'type'          => 'text',
            'validate'      => 'printable',
            'order'         => 0,
            'form_designer' => false,
            'required'      => true
        );
        jrCore_form_field_create($_tmp);
    }

    // Text
    $_tmp = array(
        'name'          => 'forum_text',
        'label'         => 4,
        'help'          => 5,
        'type'          => 'textarea',
        'validate'      => 'allowed_html',
        'required'      => true,
        'form_designer' => false,
        'order'         => 1,
        'style'         => 'height:250px'
    );
    // See if we are allowing BBCode
    if (strpos($_user['quota_jrCore_active_formatters'], 'format_string_bbcode')) {
        $_tmp['sublabel'] = 48;
    }
    if (isset($_conf['jrForum_editor']) && $_conf['jrForum_editor'] == 'on') {
        $_tmp['type'] = 'editor';
    }
    jrCore_form_field_create($_tmp);

    // If this is an admin user or the forum owner, they can pin a post
    if ((jrUser_is_admin() || jrProfile_is_profile_owner($_rt['forum_profile_id'])) && $_rt['forum_group_id'] == $_rt['_item_id']) {

        // Get config
        $_cfg = jrForum_get_config($_rt['forum_profile_id']);

        // Forum Category
        if (isset($_cfg['enable_cats']) && $_cfg['enable_cats'] == 'on') {
            $tbl  = jrCore_db_table_name('jrForum', 'category');
            $req  = "SELECT cat_title_url, cat_title FROM {$tbl} WHERE cat_profile_id = '{$_rt['forum_profile_id']}' ORDER BY cat_order ASC";
            $_ct  = jrCore_db_query($req, 'cat_title_url', false, 'cat_title');
            $_tmp = array(
                'name'          => 'forum_cat_url',
                'label'         => 87,
                'help'          => 88,
                'type'          => 'select',
                'options'       => $_ct,
                'validate'      => 'not_empty',
                'form_designer' => false,
                'order'         => 3,
                'required'      => true
            );
            jrCore_form_field_create($_tmp);
        }
    }

    if (jrUser_is_admin() || jrUser_get_profile_home_key('quota_jrForum_file_attachments') == 'on') {

        // File Attachment
        $_tmp = array(
            'name'          => 'forum_file',
            'label'         => 6,
            'help'          => 7,
            'text'          => 117,
            'type'          => 'file',
            'extensions'    => $_conf['jrForum_allowed_file_types'],
            'value'         => $_rt,
            'order'         => 4,
            'max'           => (isset($_conf['jrForum_max_attachment_size'])) ? (int) $_conf['jrForum_max_attachment_size'] : 2097152,
            'multiple'      => true,
            'form_designer' => false
        );
        jrCore_form_field_create($_tmp);
    }

    // We only show title, attachment, pinned on the topic title post
    if (isset($_rt['forum_group_id']) && $_rt['forum_group_id'] == $_rt['_item_id']) {

        // If this is an admin user or the forum owner, they can pin a post
        if (jrUser_is_admin() || jrProfile_is_profile_owner($_rt['forum_profile_id'])) {

            // Sticky
            $_tmp = array(
                'name'          => 'forum_pinned',
                'label'         => 19,
                'help'          => 20,
                'default'       => 'off',
                'type'          => 'checkbox',
                'validate'      => 'onoff',
                'order'         => 5,
                'required'      => true,
                'form_designer' => false
            );
            jrCore_form_field_create($_tmp);

            // Locked
            $_tmp = array(
                'name'          => 'forum_locked',
                'label'         => 23,
                'help'          => 101,
                'default'       => 'off',
                'type'          => 'checkbox',
                'validate'      => 'onoff',
                'order'         => 6,
                'required'      => true,
                'form_designer' => false
            );
            jrCore_form_field_create($_tmp);
        }
    }
    jrCore_page_display();
}
