<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: set_solution
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_set_solution($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrCore_json_response(array('error' => 'permission denied'));
    }
    if (!isset($_conf['jrForum_solution_button']) || $_conf['jrForum_solution_button'] != 'on') {
        jrCore_json_response(array('error' => 'solution option is not enabled'));
    }
    if (!isset($_conf['jrForum_solutions']) || strlen($_conf['jrForum_solutions']) < 6) {
        jrCore_json_response(array('error' => 'no solution options have been configured'));
    }
    // We must get a valid ID
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_json_response(array('error' => 'invalid topic id'));
    }
    $_rt = jrCore_db_get_item('jrForum', $_post['id']);
    if (!is_array($_rt)) {
        jrCore_json_response(array('error' => 'invalid topic id - data does not exist'));
    }
    if (!jrUser_is_admin() && !jrUser_can_edit_item($_rt)) {
        jrCore_json_response(array('error' => 'permission denied'));
    }
    $pid = (int) $_post['profile_id'];
    // Add/update/remove solution
    if ($_post['s'] == '0') {
        if (jrCore_db_delete_item_key('jrForum', $_post['id'], 'forum_solution')) {
            jrProfile_reset_cache($pid, 'jrForum');
            jrCore_json_response(array('success' => 'solution removed'));
        }
    }
    else {
        $_dt = array('forum_solution' => $_post['s']);
        if (jrCore_db_update_item('jrForum', $_post['id'], $_dt)) {
            jrProfile_reset_cache($pid, 'jrForum');

            // We need to tell the JS what background color to set the solution to
            $_cl = array();
            $col = '#FFFFFF';
            if (isset($_conf['jrForum_solution_button']) && $_conf['jrForum_solution_button'] == 'on' && isset($_conf['jrForum_solutions']) && strlen($_conf['jrForum_solutions']) > 4) {
                $_fs = explode("\n", $_conf['jrForum_solutions']);
                if (is_array($_fs)) {
                    foreach ($_fs as $line) {
                        list($tag, $col) = explode('|', $line);
                        $tag       = trim($tag);
                        $_cl[$tag] = substr(trim($col), 0, 7);
                    }
                }
                if (isset($_cl["{$_post['s']}"])) {
                    $col = $_cl["{$_post['s']}"];
                }
            }
            jrCore_json_response(array('success' => 'solution added', 'color' => $col));
        }
    }
    jrCore_json_response(array('error' => 'error adding solution to topic'));
}
