<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: post_create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_post_create_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }

    $_ln = jrUser_load_lang_strings();

    // Check for valid text
    if (!isset($_post['forum_text']) || strlen($_post['forum_text']) === 0) {
        $_res = array('error' => $_ln['jrForum'][51]);
        jrCore_json_response($_res);
    }

    // Check for Wait Timer
    if (!jrUser_is_admin() && isset($_SESSION['jrForum_last_post_timer']) && $_SESSION['jrForum_last_post_timer'] > (time() - ($_conf['jrForum_wait_time'] * 60))) {
        $_res = array('error' => $_ln['jrForum'][22] . $_conf['jrForum_wait_time'] . 'm');
        jrCore_json_response($_res);
    }

    // Check for banned words..
    if ($ban = jrCore_run_module_function('jrBanned_is_banned', 'word', $_post['forum_text'])) {
        $_res = array('error' => "{$_ln['jrCore'][67]} " . jrCore_strip_html($ban));
        jrCore_json_response($_res);
    }

    // Start timer
    $_SESSION['jrForum_last_post_timer'] = time();

    // our profile id
    $apd = (int) $_post['forum_profile_id'];
    if (!jrUser_is_admin()) {
        jrForum_check_for_blocked_user($_user['user_name'], $apd);
    }

    // Does our Topic leader still exist?
    $gid = (int) $_post['forum_group_id'];
    $_ft = jrCore_db_get_item('jrForum', $gid, true);
    if (!$_ft || !is_array($_ft)) {
        $_res = array('error' => $_ln['jrForum'][123]);
        jrCore_json_response($_res);
    }

    // Is the topic locked?
    if (!jrUser_is_profile_owner($apd) && isset($_ft['forum_locked']) && $_ft['forum_locked'] == 'on') {
        $_res = array('error' => $_ln['jrForum'][33]);
        jrCore_json_response($_res);
    }

    $_save = array(
        'forum_group_id'   => $gid,
        'forum_text'       => trim($_post['forum_text']),
        'forum_profile_id' => $apd,
    );
    // When posting to a forum, we always use the poster's home info
    $_core = array(
        '_profile_id' => jrUser_get_profile_home_key('_profile_id')
    );
    $pid   = jrCore_db_create_item('jrForum', $_save, $_core);
    if ($pid && jrCore_checktype($pid, 'number_nz')) {

        // Update topic leader info
        $_sv = array(
            'forum_updated'         => 'UNIX_TIMESTAMP()',
            'forum_updated_user_id' => $_user['_user_id']
        );
        jrCore_db_update_item('jrForum', $gid, $_sv, null, false);
        jrCore_db_increment_key('jrForum', $gid, 'forum_post_count', 1);

        // Get topic leader category
        if (isset($_ft['forum_cat_url'])) {
            // Update cat info
            jrForum_set_category_last_user_info($apd, $_ft['forum_cat_url'], $_user);

            // Update view time for this user
            jrForum_update_view_time($apd, $_ft['forum_cat_url'], $gid, $_user['_user_id'], time());
        }

        // turn watches on for the poster unless they
        // have disabled notifications in User Notifications
        if ((!isset($_conf['jrForum_auto_follow']) || $_conf['jrForum_auto_follow'] != 'off') && (!isset($_user['user_notifications_disabled']) || $_user['user_notifications_disabled'] == 'off')) {
            $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
            $uid = (int) $_user['_user_id'];
            $req = "INSERT IGNORE INTO {$tbl} (follow_forum_id,follow_user_id) VALUES ({$gid},{$uid})";
            jrCore_db_query($req);
        }

        // Notify users watching that our topic has been updated
        $_profile = jrCore_db_get_item('jrProfile', $apd);
        $post_url = "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$_post['module_url']}/{$gid}/{$_ft['forum_title_url']}";
        $page_num = 1;
        if (!isset($_conf['jrForum_direction']) || $_conf['jrForum_direction'] == 'asc') {
            $page_num = jrForum_get_post_page_num($gid, $pid);
            if ($page_num > 1) {
                $post_url .= '/p=' . $page_num;
            }
        }
        $_ft = array(
            'forum_id'        => $gid,
            'forum_user_id'   => (int) $_user['_user_id'],
            'forum_user_name' => $_user['user_name'],
            'forum_topic_url' => $post_url
        );
        jrForum_follow_notify($_ft);
        jrProfile_reset_cache($_save['forum_profile_id'], 'jrForum');
        jrUser_reset_cache($_user['_user_id'], 'jrForum');

        if (isset($_conf['jrForum_timeline']) && $_conf['jrForum_timeline'] == 'on') {
            // Add to Actions...
            $hid = jrUser_get_profile_home_key('_profile_id');
            $aid = jrCore_run_module_function('jrAction_save', 'posted', 'jrForum', $pid, null, false, $hid);
            if ($aid && $aid > 0) {
                jrCore_run_module_function('jrAction_process_mentions', $_save['forum_text'], $aid);
            }
        }

        $_res = array(
            'success' => 'successfully posted',
            'id'      => $pid,
            'page'    => $page_num,
            'url'     => $post_url
        );
        jrCore_json_response($_res);

    }

    // We could not create the post
    $_res = array(
        'error' => 'unable to create post in database'
    );
    jrCore_json_response($_res);

}
