<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_create_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_rt = jrCore_form_get_save_data('jrForum', 'create', $_post);

    // If we get a forum category URL, validate it
    $pid = (int) $_post['forum_profile_id'];
    jrForum_check_for_blocked_user($_user['user_name'], $pid);

    $_ct = false;
    $cat = '';
    if (isset($_post['forum_cat_url'])) {
        $tbl = jrCore_db_table_name('jrForum', 'category');
        $url = jrCore_db_escape($_post['forum_cat_url']);
        $req = "SELECT cat_id, cat_title FROM {$tbl} WHERE cat_title_url = '{$url}' AND cat_profile_id = '{$pid}'";
        $_ct = jrCore_db_query($req, 'SINGLE');
        if (!is_array($_ct)) {
            // try for the urlencoded version in case of all foreign language eg: الفئة-العامة will be stored as %D8%A7%D9%84%D9%81%D8%A6%D8%A9-%D8%A7%D9%84%D8%B9%D8%A7%D9%85%D8%A9
            $url = jrCore_db_escape(rawurlencode($_post['forum_cat_url']));
            $req = "SELECT cat_id, cat_title FROM {$tbl} WHERE cat_title_url = '{$url}' AND cat_profile_id = '{$pid}'";
            $_ct = jrCore_db_query($req, 'SINGLE');
            if (!is_array($_ct)) {
                jrCore_set_form_notice('error', 'Invalid forum category - please try again');
                jrCore_form_result();
            }
        }
        $_rt['forum_cat']     = $_ct['cat_title'];
        $_rt['forum_cat_url'] = $_post['forum_cat_url'];
        $cat                  = $_post['forum_cat_url'];
    }

    // Add in additional info for this new topic
    $_rt['forum_title_url']       = jrCore_url_string($_rt['forum_title']);
    $_rt['forum_profile_id']      = $pid;
    $_rt['forum_post_count']      = 1;
    $_rt['forum_updated']         = 'UNIX_TIMESTAMP()';
    $_rt['forum_updated_user_id'] = $_user['_user_id'];
    if (!isset($_rt['forum_pinned']) || $_rt['forum_pinned'] != 'on') {
        $_rt['forum_pinned'] = 'off';
    }

    // When posting to a forum, we always use the poster's home info
    $_core = array(
        '_profile_id' => jrUser_get_profile_home_key('_profile_id')
    );
    // $fid will be the INSERT_ID (_item_id) of the created item
    $fid = jrCore_db_create_item('jrForum', $_rt, $_core);
    if (!$fid) {
        jrCore_set_form_notice('error', 11);
        jrCore_form_result();
    }
    // Update created doc with our forum_group_id, which brings all sections together
    $_sv = array('forum_group_id' => $fid);
    jrCore_db_update_item('jrForum', $fid, $_sv);

    // Save any uploaded media files added in by our
    if (jrUser_is_admin() || (isset($_user['quota_jrForum_file_attachments']) && $_user['quota_jrForum_file_attachments'] == 'on')) {
        jrCore_save_all_media_files('jrForum', 'create', $_core['_profile_id'], $fid);
    }

    // Update cat info
    if (strlen($cat) > 0) {
        jrForum_set_category_last_user_info($pid, $cat, $_user);
    }

    jrCore_form_delete_session();
    jrProfile_reset_cache($pid, 'jrForum');
    jrUser_reset_cache($_user['_user_id'], 'jrForum');

    // Notify profile owners
    $_rt['forum_group_id'] = $fid;
    jrForum_notify_forum_owners($_rt);

    // Notify Category Watchers
    jrForum_notify_category_watchers($_rt, $_ct);

    // turn watches on for the poster unless they
    // have disabled notifications in User Notifications
    if ((!isset($_conf['jrForum_auto_follow']) || $_conf['jrForum_auto_follow'] != 'off') && (!isset($_user['user_notifications_disabled']) || $_user['user_notifications_disabled'] == 'off')) {
        $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
        $uid = (int) $_user['_user_id'];
        $req = "INSERT IGNORE INTO {$tbl} (follow_forum_id,follow_user_id) VALUES ('{$fid}','{$uid}')";
        jrCore_db_query($req);
    }

    // Update category counts
    if (is_array($_ct)) {
        $tbl = jrCore_db_table_name('jrForum', 'category');
        $req = "UPDATE {$tbl} SET cat_updated = UNIX_TIMESTAMP(), cat_topic_count = (cat_topic_count + 1) WHERE cat_id = '{$_ct['cat_id']}' LIMIT 1";
        jrCore_db_query($req);
    }

    if ($_conf['jrForum_timeline'] == 'on') {
        // Add to Actions...
        $aid = jrCore_run_module_function('jrAction_save', 'create', 'jrForum', $fid, null, false, jrUser_get_profile_home_key('_profile_id'));
        if ($aid && $aid > 0) {
            jrCore_run_module_function('jrAction_process_mentions', $_rt['forum_text'], $aid);
        }
    }

    // Update view time
    jrForum_update_view_time($pid, $cat, $fid, $_user['_user_id'], (time() + 1));
    unset($_SESSION['jrforum_new_posts'][$pid][$cat][$fid]);

    // Start timer
    $_SESSION['jrForum_last_post_timer'] = time();

    // Get profile_url for profile we posted on
    $url = jrCore_db_get_item_key('jrProfile', $pid, 'profile_url');
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/{$_post['module_url']}/{$fid}/{$_rt['forum_title_url']}");
}
