<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_create($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Must get a valid profile_id
    if (!isset($_post['profile_id']) || !jrCore_checktype($_post['profile_id'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid profile_id');
    }
    jrForum_check_for_blocked_user($_user['user_name'], $_post['profile_id']);

    // See if allowed
    if (isset($_user['quota_jrForum_can_post']) && $_user['quota_jrForum_can_post'] == 'off') {
        jrUser_not_authorized();
    }

    // See if are allowing private profiles to post
    if (!jrUser_is_admin() && isset($_user['profile_private']) && $_user['profile_private'] != '1') {
        // This user has a private profiles
        if (isset($_conf['jrForum_allow_private']) && $_conf['jrForum_allow_private'] == 'off') {
            $_ln = jrUser_load_lang_strings();
            $_pr = jrProfile_get_privacy_options();
            $url = jrCore_get_module_url('jrProfile');
            $url = "{$_conf['jrCore_base_url']}/{$url}/settings/hl=profile_private";
            jrCore_notice_page('error', $_ln['jrForum'][111] . ' <strong>' . $_pr["{$_user['profile_private']}"] . '</strong><br>' . $_ln['jrForum'][112] . '<br><br><a href="' . $url . '"><u>' . $_ln['jrForum'][113] . '</u></a>', 'referrer', null, false);
        }
    }

    // Start our create form
    jrCore_page_banner(2);

    // Form init
    $_tmp = array(
        'submit_value' => 2,
        'cancel'       => jrCore_is_profile_referrer()
    );
    jrCore_form_create($_tmp);

    // Category
    if (isset($_post['_1']) && strlen($_post['_1']) > 0) {
        $_tmp = array(
            'name'  => 'forum_cat_url',
            'type'  => 'hidden',
            'value' => $_post['_1']
        );
        jrCore_form_field_create($_tmp);
    }

    // Profile ID
    if (isset($_post['profile_id']) && jrCore_checktype($_post['profile_id'], 'number_nz')) {
        $_tmp = array(
            'name'  => 'forum_profile_id',
            'type'  => 'hidden',
            'value' => $_post['profile_id']
        );
        jrCore_form_field_create($_tmp);
    }

    // Title
    $_tmp = array(
        'name'     => 'forum_title',
        'label'    => 1,
        'help'     => 3,
        'type'     => 'text',
        'validate' => 'printable',
        'order'    => 0,
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Text
    $_tmp = array(
        'name'          => 'forum_text',
        'label'         => 4,
        'help'          => 5,
        'type'          => 'textarea',
        'validate'      => 'allowed_html',
        'order'         => 1,
        'required'      => true,
        'form_designer' => false
    );
    // See if we are allowing BBCode
    if (strpos($_user['quota_jrCore_active_formatters'], 'format_string_bbcode')) {
        $_tmp['sublabel'] = 48;
    }
    if (isset($_conf['jrForum_editor']) && $_conf['jrForum_editor'] == 'on') {
        $_tmp['type'] = 'editor';
    }
    jrCore_form_field_create($_tmp);

    // Optional items
    if (jrUser_is_admin() || jrUser_get_profile_home_key('quota_jrForum_file_attachments') == 'on') {

        // File Attachment
        $_tmp = array(
            'name'          => 'forum_file',
            'label'         => 6,
            'help'          => 7,
            'text'          => 117,
            'type'          => 'file',
            'order'         => 3,
            'extensions'    => $_conf['jrForum_allowed_file_types'],
            'max'           => (isset($_conf['jrForum_max_attachment_size'])) ? (int) $_conf['jrForum_max_attachment_size'] : 2097152,
            'multiple'      => true,
            'form_designer' => false
        );
        jrCore_form_field_create($_tmp);
    }

    // If this is an admin user or the forum owner, they can pin a post
    if (jrUser_is_admin() || (isset($_post['profile_id']) && jrProfile_is_profile_owner($_post['profile_id']))) {

        // Forum Pinned
        $_tmp = array(
            'name'          => 'forum_pinned',
            'label'         => 19,
            'help'          => 20,
            'default'       => 'off',
            'type'          => 'checkbox',
            'validate'      => 'onoff',
            'order'         => 4,
            'required'      => true,
            'form_designer' => false
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
