<?php
 /**
 * Jamroom Forum module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: active_users
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrForum_active_users($_post, $_user, $_conf)
{
    // _1 = profile_id
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        if (jrUser_is_admin()) {
            return "jrForum_active_users: missing required profile_id parameter";
        }
        return '';
    }
    // _2 = seconds (default is 900 for 15 minutes
    if (!isset($_post['_2']) || !jrCore_checktype($_post['_2'], 'number_nz')) {
        if (jrUser_is_admin()) {
            return "jrForum_active_users: missing required seconds parameter";
        }
        return '';
    }
    $key = "{$_post['_1']}~{$_post['_2']}";
    if (!$out = jrCore_is_cached('jrForum', $key, false)) {

        $_rt = array(
            'active_user_count' => 0,
            'logged_in_count'   => 0,
            'guest_count'       => 0
        );
        $_us = array();
        $old = (int) $_post['_2'];
        $tbl = jrCore_db_table_name('jrForum', 'active');
        $req = "SELECT active_user_id FROM {$tbl} WHERE active_time > (UNIX_TIMESTAMP() - {$old}) AND active_profile_id = '{$_post['_1']}' ORDER BY active_time DESC";
        $_au = jrCore_db_query($req, 'NUMERIC');
        if ($_au && is_array($_au)) {
            foreach ($_au as $v) {
                if ($v['active_user_id'] > 0) {
                    if (!isset($_us["{$v['active_user_id']}"])) {
                        $_us["{$v['active_user_id']}"] = $v['active_user_id'];
                    }
                    $_rt['logged_in_count']++;
                }
                else {
                    $_rt['guest_count']++;
                }
                $_rt['active_user_count']++;
            }
        }
        if (count($_us) > 0) {
            $_sc = array(
                'search'                       => array(
                    "_item_id in " . implode(',', $_us)
                ),
                'include_jrProfile_keys'       => true,
                'exclude_jrProfile_quota_keys' => true,
                'ignore_pending'               => true,
                'limit'                        => 250
            );
            $_sc = jrCore_db_search_items('jrUser', $_sc);
            if ($_sc && is_array($_sc)) {
                $_rt = array_merge($_sc, $_rt);
            }
        }
        $out = jrCore_parse_template('forum_active_users.tpl', $_rt, 'jrForum');
        // We override cache and set 30 seconds
        $sec = 0;
        if (!empty($_conf['jrCore_default_cache_seconds'])) {
            if ($_conf['jrCore_default_cache_seconds'] > 30) {
                $sec = 30;
            }
        }
        jrCore_add_to_cache('jrForum', $key, $out, $sec, $_post['_1'], false);
    }
    return $out;
}
