<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: user_settings
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_user_settings($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();

    // Make sure user has access
    $acc = jrUser_get_profile_home_key('quota_jrForum_signature');
    if ($acc != 'on') {
        jrUser_not_authorized();
    }

    $_ln = jrUser_load_lang_strings();
    jrCore_page_banner($_ln['jrForum'][104]);

    // Get existing settings
    $_rt = jrForum_get_user_settings();

    // Form init
    $murl = jrCore_get_module_url('jrForum');
    $_tmp = array(
        'submit_value'     => $_ln['jrForum'][32],
        'cancel'           => 'referrer',
        'form_ajax_submit' => false,
        'action'           => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/user_settings_save",
        'values'           => $_rt
    );
    jrCore_form_create($_tmp);

    // Include Signature
    $_tmp = array(
        'name'     => 'enable_signature',
        'label'    => $_ln['jrForum'][105],
        'help'     => $_ln['jrForum'][106],
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Signature
    $_tmp = array(
        'name'     => 'signature',
        'label'    => $_ln['jrForum'][107],
        'sublabel' => $_ln['jrForum'][110],
        'help'     => $_ln['jrForum'][108],
        'type'     => 'textarea',
        'validate' => 'allowed_html',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    return jrCore_page_display(true);
}
