<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: settings_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_settings_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    jrCore_form_validate($_post);

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_rt = array(
        'enable_cats'   => $_post['enable_cats'],
        'auto_lock'     => (int) $_post['auto_lock'],
        'blocked_users' => $_post['blocked_users']
    );
    $_rt = array(
        'profile_jrForum_settings' => json_encode($_rt)
    );
    jrCore_db_update_item('jrProfile', $_user['user_active_profile_id'], $_rt);

    // If we are enabling categories for the first time, we need to
    // update all existing forum entries with a default category and
    // make sure that category exists.
    if (isset($_post['enable_cats']) && $_post['enable_cats'] == 'on') {
        $_tp = jrCore_db_get_items_missing_key('jrForum', 'forum_cat');
        if (is_array($_tp)) {

            // See if we have a default category
            $tbl = jrCore_db_table_name('jrForum', 'category');
            $req = "SELECT * FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' ORDER BY cat_order ASC LIMIT 1";
            $_ct = jrCore_db_query($req, 'SINGLE');
            if (is_array($_ct) && strlen($_ct['cat_title']) > 0) {
                $ttl = $_ct['cat_title'];
                $url = jrCore_url_string($ttl);
            }
            else {
                $ttl = 'default';
                $url = jrCore_url_string($ttl);
                // No categories created - set everything to the "default" category
                $req = "INSERT INTO {$tbl} (cat_profile_id, cat_title, cat_title_url, cat_order, cat_update_user) VALUES ('{$_profile['_profile_id']}', 'default', '{$url}', 0, '')";
                $cid = jrCore_db_query($req, 'INSERT_ID');
                if (!$cid) {
                    jrCore_set_form_notice('error', 'An error was encountered saving the settings - please try again');
                    jrCore_form_result();
                }
            }
            $_tp = array_flip($_tp);

            // Not every forum_id we grabbed is a topic leader - get those now
            $_sc = array(
                'search'         => array(
                    "forum_profile_id = {$_profile['_profile_id']}",
                    "forum_post_count > 0"
                ),
                'return_keys'    => array('_item_id'),
                'skip_triggers'  => true,
                'ignore_pending' => true,
                'privacy_check'  => false,
                'limit'          => 100000
            );
            $_ft = jrCore_db_search_items('jrForum', $_sc);
            if ($_ft && is_array($_ft) && is_array($_ft['_items'])) {
                $_in = array();
                foreach ($_ft['_items'] as $_fid) {
                    $fid = (int) $_fid['_item_id'];
                    if (isset($_tp[$fid])) {
                        $_in[$fid] = array(
                            'forum_cat'     => $ttl,
                            'forum_cat_url' => $url
                        );
                    }
                }
                if (count($_in) > 0) {
                    jrCore_db_update_multiple_items('jrForum', $_in);
                }
                unset($_in);
            }
        }

    }

    // Make sure counts and last poster are good
    jrForum_update_category_info($_user['user_active_profile_id']);

    jrCore_set_form_notice('success', 30);
    jrCore_form_result();
}
