<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: default
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_default($_profile, $_post, $_user, $_conf)
{
    global $_mods;
    // Active forum config
    $_cfg = (isset($_profile['profile_jrForum_settings'])) ? json_decode($_profile['profile_jrForum_settings'], true) : false;

    $murl = jrCore_get_module_url('jrForum');
    // [_uri] => /power-test/forum/2/this-is-another-new-topic-what-do-you-think
    // [module_url] => power-test
    // [module] =>
    // [option] => forum
    // [_1] => 2
    // [_2] => this-is-another-new-topic-what-do-you-think
    // [_profile_id] => 27
    // Viewing an individual forum post

    // See if categories are turned on
    $cat = '';
    if (isset($_cfg['enable_cats']) && $_cfg['enable_cats'] == 'on') {
        // We are using categories - make sure our URL is using a category
        if (isset($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz')) {
            // Our request does NOT have a category - let's get it and redirect
            $_tp = jrCore_db_get_item('jrForum', $_post['_1'], true);
            if (isset($_tp['forum_cat_url'])) {
                jrCore_set_custom_header('HTTP/1.1 301 Moved Permanently');
                $add = '';
                if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
                    $add = "/p={$_post['p']}";
                }
                jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/{$_tp['forum_cat_url']}/{$_post['_1']}/{$_tp['forum_title_url']}{$add}");
            }
            jrCore_page_not_found();
        }
        // NOTE: $_post['_1'] could be EMPTY on the forum index
        if (isset($_post['_1'])) {
            $cat = $_post['_1'];
            if (isset($_post['_2'])) {
                $tid = (int) $_post['_2'];
            }
        }
    }
    else {
        // See if we got a category
        if (isset($_post['_2']) && jrCore_checktype($_post['_2'], 'number_nz') && !jrCore_checktype($_post['_1'], 'number_nz')) {
            // We should not have a category - redirect
            $_tp = jrCore_db_get_item('jrForum', $_post['_1'], true);
            if (is_array($_tp)) {
                jrCore_set_custom_header('HTTP/1.1 301 Moved Permanently');
                jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/{$_post['_2']}/{$_tp['forum_title_url']}");
            }
            jrCore_page_not_found();
        }
        if (isset($_post['_1'])) {
            $tid = (int) $_post['_1'];
        }
    }

    //-----------------------------
    // TOPIC DETAIL
    //-----------------------------
    if (isset($tid) && jrCore_checktype($tid, 'number_nz')) {

        $ckey = jrCore_get_current_url();
        $_cch = jrCore_is_cached('jrForum', $ckey);
        if ($_cch && strlen($_cch['html']) > 0) {

            // Update view and active time
            if (jrUser_is_logged_in()) {

                // Include Editor JS for response
                if (isset($_conf['jrForum_editor']) && $_conf['jrForum_editor'] == 'on') {
                    $tmp = jrCore_get_flag('jrcore_editor_js_included');
                    if (!$tmp) {

                        // TODO: Move to Core Function
                        $_js = array('source' => "{$_conf['jrCore_base_url']}/modules/jrCore/contrib/tinymce/tinymce.min.js?v={$_mods['jrCore']['module_version']}");
                        jrCore_create_page_element('javascript_href', $_js);

                        // Initialize fields
                        $_rp          = array(
                            'field_name'     => 'forum_text',
                            'form_editor_id' => 'eforum_text'
                        );
                        $allowed_tags = explode(',', $_user['quota_jrCore_allowed_tags']);
                        foreach ($allowed_tags as $tag) {
                            $_rp[$tag] = true;
                        }

                        // See what modules are providing
                        $_tm = jrCore_get_registered_module_features('jrCore', 'editor_button');
                        if ($_tm && is_array($_tm)) {
                            foreach ($_tm as $mod => $_items) {
                                $tag       = strtolower($mod);
                                $_rp[$tag] = false;
                                // Make sure the user is allowed Quota access
                                if (jrCore_module_is_active($mod) && isset($_user["quota_{$mod}_allowed"]) && $_user["quota_{$mod}_allowed"] == 'on') {
                                    if (is_file(APP_DIR . "/modules/{$mod}/tinymce/plugin.min.js")) {
                                        $_js = array('source' => "{$_conf['jrCore_base_url']}/modules/{$mod}/tinymce/plugin.min.js?v=" . $_mods[$mod]['module_version']);
                                        jrCore_create_page_element('javascript_href', $_js);
                                    }
                                    $_rp[$tag] = true;
                                }
                            }
                        }

                        $ini = @jrCore_parse_template('form_editor.tpl', $_rp, 'jrCore');
                        $_js = array($ini);
                        jrCore_create_page_element('javascript_ready_function', $_js);
                        jrCore_set_flag('jrcore_editor_js_included', 1);

                    }
                }

                // Update View time
                jrForum_update_session_view_time($_profile['_profile_id'], $_cch['category'], $tid, $_cch['updated']);

                // Reset cache for index page we just came from so our "read" item will update
                $pgbr = (isset($_conf['jrForum_index_count'])) ? intval($_conf['jrForum_index_count']) : 10;
                jrCore_delete_cache('jrForum', jrCore_get_local_referrer() . $pgbr);
                jrForum_update_active_time($_post['_profile_id'], $_user['_user_id']);
            }
            else {
                jrForum_update_active_time($_post['_profile_id'], 0);
            }
            jrCore_page_title($_cch['title']);

            foreach (array('jrprofile_disable_header', 'jrprofile_disable_sidebar', 'jrprofile_disable_footer') as $opt) {
                if (isset($_cch[$opt]) && $_cch[$opt] === 1) {
                    jrCore_set_flag($opt, 1);
                }
                else {
                    jrCore_set_flag($opt, 0);
                }
            }

            // meta
            if (isset($_cch['meta'])) {
                jrCore_set_flag('meta_html', $_cch['meta']);
            }
            return $_cch['html'];
        }

        // We get ALL posts here even if we are paginating, since we must have
        // the Topic Leader (0) for some info.  We will prune below
        $_sp = array(
            'search'      => array(
                "forum_group_id = {$tid}"
            ),
            'order_by'    => array(
                '_created' => 'asc'
            ),
            'quota_check' => false,
            'limit'       => 1000
        );
        $_rt = jrCore_db_search_items('jrForum', $_sp);
        if (!empty($_rt['_items'][0])) {

            // Our "Topic Leader"
            $_tl = $_rt['_items'][0];

            // If we have enabled edit protection, figure out which items can be edited
            $adm = jrUser_is_admin();
            foreach ($_rt['_items'] as $k => $v) {
                if (isset($_conf['jrForum_edit_protect']) && jrCore_checktype($_conf['jrForum_edit_protect'], 'number_nz')) {
                    $_rt['_items'][$k]['user_can_edit'] = (!$adm && $v['_created'] < (time() - $_conf['jrForum_edit_protect'])) ? false : true;
                }
                else {
                    $_rt['_items'][$k]['user_can_edit'] = true;
                }
            }

            // Order bt desc?
            if (isset($_conf['jrForum_direction']) && $_conf['jrForum_direction'] == 'desc') {
                $_rt['_items'] = array_reverse($_rt['_items']);
            }

            $page = 1;
            if (isset($_conf['jrForum_post_pagebreak']) && jrCore_checktype($_conf['jrForum_post_pagebreak'], 'number_nz')) {
                // We are paginating - we need to create a NEW $_rt from the existing
                if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
                    $page = (int) $_post['p'];
                }
                $off_b = (($page - 1) * $_conf['jrForum_post_pagebreak']);
                $off_e = (($page - 1) * $_conf['jrForum_post_pagebreak']) + $_conf['jrForum_post_pagebreak'];
                $_temp = array();
                foreach ($_rt['_items'] as $k => $v) {
                    if ($k >= $off_b && $k < $off_e) {
                        $_temp[] = $v;
                    }
                }
                $_rt['info']['prev_page']     = ($page > 1) ? ($page - 1) : 1;
                $_rt['info']['this_page']     = $page;
                $_rt['info']['next_page']     = ($page + 1);
                $_rt['info']['total_pages']   = ceil(count($_rt['_items']) / $_conf['jrForum_post_pagebreak']);
                $_rt['info']['page_base_url'] = jrCore_strip_url_params(jrCore_get_current_url(), array('p'));
                $_rt['_items']                = $_temp;
                unset($_temp, $off_b, $off_e);
            }

            // We need our LAST POST time
            $upd = (int) $_tl['forum_updated'];

            // Make sure the forum_post_count key is actually correct
            if ($_tl['_item_id'] == $_tl['forum_group_id'] && (!isset($_tl['forum_post_count']) || $_tl['forum_post_count'] != $_rt['info']['total_items'])) {
                jrCore_db_update_item('jrForum', $_tl['_item_id'], array('forum_post_count' => $_rt['info']['total_items']));
                $_tl['forum_post_count'] = $_rt['info']['total_items'];
            }

            // Next - get info about the profile forum this topic is in
            $_pi = jrCore_db_get_item('jrProfile', $_post['_profile_id'], true);
            $_rt = $_rt + $_pi;

            // See if we need to be locked
            if (!empty($_pi['profile_jrForum_settings']) && (!isset($_tl['forum_locked']) || $_tl['forum_locked'] != 'on')) {
                $_st = json_decode($_pi['profile_jrForum_settings'], true);
                if (isset($_st['auto_lock']) && jrCore_checktype($_st['auto_lock'], 'number_nz')) {
                    $old = (time() - ($_st['auto_lock'] * 86400));
                    if ($_tl['forum_updated'] < $old && $_rt['_items'][0]['_updated'] < $old) {
                        $_tl['forum_locked'] = 'on';
                        $_sv                 = array(
                            'forum_locked' => 'on'
                        );
                        jrCore_db_update_item('jrForum', $_tl['_item_id'], $_sv);

                        // We've locked this topic - delete any topic follow requests for this topic
                        // as no more posts will be posted to this topic
                        $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
                        $req = "DELETE FROM {$tbl} WHERE follow_forum_id = '" . intval($_tl['_item_id']) . "'";
                        jrCore_db_query($req);
                    }
                }
            }

            if (jrUser_is_logged_in()) {

                // Check if the viewing user is following this topic
                $iid = intval($_tl['_item_id']);
                $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
                $req = "SELECT * FROM {$tbl} WHERE follow_forum_id = '{$iid}' AND follow_user_id = '" . intval($_user['_user_id']) . "'";
                $_if = jrCore_db_query($req, 'SINGLE');
                if ($_if && is_array($_if)) {
                    $_rt['forum_user_is_following'] = 1;
                }
                else {
                    $_rt['forum_user_is_following'] = 0;
                }

                // Update view time
                $cat_url = '';
                if (isset($_tl['forum_cat_url'])) {
                    $cat_url = $_tl['forum_cat_url'];
                }
                jrForum_update_session_view_time($_profile['_profile_id'], $cat_url, $tid, $upd);

                $pgbr = (isset($_conf['jrForum_index_count'])) ? intval($_conf['jrForum_index_count']) : 10;
                jrCore_delete_cache('jrForum', jrCore_get_local_referrer() . $pgbr);
                jrForum_update_active_time($_post['_profile_id'], $_user['_user_id']);
            }
            else {
                jrForum_update_active_time($_post['_profile_id'], 0);
            }

            // See if we had a search string
            $_rt['breadcrumb_url'] = '';
            if (strlen($cat) > 0) {
                $_rt['breadcrumb_url'] = "/{$cat}";
            }
            if (isset($_post['search_string'])) {
                $_rt['search_string_value'] = htmlentities(strip_tags($_post['search_string']));
                $_rt['breadcrumb_url']      .= '/search_string=' . $_rt['search_string_value'];
                // See if we came from a page deeper in the result set
                $rurl = jrCore_get_local_referrer();
                if (strpos($rurl, 'p=')) {
                    $_tmp = explode('/', $rurl);
                    if (isset($_tmp) && is_array($_tmp)) {
                        foreach ($_tmp as $v) {
                            if (strpos($v, 'p=') === 0) {
                                $_rt['breadcrumb_url'] .= '/p=' . intval(substr($v, 2));
                                break;
                            }
                        }
                    }
                }
            }
            elseif (isset($_SESSION['jrforum_index_page_num']) && is_numeric($_SESSION['jrforum_index_page_num'])) {
                $_rt['breadcrumb_url'] .= '/p=' . $_SESSION['jrforum_index_page_num'];
                $_rt['forum_page_num'] = $_SESSION['jrforum_index_page_num'];
            }

            // With a pagebreak, if we are PAST page 1, we have to get info on the Topic Leader
            $_rt['topic'] = $_tl;

            // Get solution colors setup
            if (isset($_rt['topic']['forum_solution'])) {
                $_cl = array();
                if (isset($_conf['jrForum_solution_button']) && $_conf['jrForum_solution_button'] == 'on' && isset($_conf['jrForum_solutions']) && strlen($_conf['jrForum_solutions']) > 4) {
                    $_fs = explode("\n", $_conf['jrForum_solutions']);
                    if (is_array($_fs)) {
                        foreach ($_fs as $line) {
                            list($tag, $col) = explode('|', $line);
                            $tag       = trim($tag);
                            $_cl[$tag] = substr(trim($col), 0, 7);
                        }
                    }
                }
                if (isset($_cl["{$_rt['topic']['forum_solution']}"])) {
                    $_rt['topic']['forum_solution_color'] = $_cl["{$_rt['topic']['forum_solution']}"];
                }
            }

            // BBCode Help
            $_rt['category_url']   = $cat;
            $_rt['user_signature'] = jrForum_get_user_signature();

            if (isset($_rt['info']['next_page']) && $_rt['info']['next_page'] > $_rt['info']['total_pages']) {
                $_rt['info']['next_page'] = 0;
            }
            $html = jrCore_parse_template('item_detail.tpl', $_rt, 'jrForum');
            if ($page > 1) {
                $_ln   = jrUser_load_lang_strings();
                $title = "{$_rt['topic']['forum_title']} - {$_ln['jrForum'][114]} {$page} - {$_profile['profile_name']}";
            }
            else {
                $title = "{$_rt['topic']['forum_title']} - {$_profile['profile_name']}";
            }
            $_cch = array(
                'html'                      => $html,
                'title'                     => $title,
                'updated'                   => $upd,
                'category'                  => ((isset($_tl['forum_cat_url'])) ? $_tl['forum_cat_url'] : ((strlen($cat) > 0) ? $cat : '')),
                'jrprofile_disable_header'  => (jrCore_get_flag('jrprofile_disable_header')) ? 1 : 0,
                'jrprofile_disable_sidebar' => (jrCore_get_flag('jrprofile_disable_sidebar')) ? 1 : 0,
                'jrprofile_disable_footer'  => (jrCore_get_flag('jrprofile_disable_footer')) ? 1 : 0
            );

            // Meta social tags
            if (isset($_tl) && is_array($_tl)) {
                // meta for detail page
                $_rep = array(
                    'item'   => $_tl,
                    'method' => jrCore_get_server_protocol()
                );
                $html = jrCore_parse_template('item_detail_meta.tpl', $_rep, 'jrForum');
                jrCore_set_flag('meta_html', $html);
                $_cch['meta'] = $html;
            }
            jrCore_page_title($title);
            jrCore_add_to_cache('jrForum', $ckey, $_cch);
            return $_cch['html'];
        }
        else {
            jrCore_page_not_found();
        }
    }

    //-----------------------------
    // CATEGORY INDEX
    //-----------------------------
    elseif (isset($_cfg['enable_cats']) && $_cfg['enable_cats'] == 'on' && !isset($_post['_1']) && !isset($_post['search_string'])) {

        // First - get categories
        $tbl                = jrCore_db_table_name('jrForum', 'category');
        $req                = "SELECT * FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' ORDER BY cat_order ASC";
        $_profile['_items'] = jrCore_db_query($req, 'NUMERIC');

        // Get viewed times for user
        if (jrUser_is_logged_in() && is_array($_profile['_items'])) {

            $tbl = jrCore_db_table_name('jrForum', 'view');
            $req = "SELECT view_cat_url, view_time FROM {$tbl} WHERE view_user_id = '{$_user['_user_id']}' AND view_profile_id = '{$_profile['_profile_id']}' AND view_topic_id = '0' AND view_cat_url != '' GROUP BY view_cat_url";
            $_ct = jrCore_db_query($req, 'view_cat_url', false, 'view_time');
            if (!is_array($_ct) || count($_ct) === 0) {
                $_ct = false;
            }

            // get the following state for each thread
            $tblf = jrCore_db_table_name('jrForum', 'follow_category');
            $reqf = "SELECT * FROM {$tblf} WHERE  follow_user_id = '" . intval($_user['_user_id']) . "'";
            $_if  = jrCore_db_query($reqf, 'follow_cat_id');

            $_uv = array();
            foreach ($_profile['_items'] as $k => $_v) {
                // following status
                if ($_if && in_array($_v['cat_id'], array_keys($_if))) {
                    $_profile['_items'][$k]['forum_user_is_following_category'] = 1;
                }
                else {
                    $_profile['_items'][$k]['forum_user_is_following_category'] = 0;
                }

                if (isset($_v['cat_update_user']) && strlen($_v['cat_update_user']) > 0) {
                    $_profile['_items'][$k]['cat_update_user'] = json_decode($_v['cat_update_user'], true);
                }
                if (isset($_v['cat_topic_count']) && $_v['cat_topic_count'] == '0') {
                    continue;
                }
                // If this user has never visited before, setup view times
                if (!$_ct) {
                    $_uv[] = $_v['cat_title_url'];
                    continue;
                }
                elseif (!isset($_ct["{$_v['cat_title_url']}"])) {
                    $_uv[] = $_v['cat_title_url'];
                }
                if (!isset($_ct["{$_v['cat_title_url']}"]) || (($_ct["{$_v['cat_title_url']}"] + 1) < $_v['cat_updated']) || isset($_SESSION['jrforum_new_posts']["{$_profile['_profile_id']}"]["{$_v['cat_title_url']}"])) {
                    $_profile['_items'][$k]['cat_new_topic_posts'] = 1; // new posts since our last visit!
                }
            }
            if (count($_uv) > 0) {
                $_oc = array();
                $req = "INSERT IGNORE INTO {$tbl} (view_user_id, view_profile_id, view_cat_url, view_topic_id, view_time, view_notified) VALUES ";
                foreach ($_uv as $ucat) {
                    $_oc[] = "('{$_user['_user_id']}', '{$_profile['_profile_id']}', '" . jrCore_db_escape($ucat) . "', '0', UNIX_TIMESTAMP(), '0')";
                    $_oc[] = "('{$_user['_user_id']}', '{$_profile['_profile_id']}', '" . jrCore_db_escape($ucat) . "', '4294967295', UNIX_TIMESTAMP(), '0')";
                }
                $req .= implode(',', $_oc);
                jrCore_db_query($req);
                unset($_uv, $_oc);
            }
        }
        else {
            foreach ($_profile['_items'] as $k => $_v) {
                if (strlen($_v['cat_update_user']) > 0) {
                    $_profile['_items'][$k]['cat_update_user'] = json_decode($_v['cat_update_user'], true);
                }
            }
        }

        $_lng = jrUser_load_lang_strings();
        jrCore_page_title("{$_lng['jrForum'][36]} - {$_profile['profile_name']}");
        return jrCore_parse_template('item_categories.tpl', $_profile, 'jrForum');
    }

    //-----------------------------
    // ITEM INDEX
    //-----------------------------
    else {

        // [_uri] => /power-test/forum/<category>
        // [module_url] => power-test
        // [module] =>
        // [option] => forum
        // [_profile_id] => 27
        $_post['_profile_id'] = (int) $_post['_profile_id'];

        // Viewing forum category OR index (if not using categories)
        $_lng = jrUser_load_lang_strings();
        $pgbr = (isset($_conf['jrForum_index_count'])) ? intval($_conf['jrForum_index_count']) : 10;
        $ckey = jrCore_get_current_url() . $pgbr;
        if (!isset($_post['search_string'])) {
            if ($_cch = jrCore_is_cached('jrForum', $ckey)) {
                if (isset($_post['_1']) && $_post['_1'] == 'my_posts') {
                    jrProfile_set_active_profile_tab('my_posts');
                    $_cch['title'] = "{$_lng['jrForum'][93]} - {$_profile['profile_name']}";
                }
                if (isset($_post['_1']) && $_post['_1'] == 'new_posts') {
                    jrProfile_set_active_profile_tab('new_posts');
                    $_cch['title'] = "{$_lng['jrForum'][100]} - {$_profile['profile_name']}";
                }
                jrCore_page_title($_cch['title']);
                foreach (array('jrprofile_disable_header', 'jrprofile_disable_sidebar', 'jrprofile_disable_footer') as $opt) {
                    if (isset($_cch[$opt]) && $_cch[$opt] === 1) {
                        jrCore_set_flag($opt, 1);
                    }
                    else {
                        jrCore_set_flag($opt, 0);
                    }
                }
                return $_cch['html'];
            }
        }
        // Page
        $page = 1;
        if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
            $page = (int) $_post['p'];
        }
        $_SESSION['jrforum_index_page_num'] = $page;

        $cat = false;
        if (isset($_post['_1']) && $_post['_1'] == 'my_posts') {
            $cat   = 'my_posts';
            $title = "{$_lng['jrForum'][93]} - {$_profile['profile_name']}";
        }
        elseif (isset($_post['_1']) && $_post['_1'] == 'new_posts') {
            $cat   = 'new_posts';
            $title = "{$_lng['jrForum'][100]} - {$_profile['profile_name']}";
        }
        elseif (isset($_post['_1']) && isset($_cfg['enable_cats']) && $_cfg['enable_cats'] == 'on') {
            // Is this a valid category?
            $tbl = jrCore_db_table_name('jrForum', 'category');
            $req = "SELECT * FROM {$tbl} WHERE cat_profile_id = '{$_post['_profile_id']}' AND cat_title_url = '" . jrCore_url_string($_post['_1']) . "' LIMIT 1";
            $_ex = jrCore_db_query($req, 'SINGLE');
            if (!$_ex || !is_array($_ex)) {
                // Bad category - redirect to category index
                jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}");
            }
            $cat   = strip_tags($_post['_1']);
            $title = "{$cat} - {$_profile['profile_name']}";
        }
        else {
            $title = "{$_lng['jrForum'][36]} - {$_profile['profile_name']}";
        }
        jrCore_page_title($title);

        // See if we were given a search string
        if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {

            // For a SEARCH, we have to first find all the posts and just
            // group them by forum_group_id - then get all matching topics
            // This is the forum index, showing all posts
            $_sp = array(
                'return_keys'    => array('forum_group_id'),
                'ignore_missing' => true,
                'quota_check'    => false,
                'limit'          => 1000
            );
            if (jrCore_module_is_active('jrSearch')) {
                $_sp['search'] = array(
                    "forum_profile_id = {$_post['_profile_id']}",
                    "forum_text full_text {$_post['search_string']}"
                );
            }
            else {
                $_sp['skip_triggers'] = true;
                $_sp['search']        = array(
                    "forum_profile_id = {$_post['_profile_id']}",
                    "forum_text like %{$_post['search_string']}% || forum_title like %{$_post['search_string']}%"
                );
            }
            if ($cat) {
                switch ($cat) {

                    case 'my_posts':
                        if (jrUser_is_logged_in()) {
                            jrProfile_set_active_profile_tab('my_posts');
                            // Get only posts we have been involved in
                            $_sp['search'][]      = "_user_id = {$_user['_user_id']}";
                            $_sp['privacy_check'] = false;
                        }
                        else {
                            $_sp['search'][] = "forum_cat_url = {$_post['_1']}";
                        }
                        break;

                    case 'new_posts':
                        jrProfile_set_active_profile_tab('new_posts');
                        $_sp['order_by'] = array('_item_id' => 'numerical_desc');
                        break;

                    default:
                        $_sp['search'][] = "forum_cat_url = {$_post['_1']}";
                        break;

                }
            }
            $_rt = jrCore_db_search_items('jrForum', $_sp);
            if (isset($_rt['_items']) && is_array($_rt['_items'])) {
                $_ids = array();
                foreach ($_rt['_items'] as $v) {
                    $_ids[] = $v['forum_group_id'];
                }
                // Get actual topics
                $_sp = array(
                    'search'         => array(
                        "_item_id in " . implode(',', $_ids)
                    ),
                    'order_by'       => array(
                        'forum_updated' => 'numerical_desc'
                    ),
                    'quota_check'    => false,
                    'privacy_check'  => false,
                    'ignore_missing' => true,
                    'pagebreak'      => $pgbr,
                    'page'           => (isset($_post['p'])) ? intval($_post['p']) : 1
                );
                $_rt = jrCore_db_search_items('jrForum', $_sp);
            }
        }
        else {

            // This is the forum index, showing all posts
            $_sp = array(
                'search'         => array(
                    "forum_updated > 0",
                    "forum_profile_id = {$_post['_profile_id']}"
                ),
                'order_by'       => array(
                    'forum_pinned'  => 'desc',
                    'forum_updated' => 'numerical_desc'
                ),
                'quota_check'    => false,
                'ignore_missing' => true,
                'ignore_pending' => true,
                'pagebreak'      => $pgbr,
                'page'           => $page
            );
            if ($cat) {
                switch ($cat) {

                    case 'my_posts':
                        if (jrUser_is_logged_in()) {
                            jrProfile_set_active_profile_tab('my_posts');
                            // Get only posts we have been involved in
                            $_up = array(
                                'search'         => array(
                                    "forum_profile_id = {$_post['_profile_id']}",
                                    "_user_id = {$_user['_user_id']}"
                                ),
                                'return_keys'    => array('forum_group_id'),
                                'order_by'       => array(
                                    '_item_id' => 'desc'
                                ),
                                'skip_triggers'  => true,
                                'ignore_pending' => true,
                                'privacy_check'  => false,
                                'limit'          => 10000
                            );
                            $_up = jrCore_db_search_items('jrForum', $_up);
                            if ($_up && is_array($_up) && isset($_up['_items'])) {
                                $_ui = array();
                                foreach ($_up['_items'] as $_fg) {
                                    $fgi       = (int) $_fg['forum_group_id'];
                                    $_ui[$fgi] = $fgi;
                                }
                                unset($_up);
                                $_sp['search'][] = 'forum_group_id in ' . implode(',', $_ui);
                            }
                            else {
                                // No matches
                                $_sp['search'][] = 'forum_group_id = 0';
                            }
                            $_sp['privacy_check'] = false;
                            unset($_sp['order_by']['forum_pinned']);
                        }
                        else {
                            $_sp['search'][] = "forum_cat_url = {$_post['_1']}";
                        }
                        break;

                    case 'new_posts':
                        jrProfile_set_active_profile_tab('new_posts');
                        unset($_sp['order_by']['forum_pinned']);
                        break;

                    default:
                        $_sp['search'][] = "forum_cat_url = {$_post['_1']}";
                        break;
                }
            }
            $_rt = jrCore_db_search_items('jrForum', $_sp);
        }
        if (isset($_rt['_items']) && is_array($_rt['_items'])) {

            // Get solution colors setup
            $_cl = array();
            $ufs = false;
            if (isset($_conf['jrForum_solution_button']) && $_conf['jrForum_solution_button'] == 'on' && isset($_conf['jrForum_solutions']) && strlen($_conf['jrForum_solutions']) > 4) {
                $ufs = true;
                $_fs = explode("\n", $_conf['jrForum_solutions']);
                if (is_array($_fs)) {
                    foreach ($_fs as $line) {
                        list($tag, $col) = explode('|', $line);
                        $tag       = trim($tag);
                        $_cl[$tag] = substr(trim($col), 0, 7);
                    }
                }
            }

            // Get last viewed times for this user
            if (jrUser_is_logged_in()) {

                $_id = array();
                foreach ($_rt['_items'] as $_v) {
                    $_id[] = (int) $_v['_item_id'];
                }

                // get the following state for each thread
                $tbl = jrCore_db_table_name('jrForum', 'follow_topic');
                $req = "SELECT * FROM {$tbl} WHERE follow_user_id = '" . intval($_user['_user_id']) . "' AND follow_forum_id IN(" . implode(',', $_id) . ")";
                $_if = jrCore_db_query($req, 'follow_forum_id');

                $_vc = array();
                foreach ($_rt['_items'] as $k => $_v) {
                    $iid = (int) $_v['_item_id'];
                    if (isset($_v['forum_cat_url'])) {
                        $_vc[$iid] = $_v['forum_cat_url'];
                    }
                    // following status
                    if ($_if && isset($_if["{$_v['forum_group_id']}"])) {
                        $_rt['_items'][$k]['forum_user_is_following'] = 1;
                    }
                    else {
                        $_rt['_items'][$k]['forum_user_is_following'] = 0;
                    }
                    // Handle solutions
                    if ($ufs && isset($_v['forum_solution']) && strlen($_v['forum_solution']) > 0) {
                        if (isset($_cl["{$_v['forum_solution']}"])) {
                            $_rt['_items'][$k]['forum_solution_color'] = $_cl["{$_v['forum_solution']}"];
                        }
                    }
                }
                // Get individual updated times for posts on this page
                $tbl = jrCore_db_table_name('jrForum', 'view');
                if (strlen($cat) > 0 && $cat != 'my_posts' && $cat != 'new_posts') {
                    $req = "SELECT view_topic_id, view_time FROM {$tbl} WHERE view_profile_id = '{$_post['_profile_id']}' AND view_user_id = '{$_user['_user_id']}' AND view_cat_url = '{$cat}' AND view_topic_id IN(4294967295," . implode(',', $_id) . ")";
                }
                else {
                    $req = "SELECT view_topic_id, view_time FROM {$tbl} WHERE view_profile_id = '{$_post['_profile_id']}' AND view_user_id = '{$_user['_user_id']}' AND view_cat_url != 'new_posts' AND view_topic_id IN(4294967295," . implode(',', $_id) . ")";
                }
                $_lv = jrCore_db_query($req, 'view_topic_id', false, 'view_time');

                $_fn = array();
                foreach ($_rt['_items'] as $k => $_v) {
                    // 4294967295 as topic_id is the last time the user clicked on "mark all topics read"
                    if (!is_array($_lv) || (isset($_v['forum_updated']) && isset($_lv['4294967295']) && $_lv['4294967295'] >= $_v['forum_updated'])) {
                        continue;
                    }
                    elseif (!isset($_lv["{$_v['_item_id']}"]) || $_v['forum_updated'] > $_lv["{$_v['_item_id']}"]) {
                        $_rt['_items'][$k]['forum_new_topic_posts'] = 1; // new posts!
                        $_fn["{$_v['_item_id']}"]                   = 1;
                    }
                }
                if (count($_fn) > 0) {
                    // There are items on the page that have NEW updates we have not seen yet
                    if (!isset($_SESSION['jrforum_new_posts'])) {
                        $_SESSION['jrforum_new_posts'] = array();
                    }
                    foreach ($_fn as $iid => $ignore) {
                        if (isset($_vc[$iid])) {
                            $icat                                                                     = $_vc[$iid];
                            $_SESSION['jrforum_new_posts']["{$_profile['_profile_id']}"][$icat][$iid] = 1;
                        }
                    }
                    unset($_fn);
                }
                else {
                    // We've seen everything in this category - update view times
                    $req = "INSERT INTO {$tbl} (view_user_id, view_profile_id, view_cat_url, view_topic_id, view_time, view_notified) VALUES ";
                    $req .= "('{$_user['_user_id']}', '{$_profile['_profile_id']}', '" . jrCore_db_escape($cat) . "', '0', UNIX_TIMESTAMP(), '0'),";
                    $req .= "('{$_user['_user_id']}', '{$_profile['_profile_id']}', '" . jrCore_db_escape($cat) . "', '4294967295', UNIX_TIMESTAMP(), '0') ";
                    $req .= 'ON DUPLICATE KEY UPDATE view_time = UNIX_TIMESTAMP()';
                    jrCore_db_query($req);
                    unset($_SESSION['jrforum_new_posts']["{$_profile['_profile_id']}"][$cat]);
                }
            }
            else {
                // User is not logged in - just setup solutions
                foreach ($_rt['_items'] as $k => $_v) {
                    if (isset($_v['forum_solution']) && strlen($_v['forum_solution']) > 0) {
                        if (isset($_cl["{$_v['forum_solution']}"])) {
                            $_rt['_items'][$k]['forum_solution_color'] = $_cl["{$_v['forum_solution']}"];
                        }
                    }
                }

            }

            // Add info about the profile who is hosting the forum
            $_pi                      = jrCore_db_get_item('jrProfile', $_post['_profile_id'], true);
            $_rt                      = $_rt + $_pi;
            $_rt['found_forum_posts'] = 1;

        }
        else {
            // All we need is profile info - no posts
            $_rt                      = jrCore_db_get_item('jrProfile', $_post['_profile_id'], true);
            $_rt['found_forum_posts'] = 0;

        }
        if (isset($_post['search_string'])) {
            $_rt['search_string_value'] = jrCore_entity_string($_post['search_string']);
        }

        // Category info
        $tbl = jrCore_db_table_name('jrForum', 'category');
        $req = "SELECT * FROM {$tbl} WHERE cat_title_url = '" . jrCore_db_escape($cat) . "' AND cat_profile_id = " . $_post['_profile_id'] . " LIMIT 1";
        $_ct = jrCore_db_query($req, 'SINGLE');
        if (!is_array($_ct)) {
            // try for the urlencoded version in case of all foreign language eg: الفئة-العامة will be stored as %D8%A7%D9%84%D9%81%D8%A6%D8%A9-%D8%A7%D9%84%D8%B9%D8%A7%D9%85%D8%A9
            $req = "SELECT * FROM {$tbl} WHERE cat_title_url = '" . jrCore_db_escape(rawurlencode($cat)) . "' AND cat_profile_id = " . $_post['_profile_id'] . " LIMIT 1";
            $_ct = jrCore_db_query($req, 'SINGLE');
        }
        $_rt['category_title']     = (isset($_ct['cat_title'])) ? $_ct['cat_title'] : '';
        $_rt['category_read_only'] = (isset($_ct['cat_read_only'])) ? $_ct['cat_read_only'] : '';
        $_rt['category_note']      = (isset($_ct['cat_note'])) ? $_ct['cat_note'] : '';
        $_rt['category_id']        = (isset($_ct['cat_id'])) ? $_ct['cat_id'] : 0;
        $_rt['category_url']       = $cat;
        $_rt['categories_enabled'] = (isset($_cfg['enable_cats']) && $_cfg['enable_cats'] == 'on') ? 'on' : 'off';

        // get the following state for this category
        if (jrUser_is_logged_in()) {
            $tblf                                             = jrCore_db_table_name('jrForum', 'follow_category');
            $reqf                                             = "SELECT * FROM {$tblf} WHERE  follow_user_id = '" . intval($_user['_user_id']) . "' AND follow_cat_id = '{$_rt['category_id']}' ";
            $_if                                              = jrCore_db_query($reqf, 'SINGLE');
            $_rt['category_forum_user_is_following_category'] = (isset($_if['follow_cat_id']) && jrCore_checktype($_if['follow_cat_id'], 'number_nn')) ? true : false;
        }

        $html = jrCore_parse_template('item_index.tpl', $_rt, 'jrForum');
        $_cch = array(
            'html'                      => $html,
            'title'                     => $title,
            'jrprofile_disable_header'  => (jrCore_get_flag('jrprofile_disable_header')) ? 1 : 0,
            'jrprofile_disable_sidebar' => (jrCore_get_flag('jrprofile_disable_sidebar')) ? 1 : 0,
            'jrprofile_disable_footer'  => (jrCore_get_flag('jrprofile_disable_footer')) ? 1 : 0
        );
        jrCore_add_to_cache('jrForum', $ckey, $_cch);
        return $html;
    }
    return false;
}
