<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_transfer_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_transfer_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid TRANSFER FROM id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_form_result();
    }
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT * FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid category id (2)');
        jrCore_form_result();
    }

    // we must get a valid id we are transferring TO
    if (!isset($_post['cat_id']) || !jrCore_checktype($_post['cat_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid transfer to category id');
        jrCore_location('referrer');
    }
    $req = "SELECT cat_title, cat_title_url FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['cat_id']}' LIMIT 1";
    $_nc = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_nc)) {
        jrCore_set_form_notice('error', 'invalid transfer to category id (2)');
        jrCore_location('referrer');
    }
    // move topics
    $_sc = array(
        'search'         => array(
            "forum_cat = {$_rt['cat_title']}",
            "forum_profile_id = {$_profile['_profile_id']}"
        ),
        'return_keys'    => array('_item_id', '_updated'),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'limit'          => 100000
    );
    $_tp = jrCore_db_search_items('jrForum', $_sc);
    if (is_array($_tp) && is_array($_tp['_items'])) {

        $_id = array();
        $_cr = array();
        foreach ($_tp['_items'] as $_top) {
            $fid       = (int) $_top['_item_id'];
            $_id[$fid] = array(
                'forum_cat'     => $_nc['cat_title'],
                'forum_cat_url' => $_nc['cat_title_url']
            );
            $_cr[$fid] = array(
                '_updated' => $_top['_updated']
            );
        }
        if (count($_id) > 0) {
            jrCore_db_update_multiple_items('jrForum', $_id, $_cr);
        }

        // Set view_times set for old cat moving to new cat
        $url = jrCore_db_escape($_nc['cat_title_url']);
        $tbl = jrCore_db_table_name('jrForum', 'view');
        $req = "UPDATE {$tbl} SET view_cat_url = '{$url}' WHERE view_profile_id = '{$_profile['_profile_id']}' AND view_cat_url = '" . jrCore_db_escape($_rt['cat_title_url']) . "' AND view_topic_id NOT IN(0,4294967295)";
        jrCore_db_query($req);

        // Delete old category read-all entries
        $req = "DELETE FROM {$tbl} WHERE view_profile_id = '{$_profile['_profile_id']}' AND view_cat_url = '" . jrCore_db_escape($_rt['cat_title_url']) . "' AND view_topic_id IN(0,4294967295)";
        jrCore_db_query($req);

        // Change over in cats
        $tbl = jrCore_db_table_name('jrForum', 'category');
        if (isset($_rt['cat_updated']) && isset($_nc['cat_updated']) && $_rt['cat_updated'] > $_nc['cat_updated']) {
            $req = "UPDATE {$tbl} SET cat_updated = '{$_rt['cat_updated']}', cat_topic_count = (cat_topic_count + {$_rt['cat_topic_count']}), cat_update_user = '" . jrCore_db_escape($_rt['cat_update_user']) . "' WHERE cat_id = '{$_post['cat_id']}'";
        }
        else {
            // We don't need to update the last user
            $req = "UPDATE {$tbl} SET cat_topic_count = (cat_topic_count + {$_rt['cat_topic_count']}) WHERE cat_id = '{$_post['cat_id']}'";
        }
        jrCore_db_query($req);

        $tbl = jrCore_db_table_name('jrForum', 'category');
        $req = "UPDATE {$tbl} SET cat_updated = 0, cat_topic_count = 0, cat_update_user = '' WHERE cat_id = '{$_post['id']}'";
        jrCore_db_query($req);
    }
    jrProfile_reset_cache($_profile['_profile_id'], 'jrForum');
    $murl = jrCore_get_module_url('jrForum');
    $_ln  = jrUser_load_lang_strings();
    jrCore_set_form_notice('success', $_ln['jrForum'][77]);
    jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories");
}
