<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_transfer
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_transfer($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_title, cat_desc, cat_read_only FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid category id (2)');
        jrCore_location('referrer');
    }
    jrProfile_set_active_profile_tab('categories');

    $_ln = jrUser_load_lang_strings();

    // Start our create form
    jrCore_page_banner($_ln['jrForum'][74], null, false);

    // Form init
    $murl = jrCore_get_module_url('jrForum');
    $_tmp = array(
        'submit_value' => $_ln['jrForum'][73],
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories",
        'action'       => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_transfer_save",
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // Category ID
    $_tmp = array(
        'name'  => 'id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // Transfer To
    $req = "SELECT cat_id, cat_title FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id != '{$_post['id']}' ORDER BY cat_title ASC";
    $_ct = jrCore_db_query($req, 'cat_id', false, 'cat_title');
    if (!is_array($_ct)) {
        jrCore_set_form_notice('error', 'There are no other categories to transfer the posts to');
        jrCore_location('referrer');
    }
    $_tmp = array(
        'name'     => 'cat_id',
        'default'  => '',
        'type'     => 'select',
        'options'  => $_ct,
        'validate' => 'number_nz',
        'required' => 'on',
        'label'    => $_ln['jrForum'][75],
        'help'     => $_ln['jrForum'][76]
    );
    jrCore_form_field_create($_tmp);
    return jrCore_page_display(true);
}
