<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_order_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_order_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_location('referrer');
    }

    // Get all categories for this profile
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_id, cat_order FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' ORDER BY cat_order ASC";
    $_rt = jrCore_db_query($req, 'cat_id', false, 'cat_order');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'unable to load categories from database - please try again');
        jrCore_location('referrer');
    }
    $oid = 0;
    foreach ($_rt as $cid => $ord) {
        if ($cid == $_post['id']) {
            // We found our match
            $new = ($ord - 1);
            $req = "UPDATE {$tbl} SET cat_order = CASE cat_id
                      WHEN {$oid} THEN {$ord}
                      WHEN {$cid} THEN {$new}
                      ELSE cat_order END";
            jrCore_db_query($req);
            $murl = jrCore_get_module_url('jrForum');
            jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories");
        }
        $oid = $cid;
    }
    jrCore_set_form_notice('error', 'unable to load categories from database - please try again');
    jrCore_location('referrer');
}
