<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_modify
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_modify($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_title, cat_desc, cat_note, cat_read_only FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid category id (2)');
        jrCore_location('referrer');
    }
    jrProfile_set_active_profile_tab('categories');
    $_ln = jrUser_load_lang_strings();

    // Start our create form
    jrCore_page_banner($_ln['jrForum'][78], null, false);

    // Form init
    $murl = jrCore_get_module_url('jrForum');
    $_tmp = array(
        'submit_value'     => $_ln['jrForum'][73],
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories",
        'action'           => "{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/cat_modify_save",
        'form_ajax_submit' => false,
        'values'           => $_rt
    );
    jrCore_form_create($_tmp);

    // Category ID
    $_tmp = array(
        'name'  => 'id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // Category Name
    $_tmp = array(
        'name'     => 'cat_title',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => 'on',
        'max'      => '128',
        'label'    => $_ln['jrForum'][68],
        'help'     => $_ln['jrForum'][69]
    );
    jrCore_form_field_create($_tmp);

    // Category Description
    $_tmp = array(
        'name'     => 'cat_desc',
        'default'  => '',
        'type'     => 'textarea',
        'validate' => 'printable',
        'required' => 'off',
        'max'      => '1024',
        'label'    => $_ln['jrForum'][79],
        'help'     => $_ln['jrForum'][80]
    );
    jrCore_form_field_create($_tmp);

    // Category Note
    $_tmp = array(
        'name'     => 'cat_note',
        'default'  => '',
        'type'     => 'editor',
        'validate' => 'allowed_html',
        'required' => 'off',
        'max'      => '8192',
        'label'    => $_ln['jrForum'][102],
        'help'     => $_ln['jrForum'][103]
    );
    jrCore_form_field_create($_tmp);

    // Category Read Only
    $_tmp = array(
        'name'     => 'cat_read_only',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'off',
        'label'    => $_ln['jrForum'][81],
        'help'     => $_ln['jrForum'][82]
    );
    jrCore_form_field_create($_tmp);

    return jrCore_page_display(true);
}
