<?php
/**
 * @copyright 2022 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * profile view: cat_delete_save
 * @param array $_profile Profile DS data
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function profile_view_jrForum_cat_delete_save($_profile, $_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    jrUser_check_quota_access('jrForum');
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }
    // we must get a valid id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid category id');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrForum', 'category');
    $req = "SELECT cat_title FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' AND cat_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid category id (2)');
        jrCore_location('referrer');
    }
    $_ln = jrUser_load_lang_strings();
    // Make sure there are no topics in this category
    $_sc = array(
        'search'         => array(
            "forum_cat = {$_rt['cat_title']}",
            "forum_profile_id = {$_profile['_profile_id']}"
        ),
        'return_count'   => true,
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'limit'          => 100000
    );
    $_tp = jrCore_db_search_items('jrForum', $_sc);
    if (is_array($_tp) && is_array($_tp['_items'])) {
        jrCore_set_form_notice('error', $_ln['jrForum'][85]);
        jrCore_location('referrer');
    }
    $req = "DELETE FROM {$tbl} WHERE cat_id = '{$_post['id']}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {

        // If we delete the LAST category, we disable categories in our settings
        $req = "SELECT COUNT(cat_id) as cat_count FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}'";
        $_cc = jrCore_db_query($req, 'SINGLE');
        if (!$_cc || $_cc['cat_count'] == '0') {

            // No more categories for this profile - turn of category support
            $_cfg = jrForum_get_config($_profile['_profile_id']);
            unset($_cfg['enable_cats']);
            $_rt = array(
                'profile_jrForum_settings' => json_encode($_cfg)
            );
            jrCore_db_update_item('jrProfile', $_profile['_profile_id'], $_rt);
        }
        jrProfile_reset_cache($_profile['_profile_id'], 'jrForum');
        jrCore_set_form_notice('success', $_ln['jrForum'][86]);
    }
    else {
        jrCore_set_form_notice('success', $_ln['jrForum'][84]);
    }
    $murl = jrCore_get_module_url('jrForum');
    jrCore_location("{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$murl}/categories");
}
