<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: integrity_check_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFollower_integrity_check_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    jrCore_logger('INF', 'Followers: integrity check started');
    ini_set('max_execution_time', 82800); // 23 hours max

    // Module install validation
    if (isset($_post['validate_counts']) && $_post['validate_counts'] == 'on') {

        jrCore_form_modal_notice('update', "validating profile follower counts");

        // Get profiles
        $pid = 0;
        $tot = 0;
        while (true) {
            $_sc = array(
                'search'         => array(
                    "_item_id > {$pid}"
                ),
                'return_keys'    => array('_profile_id'),
                'skip_triggers'  => true,
                'ignore_pending' => true,
                'privacy_check'  => false,
                'limit'          => 250
            );
            $_rt = jrCore_db_search_items('jrProfile', $_sc);
            if ($_rt && is_array($_rt) && is_array($_rt['_items'])) {
                $_dt = array();
                $str = $_rt['_items'][0]['_profile_id'];
                foreach ($_rt['_items'] as $v) {
                    $pid       = $v['_profile_id'];
                    $cnt       = jrFollower_get_profile_follower_count($pid);
                    $_dt[$pid] = array('profile_jrFollower_item_count' => $cnt);
                    $tot++;
                }
                $upd = count($_dt);
                if ($upd > 0) {
                    jrCore_db_update_multiple_items('jrProfile', $_dt);
                    jrCore_form_modal_notice('update', "updated follower counts for {$upd} profiles ({$str} - {$pid})");
                }
            }
            else {
                // No more profiles...
                break;
            }
        }
        jrCore_form_modal_notice('update', "successfully validated profile follower counts for {$tot} profiles");
    }
    jrCore_form_delete_session();
    jrCore_logger('INF', 'Followers: integrity check completed');
    jrCore_form_modal_notice('complete', 'The follower integrity check options successfully completed');
    exit;
}
