<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: follow
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFollower_follow($_post, $_user, $_conf)
{
    // [_uri] => /fans/follow/5/__ajax=1
    // [module_url] => fans
    // [module] => jrFollower
    // [option] => follow
    // [_1] => 5 (profile_id to be followed)
    // [__ajax] => 1

    jrUser_session_require_login();
    jrCore_validate_location_url();

    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        $_rs = array('error' => 'invalid profile_id - please try again');
        jrCore_json_response($_rs);
    }

    $_ln = jrUser_load_lang_strings();
    $pid = (int) $_post['_1'];

    // First - see if this user is already following
    if (jrFollower_is_follower($_user['_user_id'], $pid)) {
        // User is already a follower
        $_rs = array('OK' => 1, 'VALUE' => $_ln['jrFollower'][2]);
        jrCore_json_response($_rs);
    }

    // check to see if this is an existing profile
    $_pi = jrCore_db_get_item('jrProfile', $pid, true);
    if (!$_pi || !is_array($_pi) || !isset($_pi['_profile_id'])) {
        $_rs = array('error' => 'invalid profile_id - please try again');
        jrCore_json_response($_rs);
    }
    // We need to see if this profile is requiring approval of followers
    $act = 1;
    if (isset($_pi['profile_jrFollower_approve']) && $_pi['profile_jrFollower_approve'] == 'on') {
        $act = 0;
    }

    // Create our new following entry
    if ($fid = jrFollower_create_follow($_user['_user_id'], $pid, $act)) {

        if ($act === 0) {
            // Notify owners
            if ($_owners = jrProfile_get_owner_info($pid)) {
                // Send out email to profile owners letting them know of the new PENDING follower
                $_rp = array(
                    'system_name'          => $_conf['jrCore_system_name'],
                    'follower_name'        => $_user['user_name'],
                    'follower_url'         => "{$_conf['jrCore_base_url']}/" . jrUser_get_profile_home_key('profile_url'),
                    'approve_follower_url' => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/{$pid}/{$_pi['profile_url']}",
                    '_profile'             => $_pi
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrFollower', 'approve', $_rp);
                foreach ($_owners as $_o) {
                    jrUser_notify($_o['_user_id'], 0, 'jrFollower', 'follower_pending', $sub, $msg);
                }
            }
            $_rs = array('PENDING' => 1, 'VALUE' => $_ln['jrFollower'][5]);
        }
        else {
            // Notify owners
            if ($_owners = jrProfile_get_owner_info($pid)) {
                $_rp = array(
                    'profile_url'          => $_pi['profile_url'],
                    'system_name'          => $_conf['jrCore_system_name'],
                    'follower_name'        => $_user['user_name'],
                    'follower_profile_url' => "{$_conf['jrCore_base_url']}/" . jrUser_get_profile_home_key('profile_url'),
                    'follower_browse_url'  => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/{$pid}/{$_pi['profile_url']}",
                    '_profile'             => $_pi
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrFollower', 'new_follower', $_rp);
                foreach ($_owners as $_o) {
                    jrUser_notify($_o['_user_id'], 0, 'jrFollower', 'new_follower', $sub, $msg);
                }
            }

            // Increment Profile counts...
            jrCore_db_increment_key('jrProfile', $pid, 'profile_jrFollower_item_count', 1);

            // Add to Actions...
            if (jrFollower_is_action_enabled($_user)) {
                $upid = jrUser_get_profile_home_key('_profile_id');
                $_pt  = jrCore_db_get_item('jrProfile', $upid);
                $_sav = array(
                    'action_original_module'  => 'jrProfile',
                    'action_original_item_id' => $pid,
                    'quota_jrAction_allowed'  => (isset($_pt['quota_jrAction_allowed'])) ? $_pt['quota_jrAction_allowed'] : false
                );
                jrCore_run_module_function('jrAction_save', 'create', 'jrFollower', $fid, $_sav, false, $upid);
                jrProfile_reset_cache($upid, 'jrFollower');
            }
            $_rs = array('OK' => 1, 'VALUE' => $_ln['jrFollower'][2]);
        }

        jrProfile_reset_cache($pid, 'jrFollower');
        jrUser_reset_cache($_user['_user_id'], 'jrFollower');
        jrCore_json_response($_rs);

    }
    $_rs = array('error' => 'error creating follow request - please try again');
    jrCore_json_response($_rs);
}
