tinymce.PluginManager.add('jrembed', function(editor, url) {

    var showDialog = function() {
        var w = (tinymce.DOM.getViewPort().w - 200);
        if (w > 1140) {
            w = 1140;
        }
        if (w < 400) {
            w = 400;
        }
        var h = (tinymce.DOM.getViewPort().h - 200);
        if (h > 800) {
            h = 800;
        }
        return editor.windowManager.openUrl({
            title: 'Embed Local Media',
            url: core_system_url + '/' + jrEmbed_url + '/tabs/__ajax=1',
            width: w,
            height: h,
            buttons: [
                {
                    type: 'cancel',
                    text: 'Close'
                },
            ]
        });
    };
    editor.ui.registry.addButton('jrembed', {
        icon: 'embed',
        name: 'jrembed',
        tooltip: "Embed Local Media",
        onAction: function() {
            showDialog()
        }
    });
    editor.shortcuts.add('ctrl+shift+e', "Embed Local Media", function() {
        showDialog();
    });
    editor.shortcuts.add('ctrl+e', "Embed Local Media", function() {
        showDialog();
    });
});