<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: rebase_modules
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_rebase_modules($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    // Make sure the skin directory is writable by the web user
    if (!is_writable(APP_DIR . '/modules')) {
        jrCore_set_form_notice('error', 'The modules directory is not writable by the web user - unable to rebase modules');
        jrCore_page_banner('Rebase Modules');
        jrCore_get_form_notice();
        jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    }
    jrCore_page_banner('Rebase Modules');
    jrCore_page_notice('error', '<b>Warning!</b> Do not run this rebase tool on a live Jamroom site!<br>This tool is designed for Jamroom Developers working with the Git version control system', false);

    // Form init
    $_tmp = array(
        'submit_value'  => 'Rebase Modules',
        'cancel'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'submit_prompt' => 'Are you sure you want to rebase the modules?',
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'  => 'delete_old',
        'label' => 'rebase modules',
        'help'  => "After rebasing, would you like to delete old versions of the module from the file system?",
        'type'  => 'checkbox'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
