<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: query_stats
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_query_stats($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    $url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/query_stats_reset_save";
    $btn = jrCore_page_button('delete', 'Reset', "jrCore_confirm('Reset the Query Counts?', '', function(){ jrCore_window_location('{$url}') })");
    jrCore_page_banner('database query counts', $btn);
    if (!function_exists('apcu_cache_info')) {
        jrCore_notice_page('error', 'APCu Cache Function must be enabled in your PHP install to view Query counts');
    }

    // Start our output
    $dat             = array();
    $dat[1]['title'] = 'file';
    $dat[1]['width'] = '55%';
    $dat[2]['title'] = 'line number';
    $dat[2]['width'] = '15%';
    $dat[3]['title'] = 'query count';
    $dat[3]['width'] = '15%';
    $dat[4]['title'] = 'AVG query time (MS)';
    $dat[4]['width'] = '15%';
    jrCore_page_table_header($dat);

    $run = true;
    $_rt = array();
    $_nw = array();
    if (jrCore_module_is_active('jrCloudClient') && jrCloudClient_get_this_server_name()) {
        if ($_rt = jrCloudClient_run_server_role_function('app', 'jrDeveloper_get_query_count_data')) {
            foreach ($_rt as $k => $v) {
                if ($v = json_decode($v, true)) {
                    $_rt[$k] = $v['data'];
                }
            }
            $run = false;
        }
    }
    if ($run) {
        $_rt = array(jrDeveloper_get_query_count_data());
    }
    if ($_rt && is_array($_rt)) {
        $_qs = array();
        // Gather
        foreach ($_rt as $server) {
            foreach ($server['keys'] as $key => $count) {
                // $key consists of
                // <pfx>:c:<md5 key>:<file>:<line number> => <number of times called>
                list(, , $key, $script, $line) = explode(':', $key, 5);
                if (!isset($_qs[$key])) {
                    $_qs[$key] = array(0, 0, $script, $line);
                }
                else {
                    $_qs[$key][2] = $script;
                    $_qs[$key][3] = $line;
                }
                $_qs[$key][0] = $count;
            }
            foreach ($server['time'] as $key => $msecs) {
                // $key consists of
                // <pfx>:d:<md5 key> => <cumulative ms>
                list(, , $key) = explode(':', $key, 3);
                if (!isset($_qs[$key])) {
                    $_qs[$key] = array(0, 0);
                }
                $_qs[$key][1] = $msecs;
            }
        }
        // Sort
        $_nw = array();
        foreach ($_qs as $key => $e) {
            if (!strpos($e[2], 'ata/cache')) {
                $total = round($e[1] / $e[0]);
                if ($total > 0) {
                    $_nw[$key] = $total;
                }
            }
        }
        arsort($_nw);
        if (count($_nw) > 500) {
            $_nw = array_slice($_nw, 0, 500);
        }
        foreach ($_nw as $key => $v) {
            $dat             = array();
            $dat[1]['title'] = str_replace(APP_DIR . '/', '', $_qs[$key][2]);
            $dat[2]['title'] = jrCore_number_format($_qs[$key][3]);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrCore_number_format($_qs[$key][0]);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_number_format($v);
            $dat[4]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
    }
    if (count($_nw) === 0) {
        $dat             = array();
        $dat[1]['title'] = 'No recorded database query statistics';
        $dat[1]['class'] = 'p10 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_display();
}
