<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: clone_skin
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_clone_skin($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    // Make sure the skin directory is writable by the web user
    if (!is_writable(APP_DIR . '/skins')) {
        jrCore_set_form_notice('error', 'The skin directory is not writable by the web user - unable to clone a skin');
        jrCore_page_banner('Clone Skin');
        jrCore_get_form_notice();
        jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    }
    else {

        jrCore_set_form_notice('success', "&bull; <strong>Active</strong> customized templates will be copied to the template file of the new skin<br>&bull; <strong>Inactive</strong> customized templates will be copied to the new skin but left inactive<br>&bull; <strong>Skin Settings</strong> will be copied with their existing values to the new skin<br>&bull; <strong>Custom Skin Images</strong> will be copied to the new skin<br>&bull; <strong>Customized Language</strong> strings will be copied to the new skin<br>&bull; <strong>Custom Style</strong> changes will be copied to the new skin", false);
        jrCore_page_banner('Clone Skin');

        // Form init
        $_tmp = array(
            'submit_value'  => 'clone skin',
            'cancel'        => 'referrer',
            'submit_prompt' => 'Are you sure you want to clone the selected skin?',
        );
        jrCore_form_create($_tmp);

        $_tmp = array();
        $_opt = jrCore_get_skins();
        if ($_opt && is_array($_opt)) {
            foreach ($_opt as $s => $d) {
                $_mta     = jrCore_skin_meta_data($s);
                $_tmp[$s] = (isset($_mta['title'])) ? $_mta['title'] : $s;
            }
        }
        $_tmp = array(
            'name'     => 'skin_to_clone',
            'type'     => 'select',
            'options'  => $_tmp,
            'default'  => $_conf['jrCore_active_skin'],
            'required' => 'on',
            'label'    => 'Skin to Clone',
            'help'     => 'Select the skin that you want to make a clone of.',
            'section'  => 'clone skin'
        );
        jrCore_form_field_create($_tmp);

        $_tmp = array(
            'name'        => 'skin_name',
            'label'       => 'Skin Directory',
            'sublabel'    => 'The name of the new skin directory',
            'help'        => "Enter the directory you would like to save this new skin as - only letters, numbers and underscores are allowed.<br><br><b>NOTE:</b> If you are not a Jamroom developer use <b>xx</b> as the developer prefix - i.e. <b>xx</b>SkinName.",
            'type'        => 'text',
            'value'       => '',
            'min'         => 3,
            'placeholder' => 'xx???',
            'required'    => 'on',
            'validate'    => 'core_string'
        );
        if (!empty($_conf['jrDeveloper_developer_prefix'])) {
            $_tmp['placeholder'] = $_conf['jrDeveloper_developer_prefix'] . '???';
            $_tmp['sublabel']    = "must begin with &quot;{$_conf['jrDeveloper_developer_prefix']}&quot;";
        }
        jrCore_form_field_create($_tmp);

        $_tmp = array(
            'name'       => 'skin_title',
            'label'      => 'Skin Title',
            'help'       => 'Enter the name of this new skin',
            'type'       => 'text',
            'value'      => '',
            'validate'   => 'not_empty',
            'required'   => 'on',
            'onkeypress' => "if (event && event.keyCode == 13) return false;"
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
