<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.1.0
*/

namespace Adminer;

// Set it up so it works in Jamroom
define('APP_DIR', '../..');
require APP_DIR . '/modules/jrCore/include.php';
jrCore_init();

// Make sure it is a master admin
$_user = jrUser_session_start();
jrUser_session_require_login();
jrUser_master_only();

// Our db server info
if (isset($_SERVER['JR_MASTER_HOST'])) {
    $_conf['master_host'] = $_SERVER['JR_MASTER_HOST'];
}

if ($_SERVER['QUERY_STRING'] === '' || empty($_COOKIE['adminer_permanent'])) {
    $_POST['auth']['driver']    = 'server';
    $_POST['auth']['db']        = $_conf['jrCore_db_name'];
    $_POST['auth']['server']    = "{$_conf['jrCore_db_host']}:{$_conf['jrCore_db_port']}";
    $_POST['auth']['username']  = $_conf['jrCore_db_user'];
    $_POST['auth']['password']  = $_conf['jrCore_db_pass'];
    $_POST['auth']['permanent'] = 1;
}

if (!isset($_conf['jrCore_db_prefix'])) {
    $_conf['jrCore_db_prefix'] = 'jr_';
}
$GLOBALS['prefix'] = $_conf['jrCore_db_prefix'];

$ga="5.1.0";error_reporting(24575);set_error_handler(function($lc,$nc){return!!preg_match('~^(Trying to access array offset on( value of type)? null|Undefined (array key|offset|index))~',$nc);},E_WARNING|E_NOTICE);$Fc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Fc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Sh=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Sh)$$X=$Sh;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$f;return$f;}function
adminer(){global$b;return$b;}function
driver(){global$l;return$l;}function
version(){global$ga;return$ga;}function
idf_unescape($rd){if(!preg_match('~^[`\'"[]~',$rd))return$rd;$Td=substr($rd,-1);return
str_replace($Td.$Td,$Td,substr($rd,1,-1));}function
q($Xg){global$f;return$f->quote($Xg);}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($Rf,$Fc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($Rf)){foreach($X
as$Md=>$W){unset($Rf[$y][$Md]);if(is_array($W)){$Rf[$y][stripslashes($Md)]=$W;$Rf[]=&$Rf[$y][stripslashes($Md)];}else$Rf[$y][stripslashes($Md)]=($Fc?$W:stripslashes($W));}}}}function
bracket_escape($rd,$za=false){static$Fh=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($rd,($za?array_flip($Fh):$Fh));}function
min_version($hi,$ge="",$g=null){global$f;if(!$g)$g=$f;$Ag=$g->server_info;if($ge&&preg_match('~([\d.]+)-MariaDB~',$Ag,$B)){$Ag=$B[1];$hi=$ge;}return$hi&&version_compare($Ag,$hi)>=0;}function
charset($f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
ini_bool($zd){$X=ini_get($zd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$K;if($K===null)$K=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$K;}function
set_password($gi,$P,$V,$G){$_SESSION["pwds"][$gi][$P][$V]=($_COOKIE["adminer_key"]&&is_string($G)?array(encrypt_string($G,$_COOKIE["adminer_key"])):$G);}function
get_password(){$K=get_session("pwds");if(is_array($K))$K=($_COOKIE["adminer_key"]?decrypt_string($K[0],$_COOKIE["adminer_key"]):false);return$K;}function
get_val($I,$n=0){global$f;return$f->result($I,$n);}function
get_vals($I,$d=0){global$f;$K=array();$J=$f->query($I);if(is_object($J)){while($L=$J->fetch_row())$K[]=$L[$d];}return$K;}function
get_key_vals($I,$g=null,$Dg=true){global$f;if(!is_object($g))$g=$f;$K=array();$J=$g->query($I);if(is_object($J)){while($L=$J->fetch_row()){if($Dg)$K[$L[0]]=$L[1];else$K[]=$L[0];}}return$K;}function
get_rows($I,$g=null,$m="<p class='error'>"){global$f;$jb=(is_object($g)?$g:$f);$K=array();$J=$jb->query($I);if(is_object($J)){while($L=$J->fetch_assoc())$K[]=$L;}elseif(!$J&&!is_object($g)&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$K;}function
unique_array($L,$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$K=array();foreach($w["columns"]as$y){if(!isset($L[$y]))continue
2;$K[$y]=$L[$y];}return$K;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where($Z,$o=array()){global$f;$K=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,1);$d=escape_key($y);$Dc=$o[$y]["type"];$K[]=$d.(JUSH=="sql"&&$Dc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Dc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($o[$y],q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$Dc)&&preg_match("~[^ -@]~",$X))$K[]="$d = ".q($X)." COLLATE ".charset($f)."_bin";}foreach((array)$Z["null"]as$y)$K[]=escape_key($y)." IS NULL";return
implode(" AND ",$K);}function
where_check($X,$o=array()){parse_str($X,$Pa);remove_slashes(array(&$Pa));return
where($Pa,$o);}function
where_link($u,$d,$Y,$Xe="="){return"&where%5B$u%5D%5Bcol%5D=".urlencode($d)."&where%5B$u%5D%5Bop%5D=".urlencode(($Y!==null?$Xe:"IS NULL"))."&where%5B$u%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$o,$O=array()){$K="";foreach($e
as$y=>$X){if($O&&!in_array(idf_escape($y),$O))continue;$sa=convert_field($o[$y]);if($sa)$K.=", $sa AS ".idf_escape($y);}return$K;}function
cookie($D,$Y,$be=2592000){global$ba;return
header("Set-Cookie: $D=".urlencode($Y).($be?"; expires=".gmdate("D, d M Y H:i:s",time()+$be)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($pb){parse_str($_COOKIE[$pb],$Eg);return$Eg;}function
get_setting($y,$pb="adminer_settings"){$Eg=get_settings($pb);return$Eg[$y];}function
save_settings($Eg,$pb="adminer_settings"){return
cookie($pb,http_build_query($Eg+get_settings($pb)));}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($Kc=false){$ai=ini_bool("session.use_cookies");if(!$ai||$Kc){session_write_close();if($ai&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($gi,$P,$V,$j=null){global$Qb;$Wh=remove_from_uri(implode("|",array_keys($Qb))."|username|ext|".($j!==null?"db|":"").($gi=='mssql'||$gi=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Wh,$B);return"$B[1]?".(sid()?SID."&":"").($gi!="server"||$P!=""?urlencode($gi)."=".urlencode($P)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$C=null){if($C!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$C;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($I,$A,$C,$Zf=true,$sc=true,$_c=false,$th=""){global$f,$m,$b;if($sc){$Tg=microtime(true);$_c=!$f->query($I);$th=format_time($Tg);}$Og="";if($I)$Og=$b->messageQuery($I,$th,$_c);if($_c){$m=error().$Og.script("messagesPrint();");return
false;}if($Zf)redirect($A,$C.$Og);return
true;}function
queries($I){global$f;static$Uf=array();static$Tg;if(!$Tg)$Tg=microtime(true);if($I===null)return
array(implode("\n",$Uf),format_time($Tg));$Uf[]=(preg_match('~;$~',$I)?"DELIMITER ;;\n$I;\nDELIMITER ":$I).";";return$f->query($I);}function
apply_queries($I,$T,$oc='Adminer\table'){foreach($T
as$R){if(!queries("$I ".$oc($R)))return
false;}return
true;}function
queries_redirect($A,$C,$Zf){list($Uf,$th)=queries(null);return
query_redirect($Uf,$A,$C,$Zf,false,!$Zf,$th);}function
format_time($Tg){return
sprintf('%.3f s',max(0,microtime(true)-$Tg));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($rf=""){return
substr(preg_replace("~(?<=[?&])($rf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Db=false,$Hb=""){$Ec=$_FILES[$y];if(!$Ec)return
null;foreach($Ec
as$y=>$X)$Ec[$y]=(array)$X;$K='';foreach($Ec["error"]as$y=>$m){if($m)return$m;$D=$Ec["name"][$y];$Ah=$Ec["tmp_name"][$y];$lb=file_get_contents($Db&&preg_match('~\.gz$~',$D)?"compress.zlib://$Ah":$Ah);if($Db){$Tg=substr($lb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Tg))$lb=iconv("utf-16","utf-8",$lb);elseif($Tg=="\xEF\xBB\xBF")$lb=substr($lb,3);}$K.=$lb;if($Hb)$K.=(preg_match("($Hb\\s*\$)",$lb)?"":$Hb)."\n\n";}return$K;}function
upload_error($m){$ne=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?'Unable to upload a file.'.($ne?" ".sprintf('Maximum allowed file size is %sB.',$ne):""):'File does not exist.');}function
repeat_pattern($zf,$Zd){return
str_repeat("$zf{0,65535}",$Zd/65535)."$zf{0,".($Zd%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($Xg,$Zd=80,$bh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Zd).")($)?)u",$Xg,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Zd).")($)?)",$Xg,$B);return
h($B[1]).$bh.(isset($B[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",','),preg_split('~~u','0123456789',-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Ac=false){$K=table_status($R,$Ac);return($K?:array("Name"=>$R));}function
column_foreign_keys($R){global$b;$K=array();foreach($b->foreignKeys($R)as$q){foreach($q["source"]as$X)$K[$X][]=$q;}return$K;}function
fields_from_edit(){global$l;$K=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$D=bracket_escape($y,1);$K[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==$l->primary),);}return$K;}function
dump_headers($pd,$ze=false){global$b;$K=$b->dumpHeaders($pd,$ze);$of=$_POST["output"];if($of!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($pd).".$K".($of!="file"&&preg_match('~^[0-9a-z]+$~',$of)?".$of":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$K;}function
dump_csv($L){foreach($L
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$L[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$L)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$K=ini_get("upload_tmp_dir");if(!$K){if(function_exists('sys_get_temp_dir'))$K=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return
false;$K=dirname($p);unlink($p);}}return$K;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$yb){rewind($r);fwrite($r,$yb);ftruncate($r,strlen($yb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first($ra){return
reset($ra);}function
password_file($h){$p=get_temp_dir()."/adminer.key";if(!$h&&!file_exists($p))return
false;$r=file_open_lock($p);if(!$r)return
false;$K=stream_get_contents($r);if(!$K){$K=rand_string();file_write_unlock($r,$K);}else
file_unlock($r);return$K;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$_,$n,$sh){global$b;if(is_array($X)){$K="";foreach($X
as$Md=>$W)$K.="<tr>".($X!=array_values($X)?"<th>".h($Md):"")."<td>".select_value($W,$_,$n,$sh);return"<table>$K</table>";}if(!$_)$_=$b->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$K=$b->editVal($X,$n);if($K!==null){if(!is_utf8($K))$K="\0";elseif($sh!=""&&is_shortable($n))$K=shorten_utf8($K,max(0,+$sh));else$K=h($K);}return$b->selectVal($K,$_,$n,$X);}function
is_mail($bc){$ta='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Pb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$zf="$ta+(\\.$ta+)*@($Pb?\\.)+$Pb";return
is_string($bc)&&preg_match("(^$zf(,\\s*$zf)*\$)i",$bc);}function
is_url($Xg){$Pb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Pb?\\.)+$Pb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Xg);}function
is_shortable($n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($R,$Z,$Gd,$t){$I=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($Gd&&(JUSH=="sql"||count($t)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$t).")$I":"SELECT COUNT(*)".($Gd?" FROM (SELECT 1$I GROUP BY ".implode(", ",$t).") x":$I));}function
slow_query($I){global$b,$Bh,$l;$j=$b->database();$uh=$b->queryTimeout();$Ig=$l->slowQuery($I,$uh);$g=null;if(!$Ig&&support("kill")&&is_object($g=connect($b->credentials()))&&($j==""||$g->select_db($j))){$Od=$g->result(connection_id());echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Od&token=$Bh'); }, 1000 * $uh);");}ob_flush();flush();$K=@get_key_vals(($Ig?:$I),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$K;}function
get_token(){$Xf=rand(1,1e6);return($Xf^$_SESSION["token"]).":$Xf";}function
verify_token(){list($Bh,$Xf)=explode(":",$_POST["token"]);return($Xf^$_SESSION["token"])==$Bh;}function
lzw_decompress($Ea){$Lb=256;$Fa=8;$Xa=array();$jg=0;$kg=0;for($u=0;$u<strlen($Ea);$u++){$jg=($jg<<8)+ord($Ea[$u]);$kg+=8;if($kg>=$Fa){$kg-=$Fa;$Xa[]=$jg>>$kg;$jg&=(1<<$kg)-1;$Lb++;if($Lb>>$Fa)$Fa++;}}$Kb=range("\0","\xFF");$K="";foreach($Xa
as$u=>$Wa){$ac=$Kb[$Wa];if(!isset($ac))$ac=$qi.$qi[0];$K.=$ac;if($u)$Kb[]=$qi.$ac[0];$qi=$ac;}return$K;}function
script($Lg,$Eh="\n"){return"<script".nonce().">$Lg</script>$Eh";}function
script_src($Xh){return"<script src='".h($Xh)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($D,$Y=""){return"<input type='hidden' name='".h($D)."' value='".h($Y)."'>\n";}function
input_token($Ng=""){global$Bh;return
input_hidden("token",($Ng?:$Bh));}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Xg){return
str_replace("\0","&#0;",htmlspecialchars($Xg,ENT_QUOTES,'utf-8'));}function
nl_br($Xg){return
str_replace("\n","<br>",$Xg);}function
checkbox($D,$Y,$Ra,$Qd="",$We="",$Va="",$Rd=""){$K="<input type='checkbox' name='$D' value='".h($Y)."'".($Ra?" checked":"").($Rd?" aria-labelledby='$Rd'":"").">".($We?script("qsl('input').onclick = function () { $We };",""):"");return($Qd!=""||$Va?"<label".($Va?" class='$Va'":"").">$K".h($Qd)."</label>":$K);}function
optionlist($af,$wg=null,$bi=false){$K="";foreach($af
as$Md=>$W){$bf=array($Md=>$W);if(is_array($W)){$K.='<optgroup label="'.h($Md).'">';$bf=$W;}foreach($bf
as$y=>$X)$K.='<option'.($bi||is_string($y)?' value="'.h($y).'"':'').($wg!==null&&($bi||is_string($y)?(string)$y:$X)===$wg?' selected':'').'>'.h($X);if(is_array($W))$K.='</optgroup>';}return$K;}function
html_select($D,$af,$Y="",$Ve="",$Rd=""){return"<select name='".h($D)."'".($Rd?" aria-labelledby='$Rd'":"").">".optionlist($af,$Y)."</select>".($Ve?script("qsl('select').onchange = function () { $Ve };",""):"");}function
html_radios($D,$af,$Y=""){$K="";foreach($af
as$y=>$X)$K.="<label><input type='radio' name='".h($D)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$K;}function
confirm($C="",$xg="qsl('input')"){return
script("$xg.onclick = () => confirm('".($C?js_escape($C):'Are you sure?')."');","");}function
print_fieldset($v,$Yd,$ki=false){echo"<fieldset><legend>","<a href='#fieldset-$v'>$Yd</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$v');",""),"</legend>","<div id='fieldset-$v'".($ki?"":" class='hidden'").">\n";}function
bold($Ha,$Va=""){return($Ha?" class='active $Va'":($Va?" class='$Va'":""));}function
js_escape($Xg){return
addcslashes($Xg,"\r\n'\\/");}function
pagination($E,$vb){return" ".($E==$vb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
hidden_fields($Rf,$sd=array(),$Kf=''){$K=false;foreach($Rf
as$y=>$X){if(!in_array($y,$sd)){if(is_array($X))hidden_fields($X,array(),$y);else{$K=true;echo
input_hidden(($Kf?$Kf."[$y]":$y),$X);}}}return$K;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$ua,$n,$Y,$ec=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$ie);$K=($ec!==null?"<label><input type='$U'$ua value='$ec'".((is_array($Y)?in_array($ec,$Y):$Y===$ec)?" checked":"")."><i>".'empty'."</i></label>":"");foreach($ie[1]as$u=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ra=(is_array($Y)?in_array($X,$Y):$Y===$X);$K.=" <label><input type='$U'$ua value='".h($X)."'".($Ra?' checked':'').'>'.h($b->editVal($X,$n)).'</label>';}return$K;}function
input($n,$Y,$s,$ya=false){global$l,$b;$D=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$ig=(JUSH=="mssql"&&$n["auto_increment"]);if($ig&&!$_POST["save"])$s=null;$Tc=(isset($_GET["select"])||$ig?array("orig"=>'original'):array())+$b->editFunctions($n);$Mb=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$ua=" name='fields[$D]'$Mb".($ya?" autofocus":"");$kc=$l->enumLength($n);if($kc){$n["type"]="enum";$n["length"]=$kc;}echo$l->unconvertFunction($n)." ";if($n["type"]=="enum")echo
h($Tc[""])."<td>".$b->editInput($_GET["edit"],$n,$ua,$Y);else{$fd=(in_array($s,$Tc)||isset($Tc[$s]));echo(count($Tc)>1?"<select name='function[$D]'$Mb>".optionlist($Tc,$s===null||$fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Tc))).'<td>';$Ad=$b->editInput($_GET["edit"],$n,$ua,$Y);if($Ad!="")echo$Ad;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$ua value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$ua value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$ie);foreach($ie[1]as$u=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ra=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$D][$u]' value='".h($X)."'".($Ra?' checked':'').">".h($b->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$ua cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($rh=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($rh&&JUSH!="sqlite")$ua.=" cols='50' rows='12'";else{$M=min(12,substr_count($Y,"\n")+1);$ua.=" cols='30' rows='$M'";}echo"<textarea$ua>".h($Y).'</textarea>';}else{$Nh=$l->types();$pe=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$B)?((preg_match("~binary~",$n["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$n["unsigned"]?1:0)):($Nh[$n["type"]]?$Nh[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$pe+=7;echo"<input".((!$fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($pe?" data-maxlength='$pe'":"").(preg_match('~char|binary~',$n["type"])&&$pe>20?" size='".($pe>99?60:40)."'":"")."$ua>";}echo$b->editHint($_GET["edit"],$n,$Y);$Gc=0;foreach($Tc
as$y=>$X){if($y===""||!$X)break;$Gc++;}if($Gc&&count($Tc)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Gc);");}}function
process_input($n){global$b,$l;if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return
null;$rd=bracket_escape($n["field"]);$s=$_POST["function"][$rd];$Y=$_POST["fields"][$rd];if($n["type"]=="enum"||$l->enumLength($n)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$Ec=get_file("fields-$rd");if(!is_string($Ec))return
false;return$l->quoteBinary($Ec);}return$b->processInput($n,$Y,$s);}function
search_tables(){global$b,$f;$_GET["where"][0]["val"]=$_POST["query"];$zg="<ul>\n";foreach(table_status('',true)as$R=>$S){$D=$b->tableName($S);if(isset($S["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$J=$f->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($R),array())),1));if(!$J||$J->fetch_row()){$Nf="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$zg<li>".($J?$Nf:"<p class='error'>$Nf: ".error())."\n";$zg="";}}}echo($zg?"<p class='message'>".'No tables.':"</ul>")."\n";}function
on_help($db,$Gg=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $db, $Gg) }, onmouseout: helpMouseout});","");}function
edit_form($R,$o,$L,$Vh){global$b,$m;$gh=$b->tableName(table_status1($R,true));page_header(($Vh?'Edit':'Insert'),$m,array("select"=>array($R,$gh)),$gh);$b->editRowPrint($R,$o,$L,$Vh);if($L===false){echo"<p class='error'>".'No rows.'."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".'You have no privileges to update this table.'."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$ya=!$_POST;foreach($o
as$D=>$n){echo"<tr><th>".$b->fieldName($n);$k=$_GET["set"][bracket_escape($D)];if($k===null){$k=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$k,$gg))$k=$gg[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$k=bin2hex($k);}$Y=($L!==null?($L[$D]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($L[$D])?implode(",",$L[$D]):(is_bool($L[$D])?+$L[$D]:$L[$D])):(!$Vh&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$k)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$n);$s=($_POST["save"]?(string)$_POST["function"][$D]:($Vh&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Vh&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($ya!==false)$ya=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$ya);if($ya)$ya=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".'Save'."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($Vh?'Save and continue edit':'Save and insert next')."' title='Ctrl+Shift+Enter'>\n",($Vh?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".'Saving'."…', this); };"):"");}echo($Vh?"<input type='submit' name='delete' value='".'Delete'."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}if(isset($_GET["file"])){if(substr($ga,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0�\0\n @\0�C��\"\0`E�Q����?�tvM'�Jd�d\\�b0\0�\"��fӈ��s5����A�XPaJ�0���8�#R�T��z`�#.��c�X��Ȁ?�-\0�Im?�.�M��\0ȯ(̉��/(%�\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("b7�'���o9�c`��a1���#y��d��C�1��tFQx�\\2�\n�S���n0�'#I��,\$M�c)��c����1i�Xi3ͦ���n)T�i��d:FcI�[��c��	��Fé�vt2�+�C,�a�G�F����:;Nu�)����Ǜ!�tl���F�|��,�`pw�S-����������oQk�� n�E��O+,=�4�mM���Ƌ�GS��Zh�6��. uO�M�C@����M'�(�b5�ҩ��H�a2)�qиpe6�?t#Z-���ox�<���s���;��H�4\$�䥍�ۚ��a�4�\"�(�!C,D�N��;����Jj����@�@�!����K�����6��jX�\r����@ 2@�b��(Z�Apl��8��h�.�=*H�4q3�AЂ�.��K���!�f�qr�!�1�Ȏ�c���*+ �(�\n�2�j���(dYA���D�t�ϑ�m*R�P�Qb#J+�1��N���̙>�A�wK�C`�P���=��<��@�̊��c��]Rr�C����H���Z�մ\0�=P��\$�@o�(����0C�G-��Z�Aʅt3:t���c��͵J����lc��R����\n�r��l�Ψk�9G��p�!pj�_X]h�Xfu��0̳�ҝ�0�=�C��6#˞75�s,�(f#z�X>3[�n?��1m�\\X��PX�eggJ4>��� \\T��?�H�3�y�~�hx�t6��%u��8L��m\nX���i���M��[����,�Y��P��9|~O�1���*�5+ӣ��1d{o=��g���x,��E�P��K��sк�E^4�f�;�*J��#j=�k�t�8�W1v�h��������ԃ�3�B��t�ȧ����.^̀os�`�?��7}?Z�]y���[iPn���W�������\"�z�x\"���4ؽr�?'�\"@g���f!�637�QCA�\r��Y��T�P�}@���M�}ͽ+����{�!��ղ������ݜ��4׹ G	I��\0^�RN}E���DY��{��/>����#Ɓ*��n��:��Fp��hn%����w#�����p΍�\\�\0��P����+�E�\r��)sL�ӱ�d\r��@�������-\$���V]Ã����;��d���0�\0X%ܰQ��*� w]�d��X�y�a&3M�M8�rXE�lQ%ֽB2�t�!\0�1,�ʈ�TI�-�4��hee3�ņD�n�.���P�'��3Ն���Z�R�sx�i�8��.�3�FI֒Ԛb�Si�i2�)�+\r+p�Cc9..i�paI�xn�԰�Rja�O)�\raĘ�@Y�\rrNP��jBC`d\0�7�̻'@#�֩�9�\"�	u\rtqՒ\"ae�0��Y*�`r�BM�D�l�59�������7<1�3g��e��D�>Ң{\\Xyr�3m�̨��*.3(7�����.��Y[/!�3�(���sC��(�)f���Q'���N��@*L�aŜ\"�dA�8���ݴ\":�M��I	(��*1C���)�L�y�f��4S(�ƻ\"�Qۄ������TW�A{&.�+6o1��:�\\Gȣ[�Z�3����CuH	Ɯ��qؼ���	�0S�s-�&���&�eCb@(\r(�R��5��bH�\r�Nl��ҘH��e�|a�È1.!�x蓂�YCH�)>JI����� =Aڧɥ�C���T���p�r� +���;IOe]�.5�<[��vS|̔���4݅�9�U�ܩQsⴓ��-ߘ\n�n\$\n[1���ʊ'z҂9�L�Vz*X�g�x�T�~�'�E�+�Y�,A�K�G��xs��a]5�ƨ�A>Ti����RLj�q�=|Y58o<���j�\r�LP0N����&|f�9b#��,[TY����u֚�c�`��ֈ�d�O���v & �VO-��j<�B���7��p#�x�&��A�Ch��Q�5����%�<�y+�\$�~�Tm9?�ck�!j�o� cV\ng�]�4����SJI�PT�_	>��~�;ś��O���f��Q�\nw�M#�uե���X��o8��TK%e��\\d-��,mS�F��K���E�g\0�\$�4L�ٖ㈑���M�\0��P���-�ꧼ�Á��A�)k�z�5Q��z�[�4�d���e������}/ݟ���h���\r�WWs<���k��I�*[���@�ics�B��@5Gj�7	��_/-�������A�6\0ЉzZ7��ΏhO��e�4��Q]G߾����tJyQN	��S����\\���� P�\nJ����O�nb������O�Oΐ����ތ��nNdNT��c�o��F��/��cΞ�]��G\nP9ƴ)�����2���!�n��\ng��O��M!O���B���#D���0���#���l��^J\0PoF�Q�t\0pp\n��F�O�_�,��L��.,Y#R��-�Ԓ��h\0v�00��\0AP�O����p�/P�'�c��ڜ��\0�-\\����{��PSY��.W`�PN��\njԢh�n%p}I{͟b��6����QQ�Z�)z�1|��pP邗�Z���ɪ�Ǣ`Z� ������C\n��\r\0��\0fq�Y1S��4M�`��Z�L�@`*]@Z\r`� �>Ѽ�K��be�R��G��&��g�Fn-ў�QXKҤ����/�\r ċq�.���?�\"`�J#q�i�\$Q��4��Q�%�Hz�M&1�&k�&�H��'�8c��R@Q��J�S��8��\r�� �ڏ�����*����{R�)��+��`��r�'2�*R�,@�+�)��-�a,��,���#)������6\0�/�Ư� Xr�(���R��0�e��1J�+2؆��,�-3\0�\r��Wr�/r���,�{2�>(�x�K,�0�T_�Y5334��Dfs)���2R�-^\r�7Q���7�O2�6�0S�)�b\r���.�٣�Q.�2r�-�J�3)/�-:s�;��/Ҋ�N�Y�\$���,hR��K1�s(ѩ\$c�3�1���4��sH?T�r�^t	6t#;қA�W4�%T\r+4 ��8s�)J���%2W24=7����@`�E+A�3tUE�8�!6%@�At	C�B�YCS�3�C��D [\$4IHtL�r�\0�:S�H���TKF�9@��:R1F4SKF\$ �\0�3A3#i�J�uEtB�	B4�9�3H�1!4�+0	N���.\0���.�J�f��P�4����Oԕ4��4F�Hԩ\"[9-��P�4�;/�?=��9�Z.A<aT�R�W,t�;��\0�T�G,u4\0�V�qV�OT�ڞkyV �Ws�Xu;r�Vu�,cPeuXՑ-��ZuMQ��LӉ12wI3�;C�]s�\\�N��c4��55�:3]2��? 2%\\3\"z\r�G[�7\" u'*��Q�3J�z-�4�d ���&��S��@�j{M�6�x0�/S�oX�'+5�\n��Z�ac�0`�!��`i�KKn ��\\S�Yuy2�7Xi8�,�[3֚���voE��hth_֍Q7i3�iMf��i�6�e`e�:�_#e@�Y\$��c14���C40�\rg��g�+j��:\"�\\MJ��,");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("b7�'���o9�c����b�F��r7�M�HP�`2\r\"'�\r�\rF#s1�p;��Ɠ���e2I���Y.�GF�I��:4��S���3��㔚Y�u(Ìc(�`h��#%0[��L�����h���C!���E����b5�Ú�������y�fb��w	�z#���1�P��6�����l2��MQ�d�e#�Q��m�>�5ً�n�1��S��e0��o#����G��y��GxA�׍��]��]Ի�LƓ)��s2�5��]��6�8��-�ļ����o�� NZ�)�[Y�#��)Pk��p���8C(\\5��w\0C-��&\n(�:��rʖ��c�lL��t��A HR @��	x�FtB8��LB�I���0�\r@�3��|s��� �s\$�)�r����s��I2TF9�r�:��t0�;A����r��*͔�=�!ʹ�.*���r�\r.U��534�h@@1?��R�QnC�4��(�9�#8�7�a��Ւ�QO�P�2�LB�H���K%��YTUUe\\��E`�!ȅn��(�@�M#�0Ьb0����4��\noX���tӃt�X��j1�sHĢۈʭ+�����\\	�H��,�@�����6�0,�9ζ�ʊ٣.2㢩�c�@5��65�P�Q\\�!�fޯ+@0��\r��X�O�d�Zq\n*�y��:B�£�È�-�gC�>W��c��[�o��cJ=e������;ۢ)��S���#��W��7�麭G�à�8n���3�a@`a�Xq�pn׭�4��tt��Cʡ��C��/fp�O���p`AHYX��a�o[���\0�4�ەskvɀGT��\0�٠�:�9�m.~9�m���C��y�{��㳠��zv�0�ū���F1D.H�9O\r0	�,��]��Ma�6�\0d��7x�͍%t���s�1G�����V	��m֛Q!A��Ew�haw�\0A<����=<p��Aq�W�Vf�x�����{X\nA,�4㘢��t�ǰ�'H��[Mi�ܾ��2M�#D����n\"��q��P��*+є8�	����͂�X�yC(6W��>��Z`a(��@�0Z��w1Ċxʥa�;��t�d�Ahv!�:�Y ��\r���``V�握�Jh}#(j`�7�d\r�\0cUr�?��DH�����^�Pj��t���8�ɉf9�&\0");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:��gCI��\n8��3)��7���81��x:\nOg#)��r7\n\"��`�|2�gSi�H)N�S��\r��\"0��@�)�`(\$s6O!��V/=��g@T4�=��iS��6IO�G#�X�VC��s��Z1.�hp8,�[�H�~Cz���2�l�c3���s���I�b�4\n�F8NPC\r\$�n�T���=\\�r9O\"�	��l<�\r�\\x�I,�s\nA��el1����E�Ư�L��]�[M'=��K��e�\0��lӝә���\n�i��v�c��������]EHפ���H�o��ֽΈ�麮��쨋�6�#�Ґ��\":cz>ߣC2v�CX�<�P���*5���0X97�N����\"�3���!���!���#��\nZ%�ć#CH�!��rX�&:c��7JHp~�# ��A:86������&���|ˠ���3��@�2<�sΆ�PN��]�!�0M-˲4�0���\0��\\ԗ響33�d!>H��5�.,4��pX25Mڢ�*��,��(��\n,(��!���a��pΎ�n\0Rփ�v�m�I.\r�][H�������<J8�Ѷ5N��C��<�ɠ��%mCr#�`X�D�ooS�L)^�B��{���`��wJ�JZ�/���XC(��>a@O��Ӛ��%�Dpӣ��8a�^���X2`�\\���~�����\$�`W��!�Qc�ذ�!\"#\"i�iZnJ\r�\$.\$���:j�]�1�C{��`�7ܻ�<��p�A��`n��S��#F�3��`bA��6�:u�:n8���VԃNa��2��I0*iri�%�8�g�/5��ܭ,t���3���Y����g����r9u�=C[�ʦ�:c@{�^˨z�XR�Ⱥ�7!ut0��⼸&E�B���o�4k�\"�#P�<��9�H�g�6!b�H��k�\\����MAG��R�PK\"o�7*�K� CAa�2(&�z2\$�+�f^\n��0����zE� I\r�H<��Y!`t��R��!�e�����]C�[���2.\\P((��2����p��p�M�p!�YV�@\"�l&`�4�(qБ�\n��,/�2�)�#��_\0��C8E]�/2 W� )�A��	\rϺ��qL�R�TˣO�=���nc��I1܍x6p\$�!�Q�Q�0R��`=Kr|���Ԋ\n,���`���c\rq�<�I~e�t�1�y#�	4H�X� N�Hz&Mi@6%Ƀ6�̘DA�6�\$�8�h[M=:Ni�:'Q�\r�ѝ� �o�\\���u�0�=R��X�*8hr��\$PA�����B@t\r�%A��EB[���3��O!��\\�X�9~\nx\\@�����3�\0�<�ο�Ba��2nwV��*��\"ETZ�Q�Vb��E�\n)\r��,����9ZduN,�Y�2e�RՂ[�䪕нT�N21Q��C���ŗ�t�,BydR�Q���� �\rM�d�Q\n#WU�Uj�t���z,�ܫgV�LZ��Â�1Y��8\r�zl׫!i&Br���+8l�He)�[[0�Hr����J�VY�n3baW�@ :˨��׊`� ��=�ɾ������N��@���x\nXԅ�� ;R�~�@�Mu�2Y�����o��j�|��q&�T��6X�Z����n��{fd��Kw�wZ��To`d`�K�j���V�{��L����!̙����0Y��f܉��O��!I�nB�#�+����;���`��CZ\\�GF�ci!�z��:dI��ʜ�A���ѓHܐ�X�5׼�I�s�a���3NK�'�м��By�!��(��&Q�tr��	T�z�����:�W(��#��>[��^��e:U+���A,��7��~�a��Ձ�\"O��c�fV��@��|t5_�2ֲ��B�sI��[}�����[�aȩ�9S3d���c�ݷz��͘Wqe\n]^d�k\0����=��3��z�a�޼~��2�����0��hw7ap-���	����܆ۿ�\0��G�ቃa��	/g�wl�^�ָ����Ci���/�t����0t	h��I}�!'��f�n������w����ic7O�9om��~L�8�\r����z�'�UF��b�V�S����cZ�4���]�s꒿[-iW�om�����5��.�t�=���K����bc��X͞����=�82��i�E�G��Q*)C��uE�AJ�t�\"�p_�B�\"����p� &T+��H���{�(�2�^O�,�t�+���hLe��͐�C7~�4��d���J3kjA@7�s�Sq�p��SF(�,����)�i��b4�@��ir�\0A\0K�;�FĊ\r8�X��\\�-I��\$%%/<%E�.�]�����W� bL�MF��-�RM�:�0��	��z�^�cЖGZ�B:��.?i�Ӏ�3(+@L&v��Y �`�p���#��n��М����`�-���^�q�v^ �\r��e�^�j��lBb](�X��\rF�X��&��%:Pf���� �M@�ΐ�D��!���&�f��zK�(�c�U�8�o��b�1>�@Ч����^�<�1N-m��垠l�hr��vdHrb.�����?C�e������� Z@��^`^���)�h^�Hd���(NƷ��J��`Y�������ёQ�Ѡ�Q�����N�֣p��MNݍdժ�ﮚ�*�;Hx�@��j	P�X���f��;���n3G��`�% �\$-t�-F�jGd f\$�FD�K!`z a\r#���#G����EP�22G\0�'���T����&r\"�m��l����\"��(�@�\r���C�R����n�0������b!*bX\r�\"�\"	D��#R�\r��R�6�F�-%N��d�N�kb��I#\rE'�m\n��qH���k'�R��!q�D�®��2�β#�RV`��ķ@�l y3(�-B�\r��b53&14h�\r\"���Dk>�`r���4@�)\$�(K!I�vNb�MD�z��e5B�%�[63F٭�䭢�\"fW�J[�)S����(*�7FK7�Dr8\r�8B`DBV!ED9��,���\$(���@�#�Tu�ZC29	��u��#�Հ�29#�@t�X��t`L�\nbtx�LqF���D�d4�@��n\n���'���N�N�SEtZc�h�\0�s�C�C�]\$��\$�R�V2[\$�bRP�DI��-?F�Dӫ���DĦ#�ut0 �_Fi�K��ޭ�2��4��C̮\n�K��)�&��\r+62���Jޮ4����>��R�t������BD�E�D�VPTwG�u@�����DO	���YO*�����D隺q�N��Q`N䦧��\\��\n��%�<�rqF޲UT��Y&2t;h�N��Bl�B�r�ԁHRL�h([u�%�f�?tG�WQtID�++��땓%��Y�`L�z#�Jl�M���BEU���}3�Q�\"2�U�-b���{���eB\$��!��]U���B�,jҔ~ً�����/������^�B��R��+��6'7J�b�� ãD�;\r�O�)P��\rJ��qS\0�R@CB\$D�)C�JP�h�q�f9\0����&p�H5<��o�����S���kseC_��L��������\"%`\n��d &��ezP�T�V��ԭ����n�^	��\nb�n���l����dL�k �5����M�p���}�\r������E6����n�'o6�!v�u�Iln��5�|a�ήœrL��E��r�!u%au�b-�� �zp�`t���(&�\r��H��<��eX\0�u�.3�;;,V3�� e�_,��]�M]�}_h����\\1q������D �|(u)��׭�W�%1����1/0�W�8�c����J�b��~�������2Ϲ��A����`A1\"�Q\"�Ox�V��'�}��@B&�@� �Vwv�B�e��b8&L\"��~��&^�����Ç�f*lW���C��EW�Qx�*x�k�Çp?�݊\$2#ȶ� ��o��S4`A+B�X�Y�D�̒�x���_38�()�Hd�?x��Xę�=� 8ބ��(�%Ȥz��\n\0�\n`�����*%�@I�z�m�7�#�����k��s�N��\$�[t�AK����p����%�(jD�e�˔\\�F�9LjKt���s����q�������ᙶ���� �9B8�\"ǋ<ǖ'��9*q��T#�R\\��`e-i/����4U\0ǆ�m�������@�/�1��}�E@]���yy�qx��]o�hX#ۍ �d��hl��%��������4x�}��HI�H���:�\nS������\\�`Q�֌8���#�\"�xb�\n8��1˟��u31w`z	@�	��\r�8&��*!�.�R�<�h�@�у��Li�2GDjONE4����O0Cы����ƾ�u��B�C+�4��݂,��\$�L\$I���pKg�kknN˖!� \r)*��Mt�Kx6�֏P(T�bE���Rq���=N����]��B�I���S%M��;�vT�67v�tT\r� J�\n��	*\r�*7.&��h�y����;��V\0�Qz(�lHz��u��{�5�'�F��B�D�U�E�׬#���_\0@��@�K%@�rP�5����*Mj��\\Q��j8]�v[�U\0ښ_����D�����|?�1��Z�M���Uڡ�(<�ˬ)©��D�6�S��Xq���>	yf@P�R=F��#Tj\rBk��p\0���ϗ�o�xœU|�`�^J���(:�;tX{\"��i�����,�\$�[1&�5F5��-�Z���TX�M�\"�~�T�#]`m;��R�0���a�\\����c;h<�̼���P��D��{ib�:�\0��l~/bN�2շ`Q����5�\n�cT[Htl�D\"�>��/d��8��MowZ\r�iB�h�R槫Z'd@o��iR�9�G�A�x�G���Wj���Gy�b�KV�}F��\\3��\"�\0@z�cϣX�\"	�Y v�6yl�<R(R]��2�5�_��>�b��B,\$��Ŕ8q�{Ȍ�˛�� ��%����N�P�nP���-�����#s��;���XL��R r��\nnr-�3^_�+6�i�m\0�k�2��|@`\0u�I^\\����v,=4.*�bx7�k�RԦ�o��	y�΂���s�Qv���&.#]���D\rϭԒ�8I\"r��(�(���\nt甼��̩��>�UKd�/}������#�0MT�&��۠\r��r�{�	��YÝ�J��	<a�X2����:��,uQ��Z�G��]��}���k�_{�=� ؤ3i����~,� ����}48�8�Hr	��M2�#�P����bq�'���N�@Z��ԞPI	��r������Щ��?��N�w)��9�mMs��H��Ł�gN� �]p1�]����:\$t��7�����1�y�FAg����!�Y�8`,�oDh��\\\0x��:?�\"+��	���S�:Q��#A*޸��h�@X�@V� �I	��>�A\0��	�JPꏋBse�t\r��e�rR.���	�rr\n���Q��}h\0t�\r�mt0� �F�#}�h�`�.��L�`=�*z| ��5����<���2�A��F�J��@����ȳ�nh�ymt�bF\0��2�Bޓ5�K\\aoZ��Q�	���.�3T�iHV�e�!��^�\\�T� �K�!�F���P�`���W	�����L��3V�����i\$�C�oav[��\rn\0d�0�!���C4�0�t�4��MHj�&��A�l��XlC)�eM>;��mSQ���CXT\\��n���2#����V��R�7\"�eЕ�t�n|�������)�5�`}�z~r�B�t��o�]@X��28'����N9ǆ�~%��yO\"bB���zD���T�\0� qE*'0TT\\�\"#,�Hz����}3h�!�WK�\"H�EhQ!Z��D�\$Q���	��Ҁy�@�5��r��ظ&�.0i(���w�y�n��\"���E�# q뀻���c�?< �ЧHI��C�B�p����fV�ATU��n�qK�2��dUܮ!w`-]�u��1�I�'��Rȣ6\r�J5q�A�\\��(��.Am�p�Z���\$���f���\n\0�sA)����(;�\$�!�#u�@��5����1���`\0�#������\0�mp[�HF�����8�XAܒ�~���\0o�{ y��t忐`�j��M���܅b� ���l\"W��T�X5�y��/�Mi޲���69i�Jl\$;\"�H~Bɶ��I�N��0�\$+�FDd�ӦB:B5q3@Zd�S�jG�W\r�KE�0��6rQz5\0b���H�/=�o���-� rY��@��1/l&�-C�\0�32fɕ�u8��['2I�N�J�@ZC���rC	�՗�!xɠ�����i)9�X\"҆�@w�(�)������Ɯ\$)E�2T`d�,�e(p�Jx!ҩ�l�^�R��-�2�m���y&���|\r���\0R��\0�K�� ��+p��U҈�C�e�0#X�����\"�H�;����	�(�y�k�6�����r�\$d���!n��k�@u.Q��H�'�x��.�!L�#�Z�ABpȔR�0�ʌ��j`5��b%C0@��,i\$�HJ�R���;�r+�D��a[H>�:ly�/��&e��\n��	7'9@���+(�}�;��s�\0�S;�P�>p7nIl(VRt��m.(>_D�NnIY�M\\�+�K�#�/X�BP�(�`עt\"�M'!~ҹ����K������#�a�xO1%1��m���\n���I��r���&�4G�O��[W_�u]����_(�	ͼ�hxs1%��!r��%�llD�D)�7��!�j>��\r�Ob| 3A�\nH��hי~60\0A��!�෩�u�䃰2O<&��6���L�覎(!C��^����6dx��'�E���f��d^,c�LBK�\$����Mf^�����3��e@��P�nTJUH��>���~� 1ī�K���˫�)�H�י�ʱ*�*(�gf�FdwK��\0�\0*%�\0\"|�H�@��\0��J>*d�(&�mj�eV܂1�ʆ��)���Y�\0���\0\n5�h-#�����G,���U�WqjJx��P(�����utR`���AJ���������\"-����8\"M��A*\"Q���%\rh�D���.nD`-W�_W��*+m\"�9S�\na��'DF!��2�Ik��՟hX���Ӏ}�Y�f��5:Ra�i�8�_\0ou�Ł/)U\n������He|�/�>�4b���9o��ǎHRS�X��M���2#�b��]��L���8�<����w�y��	o�9\0�Mи�=��}����i�\\�	i��@^�\$�,�|�Y.�(MZoum5�YO�}Dy!\$�ё\0P�\0��\n�������!3�2�\\��*j��h���@R3ݏD�F(#�;��|	%L�0˄(�|�h����P�����h�EMY*h���+�8\"JrO�9ܩ\r7���p�D3��J���|6aI%Nb�p��ޒ�S���&8�Bi>u�(�E0(���kJY���������0�9�UM���eWP�Ԓ�H��<�O:ZUE<�.�V���']]��*����%D\n	�.W���΅(uP5(	�2^�BCl�zP�`3���\0�(�1Tj�b]pN\\:���!�,�Lg`P�HH�Ү(�\n�<��Etb�0G���\nؗD[�p���00��Sq� ��Ⱦ6iI�	j{\0����PKq�\"ɯS�ƺ���t�;>Mp�Sc��ɦЖ�x6�E�����4�N�'��ΰ�u��}\0�_e����H�!�7B���\\k!^��W�\r��lq,��oXh�6����=_cS؈#V\$o��lQb��!�䋤��)��1\"�<�+VZ�I`K��ND��_���<e�Moaa9���3����e��*�Vb� Ukc�;���j��b]�V�n���*��JVHH�bjd�AV��#��NB6@��n���0�c�8dՎ�g��N�����@����Ӯ����\0Εq9Z�¶�g�E�6�KU�JնU�z mde;I�~��e��T�r��]����m~k���n[5�Ei��j�q+�MYx�.���\0lÿD�+bOŭ��m�HP�#_�:1��\n,��(1r���F�p����*:�W�א�0��P|hh�9��G�[K�5kL��ty��BH��X����.*YK����A_�7J��a}t��2�D��Y�tB��Հ��P�֏c{��/�S���~F`-�T#M�����\n��KE�C���Z+�\n��ȍ&�U��'�8�wD��0F-qx���Ɣ����t�x���>�CӓL^��la�9�\$3��E��;+��B��%�t�뭋��[�(�k�L�P�J�V�����W�ɐ��l5`i�å���U�^� b2�n�eP�t�C	�!����y%�b��^�U�>a��P�TVʶ�I���UׄV��!4��kj�㥤_���F;J�XW`i�`+�+��<X�/]=��a4L�h��V��!{:;P\"1Ы�]HG��h�d�.���R�hP������ǈ>�\0 �����iқs��`,��o���tk<=��`q3�DK�*)��H��GG��\"��to������1i-����#]�F�u�p��e��B�(�Z�u@,!�j�O��\\�*.����E��gi�X轄�-���]�����]�o87�f���aRpF��N��!7���D�R�ip�x���\n�h�ὕ�B���C�y@Q�l\$a*K�M�X�Z:�O�J��m�����y�a�4�Q��~��bT�@�E	�E��kx����	�L+%G\n�\0'��j2[��C6\$�E��t�K<���}��v�/O���P�7>�V2�����	\"�W�[*ٖ�Dq�mʉ*r����K'E����[A\0�\0[�ORdi�P��X�X�h[g��4(:B�g�8���\\r y��Eˎs_�m��r#�\0��8�1�60ȕ�K��Dw�*`�E��,a���@�>2_��q~��Xø�JW��K�<#>X@�v;���^YB�E�.]�\\�d���N�R͢�q,��g_�b>�5ee���ƈ�%-,n��]\nx�>����t%ˀ��1�F,�d��62�f-�՛�����gF,���BWA+���Wm�\\�\$������m���kC5��@�@��#uA.ڇ�6��#��8�d�I�\\�f�#9�8�ggmI��o�w!1Ӛd�9Vfp\"=q�����	�+��I���C-�o�.�7<�60�'��@�mkzi i��.b�iL���:u_4r-��ܓQ`,�\0\0C��Sɽ��Niٙ״�pLvΠ@E�+!g�}��Z!�۞�����oX��\nXlp���J�4\r�l\rD�ۼ�%-���ƫ0��r�y�X�\\�g:���/;���Y� �{�_���7H%�ƉB0ި~�<z,��Ghy�wO�����=y�|�=Y�zA7>W��̱CG=-2`s�D&C݀&r3�Ԣ3-&�@k3Up^^ϓ\"��S%YUO�+�sKWX�c1e\"Ri�儳5Y�\$�T��e����No\0Ja+�V����uL��3a�\nmO�\rM�w:D�DA�,8��~Ȁ� \$\\�\0�my/V��C�-TEP\r�%+]L��@VJ��[�v٨\0�3RQG��߉�j7��`%�{�9�8�\$�2[��#�T1���Jr)S�����%���T���\$4���\nV��� �� �8�Kz����)����ZMs�W\0�Š5٭�V�h�)��#D���57�\$'�BY4�\r<��|Ln����h�y�:��]���R�/gSY\nc&k�Q��\$I	��@E2��޼�㽼���0B����,�ԝ�z{�d��N�=�bL�\0�fȣE���N9\"��еz�Cf�6���ʥJ� S)��Zu�V��	�҉���5՗�b�)t����_�?�\"Z@��Mh�&ۿx�*��I�l���\$��\$Um��)�`d��K���K'�L��5r�'��Y����N�9��x�R�.�|2SM��NB�G-�rjQ|� '��ֹ���N�;���HC��Z|+F�d�/6�C�d�n���p]w�B\r)!�J���B\rse�d�#�>H�m�఼Wd��Y��P���{��a3\n�c&q����y�stC棵D���>�'snsy2����b��b��.{���B�\n=�O�!;�\\*�+���W���X�D\\���X��Oh�F������X��]����4.#M<����j��Mt�S����&�G�UP�&td���B���0!{�>�2�:��Q�����af^��B��`��eF*0�Z�\\|��'�&hd����gx(;����G]�@�\"��_�%���n,�jPf�Cr��0�o�i�--��K�5a{��9�я���ܒ���Z=\0M-��a~DMF�w�!��S�����k��1�|�G�=_��@�[������A�˗V��HW�\\��e�t:��0y��],M�p�\\�ﶲ��),\$w�\$�����j8�%)��-*Rq*�SH�n��2Vj�U��h��[*���8y��!�jw;�Ĵ	���f�>�]͇3�*�}���\n��\\/�\n;�6m�@�b�;�h��-Ȓ�U�:I�NP����}�V�lnU��%.�9�B���@Ip\0��\nK�7\$�`E�xD]�\nF|�!n��Ԅ�ߺ�\\����Ȼy�?����,W�ͭ�����:�u\\q�&4g�5H��;�Q�Ǡ�\"˒s֝�vhInfU�(�V��V��#��If;�:{�~�r󭜨;��O1F�\$�\\�C��cV_���}��I9'�V�O�l�tn\n��B�R�1�m�|�wK6O� ֝�鑘\0j�����O�=/i�>F�v���n��;_��؁�|�A9?+cܰ����#F\0P\n��|�����!:�>/�N{�Ū;�0���%�>w@N`����6�;����\"/X�g	D:�g�i�##���kK�rR���M����:@��\$�w@��\0�we��<ݕַ�{�w��P��2���:<⪇\$�&:~�륽�>n�D�w��83��<�V�q�Z�LdS��\0,�k��?A�\rfΫ=I\n��h��<�M�I:E��0�@�\r�2�S���+\"�chI\0�d���(\n�[�ϔ:�6���KA(���8�#��g�@ZCP���� �^U���C� mx{IBn6\n[DA33JL�N�Id��dR���q�2(��7�uA�fp`z�מ��@|��Y�G���ko�O����y�>%ԄH���b��N��Г�0�2j�nr��9���j���Ш����������]�����c��������6 ԛs�p\\�k\r��j��'D*<��>�y����`��p���rW��\$��!�l�G��||(q�B�R��0{����⏸���T*\0���2���G�O�EI�)�\r�^E�op��������4����\"���^P/\0��^�7��h�4��[.>.];��Q:�؂ߤ�[8-�+�>��綽F4���6~�����8]_����\0002_�Jp���K����P�7�<�XNJ���%�ţ�t�\n���c�!P������א�3���������_���L_?2EO4�a~8X���7��P�T6z3� '�����M�)%a�>�f|���'Q�nF#�_���O�}��]؀q-�_HzHp�����Å���>�\r�p.�|�B@���Q�R���\0�F��h\n��J�����0\n�`�������K!�������:���)s'���������*��;��a��^�\"�-b�+���f����N���n��d#�\n��~\0z�Sg����U���p���hG�@T`g,�HM�M�\\�x!�8\0��O'\$���\$���C�A�&s��+?�1��'�7�^���a��� ����>�2�N,��%��ʴH��+1	�2���i� ��h@�\0���M���朽�	�FE7�f�m��\rj\rȏ���\"a����\$���w��(-��Y�la����`�ZP�K!{����P ��Bɔ����ށM퀆�z0y�,�TPW4�z��PL>l��N��\r�4�B���@����\r��X@PT��Yd.A`�d�.Ajz{w��?m<+:�j��\r\"���=��5K���b��e[�U(`P+�p Y�G,�e��?� �\r�M7����\0��");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0��F����==��FS	��_6MƳ���r:�E�CI��o:�C��Xc��\r�؄J(:=�E���a28�x�?�'�i�SANN���xs�NB��Vl0���S	��Ul�(D|҄��P��>�E�㩶yHch��-3Eb�� �b��pE�p�9.����~\n�?Kb�iw|�`��d.�x8EN��!��2��3���\r���Y���y6GFmY�8o7\n\r�0�<d4�E'�\n#�\r���.�C!�^t�(��bqH��.���s���2�N�q٤�9��#{�c�����3nӸ2��r�:<�+�9�CȨ���\n<�\r`��/b�\\���!�H�2SڙF#8Ј�I�78�K��*ں�!���鎑��+��:+���&�2|�:��9���:��N���pA/#�� �0D�\\�'�1����2�a@��+J�.�c,�����1��@^.B��ь�`OK=�`B��P�6����>(�eK%! ^!Ϭ�B��HS�s8^9�3�O1��.Xj+���M	#+�F�:�7�S�\$0�V(�FQ�\r!I��*�X�/̊���67=�۪X3݆؇���^��gf#W��g��8ߋ�h�7��E�k\r�ŹG�)��t�We4�V؝����&7�\0R��N!0�1W���y�CP��!��i|�gn��.\r�0�9�Aݸ���۶�^�8v�l\"�b�|�yHY�2�9�0�߅�.��:y���6�:�ؿ�n�\0Q�7��bk�<\0��湸�-�B�{��;�����W����&�/n�w��2A׵�����A�0yu)���kLƹtk�\0�;�d�=%m.��ŏc5�f���*�@4�� ���c�Ƹ܆|�\"맳�h�\\�f�P�N��q����s�f�~P��pHp\n~���>T_��QOQ�\$�V��S�pn1�ʚ��}=���L��Jeuc�����aA|;��ȓN��-��Z�@R��ͳ� �	��.��2�����`RE���^iP1&��ވ(���\$�C�Y�5�؃��axh@��=Ʋ�+>`��ע���\r!�b���r��2p�(=����!�es�X4G�Hhc �M�S.��|YjH��zB�SV��0�j�\nf\r�����D�o��%��\\1���MI`(�:�!�-�3=0������S���gW�e5��z�(h��d�r�ӫ�Ki�@Y.�����\$@�s�ѱEI&��Df�SR}��rڽ?�x\"�@ng����PI\\U��<�5X\"E0��t8��Y�=�`=��>�Q�4B�k���+p`�(8/N�qSK�r����i�O*[J��RJY�&u���7������#�>���Xû�?AP���CD�D���\$�����Y��<���X[�d�d��:��a\$�����Π��W�/ɂ�!+eYIw=9���i�;q\r\n���1��x�0]Q�<�zI9~W��9RD�KI6��L���C�z�\"0NW�WzH4��x�g�ת�x&�F�aӃ��\\�x��=�^ԓ���KH��x��ٓ0�EÝ҂ɚ�X�k,��R���~	��̛�Ny��Sz���6\0D	���؏�hs|.��=I�x}/�uN���'�[�R��`�N��95\0��C������X�ْ�6w1P���u�L\0V��ʲO�9[��O�>��PK�tÈu\r�|�̮R��pO��U��Drf�9�L�cSvn��Qo���@o��(��ްàp��a*�^�O>Oɹ<���e�������\"�ٓ��P>��H^���	psTO\r�0d�{�Z\$	2�,7�C���!u��}B�^����?�D��ڃF�ݱ����H�Ι`���'�@J��3��|O�ܹ�B�Mb�f1�n��@�1���(ղ����!�oow��f���)I�L\\[�����8[1)��!)���u��~�c�-�6-���y*	���>\"�m�61��ӕ�.��~�*�x��諍q��ǚG |��rl��O*%����݅�A�bRAx�g��D�f�V\\��R5l��ޤ`��5`��w�|���Sg��O���B;�Ϯ^LÖ��W?�5 ��ac}��s�ݏ�I��A��r��ݺO0�;w�x���P(�b�m�L'~�wh\0c�¨pE�߲:C�{g&ܾ/Ƒ>[����ۜ)	a}�n͡��wN�˼�x�]V^ye&�@A	�P\"� �E?P>@�|�!8 �Њ�H	�\\�`��@E	�Â�4�\0D�a!�������nr쯜\\���8�o`�H�f�����&���̒<�r��(jN�eN�)�6EO��4�.��n0�������6\r�� �\$����\$�� �N�<��|αN���j�OY\0�R�n��`�o���mkH����*�-Ϙ�w	Oz�NZ*ʛn�O�\n�#�n�⏓p[P_�b�������jP��P��Г\0�}\n/��Ӑ�������П	o}��S'��`b����\nPd�p ?Po0sq\n�:b�L���Uu\r.L`��SP���1mq���~�]%&ʚ�Q��� �\r�D�pq��pV|��f�8\$�p�&��ׂ�F��&����m�O�w��G	��1/elր��D\0�`~��`K���\\�b&�Q�Q�`ʾ�A����V�E�W�n: ؓBƌ�\r�*��l\0N��D��r뭦���[&G��h�r�H4A'�bP>�VƱ��M~�R�%2��r�m��\$�\0��2�c�����Mhʇvc���}cjg�s%l�DȺ�2�D�+�A�9#\$\0�\$RH�l��@Q!��%���\$R�FV�Ny+F\n��	 �%fz���*�ֿ��Mɾ�R�%@ڝ6\"�TN� kփ~@�F@��LQBv����6OD^hhm|6�n��L7`zr֍�Z@ր@܇3h��\$��@ѫ���t7zI��� P\rkf D�\"�b`�E@�\$\0�RZ1�&�\"~0��`��\nb�G�)	c>�[>ήe\"�6��N4�@d���n��9����ɴD4&2��\"/��|�7�u:ӱ;T3 �ԓi<TO`�Z�����B�؃�9�0�S>Qh�r\0A2�8\0W!�t��twH�OA��\0e�I��F��JT�4x�sA�AG�J2�i%:�=��#�^ ��g�7cr7s���%Ms�D v�sZ5\rb��\$�@����P��\r�\$=�%4��nX\\Xd��,l��pO��x�9b�m\"�&��g4�O�\\�(ൔ�5&rs� M�8���.I�Y5U5�IP3d�b/M��\0��3�y��^u^\"UbI�gT�?U4�N�h`�5�t���\r2}5-2�����W��(�f7@��e�/�\rJ�Kd7�- Sli3qU����z�\0�)�\$�c��oF?@]LJb�Dҿ�0��s?[gʜ�%��\rj�Un���^��R5,֪�t�FE\"��xzm��\n`�-�W#S(�l	p��%CU��辚�F�&T|jb�Z����8	��/4L�*nɦyB�:(�8�^9�8U� K���{`Z���\nF�\0Cl\r�'(`m�eR�6��M���B���C���6��v�����n%#nv�D��jGo,^:`�`s�l\r�_���X5CoV-��8RZ�@y��13q GSBt�v�Ѣt���#��bB������]��#�p���fZC�Ĳ����OZ����N��]�����sl�Ԃ���EL,+Q�@Yw�~9�I\"�8!մV5�&r�\\�7��W�&�ܼ�[\r\ri\r��~L|��d���ܷ�,��|i��@,\0�\"g�\$B�~��!)5v0�V ���b|M\$������D�f\r��8;���}�f��f�����icԄV0,Fx\rR��`�a&nȧ�QB.# Y��>w�g�����E��[�Ɨ�X���~RO��Y]8�]rK}�-��?�8�v�L�@�~�A*��f���J�M��tג���-v�[#�xL'L��>�l�8�Pg\n��\r�Q���ѱ\r�M��\":xw����\$b��-������=�kRXoQ乇9;��ˈ過��sՃ�͋�)���~�geB�Bt���,����,����K���y����-,mӀ���+��07yC��˃�Iz�ƍ�Y��^GGW��u�v0#kX��RJ\$JP+�6x��1�8���Y�g����{��?�\0�X�\r�	XF��W��ה��V/��̓dIg9߆�і�y��1��-�G�X����@O��R�y����!�GuY�5�ZF\r�㕵-�\$�O�e�u-��ZF��Zd��i�9+�쵘`M�z��\r�ҫI��y��A�Vp�:��O�J��:�V:�#:��:c��{��k�l��Zs��W����P0����#�9g@Mc�zw���[9U�\\k�����6��9Ӆ� ���y�,�����f6n-Zu���f�ً�c�,����[o�[g�d� �:w#��!W\\@�n�`�߱�\r��ɡ\$۟������\$��%��ߡ۷�z#��\$�imY��c�ɂ�k�I_������y��L���Ϲ�\$�`V��[����F�2C�8�\$��������ؼ�����G�[����¼���=�U��υ[q����K����Y���݋�Q��?�8���aX���m*G����\\��?�U�\0Ϣ���KĤ��|CR�͓�-����|ɜa��e��RY�ƺ饘�ܒ������������PJE��=��u�����\$�{�8�X��{����ŏ����ٓ�ٗ��ՙ��\r�������Ͱ٬&���Y�ҹ�(ټ�M2)��V u7\0S Z_��o]\\�|٩Ec7��S��΄[���<��<����;��-��i�� �}����l���!�,�}%����-۬��=����Ӭ��=��Y�8���PV|���zE.����\r�����bLfƸ��h*;�	ַ�;�؇�Q{��9\n_b\$5��l�UzXn�z\0xb�k�M	�2�� Z\r��c�|�ג/��}%��`�N�A�\0�*=`�F���^Q3�W�X��<���tR>r�`u�ģ>i��zN���اÝi����\$\0r���s����^C���>U�5���^a�)��	��J+>�uB��@?�J�-H���OJ'�-Tʀ�T��oUh�F��{��ԏJ[��N��V�oJ&S�B\"I^5�I�2���T���龽�]\0��\rk�L%�}�t�۷~I0�H|Pk�L5�_T�<�w��=<�x\"esa�K�\"���JH��+�U�a��'Y�~���7�)W��<6�=_�N�h�?6ܘ��y�,����a���w�\rİ�#�-V@�k��?i�b*%�޺��p?����yЀΆ�p��-p��|�n���Ca�f�8A�8�+#\r�R�@n����p��m�~ۈ{`�H?�v�*%�Ǽ�v%��G�`�`�Z��.���,�6�z��U8��|�y��V�����/�p��^��פ�m��]zcӞ���\$�IB0�|����@���pR�\n�j�9 ��G�7���읤#p߭�?����'���=�6H�lψ.�Y�OY��_V�G����O]I����=��x��\$���=�|Ϫ{��\n��<;�{:f^L'S�A1%�8*�^��p75���W��\n��\0��S⟕\02\nX(�u[��rp��B�0ڭ�x���:n	�ZI3�C����{�[��&�C(@}�r���w2�闌�nt����{C�ɆY!\0�He>��P\"�9t5�o���!�\$@\\7SS\r��C� P㄄@��I���nhG����	I�S�`x�7�0b+v5�^g�r%b�p�U��%)<+�S/Z@ �4!��j��8��\0�vN-6a[>�X�,�e\ned/�PX�`�}kOR�N���+�1O\$�π�F6B-�:wڨ�N��T�D>��x�����Y)��n�1��&�7��}�&xZ�\nޖ������W��:U@��a�⺃@��.�R�hbcT\"�����x\n� E���|߈�\r�-\0��\"�QA�Ih�\0�	 F��P\0MH�F�SB؎@�\0*��9���s\0�0'�	@Et�O�����Cx@\"G�81�`ϾP(G�=1ˏ\0��\"f>Qꎸ@�`'�>;���l������82>�zI� IG�\n�R�H	��c\"�\0�;1ێ�n�)���8�B`���(�V@Q�8c\"2���E�4r\0�9��\r�ԑ��� \0'GzH��5E!#���\rA�JЉJ�(��FC��&�d� I�\"I�V솣���G�SAX��Z~`'UA���@�����+A�\n�p��i%��ѿ�G�Z`\$��������>~?�E�\0�}� �<Q����'����E�w�ئ��#\rɂ7rQ� }�'iMI�O�0dm% ��Hʰ\"-h#��XF��M��t\$�!���R���t�,(�H8�8�!J�5I�x��r\n�Thړ~Pe@&eg\"[hؖ��4����|�2�z�D��lw#9	v{lb��/~\0���&I8%�,�IKA��\0�����/GYK�*�>���O/���2�t�eھف�P93=\$�X�d��-�&��|��#154LU���G.�i�2`����M.B���\00036�ISJ�-�~�쩦�jF\\3	o4�u	(@a3�A\0�c��`�P( ��0\$���\\}/d������\0�-�3�%b0\nc�z`��))%*��6\"����ٖ��E4��F�q���J����d��(�Ӏ����1�iLm�2�A��.)&q@\$�`L���2Lrse�� �.�vss�\r����i�KQ�󤙬 �0()�|�Mb�tU�9!�ED	�(	�`8*pa<�����80��s�\r� N���8O0�Ξ���d0��OVx��@'�<�Ol��J)�	�~}���\0U=��O�'Ňd�~\0�Of��X�H�	�L��Ҡ(]'�@�EP�LW��E'=��\0�'�\n��N�\$iI��Zy�	���>i�OH6f��'�߁x�.\"}@��-�wa2vӅ��A��L>����<0/����P��B�����͢��T���\n���<sSQ~|�ӂ��P�f�i�O�φ�lq���9T\r�����ѕgÄ���Fӧ�%O�(1�h⺶n�m�v�;�|���g���SaF��R��Ȥ�Nr��9z�%&�X��\0007\"�2t�-\rh%fŦֽ���3!�\"(�7I�\$s/ �-�7*J\rΕC�Lxw���֗�铴���(Ҫ�B,+�h\n���f\r�F�7Rf���*�:�\"�Δ4t�P�i�X�����*�\0P.(#��+H�oJAG���q�.57�+N	:-m`���&��HJO�Uvi��\0�\nGN:gR�n��2i�)}#���	F駩�>d�`�q������H���ƕe�5J);HQ�����\nHϓGRW�Ԟ��/�Jj�)K*UR���i�b8za�.�����RG��!4ͣ��@9����c: E.F|��T*��s�<Z]_O�i����\r@�2��qTlVUk�CQ\rOe��\"�\n�.�T�EUZ�Ԡ@i��^�ܪ��L��aMUB��V������'�U�+Q �V���W�m�G��Ժ�u0��*�P�T+�!u�\\�kV�y@Ƥ�j+��H��䁐�\"E��P��,�`<�H��Ք�p�ğ%	l\n�K ���\0�\$T!8@�@�2����h��4L��ŝ+��&����,�|��\"�T��Q霋�b#w)umŵ[�ޒ��)E}��[���Exd�)p����	n��-AK��1}W\\IU�nF^�\n��` \$��m)�oZ��	P�D�P�V��D �r%�R)��bұ�l�^�w�)JB���-K�D.1��8����\0��;� le�,L(\"m�N\n�Z��K�����gH���e��\0��\0t7�]��Kk\$�yN����X\0�6�(Y�������f�\\\r�K1y�,�`0��qo����\0�h\$��\n�_����dR��zE���C�h�<Y���p!�\0ro;����'g'*�!��Y�Xv��%�K4R�V�\r����Z�}Z�\r�o��mpN]N��5��xUay��\r�j��W��k�b�~��+m���edyٯʰZ�ksO�4;T���a�l@4[��]�M�7n 7�>�6���ϓ��=�h�*�0HΫj\$��[`���,����y	>��7p��D\$��u9�H ;�������R��~�0[�D��H��삕6�ܐ>-Lxj�Z�k�NȢ����n���dg�;�C\\\n�Pb[�h)3M�c�D4�0uR�#bP��5�:�a��EqH: ���:�.X��?�c�9�%n�K����a�5��J�`�7X�\n�q=ȿvr�E�<�(~���CȷPQxH�bK�ܪ�-]����\"�Q��C�U�.a��Q��v&�� ��7�]Ĩ媻�>�.9\0�=K=)���T�� ���_OX��5�!�b�U��h���AP�-����\r��%zPޔ߀<�x�����c7�|��4q�����p�C<�N���Y�5ь��)�澈��}AN_�RCTx�F�*�3���g���.�`*��B��`&�T�:**�7ƷE�W�R�\\�c�W��[���Kb��\r�o�Hr�����u 2~/խ�	@����aI� ,%b �\0�¡+{��[�,`_6�7��.�@̆�)?�m�m�b�a\n�v�������]`��W�8��!���W`��:�Fpo-`7	�\re��XXzK�I:���bD�_�5�>���ŗ��f+<Y��vg��,�%�H\\  d\$@��q�\n��A \n��6�8F�'|�I��R���T�{s�m3��8b)��	@���Lc�M���F@�#Y`��N���DX��CxzYc�0y���3hDZ��6\"�t\\7�SE;���U#�R^��ީ�s\0Cfb�ܚ��rrI\"Y�	�tå�8ZB/.�`�E��K�|����b��\n|_�}��KC�.��� p�1:����#Y\nTC	%,,��\r#�@�+��dqŁ�\$���{�D	\\J\0񒫇-`m!�|�g��dz�VI��vv&��A�`���MH\\I�����|E������j�B0ۊ@ѡnU��K��ތ��>����]ݸ�h��i�X9upr����a�\$7�v��Q��CA�>1����xif�R���7*�;8%���\"��Ʉ���w�P��TB���yH��'\n攏bظ���v��T5xcH\$�\\��ۏ����X�l��K���a�`���#t�Ew�gh�1�� �z��p���4:�\n�C��2��H�K<X	(!J��;�㏨���,��u�3�y�s�M�C9p��wz\0��ՠ9���ǈ�x�ǃ��1��B�������ي��`r�)=hLƂ�`���?z9�E�?���J���1�����Q��R�<\r�L\n8(#��r���p>��L�Q������|���\"4�(��*���8�fpiWaQ\n�Q��*���\\0@H�;�V��Y�Ά�����OZx�<F��'�I�A\n<�]�dP��_N�T!�\r˧���@*~І�B��=�%�z������;��:���AB}��&�l��c��h�`T��O�))�\0�y���I��ۦ�8��Ny��ј�G�\r\0�T�\"hn�5W@}�����Ն�B�}ZkV���Ф�y=s�	z�Ӕ����;\r쌚��,�hT��i|jza&�ր\$�i�S°�Hi��>I�B{Z*U�Ә�I�n���O�}��XMs��Q��8��I��Њ�	��v&! �k�@���#��<���T�Z�.����j�Z:�	^�B�}Y�����v�O3BTC���6=��k�eS��~���?]ij�O�Ѧ����m,\0}�!���mF!�[J�.��g��Ul�ZP٦����O[;&����]��Oht	`aILA��k�bki�N�vY���m:��v�v���k�g7���)���>��b&�؞��p�\0�5�I����]dp=�+:;��)� ���Dx@^o��ѸA���L�'�����t w�&U�g��3��B`/�=����'d>�/�dbF�\0�w\0y����9���n�Z[��6Tu���b�Z���~��~��\nzd'�@�Ra\n\n@�G���0�;vS����={��~��\0@_c0�ov�1�~�x����������e�\0p�o��>�83�|�pp�<�Il�o˄��O�;� ����%8Gx.>�o��O=^uLG��\r�N7��ݶq8~&n�5��l��]ڀ�������I..��4ओ_ۼ=��x���P������I�����5�]���[\0_�\0̓��  �<:��e��o������� �B�y�/��Eq瑻���f'�J�w��#7���N�x�F��(y��D�7�\\��'��Y2�˕�?߯)9e�nGr�vQ	�.�/�.Y��ܪ�<�zkMޠ�c��M��B+�\"ہ�\r�g�l�\0^\0��B@-	T���6�1����\n�����P�@ \"\"��@���F���0��t����U�\04��!��_|��(B\0Oc<��'����t�\"m)�TW����F ��P?f9�����C��M�mk����D���ސ�|���	�&��3�`�dΞ���\0O8�y�@��\n\0I?@@�@�/��O��\n��0���<d�\r\n�\0���H��C>�k���nm_:Gb�\$�\0�ђ��|�(v�I6�0�\"KB� �J��rK�`|6����F�T�'�9Y9>r�@y��@�%�ʄ��d�7<��\$p>t�\r\0|�yr�́��k9+����6���#��\"97�� N�ڮ���ͪ��Enp{s^�_;�\"��I�\0�J <w6��e�jc%���8�5�ր�����L&F{�2/w;����&CD���+p��%�#��BYo:d4�#H�!�A�,݃\nsα�8#=g�jl:�U��B�YX\0�eտtmd�(v��@k\\9vQ2��-{&/¶A��<%N����`�EKJ��Pպ,s&���8+-�1�T@W���8�l����D��x76@�\$�v�\"���t�X���vj��@t�H��'Ey@5�ك<ɏ��{��v�OY{LW���r:�(�,̗��\n�+�:(�5䏤�����02�%�D�Q�B��{�x-�(�*�~.����C�J�\n������S���ў#K��|䆮��ɨ2C@��a�B���bCq��y�L�7�K��4���O��fQ=�'���<!ٙ�fP+�`���gND��U���ҡ��!�\$�\$��-�/��3�Az_�@d~Q3��'��>�\n�\0�11�>���J�5���T���k8;���d�Y��^��ƥ���\0�Ӈ���(���F왕���`k���Q�+�I}Z�g0>�0MW{�z_BkП;`�(��-�wJ�e&ؤ;�FA%L\r?!��̋��\"�V�_�5G3���s?-eتQ�,�Y�s?24�~l\$߱eؤ޷�G\r�rH�����A~��O�,�G@l���dϲY���l�bЂ�?���#��:�Sߒ��k�n��ü�,�3Jy�\rg�fπ������v��/�4ݒk��d��A}�OY|t�������K�A���ޗ��?|���ށ-�����&���W`������_�\0S�����������\"��os~���G��r\$�Dr��{#�'���Eͽg���/�?����<������?��:��0�'�����Zn�7���9h@�?����b@(�3�o(�.������,���o>�{���I\"���䑂\"�`9ډ^����-�F7��%��h�Ұ��*֬�@|	\0i����@�@~C��\0�X����X\r,���3��\0����ZT ���6�.<;�C;2b��\0���K=1��#�!��� 5�:T�\nꙪMtᵀ��i�l@����9���S�b�@��(��81���i�A� �@�\r�+�8���K�B�6�~�\r�8-R���L\n�*�`6��1w�B�[�Oٻ�:���t�� A�\n�@�J\"���A8k�l[�������Co��<_�#AF��Xn�l��(��W��,�ꮈZ6���ȭXn\0���J3�Pu������>>��d�!=V�{KGe�c�F龪�Ɍ����m/��0�L��XOi*��˻�\0B/�3z���(��������}�0����+I�BPp\nB����ש���Iui�,�)0���%f	S��h�����Ϝ{���:�P�#�_���'T��k2h� �Ⱦ����i¸B����\r� 0k�ΐOn#>�l�	�\n��B���\n��2����̐�������VOiа��Y��b�s�\0����d�I�ſ	�1�6B�[�,\\���+2��(&��\0���\0�\r��p��^�Z)@<AL�zɐ��U\r�\r���tdH��\rl0D�V1� ��9�d0Lt������@[�5�P	P/��+��<Bz�zn;�f� \"�\n��xg�j���`T�2�4���X� @;���7������\"��ț9h�ۮ��>c<����C������-a\nD\np��9�bZ�����k �����*2�Bʡ���\\1���XC��'��Ɂ����D��D6�; 9;�+Ȯ`���ʃ�J���C������\0002���o���PH�>�\rc�`2A����@F��`ۂ%\$�\"D8����+A�\\`ս��y�&7�4�����x��\0ºt��Ѣp�� i��ZHe�HR�����D#LZ���p)�����.�bɀ,��pB�\$�%xB�&�TɈ`�E(�R��b���\0�;F�1i��o�TⲀ��4/��k<U�*\0�K���\r�Q�Z�e���]\0��ɑLEK����:),X�c(�?N���,W���V�GBʯ�Rqhŀ�ih�<S�oŗ�Y��EM���_�Y�YE��]Q]ų�W�KŻ45qv�����zEB��^�r�4��.���9����\n�al*�+,`�S�U�b/QE���kQ5�Xc��mTP��T�{�`����%�=	P\n\0���x{Hq��B��!R�5�P`��]��	����i�>��¤���h��F�\nN��<<| ��h�Oj��ᝐtڝ��C��)�F��88(�1�8�NR�i����\0߯�����i��蓀-�@'�2!����K@��%X\0����Dk��(Z��\0���\0���룆#���ii������(/-��\$���ػ�`t\$�����[�;^�� ׃���;O/:Θӽ��]\n�Ja��L���9F��RS劣\$�T��d����Ճ~`6��2�	����j��D�2\\OG�Q8����� XE�����4�nl��CfA�\0@�bX	b�Xd��4bk#V\r�t�~�W5�ћFEN`�m���#H��F�OX���\0�8��\$%\n;���(���)���0�\n�:D����@@��)���p	�r����)�0�jM�\n\0�8�\0�(\n��#�!�`���QQ�\r(�8��J5R?��M�(��X�)(�<~Q�G졀Rѹ6�䀑� dmǴ]\"b�����\rȵ��ʁ �&>�A��\$h?��c��(\n�\0�>�	�����}R��~\rhH��{�,G�<�m�(VN��\"�\0_�h�7:،�2A��_�>R\$�1\"\\��27\"z�#�G�l~rDG��m��l��[��I-#Srr@u ;d* I/\"1�����'�]�<���\nH���w�AI �������8#��	[v\0001�^l�#27\\��}��ɒ3#���7E&|�i9����l��&�v���\r��9�'zC./�3'�@�j+�h农�*r@��hY��;'��2~��(96{�A(9��HC�T�D��[�҅�](���,0��u(���}�3Q����)<R�2(RL����\rd�'�\n��F2{J���|�u((SA��ȱ(o%�(� °\0[�.��ʐ3�򙆚��J1(T�2��\"j��ʫ*�7ү�]*���I�:0.!H\n+�C��`����(P?Ҹ���L�aF��+��2�ʀ9�� �+�σ�*A��F�L6��0�\0�+�c�\$@cP?R���# �R��Xy:6p�D�� �,����G�5(�QQԤcP\r��+į�'J�B�8�,�m�8������-��P��pM���x�̥B�V��}�|�G,�< 6\n�\r��ҲJ�S� 9�Z������Ļ2��.��E����1K��8:ՌG*A� �&5-ĸ!jK������Ae-�9�'#/�������U'�s0��'�\n����LUJN.m��Ķ�\nK�04��9Lc��p�\0�<���L0t�2��B\$�<LBL�sLJ�xhs��1l�n'�|���W�d�����Lm,�\"��w*t���Lo-Y�hߤ�\"Z�1�ȥx��焨Ĥ� /�1�U�9̤ʒ�K�2��s.��'(̂�vI���|��������̇.cS\r�\$�����a3�r3\r��J#�i�<\r�� �1�+�΀�J�4\$�N�#���-4j�jM��\n�o/��34t��HʘlȒ��8L�/��4��SN�0�Q���4�ҳRM0]����K����3>%0�')L?*T�s���|�3`̋6���|��R�ͅ3��a�J&�r�M�xs9�2<�s+̅6�(�l͑1�>�9͟5ۉ�T��6<�x\0�\\�slM���/}GJ���\0006M�7j7�;��3��gM�7C����+\"�K�7��s�#~<���ˑ8d�i\"���\$������+��,� ���0�8Y&6��7xb/}#3���\0�8����L��	2��9��Mu9K1*��-/�䲟\n54��q�K��œ��wD栏�o1She�~#��s��l�r��:��ӜN|����\"�4���L79�?O}\0[KӉ�7��eE���(\ra�N)3�ܳJ�.k�2��BF��K���L�)�I2o9�%�|2f����sI�'D̒u��'pSBy���>/|��-\0���s�ʖ�r|�O8�DH-N�<�u�Jm:������=X%)��0�Y3�2��o\nդt	���M�,l�D�ͣ=�K����=�+�ق�6���OU>���I�>\0���MR\n�г�OY'�����A�SOM=D�S�ϫ=��r�;s�sO�=��2��?����N[.D�3�ɣ?���O�=�\0\"LO[?u\0���7@T�4v+p+\$��9L�.��1,H�J̎G����P7��F��5>U���'A5�P?A\\���%?���Y@��M��C4LAh�d���<��P�'�TN�?��4%̢��\r�������oB�E����\nҁ�qA��L��L�a�PDT�	T.��B�\n��Я.��422�؈��)�\r��P�?UT1P�@D���5�4\0��Զ�L9��I�I}'�M��*3\$�`6ɫ'H�rv9��\nP�P�?l���P���<QUC��_QGB����悌P��4���J�2|����q����,}�菦>�0��\$f��`)�PY��(�+\0��0���� �ޕ��bWQ�0�p\0�\ne�\$��rP�s��\n�Q�Q�F��n0(�@#�J@�&ў3\0*��FZ9�\"�����#��>�	�(Q����n�	Fm�h�EF�\n`(�N?r;��\0��\\��R&>��`'\0�x	cꎮ(\n�@��F���&\0���n���\n�Ə��R�/���rD�#�đ(c�Q�G����\n>ďT���FRG�ќ�%	�ѥGxtjѮ�kT��JpAr�GJ�,-�Ү(ԁ#�!e+�H�H�*4�R�K04Ar��>�t�G��R�J}�'Q�G	�rQ�GE0�\0��H���\0�e�F�����6ҍJ�9���Km)�n��P�G��J8t���K�,�R� �.t�SH��T�\0�L�+�n�(�(��1Gu�|��G�\"���H5t����!@>S?M5\"4�R�N�4��H�#`��#Ԑ�I5c�#�I=%4��IIl����?6��RL%0Ԃ�IL�Q����3��S@�(\nT�ұN`0�k���M��\0�I�&�'�qI���T\rI�0N�R��52�r��E7  ��G�, �RoI���{Pe(5Ҋe5�����%�#�>�2`\"�UKe?h��eK\\���\0���	���X*7kTH(�#�ѻKM2�#��	���R\n�%*�-!T�Q�= �UT�?T���1O�\r�.T\\�% ,�UR]K!�Q%+��MQp\ni[\0�J�J�!SQT���^�}4�7���J�T�S5H���MS�O�9�KQ`\\��WS�+\0+%MPa�Q�M`����G�G���?�.���Q㨉@#p*=�'���Rt�Ӭ>���USP�PrR��\$�\0%��U�C��0?�\\�.UuL����(�u7�(�����\0�U�7d�N�If�ME\$5K�?쎃���?�0�j�J\rT@\"�H�x�5oUV�U����W)yS)M�]T���S�\$��p>�Fc������O�Z�U.?�S5mU8%<�(Q�F���uF��V\n�MT���K�_��U@=\\5q�L?\rbus��Y\r4�w�gY!1�#�eX�a@�U�>�d4�\0��\0�#��p	�>\0��=��� � h��?�	��?������L�.՜Ԩ��	@'�nX	5`\$J�4e�K@���V-n�ֱK�u�V�]Wի���D�U�Z���m�6���h�VX[��\rV����M-Dվ��Yui;�uU��)BU�[�\$�ģsTMG4kH�!]uWR}o��H�OoI\$�?Eq��H; �\nT�ԙG�:#�\0���t�TMnc�T�-D�VJ�u�ق�?����T�%vC��ʏeG2;y]hh�\$�W�:)CWs^wuu��V�`�M��^E\\��W�^�*ՙW�R�R��W�V�z�Nן_Jt�א>����׿Wg���V5w�G\0�S�}��F�ZU�V)Zuh���WK�	4��qHU��U7X�hUD��_�y6��F�\\��T�`M�V\n�`}�4�XS݃���e`H\n�G���p���GU&#�%�}r	����e��W\"?=1I�Ze�*֞饄�ܣ�T������,���Xd�t����	�����\0&��kT���bM��P��-T��N`�%�^�BU\0�!����\0�a�<�&��G��H�?�D�%�eM9�=��L��e��}Q6=֤�k@�R\ne(�AWWu�� WB]o��Y']�8��U��@є��VԢ��-L5y��b kH�Wh�\r�VO\0Vj?��UP�Oh�ӫQ�	�#��\rm�W�cb}�\$�Le?4jVk!�Q`'U%^h��R��EN\0Tn휂u\rT��_�*\0�-��\$]�76mٻY��4TmfU&8;p?5RU\"���F�*?�g-��x����4�X쏅IuSRf�i[RSb8	4�ٽg5�6���g�*���Y������b͠V��UE n���6t��}O5��l#�M+�����\"�i5+t�#yV��� �] �QԆ��QM��ZoFե�=Zl魥6'Z�i͇YZgQu����c�U��Q�/5�sZ� �T�0>�&c��U@���Q�!ZM��U��\0�.�\$Y�P8R�?}kiցNM��IT�D��K#�x�'T�RH��7��G卵�Tގ-������p\n�i��Ul�t�U�|�V��V�0�����l����\0���D�[+lݎc�[ ���π�c�M5|\0�l�:�ҤfG6�і\r1�=��m] ���\\�Tm�Qg�1��ہX���᣺>�fu���e����b���k�am �ݣkm�Q�:\0�>���##sn}�'���g�\0�ñ��Z�U���\"�X�uk��T�>�2UR�O �%�\\��b��\$\0�`%7�8[:�����mm�7�mH��\\H=��v�KL�\$�p�KFm\$�SH�Z=���W%c�0�>�c�t���o%���X�}L\0\"��S��%Z�o�7\0#H����w�\n�{�*��i�	n��h?]�����\rq�HT`�V��meU�ꀿK�i#��v�	 \"\0��Ű��#�PM�7�Ih��ԝ��\n?�g���T7PEAT�R�PrM5`S\n5x�����@69�h�E!�6��x�T�Z4����\r;Qr��(��-K�;���` �t��UK�/V���N@��S��� �PV�m@���n��v���bT����t>�E5�;jC�?#rLc�����T�[` �yT���\0�p-�W3��������8�-I��S+T���]\"����:�������:�=�N���)XOo�:�9\0��q6�ݯr��@!��� Waۑ]e#@/��?�2tT]wU�v%�mܒQ�'����o\\շ֑��H<�4�\\Yx�SaYU\$�0XqHŔ�Sb�� W)!� �>Yyb-�\0>UY�K�G\0�k�wדSEy-�n�ck-�	؟P@��\0���WY`�\rgt��UD����1=��M޳!u�<Ħ�C�ר\$t`d�9���́\0��z}�cJD�@b�;��\$.�{���i���TP#����\\ɑ���ȍxT������k��|&e�<<D,��B'|8W�B�zk�-�^�p!�P��f�%:�\r�\r.\\_1z�\r��\$�=�0��G|�B��Ţ��{z|Շ#='����ڭ�*Rź�}��.�_nF��7�C�}k�P�1��0��ZJ���/�_eJ� 7��� <�n?-!X],\n`+UQy]�6�Tr�8�UfӏNM��DR�O�0�&ӑm=��5����i6׍]�;@�=K����Tj]�5Y�����Y]�\rwh�ԑRP0����]u�2Ӏ#��_��iG�*?�	\n_�Q�n�̔}4�0�m �0�\0�t��*:� �,��7.�;��� ���UX��*\0004��9e�.���� J�	%\nM�X��>;�!�Bz@���MtHa>�1[��?\0�N\\�<,�+�ЖAv8�D	D�v\r�(���u�jƔ2(�܃n�Ij�H\$���/^�!s�@�a\nv�&d���/A��{l�N�Ơ`�'���T�n�,!<k�:݄�S@��]�c�`،hT�T`�^ T�?;{�p5x4Dx=XkA����\n�A�� M��������\$�S� �N�ìo&������� ȕ�:��k��N�[��	��n���ҙB����߮�/�H����z����:�,t0+��2;�����a)��vPL�z)	{��#�ڂ��6������3b/�}��;)��� *��Qb,�p�b&5�p��P�ΕY���1��\rX\r!%a����<�O\$h����\0006/o�i{�)����[���*��'�4G��p�a!Vh@-��b�H?� ���Jx����Jc-��>*���f��b�&���A_��\"�%��-��=�W{�J�Yb�~%��;���%X/ ���\$�Qb��G8����f,����\rx�c(\ra��:�v1`>c��&a�����a%b@�qL�HkW����t\n���	����7�ɤ�+V|���?���N��cQ`� cg�h 6����F0�86xߝ��A]�9\0�88��J����Ճc���η�1@ 0���ab��7x�\$?8�2�NS�\$�J'D�\\�5��A%�1�v3��O�3�!7N��rh�#�;7�����{��&%��Aw\$�:���;��������pK8�c��5�ܘL���n,Ȕ�Ȁ��#����	�\0��@:�R�NEB�3˯���.h�S�=�.3�\"��ELs�cR�v)��ǭ�\$�����i�O��FImљn��!���Jb�\r�T��d�|`O����n�;(h�5���w�d�;�kN�ʪ��73�T-��78�\n�UY7D���s�7@�\n�5.���	Tsf~�k�n��)	�mA7B��N��d�ͦ�>@E��&�P@� �ツb�ҝ�:��Ҝ�AE\0�<\"�Q�k�������7X����:\0��at�l��;\r�q\0���)��|\\S;(���Y��s��_^�c��&(�|Yj^��~Z�DƸ�K���+�\0܄��;�=�ї +A�(�6\\i�Bz2mXB_��}�6߉.}���_���ӛe� [�B2e�|�(��fz�Z�����c��f}�ن\0�P@2Ad��by�f��bY�Nm��A�2×��d93f\rvd����e9���dY�f�na���c��e���/��fٓf9��f�e�~4?��_{����f�-�l�~7ں�}�bY��vM���LL������v����eш\n9E����u�U�Y\\���	�#�\$��n�g�B�<� �~����w�\r�uC�����W-d|��Ǭ��y���Tz�	1�,k�9�Q�VpRO��,hCB���~�nY˸Q��p�j��Y#��NX��Wum��Z�(��g3V��L�^oy�gq�!�gz!]�p.:�q�)	��gtJa|��u�܃�a6	�/燃���4d\$�6\n����2#1.g���s�ž���\\�&u����+�,g������wy�Y�K1�� 0�9��:מۭf6�˞�xY�9��Qb�\$��~tX'���6z���.�m�`�1�9s�@4�̓hD��y2�☾vqζ�VD.�\0�6��<���\"\0�綊k���>P9�1�vzϏ�\r����N՟�FY���V}\$:���6��`��::';�O�Od\$yF~��8���\"�턚.�5y�6O�����,Q�!=�t%��e���\0�\0yf6��}���R\n�A�`�P�r,�C\0���k@��S�zB�QCX!�I\0�.v�N����\$��@�Tc�F��Hi�Z�2֑K�\n������)]��i>�77�߀MbŸ��?����ŽC;�C���ޓc��I��4������#�0�hT�M��D=zM��X����CY�i�@`�,����y�Cݑ�i��c;�zV%������,M������%~�:ENY����.��NY�N����/�N��7h�<�A j�\\\n�aW-x`ډ��d���i~KP0�M��*i��\$�Fz|�QAV�I�=�j!�,:tB0�-�z����N���V?@K��AzxDb�V��K\0��8KD�����^��;��Gg�je�Ý�F|��oC9���u��n��(��\0���*4�A1�����j�\n��B�f�=n����Q���zxb܂D47i,!v�JP�!�XΎ��xP�{�Zv��U�Ӏj�B^!dj�\r��������K:4��z��4��bp�l����C�Cܢy����Ao\$��)6�z��Q��?A\r`���\\zEיִ\r�݃s���:Eh�e�>�Ќn�f�nڥ;����B��管��j�n~����w�Tho��M�[(�KKɮ���t!���ˤTx�4���o��y�Ɲ�EKR�6:KG��#�.\$t&��7c��-���@�]�Q�Q:ʊ߾�Ҩi-�,lQné��qO�+G�H�:�f�:�ꓯ�ID��_��Bo��M��Aj9���\n�W�3���F��~�/���f9	�0>����G��d����D��\\�A��]bK�\"\r��F~���[��c�\r�˸BOs�1�d!�y/Ѕ��n���\r�0�7�\r���	�%����h\n�2�l����Jב��ց8\"� h�Bh��j�J7�-b*�K�����!�FCV4��SK�ًF-����~�2�;�F�KÛ4������n�Z��1�vR9��\"L��:.�ν�dQh����k�a�n�k#9N�9��Ʋd��U��\0N��6�O��V��5+�iǢd��]{ج�����c	��g�AM^=����U�{vl�\$�P��5��/�(�\r):`F_:Ɨ��=�	�!y�V��9�ϟE�Q��5�>���:5�<c����Ɠ���z���	�M1�[�n��dn/����F�9�F�#`��v�X�<B�Fj�dN`Q�5�󞾴�K��5o���	�h;�������#���BZ�>����o@ck*��@����֓���D\\�S��)��pۭ���sC���6��pU[��G4�����?�.�e\na	��>W@��{�.��£��훭̵�\\9ژ>���CA�����ץ�`�0���d�]�f��M�1���I7�[����\n�]��,�q�VJ���ۑ?�tz��]����um*�p�+틽���.���\0H��W���;+���Bzo���x;^nE�tK��hq�����ꟓ�E!�+n=��T��瓗��xkj�6�{������#�h��#�[�o}��q���P�DղÝ��������o�1��xc��8D�\0�񲆜�J	������v=�W�Fzz�mk���hOޓ5j\$��X��}�<A>�n�{~h]��\"�\r��GD��x�Q�)=:�5����G:�P��D8�p	�sH2pzt�������\\ڀ����k�|)�Yt	���P�E\\D�0����¾�|p�1�Ɛs=&��`�h���IO��\n�,�M틂>Ae\\}���\\>�գ�G��7�N��l\\��L4!�5c,�T������!p}Ĭ��<�Q�H艞�89����!=�F�1j��ː�A�@��o�6�ۏ�U���9�������Ĺ���q���\nM��<_�}����3q��\0���\$n��o�>\$�z/	��+��q}����1�o\0�F8�?��P�����r�������;<�NG���E�c��\$*��qU����}��s�F�����8��b�C6��\rk��G�m� 4K<~4H!��j��m8Nkr	f.U����z��h�#�S�rU(	Zs���n�z!�/%\0����/&�}����ں6rxW`5�cG���O��b�W\$�b�M]��\$�?��z���\rޭ\"q�����J��Θn�ـ�A���&}���#[%�ɸ-�'gt\$ƕ�j��L�wN�re�\0\$8Z�#��:;�s\0M��\\������s\n�D�M�eA�������f��4I�BԾ��p`��@%Z�\0004�v");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0�\0001���\0\0����\0\0\0!�\0\0\0,\0\0\0\0\0\0!�����M��*)�o��) q��e���#��L�\0;";break;case"cross.gif":echo"GIF89a\0\0�\0001���\0\0����\0\0\0!�\0\0\0,\0\0\0\0\0\0#�����#\na�Fo~y�.�_wa��1�J�G�L�6]\0\0;";break;case"up.gif":echo"GIF89a\0\0�\0001���\0\0����\0\0\0!�\0\0\0,\0\0\0\0\0\0 �����MQN\n�}��a8�y�aŶ�\0��\0;";break;case"down.gif":echo"GIF89a\0\0�\0001���\0\0����\0\0\0!�\0\0\0,\0\0\0\0\0\0 �����M��*)�[W�\\��L&ٜƶ�\0��\0;";break;case"arrow.gif":echo"GIF89a\0\n\0�\0\0������!�\0\0\0,\0\0\0\0\0\n\0\0�i������Ӳ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$f,$l,$Qb,$m,$ba,$ca,$Sd,$Af,$hd,$Bh,$Hh,$ga;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Fc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",15);function
get_lang(){return'en';}function
lang($Gh,$Le=null){if(is_array($Gh)){$Ff=($Le==1?0:1);$Gh=$Gh[$Ff];}$Gh=str_replace("%d","%s",$Gh);$Le=format_number($Le);return
sprintf($Gh,$Le);}if(extension_loaded('pdo')){abstract
class
PdoDb{var$flavor='',$server_info,$affected_rows,$errno,$error;protected$pdo;private$result;function
dsn($Ub,$V,$G,$af=array()){$af[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$af[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoDbStatement');try{$this->pdo=new
\PDO($Ub,$V,$G,$af);}catch(\Exception$qc){auth_error(h($qc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);}abstract
function
select_db($_b);function
quote($Xg){return$this->pdo->quote($Xg);}function
query($I,$Oh=false){$J=$this->pdo->query($I);$this->error="";if(!$J){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error='Unknown error.';return
false;}$this->store_result($J);return$J;}function
multi_query($I){return$this->result=$this->query($I);}function
store_result($J=null){if(!$J){$J=$this->result;if(!$J)return
false;}if($J->columnCount()){$J->num_rows=$J->rowCount();return$J;}$this->affected_rows=$J->rowCount();return
true;}function
next_result(){if(!$this->result)return
false;$this->result->_offset=0;return@$this->result->nextRowset();}function
result($I,$n=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch();return$L?$L[$n]:false;}}class
PdoDbStatement
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(\PDO::FETCH_NUM);}function
fetch_column($n){return$this->fetchColumn($n);}function
fetch_field(){$L=(object)$this->getColumnMeta($this->_offset++);$U=$L->pdo_type;$L->type=($U==\PDO::PARAM_INT?0:15);$L->charsetnr=($U==\PDO::PARAM_LOB||(isset($L->flags)&&in_array("blob",(array)$L->flags))?63:0);return$L;}function
seek($Ne){for($u=0;$u<$Ne;$u++)$this->fetch();}}}$Qb=array();function
add_driver($v,$D){global$Qb;$Qb[$v]=$D;}function
get_driver($v){global$Qb;return$Qb[$v];}abstract
class
SqlDriver{static$If=array();static$Ld;protected$conn;protected$types=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();function
__construct($f){$this->conn=$f;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength($n){}function
unconvertFunction($n){}function
select($R,$O,$Z,$t,$cf=array(),$z=1,$E=0,$Nf=false){global$b;$Gd=(count($t)<count($O));$I=$b->selectQueryBuild($O,$Z,$t,$cf,$z,$E);if(!$I)$I="SELECT".limit(($_GET["page"]!="last"&&$z!=""&&$t&&$Gd&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$O)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($t&&$Gd?"\nGROUP BY ".implode(", ",$t):"").($cf?"\nORDER BY ".implode(", ",$cf):""),($z!=""?+$z:null),($E?$z*$E:0),"\n");$Tg=microtime(true);$K=$this->conn->query($I);if($Nf)echo$b->selectQuery($I,$Tg,!$K);return$K;}function
delete($R,$Vf,$z=0){$I="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$I,$Vf):" $I$Vf"));}function
update($R,$Q,$Vf,$z=0,$_g="\n"){$ei=array();foreach($Q
as$y=>$X)$ei[]="$y = $X";$I=table($R)." SET$_g".implode(",$_g",$ei);return
queries("UPDATE".($z?limit1($R,$I,$Vf,$_g):" $I$Vf"));}function
insert($R,$Q){return
queries("INSERT INTO ".table($R).($Q?" (".implode(", ",array_keys($Q)).")\nVALUES (".implode(", ",$Q).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,$M,$Mf){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($I,$uh){}function
convertSearch($rd,$X,$n){return$rd;}function
convertOperator($Xe){return$Xe;}function
value($X,$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($N){return
q($N);}function
warnings(){return'';}function
tableHelp($D,$Jd=false){}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex($S){return!is_view($S);}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'");}}class
Adminer{var$operators;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($P){return
h($P);}function
database(){return
DB;}function
databases($Jc=true){return
get_databases($Jc);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head($xb=null){return
true;}function
css(){$K=array();foreach(array("","-dark")as$ye){$p="adminer$ye.css";if(file_exists($p))$K[]="$p?v=".crc32(file_get_contents($p));}return$K;}function
loginForm(){global$Qb;echo"<table class='layout'>\n",$this->loginFormField('driver','<tr><th>'.'System'.'<td>',input_hidden("auth[driver]","server")."MySQL / MariaDB"),$this->loginFormField('server','<tr><th>'.'Server'.'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),$this->loginFormField('username','<tr><th>'.'Username'.'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'),$this->loginFormField('password','<tr><th>'.'Password'.'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),$this->loginFormField('db','<tr><th>'.'Database'.'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".'Login'."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],'Permanent login')."\n";}function
loginFormField($D,$jd,$Y){return$jd.$Y."\n";}function
login($de,$G){if($G=="")return
sprintf('Adminer does not support accessing a database without a password, <a href="https://www.adminer.org/en/password/"%s>more information</a>.',target_blank());return
true;}function
tableName($fh){return
h($fh["Name"]);}function
fieldName($n,$cf=0){$U=$n["full_type"];$fb=$n["comment"];return'<span title="'.h($U.($fb!=""?($U?": ":"").$fb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks($fh,$Q=""){global$l;echo'<p class="links">';$ce=array("select"=>'Select data');if(support("table")||support("indexes"))$ce["table"]='Show structure';$Jd=false;if(support("table")){$Jd=is_view($fh);if($Jd)$ce["view"]='Alter view';else$ce["create"]='Alter table';}if($Q!==null)$ce["edit"]='New item';$D=$fh["Name"];foreach($ce
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($D).($y=="edit"?$Q:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>$l->tableHelp($D,$Jd)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$eh){return
array();}function
backwardKeysPrint($_a,$L){}function
selectQuery($I,$Tg,$_c=false){global$l;$K="</p>\n";if(!$_c&&($mi=$l->warnings())){$v="warnings";$K=", <a href='#$v'>".'Warnings'."</a>".script("qsl('a').onclick = partial(toggle, '$v');","")."$K<div id='$v' class='hidden'>\n$mi</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$I))."</code> <span class='time'>(".format_time($Tg).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($I)."'>".'Edit'."</a>":"").$K;}function
sqlCommandQuery($I){return
shorten_utf8(trim($I),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions($M,$Mc){return$M;}function
selectLink($X,$n){}function
selectVal($X,$_,$n,$mf){$K=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$K="<i>".lang(array('%d byte','%d bytes'),strlen($mf))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$K</a>":$K);}function
editVal($X,$n){return$X;}function
tableStructurePrint($o,$fh=null){global$l;echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".'Column'."<td>".'Type'.(support("comment")?"<td>".'Comment':"")."</thead>\n";$Yg=$l->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$ab=h($n["collation"]);echo"<td><span title='$ab'>".(in_array($U,(array)$Yg['User types'])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($ab&&isset($fh["Collation"])&&$ab!=$fh["Collation"]?" $ab":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".'Auto Increment'."</i>":"");$k=h($n["default"]);echo(isset($n["default"])?" <span title='".'Default value'."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$k</code>":$k)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($x){echo"<table>\n";foreach($x
as$D=>$w){ksort($w["columns"]);$Nf=array();foreach($w["columns"]as$y=>$X)$Nf[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($D)."'><th>$w[type]<td>".implode(", ",$Nf)."\n";}echo"</table>\n";}function
selectColumnsPrint($O,$e){global$l;print_fieldset("select",'Select',$O);$u=0;$O[""]=array();foreach($O
as$y=>$X){$X=$_GET["columns"][$y];$d=select_input(" name='columns[$u][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($l->functions||$l->grouping?html_select("columns[$u][fun]",array(-1=>"")+array_filter(array('Functions'=>$l->functions,'Aggregation'=>$l->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$u++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$x){print_fieldset("search",'Search',$Z);foreach($x
as$u=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$u]' value='".h($_GET["fulltext"][$u])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$u]",1,isset($_GET["boolean"][$u]),"BOOL"),"</div>\n";}$Na="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$u=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)))echo"<div>".select_input(" name='where[$u][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".'anywhere'.")"),html_select("where[$u][op]",$this->operators,$X["op"],$Na),"<input type='search' name='where[$u][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Na }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint($cf,$e,$x){print_fieldset("sort",'Sort',$cf);$u=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$u]'",$e,$X,"selectFieldChange"),checkbox("desc[$u]",1,isset($_GET["desc"][$y]),'descending')."</div>\n";$u++;}}echo"<div>".select_input(" name='order[$u]'",$e,"","selectAddRow"),checkbox("desc[$u]",1,false,'descending')."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".'Limit'."</legend><div>","<input type='number' name='limit' class='size' value='".h($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($sh){if($sh!==null)echo"<fieldset><legend>".'Text length'."</legend><div>","<input type='number' name='text_length' class='size' value='".h($sh)."'>","</div></fieldset>\n";}function
selectActionPrint($x){echo"<fieldset><legend>".'Action'."</legend><div>","<input type='submit' value='".'Select'."'>"," <span id='noindex' title='".'Full table scan'."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$wb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$wb)$e[$wb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($cc,$e){}function
selectColumnsProcess($e,$x){global$l;$O=array();$t=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$l->functions)||in_array($X["fun"],$l->grouping)))){$O[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$l->grouping))$t[]=$O[$y];}}return
array($O,$t);}function
selectSearchProcess($o,$x){global$f,$l;$K=array();foreach($x
as$u=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$u]!="")$K[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$u]).(isset($_GET["boolean"][$u])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$Kf="";$ib=" $X[op]";if(preg_match('~IN$~',$X["op"])){$ud=process_length($X["val"]);$ib.=" ".($ud!=""?$ud:"(NULL)");}elseif($X["op"]=="SQL")$ib=" $X[val]";elseif($X["op"]=="LIKE %%")$ib=" LIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$ib=" ILIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Kf="$X[op](".q($X["val"]).", ";$ib=")";}elseif(!preg_match('~NULL$~',$X["op"]))$ib.=" ".$this->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$K[]=$Kf.$l->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$ib;else{$cb=array();foreach($o
as$D=>$n){if(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$cb[]=$Kf.$l->convertSearch(idf_escape($D),$X,$n).$ib;}$K[]=($cb?"(".implode(" OR ",$cb).")":"1 = 0");}}}return$K;}function
selectOrderProcess($o,$x){$K=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$K[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$K;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$Mc){return
false;}function
selectQueryBuild($O,$Z,$t,$cf,$z,$E){return"";}function
messageQuery($I,$th,$_c=false){global$l;restart_session();$ld=&get_session("queries");if(!$ld[$_GET["db"]])$ld[$_GET["db"]]=array();if(strlen($I)>1e6)$I=preg_replace('~[\x80-\xFF]+$~','',substr($I,0,1e6))."\n…";$ld[$_GET["db"]][]=array($I,time(),$th);$Qg="sql-".count($ld[$_GET["db"]]);$K="<a href='#$Qg' class='toggle'>".'SQL command'."</a>\n";if(!$_c&&($mi=$l->warnings())){$v="warnings-".count($ld[$_GET["db"]]);$K="<a href='#$v' class='toggle'>".'Warnings'."</a>, $K<div id='$v' class='hidden'>\n$mi</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $K<div id='$Qg' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($I,1000)."</code></pre>".($th?" <span class='time'>($th)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($ld[$_GET["db"]])-1)).'">'.'Edit'.'</a>':'').'</div>';}function
editRowPrint($R,$o,$L,$Vh){}function
editFunctions($n){global$l;$K=($n["null"]?"NULL/":"");$Vh=isset($_GET["select"])||where($_GET);foreach($l->editFunctions
as$y=>$Tc){if(!$y||(!isset($_GET["call"])&&$Vh)){foreach($Tc
as$zf=>$X){if(!$zf||preg_match("~$zf~",$n["type"]))$K.="/$X";}}if($y&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$K.="/SQL";}if($n["auto_increment"]&&!$Vh)$K='Auto Increment';return
explode("/",$K);}function
editInput($R,$n,$ua,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$ua value='-1' checked><i>".'original'."</i></label> ":"").($n["null"]?"<label><input type='radio'$ua value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$ua,$n,$Y,$Y===0?0:null);return"";}function
editHint($R,$n,$Y){return"";}function
processInput($n,$Y,$s=""){if($s=="SQL")return$Y;$D=$n["field"];$K=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$K="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$K=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$K=idf_escape($D)." $s $K";elseif(preg_match('~^[+-] interval$~',$s))$K=idf_escape($D)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$K);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$K="$s(".idf_escape($D).", $K)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$K="$s($K)";return
unconvert_field($n,$K);}function
dumpOutput(){$K=array('text'=>'open','file'=>'save');if(function_exists('gzencode'))$K['gz']='gzip';return$K;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($R,$Zg,$Jd=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Zg)dump_csv(array_keys(fields($R)));}else{if($Jd==2){$o=array();foreach(fields($R)as$D=>$n)$o[]=idf_escape($D)." $n[full_type]";$h="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$h=create_sql($R,$_POST["auto_increment"],$Zg);set_utf8mb4($h);if($Zg&&$h){if($Zg=="DROP+CREATE"||$Jd==1)echo"DROP ".($Jd==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($Jd==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($R,$Zg,$I){global$f;if($Zg){$ke=(JUSH=="sqlite"?0:1048576);$o=array();$qd=false;if($_POST["format"]=="sql"){if($Zg=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$qd=true;break;}}}}$J=$f->query($I,1);if($J){$Bd="";$Ja="";$Nd=array();$Uc=array();$bh="";$Cc=($R!=''?'fetch_assoc':'fetch_row');while($L=$J->$Cc()){if(!$Nd){$ei=array();foreach($L
as$X){$n=$J->fetch_field();if($o[$n->name]['generated']){$Uc[$n->name]=true;continue;}$Nd[]=$n->name;$y=idf_escape($n->name);$ei[]="$y = VALUES($y)";}$bh=($Zg=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$ei):"").";\n";}if($_POST["format"]!="sql"){if($Zg=="table"){dump_csv($Nd);$Zg="INSERT";}dump_csv($L);}else{if(!$Bd)$Bd="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$Nd)).") VALUES";foreach($L
as$y=>$X){if($Uc[$y]){unset($L[$y]);continue;}$n=$o[$y];$L[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$N=($ke?"\n":" ")."(".implode(",\t",$L).")";if(!$Ja)$Ja=$Bd.$N;elseif(strlen($Ja)+4+strlen($N)+strlen($bh)<$ke)$Ja.=",$N";else{echo$Ja.$bh;$Ja=$Bd.$N;}}}if($Ja)echo$Ja.$bh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$f->error)."\n";if($qd)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($pd){return
friendly_url($pd!=""?$pd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($pd,$ze=false){$of=$_POST["output"];$wc=(preg_match('~sql~',$_POST["format"])?"sql":($ze?"tar":"csv"));header("Content-Type: ".($of=="gz"?"application/x-gzip":($wc=="tar"?"application/x-tar":($wc=="sql"||$of!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($of=="gz"){ob_start(function($Xg){return
gzencode($Xg);},1e6);}return$wc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.'Alter database'."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?'Alter schema':'Create schema')."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.'Database schema'."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".'Privileges'."</a>\n":"");return
true;}function
navigation($xe){global$ga,$Qb,$f;echo"<h1>".$this->name()." <span class='version'>$ga";$Ge=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare($ga,$Ge)<0?h($Ge):"")."</a>","</span></h1>\n";if($xe=="auth"){$of="";foreach((array)$_SESSION["pwds"]as$gi=>$Bg){foreach($Bg
as$P=>$ci){$D=h(get_setting("vendor-$gi-$P")?:$Qb[$gi]);foreach($ci
as$V=>$G){if($G!==null){$Cb=$_SESSION["db"][$gi][$P][$V];foreach(($Cb?array_keys($Cb):array(""))as$j)$of.="<li><a href='".h(auth_url($gi,$P,$V,$j))."'>($D) ".h($V.($P!=""?"@".$this->serverName($P):"").($j!=""?" - $j":""))."</a>\n";}}}}if($of)echo"<ul id='logins'>\n$of</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$xe&&DB!=""){$f->select_db(DB);$T=table_status('',true);}$this->syntaxHighlighting($T);$this->databasesPrint($xe);$ia=array();if(DB==""||!$xe){if(support("sql")){$ia[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".'SQL command'."</a>";$ia[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".'Import'."</a>";}$ia[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".'Export'."</a>";}$vd=$_GET["ns"]!==""&&!$xe&&DB!="";if($vd)$ia[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".'Create table'."</a>";echo($ia?"<p class='links'>\n".implode("\n",$ia)."\n":"");if($vd){if($T)$this->tablesPrint($T);else
echo"<p class='message'>".'No tables.'."</p>\n";}}}function
syntaxHighlighting($T){global$f;echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.1.0");if(support("sql")){echo"<script".nonce().">\n";if($T){$ce=array();foreach($T
as$R=>$U)$ce[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$ce).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";}echo"</script>\n";}echo
script("syntaxHighlighting('".(is_object($f)?preg_replace('~^(\d\.?\d).*~s','\1',$f->server_info):"")."'".($f->flavor=='maria'?", 'maria'":($f->flavor=='cockroach'?", 'cockroach'":"")).");");}function
databasesPrint($xe){global$b,$f;$i=$this->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Ab=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".'Database'."'>".'DB'.":</span> ".($i?html_select("db",array(""=>"")+$i,DB).$Ab:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n"),"<input type='submit' value='".'Use'."'".($i?" class='hidden'":"").">\n";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint($T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$Ug){$D=$this->tableName($Ug);if($D!="")echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".'Select data'."'>".'select'."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($Ug)?"view":"structure"))." title='".'Show structure'."'>$D</a>":"<span>$D</span>")."\n";}echo"</ul>\n";}}class
Plugins
extends
Adminer{var$plugins;function
__construct($Df){if($Df===null){$Df=array();$Da="adminer-plugins";if(is_dir($Da)){foreach(glob("$Da/*.php")as$p)$wd=include_once"./$p";}$kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Da.php")){$wd=include_once"./$Da.php";if(is_array($wd)){foreach($wd
as$Cf)$Df[get_class($Cf)]=$Cf;}else$this->error.=sprintf('%s must <a%s>return an array</a>.',"<b>$Da.php</b>",$kd)."<br>";}foreach(get_declared_classes()as$Va){if(!$Df[$Va]&&preg_match('~^Adminer\w~i',$Va)){$eg=new
\ReflectionClass($Va);$kb=$eg->getConstructor();if($kb&&$kb->getNumberOfRequiredParameters())$this->error.=sprintf('<a%s>Configure</a> %s in %s.',$kd,"<b>$Va</b>","<b>$Da.php</b>")."<br>";else$Df[$Va]=new$Va;}}}$this->plugins=$Df;}private
function
callParent($s,$c){return
call_user_func_array(array('parent',$s),$c);}private
function
applyPlugin($s,$F){$c=array();foreach($F
as$y=>$X)$c[]=&$F[$y];foreach($this->plugins
as$Cf){if(method_exists($Cf,$s)){$K=call_user_func_array(array($Cf,$s),$c);if($K!==null)return$K;}}return$this->callParent($s,$c);}private
function
appendPlugin($s,$c){$K=$this->callParent($s,$c);foreach($this->plugins
as$Cf){if(method_exists($Cf,$s)){$Y=call_user_func_array(array($Cf,$s),$c);if($Y)$K+=$Y;}}return$K;}function
dumpFormat(){$c=func_get_args();return$this->appendPlugin(__FUNCTION__,$c);}function
dumpOutput(){$c=func_get_args();return$this->appendPlugin(__FUNCTION__,$c);}function
editRowPrint($R,$o,$L,$Vh){$c=func_get_args();return$this->appendPlugin(__FUNCTION__,$c);}function
editFunctions($n){$c=func_get_args();return$this->appendPlugin(__FUNCTION__,$c);}function
name(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
credentials(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
connectSsl(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
permanentLogin($h=false){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
bruteForceKey(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
serverName($P){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
database(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
schemas(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
databases($Jc=true){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
queryTimeout(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
headers(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
csp(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
head($xb=null){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
css(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
loginForm(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
loginFormField($D,$jd,$Y){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
login($de,$G){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
tableName($fh){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
fieldName($n,$cf=0){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLinks($fh,$Q=""){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
foreignKeys($R){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
backwardKeys($R,$eh){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
backwardKeysPrint($_a,$L){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectQuery($I,$Tg,$_c=false){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
sqlCommandQuery($I){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
sqlPrintAfter(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
rowDescription($R){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
rowDescriptions($M,$Mc){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLink($X,$n){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectVal($X,$_,$n,$mf){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
editVal($X,$n){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
tableStructurePrint($o,$fh=null){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
tableIndexesPrint($x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectColumnsPrint($O,$e){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectSearchPrint($Z,$e,$x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectOrderPrint($cf,$e,$x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLimitPrint($z){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLengthPrint($sh){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectActionPrint($x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectCommandPrint(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectImportPrint(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectEmailPrint($cc,$e){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectColumnsProcess($e,$x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectSearchProcess($o,$x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectOrderProcess($o,$x){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLimitProcess(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectLengthProcess(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectEmailProcess($Z,$Mc){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
selectQueryBuild($O,$Z,$t,$cf,$z,$E){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
messageQuery($I,$th,$_c=false){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
editInput($R,$n,$ua,$Y){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
editHint($R,$n,$Y){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
processInput($n,$Y,$s=""){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpDatabase($j){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpTable($R,$Zg,$Jd=0){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpData($R,$Zg,$I){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpFilename($pd){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpHeaders($pd,$ze=false){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
dumpFooter(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
importServerPath(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
homepage(){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
navigation($xe){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
syntaxHighlighting($T){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
databasesPrint($xe){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}function
tablesPrint($T){$c=func_get_args();return$this->applyPlugin(__FUNCTION__,$c);}}if(function_exists('adminer_object'))$b=adminer_object();elseif(is_dir("adminer-plugins")||file_exists("adminer-plugins.php"))$b=new
Plugins(null);else$b=new
Adminer;$Qb=array("server"=>"MySQL / MariaDB")+$Qb;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
connect($P="",$V="",$G="",$_b=null,$Ef=null,$Jg=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($nd,$Ef)=explode(":",$P,2);$Sg=$b->connectSsl();if($Sg)$this->ssl_set($Sg['key'],$Sg['cert'],$Sg['ca'],'','');$K=@$this->real_connect(($P!=""?$nd:ini_get("mysqli.default_host")),($P.$V!=""?$V:ini_get("mysqli.default_user")),($P.$V.$G!=""?$G:ini_get("mysqli.default_pw")),$_b,(is_numeric($Ef)?$Ef:ini_get("mysqli.default_port")),(!is_numeric($Ef)?$Ef:$Jg),($Sg?($Sg['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$K;}function
set_charset($Oa){if(parent::set_charset($Oa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Oa");}function
result($I,$n=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch_array();return($L?$L[$n]:false);}function
quote($Xg){return"'".$this->escape_string($Xg)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db{var$extension="MySQL",$flavor='',$server_info,$affected_rows,$info,$errno,$error;private$link,$result;function
connect($P,$V,$G){if(ini_bool("mysql.allow_local_infile")){$this->error=sprintf('Disable %s or enable %s or %s extensions.',"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->link=@mysql_connect(($P!=""?$P:ini_get("mysql.default_host")),("$P$V"!=""?$V:ini_get("mysql.default_user")),("$P$V$G"!=""?$G:ini_get("mysql.default_password")),true,131072);if($this->link)$this->server_info=mysql_get_server_info($this->link);else$this->error=mysql_error();return(bool)$this->link;}function
set_charset($Oa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Oa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Oa");}function
quote($Xg){return"'".mysql_real_escape_string($Xg,$this->link)."'";}function
select_db($_b){return
mysql_select_db($_b,$this->link);}function
query($I,$Oh=false){$J=@($Oh?mysql_unbuffered_query($I,$this->link):mysql_query($I,$this->link));$this->error="";if(!$J){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($J===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($J);}function
multi_query($I){return$this->result=$this->query($I);}function
store_result(){return$this->result;}function
next_result(){return
false;}function
result($I,$n=0){$J=$this->query($I);return($J?$J->fetch_column($n):false);}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($J){$this->result=$J;$this->num_rows=mysql_num_rows($J);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_column($n){return($this->num_rows?mysql_result($this->result,0,$n):false);}function
fetch_field(){$K=mysql_fetch_field($this->result,$this->offset++);$K->orgtable=$K->table;$K->charsetnr=($K->blob?63:0);return$K;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
connect($P,$V,$G){global$b;$af=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Sg=$b->connectSsl();if($Sg){if($Sg['key'])$af[\PDO::MYSQL_ATTR_SSL_KEY]=$Sg['key'];if($Sg['cert'])$af[\PDO::MYSQL_ATTR_SSL_CERT]=$Sg['cert'];if($Sg['ca'])$af[\PDO::MYSQL_ATTR_SSL_CA]=$Sg['ca'];if(isset($Sg['verify']))$af[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$Sg['verify'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$P)),$V,$G,$af);return
true;}function
set_charset($Oa){$this->query("SET NAMES $Oa");}function
select_db($_b){return$this->query("USE ".idf_escape($_b));}function
query($I,$Oh=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Oh);return
parent::query($I,$Oh);}}}class
Driver
extends
SqlDriver{static$If=array("MySQLi","MySQL","PDO_MySQL");static$Ld="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");function
__construct($f){parent::__construct($f);$this->types=array('Numbers'=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),'Date and time'=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),'Strings'=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),'Lists'=>array("enum"=>65535,"set"=>64),'Binary'=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),'Geometry'=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->editFunctions=array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",));if(min_version('5.7.8',10.2,$f))$this->types['Strings']["json"]=4294967295;if(min_version('',10.7,$f)){$this->types['Strings']["uuid"]=128;$this->editFunctions[0]['uuid']='uuid';}if(min_version(9,'',$f)){$this->types['Numbers']["vector"]=16383;$this->editFunctions[0]['vector']='string_to_vector';}if(min_version(5.7,10.2,$f))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction($n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,$Q){return($Q?parent::insert($R,$Q):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,$M,$Mf){$e=array_keys(reset($M));$Kf="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$ei=array();foreach($e
as$y)$ei[$y]="$y = VALUES($y)";$bh="\nON DUPLICATE KEY UPDATE ".implode(", ",$ei);$ei=array();$Zd=0;foreach($M
as$Q){$Y="(".implode(", ",$Q).")";if($ei&&(strlen($Kf)+$Zd+strlen($Y)+strlen($bh)>1e6)){if(!queries($Kf.implode(",\n",$ei).$bh))return
false;$ei=array();$Zd=0;}$ei[]=$Y;$Zd+=strlen($Y)+2;}return
queries($Kf.implode(",\n",$ei).$bh);}function
slowQuery($I,$uh){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$uh FOR $I";elseif(preg_match('~^(SELECT\b)(.+)~is',$I,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($uh*1000).") */ $B[2]";}}function
convertSearch($rd,$X,$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($rd USING ".charset($this->conn).")":$rd);}function
warnings(){$J=$this->conn->query("SHOW WARNINGS");if($J&&$J->num_rows){ob_start();select($J);return
ob_get_clean();}}function
tableHelp($D,$Jd=false){$fe=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($fe?"$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($fe?"mysql$D-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Ka;if($Ka===null){$Rg=$this->conn->result("SHOW VARIABLES LIKE 'sql_mode'",1);$Ka=(strpos($Rg,'NO_BACKSLASH_ESCAPES')===false);}return$Ka;}function
engines(){$K=array();foreach(get_rows("SHOW ENGINES")as$L){if(preg_match("~YES|DEFAULT~",$L["Support"]))$K[]=$L["Engine"];}return$K;}}function
idf_escape($rd){return"`".str_replace("`","``",$rd)."`";}function
table($rd){return
idf_escape($rd);}function
connect($sb){global$Qb;$f=new
Db;if($f->connect($sb[0],$sb[1],$sb[2])){$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");$f->flavor=(preg_match('~MariaDB~',$f->server_info)?'maria':'');$Qb[DRIVER]=($f->flavor=='maria'?"MariaDB":"MySQL");return$f;}$K=$f->error;if(function_exists('iconv')&&!is_utf8($K)&&strlen($N=iconv("windows-1250","utf-8",$K))>strlen($K))$K=$N;return$K;}function
get_databases($Jc){$K=get_session("dbs");if($K===null){$I="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$K=($Jc?slow_query($I):get_vals($I));restart_session();set_session("dbs",$K);stop_session();}return$K;}function
limit($I,$Z,$z,$Ne=0,$_g=" "){return" $I$Z".($z!==null?$_g."LIMIT $z".($Ne?" OFFSET $Ne":""):"");}function
limit1($R,$I,$Z,$_g="\n"){return
limit($I,$Z,1,0,$_g);}function
db_collation($j,$bb){$K=null;$h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$B))$K=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$B))$K=$bb[$B[1]][-1];return$K;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables($i){$K=array();foreach($i
as$j)$K[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$K;}function
table_status($D="",$Ac=false){$K=array();foreach(get_rows($Ac?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$L){if($L["Engine"]=="InnoDB")$L["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$L["Comment"]);if(!isset($L["Engine"]))$L["Comment"]="";if($D!=""){$L["Name"]=$D;return$L;}$K[$L["Name"]]=$L;}return$K;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&min_version(5.6));}function
fields($R){global$f;$fe=($f->flavor=='maria');$K=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$L){$n=$L["COLUMN_NAME"];$U=$L["COLUMN_TYPE"];$Vc=$L["GENERATION_EXPRESSION"];$yc=$L["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$yc,$Uc);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$he);$k=$L["COLUMN_DEFAULT"];if($k!=""){$Id=preg_match('~text|json~',$he[1]);if(!$fe&&$Id)$k=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($k));if($fe||$Id){$k=($k=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($B){return
stripslashes(str_replace("''","'",$B[1]));},$k));}if(!$fe&&preg_match('~binary~',$he[1])&&preg_match('~^0x(\w*)$~',$k,$B))$k=pack("H*",$B[1]);}$K[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$he[1],"length"=>$he[2],"unsigned"=>ltrim($he[3].$he[4]),"default"=>($Uc?($fe?$Vc:stripslashes($Vc)):$k),"null"=>($L["IS_NULLABLE"]=="YES"),"auto_increment"=>($yc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$yc,$B)?$B[1]:""),"collation"=>$L["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$L[PRIVILEGES],where,order")),"comment"=>$L["COLUMN_COMMENT"],"primary"=>($L["COLUMN_KEY"]=="PRI"),"generated"=>($Uc[1]=="PERSISTENT"?"STORED":$Uc[1]),);}return$K;}function
indexes($R,$g=null){$K=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$g)as$L){$D=$L["Key_name"];$K[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($L["Index_type"]=="FULLTEXT"?"FULLTEXT":($L["Non_unique"]?($L["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$K[$D]["columns"][]=$L["Column_name"];$K[$D]["lengths"][]=($L["Index_type"]=="SPATIAL"?null:$L["Sub_part"]);$K[$D]["descs"][]=null;}return$K;}function
foreign_keys($R){global$l;static$zf='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$K=array();$qb=get_val("SHOW CREATE TABLE ".table($R),1);if($qb){preg_match_all("~CONSTRAINT ($zf) FOREIGN KEY ?\\(((?:$zf,? ?)+)\\) REFERENCES ($zf)(?:\\.($zf))? \\(((?:$zf,? ?)+)\\)(?: ON DELETE ($l->onActions))?(?: ON UPDATE ($l->onActions))?~",$qb,$ie,PREG_SET_ORDER);foreach($ie
as$B){preg_match_all("~$zf~",$B[2],$Lg);preg_match_all("~$zf~",$B[5],$nh);$K[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('Adminer\idf_unescape',$Lg[0]),"target"=>array_map('Adminer\idf_unescape',$nh[0]),"on_delete"=>($B[6]?:"RESTRICT"),"on_update"=>($B[7]?:"RESTRICT"),);}}return$K;}function
view($D){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$K=array();foreach(get_rows("SHOW COLLATION")as$L){if($L["Default"])$K[$L["Charset"]][-1]=$L["Collation"];else$K[$L["Charset"]][]=$L["Collation"];}ksort($K);foreach($K
as$y=>$X)asort($K[$y]);return$K;}function
information_schema($j){return($j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){global$f;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$f->error));}function
create_database($j,$ab){return
queries("CREATE DATABASE ".idf_escape($j).($ab?" COLLATE ".q($ab):""));}function
drop_databases($i){$K=apply_queries("DROP DATABASE",$i,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$K;}function
rename_database($D,$ab){$K=false;if(create_database($D,$ab)){$T=array();$ji=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$ji[]=$R;else$T[]=$R;}$K=(!$T&&!$ji)||move_tables($T,$ji,$D);drop_databases($K?array(DB):array());}return$K;}function
auto_increment(){$xa=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$xa="";break;}if($w["type"]=="PRIMARY")$xa=" UNIQUE";}}return" AUTO_INCREMENT$xa";}function
alter_table($R,$D,$o,$Lc,$fb,$fc,$ab,$wa,$vf){global$f;$qa=array();foreach($o
as$n){if($n[1]){$k=$n[1][3];if(preg_match('~ GENERATED~',$k)){$n[1][3]=($f->flavor=='maria'?"":$n[1][2]);$n[1][2]=$k;}$qa[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$qa[]="DROP ".idf_escape($n[0]);}$qa=array_merge($qa,$Lc);$Ug=($fb!==null?" COMMENT=".q($fb):"").($fc?" ENGINE=".q($fc):"").($ab?" COLLATE ".q($ab):"").($wa!=""?" AUTO_INCREMENT=$wa":"");if($R=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$qa)."\n)$Ug$vf");if($R!=$D)$qa[]="RENAME TO ".table($D);if($Ug)$qa[]=ltrim($Ug);return($qa||$vf?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$qa).$vf):true);}function
alter_indexes($R,$qa){foreach($qa
as$y=>$X)$qa[$y]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$qa));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($ji){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$ji)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$ji,$nh){global$f;$hg=array();foreach($T
as$R)$hg[]=table($R)." TO ".idf_escape($nh).".".table($R);if(!$hg||queries("RENAME TABLE ".implode(", ",$hg))){$Gb=array();foreach($ji
as$R)$Gb[table($R)]=view($R);$f->select_db($nh);$j=idf_escape(DB);foreach($Gb
as$D=>$ii){if(!queries("CREATE VIEW $D AS ".str_replace(" $j."," ",$ii["select"]))||!queries("DROP VIEW $j.$D"))return
false;}return
true;}return
false;}function
copy_tables($T,$ji,$nh){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$D=($nh==DB?table("copy_$R"):idf_escape($nh).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($R))||!queries("INSERT INTO $D SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$L){$Ih=$L["Trigger"];if(!queries("CREATE TRIGGER ".($nh==DB?idf_escape("copy_$Ih"):idf_escape($nh).".".idf_escape($Ih))." $L[Timing] $L[Event] ON $D FOR EACH ROW\n$L[Statement];"))return
false;}}foreach($ji
as$R){$D=($nh==DB?table("copy_$R"):idf_escape($nh).".".table($R));$ii=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $ii[select]"))return
false;}return
true;}function
trigger($D){if($D=="")return
array();$M=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($M);}function
triggers($R){$K=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$L)$K[$L["Trigger"]]=array($L["Timing"],$L["Event"]);return$K;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$U){global$l;$oa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Mg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$hc=$l->enumLength;$Mh="((".implode("|",array_merge(array_keys($l->types()),$oa)).")\\b(?:\\s*\\(((?:[^'\")]|$hc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$zf="$Mg*(".($U=="FUNCTION"?"":$l->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Mh";$h=get_val("SHOW CREATE $U ".idf_escape($D),2);preg_match("~\\(((?:$zf\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Mh\\s+":"")."(.*)~is",$h,$B);$o=array();preg_match_all("~$zf\\s*,?~is",$B[1],$ie,PREG_SET_ORDER);foreach($ie
as$rf)$o[]=array("field"=>str_replace("``","`",$rf[2]).$rf[3],"type"=>strtolower($rf[5]),"length"=>preg_replace_callback("~$hc~s",'Adminer\normalize_enum',$rf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$rf[8] $rf[7]"))),"null"=>1,"full_type"=>$rf[4],"inout"=>strtoupper($rf[1]),"collation"=>strtolower($rf[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($D)),)+($U!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($D,$L){return
idf_escape($D);}function
last_id($J){return
get_val("SELECT LAST_INSERT_ID()");}function
explain($f,$I){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$I);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$wa,$Zg){$K=get_val("SHOW CREATE TABLE ".table($R),1);if(!$wa)$K=preg_replace('~ AUTO_INCREMENT=\d+~','',$K);return$K;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($_b){return"USE ".idf_escape($_b);}function
trigger_sql($R){$K="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$L)$K.="\nCREATE TRIGGER ".idf_escape($L["Trigger"])." $L[Timing] $L[Event] ON ".table($L["Table"])." FOR EACH ROW\n$L[Statement];;\n";return$K;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field($n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field($n,$K){if(preg_match("~binary~",$n["type"]))$K="UNHEX($K)";if($n["type"]=="bit")$K="CONVERT(b$K, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Kf=(min_version(8)?"ST_":"");$K=$Kf."GeomFromText($K, $Kf"."SRID($n[field]))";}return$K;}function
support($Bc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning")).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Bc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}}define('Adminer\JUSH',Driver::$Ld);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($wh,$m="",$Ia=array(),$xh=""){global$ca,$ga,$b,$Qb;page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start(null,4096);$yh=$wh.($xh!=""?": $xh":"");$zh=strip_tags($yh.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="en" dir="ltr">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$zh,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.1.0"),'">
';$ub=$b->css();$gd=false;$ed=false;foreach($ub
as$p){if(strpos($p,"adminer.css")!==false)$gd=true;if(strpos($p,"adminer-dark.css")!==false)$ed=true;}$xb=($gd?($ed?null:false):($ed?:null));$qe=" media='(prefers-color-scheme: dark)'";if($xb!==false)echo"<link rel='stylesheet'".($xb?"":$qe)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.1.0")."'>\n";echo"<meta name='color-scheme' content='".($xb===null?"light dark":($xb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.1.0");if($b->head($xb))echo"<link rel='shortcut icon' type='image/x-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.0")."'>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.0")."'>\n";foreach($ub
as$X)echo"<link rel='stylesheet'".(preg_match('~-dark~',$X)&&!$xb?$qe:"")." href='".h($X)."'>\n";echo"\n<body class='".'ltr'." nojs'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$hi=unserialize(file_get_contents($p));$Tf="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($hi["version"],base64_decode($hi["signature"]),$Tf)==1)$_COOKIE["adminer_version"]=$hi["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ga', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape('You are offline.')."';
const thousandsSeparator = '".js_escape(',')."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n";if($Ia!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.$Qb[DRIVER].'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$P=$b->serverName(SERVER);$P=($P!=""?$P:'Server');if($Ia===false)echo"$P\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$P</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ia)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Ia)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Ia
as$y=>$X){$Ib=(is_array($X)?$X[1]:h($X));if($Ib!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Ib</a> » ";}}echo"$wh\n";}}echo"<h2>$yh</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$tb){$id=array();foreach($tb
as$y=>$X)$id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$id));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Ie;if(!$Ie)$Ie=base64_encode(rand_string());return$Ie;}function
page_messages($m){global$b;$Wh=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$ve=$_SESSION["messages"][$Wh];if($ve){echo"<div class='message'>".implode("</div>\n<div class='message'>",$ve)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Wh]);}if($m)echo"<div class='error'>$m</div>\n";if($b->error)echo"<div class='error'>$b->error</div>\n";}function
page_footer($xe=""){global$b;echo"</div>\n\n<div id='menu'>\n";$b->navigation($xe);echo"</div>\n\n";if($xe!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="Logout" id="logout">
',input_token(),'</p>
</form>
';echo
script("setupSubmitHighlight(document);");}function
int32($Ae){while($Ae>=2147483648)$Ae-=4294967296;while($Ae<=-2147483649)$Ae+=4294967296;return(int)$Ae;}function
long2str($W,$li){$N='';foreach($W
as$X)$N.=pack('V',$X);if($li)return
substr($N,0,end($W));return$N;}function
str2long($N,$li){$W=array_values(unpack('V*',str_pad($N,4*ceil(strlen($N)/4),"\0")));if($li)$W[]=strlen($N);return$W;}function
xxtea_mx($si,$ri,$ch,$Md){return
int32((($si>>5&0x7FFFFFF)^$ri<<2)+(($ri>>3&0x1FFFFFFF)^$si<<4))^int32(($ch^$ri)+($Md^$si));}function
encrypt_string($Wg,$y){if($Wg=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Wg,true);$Ae=count($W)-1;$si=$W[$Ae];$ri=$W[0];$H=floor(6+52/($Ae+1));$ch=0;while($H-->0){$ch=int32($ch+0x9E3779B9);$Wb=$ch>>2&3;for($pf=0;$pf<$Ae;$pf++){$ri=$W[$pf+1];$_e=xxtea_mx($si,$ri,$ch,$y[$pf&3^$Wb]);$si=int32($W[$pf]+$_e);$W[$pf]=$si;}$ri=$W[0];$_e=xxtea_mx($si,$ri,$ch,$y[$pf&3^$Wb]);$si=int32($W[$Ae]+$_e);$W[$Ae]=$si;}return
long2str($W,false);}function
decrypt_string($Wg,$y){if($Wg=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Wg,false);$Ae=count($W)-1;$si=$W[$Ae];$ri=$W[0];$H=floor(6+52/($Ae+1));$ch=int32($H*0x9E3779B9);while($ch){$Wb=$ch>>2&3;for($pf=$Ae;$pf>0;$pf--){$si=$W[$pf-1];$_e=xxtea_mx($si,$ri,$ch,$y[$pf&3^$Wb]);$ri=int32($W[$pf]-$_e);$W[$pf]=$ri;}$si=$W[$Ae];$_e=xxtea_mx($si,$ri,$ch,$y[$pf&3^$Wb]);$ri=int32($W[0]-$_e);$W[0]=$ri;$ch=int32($ch-0x9E3779B9);}return
long2str($W,true);}$f='';$hd=$_SESSION["token"];if(!$hd)$_SESSION["token"]=rand(1,1e6);$Bh=get_token();$Af=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Af[$y]=$X;}}function
add_invalid_login(){global$b;$Ba=get_temp_dir()."/adminer.invalid";foreach(glob("$Ba*")?:array($Ba)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ba-".rand_string());if(!$r)return;$Ed=unserialize(stream_get_contents($r));$th=time();if($Ed){foreach($Ed
as$Fd=>$X){if($X[0]<$th)unset($Ed[$Fd]);}}$Dd=&$Ed[$b->bruteForceKey()];if(!$Dd)$Dd=array($th+30*60,0);$Dd[1]++;file_write_unlock($r,serialize($Ed));}function
check_invalid_login(){global$b;$Ed=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$Ed=unserialize(stream_get_contents($r));file_unlock($r);break;}}$Dd=($Ed?$Ed[$b->bruteForceKey()]:array());$He=($Dd[1]>29?$Dd[0]-time():0);if($He>0)auth_error(lang(array('Too many unsuccessful logins, try again in %d minute.','Too many unsuccessful logins, try again in %d minutes.'),ceil($He/60)));}$va=$_POST["auth"];if($va){session_regenerate_id();$gi=$va["driver"];$P=$va["server"];$V=$va["username"];$G=(string)$va["password"];$j=$va["db"];set_password($gi,$P,$V,$G);$_SESSION["db"][$gi][$P][$V][$j]=true;if($va["permanent"]){$y=implode("-",array_map('base64_encode',array($gi,$P,$V,$j)));$Of=$b->permanentLogin(true);$Af[$y]="$y:".base64_encode($Of?encrypt_string($G,$Of):"");cookie("adminer_permanent",implode(" ",$Af));}if(count($_POST)==1||DRIVER!=$gi||SERVER!=$P||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($gi,$P,$V,$j));}elseif($_POST["logout"]&&(!$hd||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),'Logout successful.'.' '.'Thanks for using Adminer, consider <a href="https://www.adminer.org/en/donation/">donating</a>.');}elseif($Af&&!$_SESSION["pwds"]){session_regenerate_id();$Of=$b->permanentLogin();foreach($Af
as$y=>$X){list(,$Ua)=explode(":",$X);list($gi,$P,$V,$j)=array_map('base64_decode',explode("-",$y));set_password($gi,$P,$V,decrypt_string(base64_decode($Ua),$Of));$_SESSION["db"][$gi][$P][$V][$j]=true;}}function
unset_permanent(){global$Af;foreach($Af
as$y=>$X){list($gi,$P,$V,$j)=array_map('base64_decode',explode("-",$y));if($gi==DRIVER&&$P==SERVER&&$V==$_GET["username"]&&$j==DB)unset($Af[$y]);}cookie("adminer_permanent",implode(" ",$Af));}function
auth_error($m){global$b,$hd;$Cg=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Cg]||$_GET[$Cg])&&!$hd)$m='Session expired, please login again.';else{restart_session();add_invalid_login();$G=get_password();if($G!==null){if($G===false)$m.=($m?'<br>':'').sprintf('Master password expired. <a href="https://www.adminer.org/en/extension/"%s>Implement</a> %s method to make it permanent.',target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$Cg]&&$_GET[$Cg]&&ini_bool("session.use_only_cookies"))$m='Session support must be enabled.';$F=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$F["lifetime"]);page_header('Login',$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".'The action will be performed after successful login with the same credentials.'."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header('No extension',sprintf('None of the supported PHP extensions (%s) are available.',implode(", ",Driver::$If)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($nd,$Ef)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Ef,$B)&&($B[1]<1024||$B[1]>65535))auth_error('Connecting to privileged ports is not allowed.');check_invalid_login();$f=connect($b->credentials());if(is_object($f)){$l=new
Driver($f);if($b->operators===null)$b->operators=$l->operators;if(Driver::$Ld=='sql'||$f->flavor=='cockroach')save_settings(array("vendor-".DRIVER."-".SERVER=>$Qb[DRIVER]));}}$de=null;if(!is_object($f)||($de=$b->login($_GET["username"],get_password()))!==true){$m=(is_string($f)?nl_br(h($f)):(is_string($de)?$de:'Invalid credentials.'));auth_error($m.(preg_match('~^ | $~',get_password())?'<br>'.'There is a space in the input password which might be the cause.':''));}if($_POST["logout"]&&$hd&&!verify_token()){page_header('Logout','Invalid CSRF token. Send the form again.');page_footer("db");exit;}if($va&&$_POST["token"])$_POST["token"]=$Bh;$m='';if($_POST){if(!verify_token()){$zd="max_input_vars";$oe=ini_get($zd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$oe||$X<$oe)){$zd=$y;$oe=$X;}}}$m=(!$_POST["token"]&&$oe?sprintf('Maximum number of allowed fields exceeded. Please increase %s.',"'$zd'"):'Invalid CSRF token. Send the form again.'.' '.'If you did not send this request from Adminer then close this page.');}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=sprintf('Too big POST data. Reduce the data or increase the %s configuration directive.',"'post_max_size'");if(isset($_GET["sql"]))$m.=' '.'You can upload a big SQL file via FTP and import it from server.';}function
select($J,$g=null,$gf=array(),$z=0){$ce=array();$x=array();$e=array();$Ga=array();$Nh=array();$K=array();for($u=0;(!$z||$u<$z)&&($L=$J->fetch_row());$u++){if(!$u){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($Kd=0;$Kd<count($L);$Kd++){$n=$J->fetch_field();$D=$n->name;$ff=(isset($n->orgtable)?$n->orgtable:"");$ef=(isset($n->orgname)?$n->orgname:$D);if($gf&&JUSH=="sql")$ce[$Kd]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($ff!=""){if(isset($n->table))$K[$n->table]=$ff;if(!isset($x[$ff])){$x[$ff]=array();foreach(indexes($ff,$g)as$w){if($w["type"]=="PRIMARY"){$x[$ff]=array_flip($w["columns"]);break;}}$e[$ff]=$x[$ff];}if(isset($e[$ff][$ef])){unset($e[$ff][$ef]);$x[$ff][$ef]=$Kd;$ce[$Kd]=$ff;}}if($n->charsetnr==63)$Ga[$Kd]=true;$Nh[$Kd]=$n->type;echo"<th".($ff!=""||$n->name!=$ef?" title='".h(($ff!=""?"$ff.":"").$ef)."'":"").">".h($D).($gf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($L
as$y=>$X){$_="";if(isset($ce[$y])&&!$e[$ce[$y]]){if($gf&&JUSH=="sql"){$R=$L[array_search("table=",$ce)];$_=ME.$ce[$y].urlencode($gf[$R]!=""?$gf[$R]:$R);}else{$_=ME."edit=".urlencode($ce[$y]);foreach($x[$ce[$y]]as$Ya=>$Kd)$_.="&where".urlencode("[".bracket_escape($Ya)."]")."=".urlencode($L[$Kd]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ga[$y]&&!is_utf8($X))$X="<i>".lang(array('%d byte','%d bytes'),strlen($X))."</i>";else{$X=h($X);if($Nh[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($Nh[$y]<=9||$Nh[$y]==246?" class='number'":"").">$X";}}echo($u?"</table>\n</div>":"<p class='message'>".'No rows.')."\n";return$K;}function
referencable_primary($yg){$K=array();foreach(table_status('',true)as$gh=>$R){if($gh!=$yg&&fk_support($R)){foreach(fields($gh)as$n){if($n["primary"]){if($K[$gh]){unset($K[$gh]);break;}$K[$gh]=$n;}}}}return$K;}function
textarea($D,$Y,$M=10,$cb=80){echo"<textarea name='".h($D)."' rows='$M' cols='$cb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($ua,$af,$Y="",$Ve="",$Bf=""){$mh=($af?"select":"input");return"<$mh$ua".($af?"><option value=''>$Bf".optionlist($af,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Bf'>").($Ve?script("qsl('$mh').onchange = $Ve;",""):"");}function
json_row($y,$X=null){static$Gc=true;if($Gc)echo"{";if($y!=""){echo($Gc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Gc=false;}else{echo"\n}\n";$Gc=true;}}function
edit_type($y,$n,$bb,$Nc=array(),$zc=array()){global$l;$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,$l->types())&&!isset($Nc[$U])&&!in_array($U,$zc))$zc[]=$U;$Yg=$l->structuredTypes();if($Nc)$Yg['Foreign keys']=$Nc;echo
optionlist(array_merge($zc,$Yg),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($bb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".'collation'.")'>":''),($l->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($l->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".'ON UPDATE'.")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($Nc?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".'ON DELETE'.")".optionlist(explode("|",$l->onActions),$n["on_delete"])."</select> ":" ");}function
get_partitions_info($R){global$f;$Rc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$J=$f->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $Rc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$K=array();list($K["partition_by"],$K["partition"],$K["partitions"])=$J->fetch_row();$wf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Rc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$K["partition_names"]=array_keys($wf);$K["partition_values"]=array_values($wf);return$K;}function
process_length($Zd){global$l;$jc=$l->enumLength;return(preg_match("~^\\s*\\(?\\s*$jc(?:\\s*,\\s*$jc)*+\\s*\\)?\\s*\$~",$Zd)&&preg_match_all("~$jc~",$Zd,$ie)?"(".implode(",",$ie[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Zd)));}function
process_type($n,$Za="COLLATE"){global$l;return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],$l->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $Za ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field($n,$Lh){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($Lh),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value($n){global$l;$k=$n["default"];$Uc=$n["generated"];return($k===null?"":(in_array($Uc,$l->generated)?(JUSH=="mssql"?" AS ($k)".($Uc=="VIRTUAL"?"":" $Uc")."":" GENERATED ALWAYS AS ($k) $Uc"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$k)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$k))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($k).")":q($k)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($k)":$k)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields($o,$bb,$U="TABLE",$Nc=array()){global$l;$o=array_values($o);$Eb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$gb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?'Column name':'Parameter name'),"<td id='label-type'>".'Type'."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".'Length',"<td>".'Options';if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".'Auto Increment'."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),"<td id='label-default'$Eb>".'Default value',(support("comment")?"<td id='label-comment'$gb>".'Comment':"");echo"<td><input type='image' class='icon' name='add[".(support("move_col")?0:count($o))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".'Add next'."'>".script("row_count = ".count($o).";"),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$u=>$n){$u++;$hf=$n[($_POST?"orig":"field")];$Nb=(isset($_POST["add"][$u-1])||(isset($n["field"])&&!$_POST["drop_col"][$u]))&&(support("drop_col")||$hf=="");echo"<tr".($Nb?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$u][inout]",explode("|",$l->inout),$n["inout"]):"")."<th>";if($Nb)echo"<input name='fields[$u][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$u][orig]",$hf);edit_type("fields[$u]",$n,$bb,$Nc);if($U=="TABLE")echo"<td>".checkbox("fields[$u][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$u'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Eb>".($l->generated?html_select("fields[$u][generated]",array_merge(array("","DEFAULT"),$l->generated),$n["generated"])." ":checkbox("fields[$u][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$u][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$gb><input name='fields[$u][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".'Add next'."'> "."<input type='image' class='icon' name='up[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=5.1.0")."' alt='↑' title='".'Move up'."'> "."<input type='image' class='icon' name='down[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=5.1.0")."' alt='↓' title='".'Move down'."'> ":""),($hf==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=5.1.0")."' alt='x' title='".'Remove'."'>":"");}}function
process_fields(&$o){$Ne=0;if($_POST["up"]){$Td=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Td,0,array($n));break;}if(isset($n["field"]))$Td=$Ne;$Ne++;}}elseif($_POST["down"]){$Pc=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$Pc){unset($o[key($_POST["down"])]);array_splice($o,$Ne,0,array($Pc));break;}if(key($_POST["down"])==$y)$Pc=$n;$Ne++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($B){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($B[0][0].$B[0][0],$B[0][0],substr($B[0],1,-1))),'\\'))."'";}function
grant($Wc,$Qf,$e,$Te){if(!$Qf)return
true;if($Qf==array("ALL PRIVILEGES","GRANT OPTION"))return($Wc=="GRANT"?queries("$Wc ALL PRIVILEGES$Te WITH GRANT OPTION"):queries("$Wc ALL PRIVILEGES$Te")&&queries("$Wc GRANT OPTION$Te"));return
queries("$Wc ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$Qf).$e).$Te);}function
drop_create($Rb,$h,$Sb,$qh,$Tb,$A,$ue,$se,$te,$Qe,$Ee){if($_POST["drop"])query_redirect($Rb,$A,$ue);elseif($Qe=="")query_redirect($h,$A,$te);elseif($Qe!=$Ee){$rb=queries($h);queries_redirect($A,$se,$rb&&queries($Rb));if($rb)queries($Sb);}else
queries_redirect($A,$se,queries($qh)&&queries($Tb)&&queries($Rb)&&queries($h));}function
create_trigger($Te,$L){$vh=" $L[Timing] $L[Event]".(preg_match('~ OF~',$L["Event"])?" $L[Of]":"");return"CREATE TRIGGER ".idf_escape($L["Trigger"]).(JUSH=="mssql"?$Te.$vh:$vh.$Te).rtrim(" $L[Type]\n$L[Statement]",";").";";}function
create_routine($og,$L){global$l;$Q=array();$o=(array)$L["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$Q[]=(preg_match("~^($l->inout)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Fb=rtrim($L["definition"],";");return"CREATE $og ".idf_escape(trim($L["name"]))." (".implode(", ",$Q).")".($og=="FUNCTION"?" RETURNS".process_type($L["returns"],"CHARACTER SET"):"").($L["language"]?" LANGUAGE $L[language]":"").(JUSH=="pgsql"?" AS ".q($Fb):"\n$Fb;");}function
remove_definer($I){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$I);}function
format_foreign_key($q){global$l;$j=$q["db"];$Je=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($Je!=""&&$Je!=$_GET["ns"]?idf_escape($Je).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^($l->onActions)\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^($l->onActions)\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$_h){$K=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($_h->size),decoct(time()));$Ta=8*32;for($u=0;$u<strlen($K);$u++)$Ta+=ord($K[$u]);$K.=sprintf("%06o",$Ta)."\0 ";echo$K,str_repeat("\0",512-strlen($K));$_h->send();echo
str_repeat("\0",511-($_h->size+511)%512);}function
ini_bytes($zd){$X=ini_get($zd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link($yf,$rh="<sup>?</sup>"){global$f;$Ag=$f->server_info;$hi=preg_replace('~^(\d\.?\d).*~s','\1',$Ag);$Yh=array('sql'=>"https://dev.mysql.com/doc/refman/$hi/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".($f->flavor=='cockroach'?"current":$hi)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Ag)."&id=",);if($f->flavor=='maria'){$Yh['sql']="https://mariadb.com/kb/en/";$yf['sql']=(isset($yf['mariadb'])?$yf['mariadb']:str_replace(".html","/",$yf['sql']));}return($yf[JUSH]?"<a href='".h($Yh[JUSH].$yf[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$hi":""))."'".target_blank().">$rh</a>":"");}function
db_size($j){global$f;if(!$f->select_db($j))return"?";$K=0;foreach(table_status()as$S)$K+=$S["Data_length"]+$S["Index_length"];return
format_number($K);}function
set_utf8mb4($h){global$f;static$Q=false;if(!$Q&&preg_match('~\butf8mb4~i',$h)){$Q=true;echo"SET NAMES ".charset($f).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$f->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header('Database'.": ".h(DB),'Invalid database.',true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),'Databases have been dropped.',drop_databases($_POST["db"]));page_header('Select database',$m,false);echo"<p class='links'>\n";foreach(array('database'=>'Create database','privileges'=>'Privileges','processlist'=>'Process list','variables'=>'Variables','status'=>'Status',)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".sprintf('%s version: %s through PHP extension %s',$Qb[DRIVER],"<b>".h($f->server_info)."</b>","<b>$f->extension</b>")."\n","<p>".sprintf('Logged as: %s',"<b>".h(logged_user())."</b>")."\n";if(isset($b->plugins)&&is_array($b->plugins)){echo"<p>".'Loaded plugins'.":\n<ul>\n";foreach($b->plugins
as$Cf){$eg=new
\ReflectionObject($Cf);echo"<li><b>".get_class($Cf)."</b>".h(preg_match('~^/[\s*]+(.+)~',$eg->getDocComment(),$B)?": $B[1]":"")."\n";}echo"</ul>\n";}$i=$b->databases();if($i){$tg=support("scheme");$bb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".'Database'.(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".'Refresh'."</a>":"")."<td>".'Collation'."<td>".'Tables'."<td>".'Size'." - <a href='".h(ME)."dbsize=1'>".'Compute'."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$T){$ng=h(ME)."db=".urlencode($j);$v=h("Db-".$j);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$v):""),"<th><a href='$ng' id='$v'>".h($j)."</a>";$ab=h(db_collation($j,$bb));echo"<td>".(support("database")?"<a href='$ng".($tg?"&amp;ns=":"")."&amp;database=' title='".'Alter database'."'>$ab</a>":$ab),"<td align='right'><a href='$ng&amp;schema=' id='tables-".h($j)."' title='".'Database schema'."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".'Selected'." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".'Drop'."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}}page_footer("db");exit;}class
TmpFile{private$handler,$size;function
__construct(){$this->handler=tmpfile();}function
write($mb){$this->size+=strlen($mb);fwrite($this->handler,$mb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$O=array(idf_escape($_GET["field"]));$J=$l->select($a,$O,array(where($_GET,$o)),$O);$L=($J?$J->fetch_row():array());echo$l->value($L[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error();$S=table_status1($a);$D=$b->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?'Materialized view':'View':'Table').": ".($D!=""?$D:h($a)),$m);$mg=array();foreach($o
as$y=>$n)$mg+=$n["privileges"];$b->selectLinks($S,(isset($mg["insert"])||!support("table")?"":null));$fb=$S["Comment"];if($fb!="")echo"<p class='nowrap'>".'Comment'.": ".h($fb)."\n";if($o)$b->tableStructurePrint($o,$S);if(support("indexes")&&$l->supportsIndex($S)){echo"<h3 id='indexes'>".'Indexes'."</h3>\n";$x=indexes($a);if($x)$b->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.'Alter indexes'."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".'Foreign keys'."</h3>\n";$Nc=foreign_keys($a);if($Nc){echo"<table>\n","<thead><tr><th>".'Source'."<td>".'Target'."<td>".'ON DELETE'."<td>".'ON UPDATE'."<td></thead>\n";foreach($Nc
as$D=>$q){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.'Alter'.'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.'Add foreign key'."</a>\n";}if(support("check")){echo"<h3 id='checks'>".'Checks'."</h3>\n";$Qa=$l->checkConstraints($a);if($Qa){echo"<table>\n";foreach($Qa
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".'Alter'."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.'Create check'."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".'Triggers'."</h3>\n";$Kh=triggers($a);if($Kh){echo"<table>\n";foreach($Kh
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".'Alter'."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.'Add trigger'."</a>\n";}}elseif(isset($_GET["schema"])){page_header('Database schema',"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$hh=array();$ih=array();$ea=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$ie,PREG_SET_ORDER);foreach($ie
as$u=>$B){$hh[$B[1]]=array($B[2],$B[3]);$ih[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$Ch=0;$Ca=-1;$sg=array();$dg=array();$Xd=array();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Ff=0;$sg[$R]["fields"]=array();foreach(fields($R)as$D=>$n){$Ff+=1.25;$n["pos"]=$Ff;$sg[$R]["fields"][$D]=$n;}$sg[$R]["pos"]=($hh[$R]?:array($Ch,0));foreach($b->foreignKeys($R)as$X){if(!$X["db"]){$Vd=$Ca;if($hh[$R][1]||$hh[$X["table"]][1])$Vd=min(floatval($hh[$R][1]),floatval($hh[$X["table"]][1]))-1;else$Ca-=.1;while($Xd[(string)$Vd])$Vd-=.0001;$sg[$R]["references"][$X["table"]][(string)$Vd]=array($X["source"],$X["target"]);$dg[$X["table"]][$R][(string)$Vd]=$X["target"];$Xd[(string)$Vd]=true;}}$Ch=max($Ch,$sg[$R]["pos"][0]+2.5+$Ff);}echo'<div id="schema" style="height: ',$Ch,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$ih)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$Ch,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($sg
as$D=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["full_type"].($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$oh=>$fg){foreach($fg
as$Vd=>$ag){$Wd=$Vd-$hh[$D][1];$u=0;foreach($ag[0]as$Lg)echo"\n<div class='references' title='".h($oh)."' id='refs$Vd-".($u++)."' style='left: $Wd"."em; top: ".$R["fields"][$Lg]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Wd)."em;'></div></div>";}}foreach((array)$dg[$D]as$oh=>$fg){foreach($fg
as$Vd=>$e){$Wd=$Vd-$hh[$D][1];$u=0;foreach($e
as$nh)echo"\n<div class='references' title='".h($oh)."' id='refd$Vd-".($u++)."'"." style='left: $Wd"."em; top: ".$R["fields"][$nh]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=5.1.0")."'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Wd)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($sg
as$D=>$R){foreach((array)$R["references"]as$oh=>$fg){foreach($fg
as$Vd=>$ag){$we=$Ch;$me=-10;foreach($ag[0]as$y=>$Lg){$Gf=$R["pos"][0]+$R["fields"][$Lg]["pos"];$Hf=$sg[$oh]["pos"][0]+$sg[$oh]["fields"][$ag[1][$y]]["pos"];$we=min($we,$Gf,$Hf);$me=max($me,$Gf,$Hf);}echo"<div class='references' id='refl$Vd' style='left: $Vd"."em; top: $we"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($me-$we)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">Permanent link</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$wc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$Hd=preg_match('~sql~',$_POST["format"]);if($Hd){echo"-- Adminer $ga ".$Qb[DRIVER]." ".str_replace("\n"," ",$f->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$f->query("SET time_zone = '+00:00'");$f->query("SET sql_mode = ''");}}$Zg=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){$b->dumpDatabase($j);if($f->select_db($j)){if($Hd&&preg_match('~CREATE~',$Zg)&&($h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1))){set_utf8mb4($h);if($Zg=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($j).";\n";echo"$h;\n";}if($Hd){if($Zg)echo
use_sql($j).";\n\n";$nf="";if($_POST["types"]){foreach(types()as$v=>$U){$kc=type_values($v);if($kc)$nf.=($Zg!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($kc);\n\n";else$nf.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$L){$D=$L["ROUTINE_NAME"];$og=$L["ROUTINE_TYPE"];$h=create_routine($og,array("name"=>$D)+routine($L["SPECIFIC_NAME"],$og));set_utf8mb4($h);$nf.=($Zg!='DROP+CREATE'?"DROP $og IF EXISTS ".idf_escape($D).";;\n":"")."$h;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$L){$h=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($L["Name"]),3));set_utf8mb4($h);$nf.=($Zg!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}echo($nf&&JUSH=='sql'?"DELIMITER ;;\n\n$nf"."DELIMITER ;\n\n":$nf);}if($_POST["table_style"]||$_POST["data_style"]){$ji=array();foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));$yb=(DB==""||in_array($D,(array)$_POST["data"]));if($R||$yb){if($wc=="tar"){$_h=new
TmpFile;ob_start(array($_h,'write'),1e5);}$b->dumpTable($D,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$ji[]=$D;elseif($yb){$o=fields($D);$b->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($D));}if($Hd&&$_POST["triggers"]&&$R&&($Kh=trigger_sql($D)))echo"\nDELIMITER ;;\n$Kh\nDELIMITER ;\n";if($wc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$D.csv",$_h);}elseif($Hd)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($D);}}foreach($ji
as$ii)$b->dumpTable($ii,$_POST["table_style"],1);if($wc=="tar")echo
pack("x512");}}}$b->dumpFooter();exit;}page_header('Export',$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Bb=array('','USE','DROP+CREATE','CREATE');$jh=array('','DROP+CREATE','CREATE');$zb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$zb[]='INSERT+UPDATE';$L=get_settings("adminer_export");if(!$L)$L=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($L["events"])){$L["routines"]=$L["events"]=($_GET["dump"]=="");$L["triggers"]=$L["table_style"];}echo"<tr><th>".'Output'."<td>".html_radios("output",$b->dumpOutput(),$L["output"])."\n","<tr><th>".'Format'."<td>".html_radios("format",$b->dumpFormat(),$L["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".'Database'."<td>".html_select('db_style',$Bb,$L["db_style"]).(support("type")?checkbox("types",1,$L["types"],'User types'):"").(support("routine")?checkbox("routines",1,$L["routines"],'Routines'):"").(support("event")?checkbox("events",1,$L["events"],'Events'):"")),"<tr><th>".'Tables'."<td>".html_select('table_style',$jh,$L["table_style"]).checkbox("auto_increment",1,$L["auto_increment"],'Auto Increment').(support("trigger")?checkbox("triggers",1,$L["triggers"],'Triggers'):""),"<tr><th>".'Data'."<td>".html_select('data_style',$zb,$L["data_style"]),'</table>
<p><input type="submit" value="Export">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Lf=array();if(DB!=""){$Ra=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Ra>".'Tables'."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".'Data'."<input type='checkbox' id='check-data'$Ra></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$ji="";$kh=tables_list();foreach($kh
as$D=>$U){$Kf=preg_replace('~_.*~','',$D);$Ra=($a==""||$a==(substr($a,-1)=="%"?"$Kf%":$D));$Nf="<tr><td>".checkbox("tables[]",$D,$Ra,$D,"","block");if($U!==null&&!preg_match('~table~i',$U))$ji.="$Nf\n";else
echo"$Nf<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$Ra)."</label>\n";$Lf[$Kf]++;}echo$ji;if($kh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".'Database'."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=$b->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$Kf=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$Kf%",$j,"","block")."\n";$Lf[$Kf]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Gc=true;foreach($Lf
as$y=>$X){if($y!=""&&$X>1){echo($Gc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Gc=false;}}}elseif(isset($_GET["privileges"])){page_header('Privileges');echo'<p class="links"><a href="'.h(ME).'user=">'.'Create user'."</a>";$J=$f->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$Wc=$J;if(!$J)$J=$f->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($Wc?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".'Username'."<th>".'Server'."<th></thead>\n";while($L=$J->fetch_assoc())echo'<tr><td>'.h($L["User"])."<td>".h($L["Host"]).'<td><a href="'.h(ME.'user='.urlencode($L["User"]).'&host='.urlencode($L["Host"])).'">'.'Edit'."</a>\n";if(!$Wc||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".'Edit'."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);$b->dumpFooter();exit;}restart_session();$md=&get_session("queries");$ld=&$md[DB];if(!$m&&$_POST["clear"]){$ld=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?'Import':'SQL command'),$m);if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$I=$_POST["query"];elseif($_POST["webfile"]){$Pg=$b->importServerPath();$r=@fopen((file_exists($Pg)?$Pg:"compress.zlib://$Pg.gz"),"rb");$I=($r?fread($r,1e6):false);}else$I=get_file("sql_file",true,";");if(is_string($I)){if(function_exists('memory_get_usage')&&($re=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($re,2*strlen($I)+memory_get_usage()+8e6));if($I!=""&&strlen($I)<1e6){$H=$I.(preg_match("~;[ \t\r\n]*\$~",$I)?"":";");if(!$ld||first(end($ld))!=$H){restart_session();$ld[]=array($H,time());set_session("queries",$md);stop_session();}}$Mg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Hb=";";$Ne=0;$ec=true;$g=connect($b->credentials());if(is_object($g)&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$eb=0;$mc=array();$sf='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|-- |$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Dh=microtime(true);$ja=get_settings("adminer_import");$Vb=$b->dumpFormat();unset($Vb["sql"]);while($I!=""){if(!$Ne&&preg_match("~^$Mg*+DELIMITER\\s+(\\S+)~i",$I,$B)){$Hb=$B[1];$I=substr($I,strlen($B[0]));}else{preg_match('('.preg_quote($Hb)."\\s*|$sf)",$I,$B,PREG_OFFSET_CAPTURE,$Ne);list($Pc,$Ff)=$B[0];if(!$Pc&&$r&&!feof($r))$I.=fread($r,1e5);else{if(!$Pc&&rtrim($I)=="")break;$Ne=$Ff+strlen($Pc);if($Pc&&rtrim($Pc)!=$Hb){$La=$l->hasCStyleEscapes()||(JUSH=="pgsql"&&($Ff>0&&strtolower($I[$Ff-1])=="e"));$zf=($Pc=='/*'?'\*/':($Pc=='['?']':(preg_match('~^-- |^#~',$Pc)?"\n":preg_quote($Pc).($La?"|\\\\.":""))));while(preg_match("($zf|\$)s",$I,$B,PREG_OFFSET_CAPTURE,$Ne)){$N=$B[0][0];if(!$N&&$r&&!feof($r))$I.=fread($r,1e5);else{$Ne=$B[0][1]+strlen($N);if(!$N||$N[0]!="\\")break;}}}else{$ec=false;$H=substr($I,0,$Ff);$eb++;$Nf="<pre id='sql-$eb'><code class='jush-".JUSH."'>".$b->sqlCommandQuery($H)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$Mg*+ATTACH\\b~i",$H,$B)){echo$Nf,"<p class='error'>".'ATTACH queries are not supported.'."\n";$mc[]=" <a href='#sql-$eb'>$eb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Nf;ob_flush();flush();}$Tg=microtime(true);if($f->multi_query($H)&&is_object($g)&&preg_match("~^$Mg*+USE\\b~i",$H))$g->query($H);do{$J=$f->store_result();if($f->error){echo($_POST["only_errors"]?$Nf:""),"<p class='error'>".'Error in query'.($f->errno?" ($f->errno)":"").": ".error()."\n";$mc[]=" <a href='#sql-$eb'>$eb</a>";if($_POST["error_stops"])break
2;}else{$th=" <span class='time'>(".format_time($Tg).")</span>".(strlen($H)<1000?" <a href='".h(ME)."sql=".urlencode(trim($H))."'>".'Edit'."</a>":"");$la=$f->affected_rows;$mi=($_POST["only_errors"]?"":$l->warnings());$ni="warnings-$eb";if($mi)$th.=", <a href='#$ni'>".'Warnings'."</a>".script("qsl('a').onclick = partial(toggle, '$ni');","");$uc=null;$vc="explain-$eb";if(is_object($J)){$z=$_POST["limit"];$gf=select($J,$g,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$Ke=$J->num_rows;echo"<p class='sql-footer'>".($Ke?($z&&$Ke>$z?sprintf('%d / ',$z):"").lang(array('%d row','%d rows'),$Ke):""),$th;if($g&&preg_match("~^($Mg|\\()*+SELECT\\b~i",$H)&&($uc=explain($g,$H)))echo", <a href='#$vc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$vc');","");$v="export-$eb";echo", <a href='#$v'>".'Export'."</a>".script("qsl('a').onclick = partial(toggle, '$v');","")."<span id='$v' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ja["output"])." ".html_select("format",$Vb,$ja["format"]).input_hidden("query",$H)."<input type='submit' name='export' value='".'Export'."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$Mg*+(CREATE|DROP|ALTER)$Mg++(DATABASE|SCHEMA)\\b~i",$H)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(isset($f->info)?$f->info:"")."'>".lang(array('Query executed OK, %d row affected.','Query executed OK, %d rows affected.'),$la)."$th\n";}echo($mi?"<div id='$ni' class='hidden'>\n$mi</div>\n":"");if($uc){echo"<div id='$vc' class='hidden explain'>\n";select($uc,$g,$gf);echo"</div>\n";}}$Tg=microtime(true);}while($f->next_result());}$I=substr($I,$Ne);$Ne=0;}}}}if($ec)echo"<p class='message'>".'No commands to execute.'."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(array('%d query executed OK.','%d queries executed OK.'),$eb-count($mc))," <span class='time'>(".format_time($Dh).")</span>\n";elseif($mc&&$eb>1)echo"<p class='error'>".'Error in query'.": ".implode("",$mc)."\n";}else
echo"<p class='error'>".upload_error($I)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$sc="<input type='submit' value='".'Execute'."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$H=$_GET["sql"];if($_POST)$H=$_POST["query"];elseif($_GET["history"]=="all")$H=$ld;elseif($_GET["history"]!="")$H=$ld[$_GET["history"]][0];echo"<p>";textarea("query",$H,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";$b->sqlPrintAfter();echo"$sc\n",'Limit rows'.": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".'File upload'."</legend><div>";$bd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$bd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$sc":'File uploads are disabled.'),"</div></fieldset>\n";$td=$b->importServerPath();if($td)echo"<fieldset><legend>".'From server'."</legend><div>",sprintf('Webserver file %s',"<code>".h($td)."$bd</code>"),' <input type="submit" name="webfile" value="'.'Run file'.'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),'Stop on error')."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),'Show only errors')."\n",input_token();if(!isset($_GET["import"])&&$ld){print_fieldset("history",'History',$_GET["history"]!="");for($X=end($ld);$X;$X=prev($ld)){$y=key($ld);list($H,$th,$Zb)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.'Edit'."</a>"." <span class='time' title='".@date('Y-m-d',$th)."'>".@date("H:i:s",$th)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$H)))),80,"</code>").($Zb?" <span class='time'>($Zb)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".'Clear'."'>\n","<a href='".h(ME."sql=&history=all")."'>".'Edit all'."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$Vh=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$D=>$n){if(!isset($n["privileges"][$Vh?"update":"insert"])||$b->fieldName($n)==""||$n["generated"])unset($o[$D]);}if($_POST&&!$m&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($Vh?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$x=indexes($a);$Qh=unique_array($_GET["where"],$x);$Wf="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,'Item has been deleted.',$l->delete($a,$Wf,!$Qh));else{$Q=array();foreach($o
as$D=>$n){$X=process_input($n);if($X!==false&&$X!==null)$Q[idf_escape($D)]=$X;}if($Vh){if(!$Q)redirect($A);queries_redirect($A,'Item has been updated.',$l->update($a,$Q,$Wf,!$Qh));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$J=$l->insert($a,$Q);$Ud=($J?last_id($J):0);queries_redirect($A,sprintf('Item%s has been inserted.',($Ud?" $Ud":"")),$J);}}}$L=null;if($_POST["save"])$L=(array)$_POST["fields"];elseif($Z){$O=array();foreach($o
as$D=>$n){if(isset($n["privileges"]["select"])){$sa=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$O[]=($sa?"$sa AS ":"").idf_escape($D);}}$L=array();if(!support("table"))$O=array("*");if($O){$J=$l->select($a,$O,array($Z),$O,array(),(isset($_GET["select"])?2:1));if(!$J)$m=error();else{$L=$J->fetch_assoc();if(!$L)$L=false;}if(isset($_GET["select"])&&(!$L||$J->fetch_assoc()))$L=null;}}if(!support("table")&&!$o){if(!$Z){$J=$l->select($a,array("*"),$Z,array("*"));$L=($J?$J->fetch_assoc():false);if(!$L)$L=array($l->primary=>"");}if($L){foreach($L
as$y=>$X){if(!$Z)$L[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=$l->primary),"auto_increment"=>($y==$l->primary));}}}edit_form($a,$o,$L,$Vh);}elseif(isset($_GET["create"])){$a=$_GET["create"];$tf=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$tf[$y]=$y;$cg=referencable_primary($a);$Nc=array();foreach($cg
as$gh=>$n)$Nc[str_replace("`","``",$gh)."`".str_replace("`","``",$n["field"])]=$gh;$jf=array();$S=array();if($a!=""){$jf=fields($a);$S=table_status($a);if(!$S)$m='No tables.';}$L=$_POST;$L["fields"]=(array)$L["fields"];if($L["auto_increment_col"])$L["fields"][$L["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($L["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),'Table has been dropped.',drop_tables(array($a)));else{$o=array();$pa=array();$Zh=false;$Lc=array();$if=reset($jf);$na=" FIRST";foreach($L["fields"]as$y=>$n){$q=$Nc[$n["type"]];$Lh=($q!==null?$cg[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$Sf=process_field($n,$Lh);$pa[]=array($n["orig"],$Sf,$na);if(!$if||$Sf!==process_field($if,$if)){$o[]=array($n["orig"],$Sf,$na);if($n["orig"]!=""||$na)$Zh=true;}if($q!==null)$Lc[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Nc[$n["type"]],'source'=>array($n["field"]),'target'=>array($Lh["field"]),'on_delete'=>$n["on_delete"],));$na=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Zh=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$if=next($jf);if(!$if)$na="";}}$vf="";if(support("partitioning")){if(isset($tf[$L["partition_by"]])){$F=array();foreach($L
as$y=>$X){if(preg_match('~^partition~',$y))$F[$y]=$X;}foreach($F["partition_names"]as$y=>$D){if($D==""){unset($F["partition_names"][$y]);unset($F["partition_values"][$y]);}}if($F!=get_partitions_info($a)){$wf=array();if($F["partition_by"]=='RANGE'||$F["partition_by"]=='LIST'){foreach($F["partition_names"]as$y=>$D){$Y=$F["partition_values"][$y];$wf[]="\n  PARTITION ".idf_escape($D)." VALUES ".($F["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$vf.="\nPARTITION BY $F[partition_by]($F[partition])";if($wf)$vf.=" (".implode(",",$wf)."\n)";elseif($F["partitions"])$vf.=" PARTITIONS ".(+$F["partitions"]);}}elseif(preg_match("~partitioned~",$S["Create_options"]))$vf.="\nREMOVE PARTITIONING";}$C='Table has been altered.';if($a==""){cookie("adminer_engine",$L["Engine"]);$C='Table has been created.';}$D=trim($L["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$C,alter_table($a,$D,(JUSH=="sqlite"&&($Zh||$Lc)?$pa:$o),$Lc,($L["Comment"]!=$S["Comment"]?$L["Comment"]:null),($L["Engine"]&&$L["Engine"]!=$S["Engine"]?$L["Engine"]:""),($L["Collation"]&&$L["Collation"]!=$S["Collation"]?$L["Collation"]:""),($L["Auto_increment"]!=""?number($L["Auto_increment"]):""),$vf));}}page_header(($a!=""?'Alter table':'Create table'),$m,array("table"=>$a),h($a));if(!$_POST){$Nh=$l->types();$L=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Nh["int"])?"int":(isset($Nh["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$L=$S;$L["name"]=$a;$L["fields"]=array();if(!$_GET["auto_increment"])$L["Auto_increment"]="";foreach($jf
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$L["fields"][]=$n;}if(support("partitioning")){$L+=get_partitions_info($a);$L["partition_names"][]="";$L["partition_values"][]="";}}}$bb=collations();$gc=$l->engines();foreach($gc
as$fc){if(!strcasecmp($fc,$L["Engine"])){$L["Engine"]=$fc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo'Table name'.": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($L["name"])."' autocapitalize='off'>\n",($gc?html_select("Engine",array(""=>"(".'engine'.")")+$gc,$L["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($bb)echo"<datalist id='collations'>".optionlist($bb)."</datalist>",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($L["Collation"])."' placeholder='(".'collation'.")'>");echo"<input type='submit' value='".'Save'."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($L["fields"],$bb,"TABLE",$Nc);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",'Auto Increment'.": <input type='number' name='Auto_increment' class='size' value='".h($L["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),'Default values',"columnShow(this.checked, 5)","jsonly");$hb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$hb,'Comment',"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$L["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($hb?"":" class='hidden'").">".h($L["Comment"])."</textarea>":'<input name="Comment" value="'.h($L["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($hb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="Save">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$a));if(support("partitioning")){$uf=preg_match('~RANGE|LIST~',$L["partition_by"]);print_fieldset("partition",'Partition by',$L["partition_by"]);echo"<p>".html_select("partition_by",array(""=>"")+$tf,$L["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($L["partition"])."'>)\n",'Partitions'.": <input type='number' name='partitions' class='size".($uf||!$L["partition_by"]?" hidden":"")."' value='".h($L["partitions"])."'>\n","<table id='partition-table'".($uf?"":" class='hidden'").">\n","<thead><tr><th>".'Partition name'."<th>".'Values'."</thead>\n";foreach($L["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($L["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($L["partition_values"][$y]).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$xd=array("PRIMARY","UNIQUE","INDEX");$S=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$xd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$xd[]="SPATIAL";$x=indexes($a);$Mf=array();if(JUSH=="mongo"){$Mf=$x["_id_"];unset($xd[0]);unset($x["_id_"]);}$L=$_POST;if($L)save_settings(array("index_options"=>$L["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$qa=array();foreach($L["indexes"]as$w){$D=$w["name"];if(in_array($w["type"],$xd)){$e=array();$ae=array();$Jb=array();$Q=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Zd=$w["lengths"][$y];$Ib=$w["descs"][$y];$Q[]=idf_escape($d).($Zd?"(".(+$Zd).")":"").($Ib?" DESC":"");$e[]=$d;$ae[]=($Zd?:null);$Jb[]=$Ib;}}$tc=$x[$D];if($tc){ksort($tc["columns"]);ksort($tc["lengths"]);ksort($tc["descs"]);if($w["type"]==$tc["type"]&&array_values($tc["columns"])===$e&&(!$tc["lengths"]||array_values($tc["lengths"])===$ae)&&array_values($tc["descs"])===$Jb){unset($x[$D]);continue;}}if($e)$qa[]=array($w["type"],$D,$Q);}}foreach($x
as$D=>$tc)$qa[]=array($tc["type"],$D,"DROP");if(!$qa)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),'Indexes have been altered.',alter_indexes($a,$qa));}page_header('Indexes',$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($L["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$L["indexes"][$y]["columns"][]="";}$w=end($L["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$L["indexes"][]=array("columns"=>array(1=>""));}if(!$L){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$L["indexes"]=$x;}$ae=(JUSH=="sql"||JUSH=="mssql");$Fg=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">Index Type
<th><input type="submit" class="wayoff">','Column'.($ae?"<span class='idxopts".($Fg?"":" hidden")."'> (".'length'.")</span>":"");if($ae||support("descidx"))echo
checkbox("options",1,$Fg,'Options',"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">Name
<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".'Add next'."'>",'</noscript>
</thead>
';if($Mf){echo"<tr><td>PRIMARY<td>";foreach($Mf["columns"]as$y=>$d)echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".'descending'."</label> ";echo"<td><td>\n";}$Kd=1;foreach($L["indexes"]as$w){if(!$_POST["drop_col"]||$Kd!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$Kd][type]",array(-1=>"")+$xd,$w["type"],($Kd==count($L["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"<td>";ksort($w["columns"]);$u=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$Kd][columns][$u]' title='".'Column'."'",($o?array_combine($o,$o):$o),$d,"partial(".($u==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($Fg?"":" hidden")."'>",($ae?"<input type='number' name='indexes[$Kd][lengths][$u]' class='size' value='".h($w["lengths"][$y])."' title='".'Length'."'>":""),(support("descidx")?checkbox("indexes[$Kd][descs][$u]",1,$w["descs"][$y],'descending'):""),"</span> </span>";$u++;}echo"<td><input name='indexes[$Kd][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$Kd]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=5.1.0")."' alt='x' title='".'Remove'."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$Kd++;}echo'</table>
</div>
<p>
<input type="submit" value="Save">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$L=$_POST;if($_POST&&!$m&&!isset($_POST["add_x"])){$D=trim($L["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),'Database has been dropped.',drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),'Database has been renamed.',rename_database($D,$L["collation"]));}else{$i=explode("\n",str_replace("\r","",$D));$ah=true;$Td="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$L["collation"]))$ah=false;$Td=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Td),'Database has been created.',$ah);}}else{if(!$L["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$L["collation"])?" COLLATE $L[collation]":""),substr(ME,0,-1),'Database has been altered.');}}page_header(DB!=""?'Alter database':'Create database',$m,array(),h(DB));$bb=collations();$D=DB;if($_POST)$D=$L["name"];elseif(DB!="")$L["collation"]=db_collation(DB,$bb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$Wc){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$Wc,$B)&&$B[1]){$D=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($D,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" autofocus value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($bb?html_select("collation",array(""=>"(".'collation'.")")+$bb,$L["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),'<input type="submit" value="Save">
';if(DB!="")echo"<input type='submit' name='drop' value='".'Drop'."'>".confirm(sprintf('Drop %s?',DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".'Add next'."'>\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?:$_GET["call"]);page_header('Call'.": ".h($da),$m);$og=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$ud=array();$nf=array();foreach($og["fields"]as$u=>$n){if(substr($n["inout"],-3)=="OUT")$nf[$u]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$ud[]=$u;}if(!$m&&$_POST){$Ma=array();foreach($og["fields"]as$y=>$n){if(in_array($y,$ud)){$X=process_input($n);if($X===false)$X="''";if(isset($nf[$y]))$f->query("SET @".idf_escape($n["field"])." = $X");}$Ma[]=(isset($nf[$y])?"@".idf_escape($n["field"]):$X);}$I=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Ma).")";$Tg=microtime(true);$J=$f->multi_query($I);$la=$f->affected_rows;echo$b->selectQuery($I,$Tg,!$J);if(!$J)echo"<p class='error'>".error()."\n";else{$g=connect($b->credentials());if(is_object($g))$g->select_db(DB);do{$J=$f->store_result();if(is_object($J))select($J,$g);else
echo"<p class='message'>".lang(array('Routine has been called, %d row affected.','Routine has been called, %d rows affected.'),$la)." <span class='time'>".@date("H:i:s")."</span>\n";}while($f->next_result());if($nf)select($f->query("SELECT ".implode(", ",$nf)));}}echo'
<form action="" method="post">
';if($ud){echo"<table class='layout'>\n";foreach($ud
as$y){$n=$og["fields"][$y];$D=$n["field"];echo"<tr><th>".$b->fieldName($n);$Y=$_POST["fields"][$D];if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,(string)$_POST["function"][$D]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="Call">
',input_token(),'</form>

<pre>
';function
pre_tr($N){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($N))));}$R='(\+--[-+]+\+\n)';$L='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$L$R?($L*)$R?~m",function($B){$Hc=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$Hc</thead>\n":$Hc).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($og['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$L=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$L["source"]=array_filter($L["source"],'strlen');ksort($L["source"]);$nh=array();foreach($L["source"]as$y=>$X)$nh[$y]=$L["target"][$y];$L["target"]=$nh;}if(JUSH=="sqlite")$J=recreate_table($a,$a,array(),array(),array(" $D"=>($L["drop"]?"":" ".format_foreign_key($L))));else{$qa="ALTER TABLE ".table($a);$J=($D==""||queries("$qa DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D)));if(!$L["drop"])$J=queries("$qa ADD".format_foreign_key($L));}queries_redirect(ME."table=".urlencode($a),($L["drop"]?'Foreign key has been dropped.':($D!=""?'Foreign key has been altered.':'Foreign key has been created.')),$J);if(!$L["drop"])$m="$m<br>".'Source and target columns must have the same data type, there must be an index on the target columns and referenced data must exist.';}page_header('Foreign key',$m,array("table"=>$a),h($a));if($_POST){ksort($L["source"]);if($_POST["add"])$L["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$L["target"]=array();}elseif($D!=""){$Nc=foreign_keys($a);$L=$Nc[$D];$L["source"][]="";}else{$L["table"]=$a;$L["source"]=array("");}echo'
<form action="" method="post">
';$Lg=array_keys(fields($a));if($L["db"]!="")$f->select_db($L["db"]);if($L["ns"]!=""){$kf=get_schema();set_schema($L["ns"]);}$bg=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$nh=array_keys(fields(in_array($L["table"],$bg)?$L["table"]:reset($bg)));$Ve="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".'Target table'.": ".html_select("table",$bg,$L["table"],$Ve)."\n";if(JUSH!="sqlite"){$Cb=array();foreach($b->databases()as$j){if(!information_schema($j))$Cb[]=$j;}echo'DB'.": ".html_select("db",$Cb,$L["db"]!=""?$L["db"]:$_GET["db"],$Ve);}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="Change"></noscript>
<table>
<thead><tr><th id="label-source">Source<th id="label-target">Target</thead>
';$Kd=0;foreach($L["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$Lg,$X,($Kd==count($L["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$nh,$L["target"][$y],"","label-target");$Kd++;}echo'</table>
<p>
ON DELETE: ',html_select("on_delete",array(-1=>"")+explode("|",$l->onActions),$L["on_delete"]),' ON UPDATE: ',html_select("on_update",array(-1=>"")+explode("|",$l->onActions),$L["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="Save">
<noscript><p><input type="submit" name="add" value="Add column"></noscript>
';if($D!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$D));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$L=$_POST;$lf="VIEW";if(JUSH=="pgsql"&&$a!=""){$Ug=table_status($a);$lf=strtoupper($Ug["Engine"]);}if($_POST&&!$m){$D=trim($L["name"]);$sa=" AS\n$L[select]";$A=ME."table=".urlencode($D);$C='View has been altered.';$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&JUSH!="sqlite"&&$U=="VIEW"&&$lf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$sa,$A,$C);else{$ph=$D."_adminer_".uniqid();drop_create("DROP $lf ".table($a),"CREATE $U ".table($D).$sa,"DROP $U ".table($D),"CREATE $U ".table($ph).$sa,"DROP $U ".table($ph),($_POST["drop"]?substr(ME,0,-1):$A),'View has been dropped.',$C,'View has been created.',$a,$D);}}if(!$_POST&&$a!=""){$L=view($a);$L["name"]=$a;$L["materialized"]=($lf!="VIEW");if(!$m)$m=error();}page_header(($a!=""?'Alter view':'Create view'),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>Name: <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$L["materialized"],'Materialized view'):""),'<p>';textarea("select",$L["select"]);echo'<p>
<input type="submit" value="Save">
';if($a!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Cd=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Vg=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$L=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),'Event has been dropped.');elseif(in_array($L["INTERVAL_FIELD"],$Cd)&&isset($Vg[$L["STATUS"]])){$rg="\nON SCHEDULE ".($L["INTERVAL_VALUE"]?"EVERY ".q($L["INTERVAL_VALUE"])." $L[INTERVAL_FIELD]".($L["STARTS"]?" STARTS ".q($L["STARTS"]):"").($L["ENDS"]?" ENDS ".q($L["ENDS"]):""):"AT ".q($L["STARTS"]))." ON COMPLETION".($L["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?'Event has been altered.':'Event has been created.'),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$rg.($aa!=$L["EVENT_NAME"]?"\nRENAME TO ".idf_escape($L["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($L["EVENT_NAME"]).$rg)."\n".$Vg[$L["STATUS"]]." COMMENT ".q($L["EVENT_COMMENT"]).rtrim(" DO\n$L[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?'Alter event'.": ".h($aa):'Create event'),$m);if(!$L&&$aa!=""){$M=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$L=reset($M);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>Name<td><input name="EVENT_NAME" value="',h($L["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">Start<td><input name="STARTS" value="',h("$L[EXECUTE_AT]$L[STARTS]"),'">
<tr><th title="datetime">End<td><input name="ENDS" value="',h($L["ENDS"]),'">
<tr><th>Every<td><input type="number" name="INTERVAL_VALUE" value="',h($L["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Cd,$L["INTERVAL_FIELD"]),'<tr><th>Status<td>',html_select("STATUS",$Vg,$L["STATUS"]),'<tr><th>Comment<td><input name="EVENT_COMMENT" value="',h($L["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$L["ON_COMPLETION"]=="PRESERVE",'On completion preserve'),'</table>
<p>';textarea("EVENT_DEFINITION",$L["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="Save">
';if($aa!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?:$_GET["procedure"]);$og=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$L=$_POST;$L["fields"]=(array)$L["fields"];if($_POST&&!process_fields($L["fields"])&&!$m){$hf=routine($_GET["procedure"],$og);$ph="$L[name]_adminer_".uniqid();foreach($L["fields"]as$y=>$n){if($n["field"]=="")unset($L["fields"][$y]);}drop_create("DROP $og ".routine_id($da,$hf),create_routine($og,$L),"DROP $og ".routine_id($L["name"],$L),create_routine($og,array("name"=>$ph)+$L),"DROP $og ".routine_id($ph,$L),substr(ME,0,-1),'Routine has been dropped.','Routine has been altered.','Routine has been created.',$da,$L["name"]);}page_header(($da!=""?(isset($_GET["function"])?'Alter function':'Alter procedure').": ".h($da):(isset($_GET["function"])?'Create function':'Create procedure')),$m);if(!$_POST){if($da=="")$L["language"]="sql";else{$L=routine($_GET["procedure"],$og);$L["name"]=$da;}}$bb=get_vals("SHOW CHARACTER SET");sort($bb);$pg=routine_languages();echo($bb?"<datalist id='collations'>".optionlist($bb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>Name: <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',($pg?'Language'.": ".html_select("language",$pg,$L["language"])."\n":""),'<input type="submit" value="Save">
<div class="scrollable">
<table class="nowrap">
';edit_fields($L["fields"],$bb,$og);if(isset($_GET["function"])){echo"<tr><td>".'Return type';edit_type("returns",$L["returns"],$bb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$L["definition"]);echo'<p>
<input type="submit" value="Save">
';if($da!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$da));echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$D=$_GET["name"];$L=$_POST;if($L&&!$m){if(JUSH=="sqlite")$J=recreate_table($a,$a,array(),array(),array(),0,array(),$D,($L["drop"]?"":$L["clause"]));else{$J=($D==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($D)));if(!$L["drop"])$J=queries("ALTER TABLE ".table($a)." ADD".($L["name"]!=""?" CONSTRAINT ".idf_escape($L["name"]):"")." CHECK ($L[clause])");}queries_redirect(ME."table=".urlencode($a),($L["drop"]?'Check has been dropped.':($D!=""?'Check has been altered.':'Check has been created.')),$J);}page_header(($D!=""?'Alter check'.": ".h($D):'Create check'),$m,array("table"=>$a));if(!$L){$Sa=$l->checkConstraints($a);$L=array("name"=>$D,"clause"=>$Sa[$D]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo'Name'.': <input name="name" value="'.h($L["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",),"?"),'<p>';textarea("clause",$L["clause"]);echo'<p><input type="submit" value="Save">
';if($D!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$D));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D=$_GET["name"];$Jh=trigger_options();$L=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Jh["Timing"])&&in_array($_POST["Event"],$Jh["Event"])&&in_array($_POST["Type"],$Jh["Type"])){$Te=" ON ".table($a);$Rb="DROP TRIGGER ".idf_escape($D).(JUSH=="pgsql"?$Te:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Rb,$A,'Trigger has been dropped.');else{if($D!="")queries($Rb);queries_redirect($A,($D!=""?'Trigger has been altered.':'Trigger has been created.'),queries(create_trigger($Te,$_POST)));if($D!="")queries(create_trigger($Te,$L+array("Type"=>reset($Jh["Type"]))));}}$L=$_POST;}page_header(($D!=""?'Alter trigger'.": ".h($D):'Create trigger'),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>Time<td>',html_select("Timing",$Jh["Timing"],$L["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>Event<td>',html_select("Event",$Jh["Event"],$L["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Jh["Event"])?" <input name='Of' value='".h($L["Of"])."' class='hidden'>":""),'<tr><th>Type<td>',html_select("Type",$Jh["Type"],$L["Type"]),'</table>
<p>Name: <input name="Trigger" value="',h($L["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$L["Statement"]);echo'<p>
<input type="submit" value="Save">
';if($D!="")echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',$D));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$fa=$_GET["user"];$Qf=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$L){foreach(explode(",",($L["Privilege"]=="Grant option"?"":$L["Context"]))as$nb)$Qf[$nb][$L["Privilege"]]=$L["Comment"];}$Qf["Server Admin"]+=$Qf["File access on server"];$Qf["Databases"]["Create routine"]=$Qf["Procedures"]["Create routine"];unset($Qf["Procedures"]["Create routine"]);$Qf["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$Qf["Columns"][$X]=$Qf["Tables"][$X];unset($Qf["Server Admin"]["Usage"]);foreach($Qf["Tables"]as$y=>$X)unset($Qf["Databases"][$y]);$De=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$De[$X]=(array)$De[$X]+(array)$_POST["grants"][$y];}$Xc=array();$Re="";if(isset($_GET["host"])&&($J=$f->query("SHOW GRANTS FOR ".q($fa)."@".q($_GET["host"])))){while($L=$J->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$L[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$ie,PREG_SET_ORDER)){foreach($ie
as$X){if($X[1]!="USAGE")$Xc["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$L[0]))$Xc["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$L[0],$B))$Re=$B[1];}}if($_POST&&!$m){$Se=(isset($_GET["host"])?q($fa)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Se",ME."privileges=",'User has been dropped.');else{$Fe=q($_POST["user"])."@".q($_POST["host"]);$xf=$_POST["pass"];if($xf!=''&&!$_POST["hashed"]&&!min_version(8)){$xf=get_val("SELECT PASSWORD(".q($xf).")");$m=!$xf;}$rb=false;if(!$m){if($Se!=$Fe){$rb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Fe IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($xf));$m=!$rb;}elseif($xf!=$Re)queries("SET PASSWORD FOR $Fe = ".q($xf));}if(!$m){$lg=array();foreach($De
as$Me=>$Wc){if(isset($_GET["grant"]))$Wc=array_filter($Wc);$Wc=array_keys($Wc);if(isset($_GET["grant"]))$lg=array_diff(array_keys(array_filter($De[$Me],'strlen')),$Wc);elseif($Se==$Fe){$Pe=array_keys((array)$Xc[$Me]);$lg=array_diff($Pe,$Wc);$Wc=array_diff($Wc,$Pe);unset($Xc[$Me]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Me,$B)&&(!grant("REVOKE",$lg,$B[2]," ON $B[1] FROM $Fe")||!grant("GRANT",$Wc,$B[2]," ON $B[1] TO $Fe"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Se!=$Fe)queries("DROP USER $Se");elseif(!isset($_GET["grant"])){foreach($Xc
as$Me=>$lg){if(preg_match('~^(.+)(\(.*\))?$~U',$Me,$B))grant("REVOKE",array_keys($lg),$B[2]," ON $B[1] FROM $Fe");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?'User has been altered.':'User has been created.'),!$m);if($rb)$f->query("DROP USER $Fe");}}page_header((isset($_GET["host"])?'Username'.": ".h("$fa@$_GET[host]"):'Create user'),$m,array("privileges"=>array('','Privileges')));$L=$_POST;if($L)$Xc=$De;else{$L=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$L["pass"]=$Re;if($Re!="")$L["hashed"]=true;$Xc[(DB==""||$Xc?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>Server<td><input name="host" data-maxlength="60" value="',h($L["host"]),'" autocapitalize="off">
<tr><th>Username<td><input name="user" data-maxlength="80" value="',h($L["user"]),'" autocapitalize="off">
<tr><th>Password<td><input name="pass" id="pass" value="',h($L["pass"]),'" autocomplete="new-password">
',($L["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$L["hashed"],'Hashed',"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".'Privileges'.doc_link(array('sql'=>"grant.html#priv_level"));$u=0;foreach($Xc
as$Me=>$Wc){echo'<th>'.($Me!="*.*"?"<input name='objects[$u]' value='".h($Me)."' size='10' autocapitalize='off'>":input_hidden("objects[$u]","*.*")."*.*");$u++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>'Server',"Databases"=>'Database',"Tables"=>'Table',"Columns"=>'Column',"Procedures"=>'Routine',)as$nb=>$Ib){foreach((array)$Qf[$nb]as$Pf=>$fb){echo"<tr><td".($Ib?">$Ib<td":" colspan='2'").' lang="en" title="'.h($fb).'">'.h($Pf);$u=0;foreach($Xc
as$Me=>$Wc){$D="'grants[$u][".h(strtoupper($Pf))."]'";$Y=$Wc[strtoupper($Pf)];if($nb=="Server Admin"&&$Me!=(isset($Xc["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".'Grant'."<option value='0'".($Y=="0"?" selected":"").">".'Revoke'."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($Pf=="All privileges"?" id='grants-$u-all'>":">".($Pf=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$u-all'); };"))),"</label>";$u++;}}}echo"</table>\n",'<p>
<input type="submit" value="Save">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="Drop">',confirm(sprintf('Drop %s?',"$fa@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Pd=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$Pd++;}queries_redirect(ME."processlist=",lang(array('%d process has been killed.','%d processes have been killed.'),$Pd),$Pd||!$_POST["kill"]);}}page_header('Process list',$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$u=-1;foreach(process_list()as$u=>$L){if(!$u){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($L
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$L[JUSH=="sql"?"Id":"pid"],0):"");foreach($L
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$L["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($L["db"]!=""?"db=".urlencode($L["db"])."&":"")."sql=".urlencode($X)).'">'.'Clone'.'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($u+1)."/".sprintf('%d in total',max_connections()),"<p><input type='submit' value='".'Kill'."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$Nc=column_foreign_keys($a);$Oe=$S["Oid"];$ka=get_settings("adminer_import");$mg=array();$e=array();$ug=array();$df=array();$sh=null;foreach($o
as$y=>$n){$D=$b->fieldName($n);$Be=html_entity_decode(strip_tags($D),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$D!=""){$e[$y]=$Be;if(is_shortable($n))$sh=$b->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$D!="")$ug[$y]=$Be;if(isset($n["privileges"]["order"])&&$D!="")$df[$y]=$Be;$mg+=$n["privileges"];}list($O,$t)=$b->selectColumnsProcess($e,$x);$O=array_unique($O);$t=array_unique($t);$Gd=count($t)<count($O);$Z=$b->selectSearchProcess($o,$x);$cf=$b->selectOrderProcess($o,$x);$z=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Rh=>$L){$sa=convert_field($o[key($L)]);$O=array($sa?:idf_escape(key($L)));$Z[]=where_check($Rh,$o);$K=$l->select($a,$O,$Z,$O);if($K)echo
reset($K->fetch_row());}exit;}$Mf=$Th=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$Mf=array_flip($w["columns"]);$Th=($O?$Mf:array());foreach($Th
as$y=>$X){if(in_array(idf_escape($y),$O))unset($Th[$y]);}break;}}if($Oe&&!$Mf){$Mf=$Th=array($Oe=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Oe));}if($_POST&&!$m){$pi=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Sa=array();foreach($_POST["check"]as$Pa)$Sa[]=where_check($Pa,$o);$pi[]="((".implode(") OR (",$Sa)."))";}$pi=($pi?"\nWHERE ".implode(" AND ",$pi):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);$b->dumpTable($a,"");$Rc=($O?implode(", ",$O):"*").convert_fields($e,$o,$O)."\nFROM ".table($a);$Zc=($t&&$Gd?"\nGROUP BY ".implode(", ",$t):"").($cf?"\nORDER BY ".implode(", ",$cf):"");$I="SELECT $Rc$pi$Zc";if(is_array($_POST["check"])&&!$Mf){$Ph=array();foreach($_POST["check"]as$X)$Ph[]="(SELECT".limit($Rc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$Zc,1).")";$I=implode(" UNION ALL ",$Ph);}$b->dumpData($a,"table",$I);$b->dumpFooter();exit;}if(!$b->selectEmailProcess($Z,$Nc)){if($_POST["save"]||$_POST["delete"]){$J=true;$la=0;$Q=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$D=>$X){$X=process_input($o[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$Q[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$Q){if($_POST["clone"])$I="INTO ".table($a)." (".implode(", ",array_keys($Q)).")\nSELECT ".implode(", ",$Q)."\nFROM ".table($a);if($_POST["all"]||($Mf&&is_array($_POST["check"]))||$Gd){$J=($_POST["delete"]?$l->delete($a,$pi):($_POST["clone"]?queries("INSERT $I$pi".$l->insertReturning($a)):$l->update($a,$Q,$pi)));$la=$f->affected_rows+(is_object($J)?$J->num_rows:0);}else{foreach((array)$_POST["check"]as$X){$oi="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$J=($_POST["delete"]?$l->delete($a,$oi,1):($_POST["clone"]?queries("INSERT".limit1($a,$I,$oi)):$l->update($a,$Q,$oi,1)));if(!$J)break;$la+=$f->affected_rows;}}}$C=lang(array('%d item has been affected.','%d items have been affected.'),$la);if($_POST["clone"]&&$J&&$la==1){$Ud=last_id($J);if($Ud)$C=sprintf('Item%s has been inserted.'," $Ud");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$C,$J);if(!$_POST["delete"]){$Jf=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Jf),$Jf,!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m='Ctrl+click on a value to modify it.';else{$J=true;$la=0;foreach($_POST["val"]as$Rh=>$L){$Q=array();foreach($L
as$y=>$X){$y=bracket_escape($y,1);$Q[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?$b->processInput($o[$y],$X):"NULL");}$J=$l->update($a,$Q," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Rh,$o),!$Gd&&!$Mf," ");if(!$J)break;$la+=$f->affected_rows;}queries_redirect(remove_from_uri(),lang(array('%d item has been affected.','%d items have been affected.'),$la),$J);}}elseif(!is_string($Ec=get_file("csv_file",true)))$m=upload_error($Ec);elseif(!preg_match('~~u',$Ec))$m='File must be in UTF-8 encoding.';else{save_settings(array("output"=>$ka["output"],"format"=>$_POST["separator"]),"adminer_import");$J=true;$cb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Ec,$ie);$la=count($ie[0]);$l->begin();$_g=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$M=array();foreach($ie[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$_g]*)$_g~",$X.$_g,$je);if(!$y&&!array_diff($je[1],$cb)){$cb=$je[1];$la--;}else{$Q=array();foreach($je[1]as$u=>$Ya)$Q[idf_escape($cb[$u])]=($Ya==""&&$o[$cb[$u]]["null"]?"NULL":q(preg_match('~^".*"$~s',$Ya)?str_replace('""','"',substr($Ya,1,-1)):$Ya));$M[]=$Q;}}$J=(!$M||$l->insertUpdate($a,$M,$Mf));if($J)$l->commit();queries_redirect(remove_from_uri("page"),lang(array('%d row has been imported.','%d rows have been imported.'),$la),$J);$l->rollback();}}}$gh=$b->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header('Select'.": $gh",$m);$Q=null;if(isset($mg["insert"])||!support("table")){$F=array();foreach((array)$_GET["where"]as$X){if(isset($Nc[$X["col"]])&&count($Nc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$F["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$Q=$F?"&".http_build_query($F):"";}$b->selectLinks($S,$Q);if(!$e&&support("table"))echo"<p class='error'>".'Unable to select the table'.($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";$b->selectColumnsPrint($O,$e);$b->selectSearchPrint($Z,$ug,$x);$b->selectOrderPrint($cf,$df,$x);$b->selectLimitPrint($z);$b->selectLengthPrint($sh);$b->selectActionPrint($x);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$Qc=get_val(count_rows($a,$Z,$Gd,$t));$E=floor(max(0,$Qc-1)/$z);}$vg=$O;$Yc=$t;if(!$vg){$vg[]="*";$ob=convert_fields($e,$o,$O);if($ob)$vg[]=substr($ob,2);}foreach($O
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($sa=convert_field($n)))$vg[$y]="$sa AS $X";}if(!$Gd&&$Th){foreach($Th
as$y=>$X){$vg[]=idf_escape($y);if($Yc)$Yc[]=idf_escape($y);}}$J=$l->select($a,$vg,$Z,$Yc,$cf,$z,$E,true);if(!$J)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$E)$J->seek($z*$E);$dc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$M=array();while($L=$J->fetch_assoc()){if($E&&JUSH=="oracle")unset($L["RNUM"]);$M[]=$L;}if($_GET["page"]!="last"&&$z!=""&&$t&&$Gd&&JUSH=="sql")$Qc=get_val(" SELECT FOUND_ROWS()");if(!$M)echo"<p class='message'>".'No rows.'."\n";else{$Aa=$b->backwardKeys($a,$gh);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$t&&$O?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".'Modify'."</a>");$Ce=array();$Tc=array();reset($O);$Yf=1;foreach($M[0]as$y=>$X){if(!isset($Th[$y])){$X=$_GET["columns"][key($O)];$n=$o[$O?($X?$X["col"]:current($O)):$y];$D=($n?$b->fieldName($n,$Yf):($X["fun"]?"*":h($y)));if($D!=""){$Yf++;$Ce[$y]=$D;$d=idf_escape($y);$od=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Ib="&desc%5B0%5D=1";$Kg=isset($n["privileges"]["order"]);echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$Sc=apply_sql_function($X["fun"],$D);echo($Kg?'<a href="'.h($od.($cf[0]==$d||$cf[0]==$y||(!$cf&&$Gd&&$t[0]==$d)?$Ib:'')).'">'."$Sc</a>":$Sc),"<span class='column hidden'>";if($Kg)echo"<a href='".h($od.$Ib)."' title='".'descending'."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.'Search'.'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$Tc[$y]=$X["fun"];next($O);}}$ae=array();if($_GET["modify"]){foreach($M
as$L){foreach($L
as$y=>$X)$ae[$y]=max($ae[$y],min(40,strlen(utf8_decode($X))));}}echo($Aa?"<th>".'Relations':"")."</thead>\n";if(is_ajax())ob_end_clean();foreach($b->rowDescriptions($M,$Nc)as$Ae=>$L){$Qh=unique_array($M[$Ae],$x);if(!$Qh){$Qh=array();foreach($M[$Ae]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Qh[$y]=$X;}}$Rh="";foreach($Qh
as$y=>$X){if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$o[$y]["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$o[$y]["collation"])?$y:"CONVERT($y USING ".charset($f).")").")";$X=md5($X);}$Rh.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$t&&$O?"":"<td>".checkbox("check[]",substr($Rh,1),in_array(substr($Rh,1),(array)$_POST["check"])).($Gd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Rh)."' class='edit'>".'edit'."</a>"));foreach($L
as$y=>$X){if(isset($Ce[$y])){$n=$o[$y];$X=$l->value($X,$n);if($X!=""&&(!isset($dc[$y])||$dc[$y]!=""))$dc[$y]=(is_mail($X)?$Ce[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$Rh;if(!$_&&$X!==null){foreach((array)$Nc[$y]as$q){if(count($Nc[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$u=>$Lg)$_.=where_link($u,$q["target"][$u],$M[$Ae][$Lg]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$u=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Qh))$_.=where_link($u++,$W["col"],$W["val"],$W["op"]);}foreach($Qh
as$Md=>$W)$_.=where_link($u++,$Md,$W);}$X=select_value($X,$_,$n,$sh);$v=h("val[$Rh][".bracket_escape($y)."]");$Y=$_POST["val"][$Rh][bracket_escape($y)];$Yb=!is_array($L[$y])&&is_utf8($X)&&$M[$Ae][$y]==$L[$y]&&!$Tc[$y]&&!$n["generated"];$rh=preg_match('~text|json|lob~',$n["type"]);echo"<td id='$v'".(preg_match(number_type(),$n["type"])&&is_numeric(strip_tags($X))?" class='number'":"");if(($_GET["modify"]&&$Yb)||$Y!==null){$cd=h($Y!==null?$Y:$L[$y]);echo">".($rh?"<textarea name='$v' cols='30' rows='".(substr_count($L[$y],"\n")+1)."'>$cd</textarea>":"<input name='$v' value='$cd' size='$ae[$y]'>");}else{$ee=strpos($X,"<i>…</i>");echo" data-text='".($ee?2:($rh?1:0))."'".($Yb?"":" data-warning='".h('Use edit link to modify this value.')."'").">$X";}}}if($Aa)echo"<td>";$b->backwardKeysPrint($Aa,$M[$Ae]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($M||$E){$rc=true;if($_GET["page"]!="last"){if($z==""||(count($M)<$z&&($M||!$E)))$Qc=($E?$E*$z:0)+count($M);elseif(JUSH!="sql"||!$Gd){$Qc=($Gd?false:found_rows($S,$Z));if($Qc<max(1e4,2*($E+1)*$z))$Qc=first(slow_query(count_rows($a,$Z,$Gd,$t)));else$rc=false;}}$qf=($z!=""&&($Qc===false||$Qc>$z||$E));if($qf)echo(($Qc===false?count($M)+1:$Qc-$E*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.'Load more data'.'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$z).", '".'Loading'."…');",""):''),"\n";}echo"<div class='footer'><div>\n";if($M||$E){if($qf){$le=($Qc===false?$E+(count($M)>=$z?2:1):floor(($Qc-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".'Page'."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".'Page'."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($u=max(1,$E-4);$u<min($le,$E+5);$u++)echo
pagination($u,$E);if($le>0)echo($E+5<$le?" …":""),($rc&&$Qc!==false?pagination($le,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$le'>".'last'."</a>");}else
echo"<legend>".'Page'."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($le>$E?pagination($E+1,$E).($le>$E+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".'Whole result'."</legend>";$Ob=($rc?"":"~ ").$Qc;$We="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Ob' : checked); selectCount('selected2', this.checked || !checked ? '$Ob' : checked);";echo
checkbox("all",1,0,($Qc!==false?($rc?"":"~ ").lang(array('%d row','%d rows'),$Qc):""),$We)."\n","</fieldset>\n";if($b->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>Modify</legend><div>
<input type="submit" value="Save"',($_GET["modify"]?'':' title="'.'Ctrl+click on a value to modify it.'.'"'),'>
</div></fieldset>
<fieldset><legend>Selected <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="Edit">
<input type="submit" name="clone" value="Clone">
<input type="submit" name="delete" value="Delete">',confirm(),'</div></fieldset>
';$Oc=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($Oc['sql']);break;}}if($Oc){print_fieldset("export",'Export'." <span id='selected2'></span>");$of=$b->dumpOutput();echo($of?html_select("output",$of,$ka["output"])." ":""),html_select("format",$Oc,$ka["format"])," <input type='submit' name='export' value='".'Export'."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($dc,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint())echo"<div>","<a href='#import'>".'Import'."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ka["format"])," <input type='submit' name='import' value='".'Import'."'>","</span>","</div>";echo
input_token(),"</form>\n",(!$t&&$O?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$Ug=isset($_GET["status"]);page_header($Ug?'Status':'Variables');$fi=($Ug?show_status():show_variables());if(!$fi)echo"<p class='message'>".'No rows.'."\n";else{echo"<table>\n";foreach($fi
as$L){echo"<tr>";$y=array_shift($L);echo"<th><code class='jush-".JUSH.($Ug?"status":"set")."'>".h($y)."</code>";foreach($L
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$dh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$S){json_row("Comment-$D",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$D",h($S[$y]));foreach($dh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$D",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($dh[$y]))$dh[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$D","?");}}}foreach($dh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$f->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$lh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($lh&&!$m&&!$_POST["search"]){$J=true;$C="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$J=truncate_tables($_POST["tables"]);$C='Tables have been truncated.';}elseif($_POST["move"]){$J=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C='Tables have been moved.';}elseif($_POST["copy"]){$J=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C='Tables have been copied.';}elseif($_POST["drop"]){if($_POST["views"])$J=drop_views($_POST["views"]);if($J&&$_POST["tables"])$J=drop_tables($_POST["tables"]);$C='Tables have been dropped.';}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$L)$C.="<b>".h($R)."</b>: ".h($L["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$J=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$C='Tables have been optimized.';}elseif(!$_POST["tables"])$C='No tables.';elseif($J=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($L=$J->fetch_assoc())$C.="<b>".h($L["Table"])."</b>: ".h($L["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$C,$J);}page_header(($_GET["ns"]==""?'Database'.": ".h(DB):'Schema'.": ".h($_GET["ns"])),$m,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".'Tables and views'."</h3>\n";$kh=tables_list();if(!$kh)echo"<p class='message'>".'No tables.'."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".'Search data in tables'." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".'Search'."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$l->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.'Table','<td>'.'Engine'.doc_link(array('sql'=>'storage-engines.html')),'<td>'.'Collation'.doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.'Data Length'.doc_link(array('sql'=>'show-table-status.html',)),'<td>'.'Index Length'.doc_link(array('sql'=>'show-table-status.html',)),'<td>'.'Data Free'.doc_link(array('sql'=>'show-table-status.html')),'<td>'.'Auto Increment'.doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.'Rows'.doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.'Comment'.doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$T=0;foreach($kh
as$D=>$U){$ii=($U!==null&&!preg_match('~table|sequence~i',$U));$v=h("Table-".$D);echo'<tr><td>'.checkbox(($ii?"views[]":"tables[]"),$D,in_array($D,$lh,true),"","","",$v),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".'Show structure'."' id='$v'>".h($D).'</a>':h($D));if($ii)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($D).'" title="'.'Alter view'.'">'.(preg_match('~materialized~i',$U)?'Materialized view':'View').'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.'Select data'.'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",'Alter table'),"Index_length"=>array("indexes",'Alter indexes'),"Data_free"=>array("edit",'New item'),"Auto_increment"=>array("auto_increment=1&create",'Alter table'),"Rows"=>array("select",'Select data'),)as$y=>$_){$v=" id='$y-".h($D)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($D)."'$v title='$_[1]'>?</a>":"<span$v>?</span>"):"<td id='$y-".h($D)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":""),"\n";}echo"<tr><td><th>".sprintf('%d in total',count($kh)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$di="<input type='submit' value='".'Vacuum'."'> ".on_help("'VACUUM'");$Ze="<input type='submit' name='optimize' value='".'Optimize'."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".'Selected'." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$di."<input type='submit' name='check' value='".'Check'."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$di.$Ze:(JUSH=="sql"?"<input type='submit' value='".'Analyze'."'> ".on_help("'ANALYZE TABLE'").$Ze."<input type='submit' name='check' value='".'Check'."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".'Repair'."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".'Truncate'."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".'Drop'."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?$b->schemas():$b->databases());if(count($i)!=1&&JUSH!="sqlite"){$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".'Move to other database'.": ",($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">')," <input type='submit' name='move' value='".'Move'."'>",(support("copy")?" <input type='submit' name='copy' value='".'Copy'."'> ".checkbox("overwrite",1,$_POST["overwrite"],'overwrite'):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".'Create table'."</a>\n",(support("view")?"<a href='".h(ME)."view='>".'Create view'."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".'Routines'."</h3>\n";$qg=routines();if($qg){echo"<table class='odds'>\n",'<thead><tr><th>'.'Name'.'<td>'.'Type'.'<td>'.'Return type'."<td></thead>\n";foreach($qg
as$L){$D=($L["SPECIFIC_NAME"]==$L["ROUTINE_NAME"]?"":"&name=".urlencode($L["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($L["SPECIFIC_NAME"]).$D).'">'.h($L["ROUTINE_NAME"]).'</a>','<td>'.h($L["ROUTINE_TYPE"]),'<td>'.h($L["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($L["SPECIFIC_NAME"]).$D).'">'.'Alter'."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.'Create procedure'.'</a>':'').'<a href="'.h(ME).'function=">'.'Create function'."</a>\n";}if(support("event")){echo"<h3 id='events'>".'Events'."</h3>\n";$M=get_rows("SHOW EVENTS");if($M){echo"<table>\n","<thead><tr><th>".'Name'."<td>".'Schedule'."<td>".'Start'."<td>".'End'."<td></thead>\n";foreach($M
as$L)echo"<tr>","<th>".h($L["Name"]),"<td>".($L["Execute at"]?'At given time'."<td>".$L["Execute at"]:'Every'." ".$L["Interval value"]." ".$L["Interval field"]."<td>$L[Starts]"),"<td>$L[Ends]",'<td><a href="'.h(ME).'event='.urlencode($L["Name"]).'">'.'Alter'.'</a>';echo"</table>\n";$pc=get_val("SELECT @@event_scheduler");if($pc&&$pc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($pc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.'Create event'."</a>\n";}if($kh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();