<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: default
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_default($_post, $_user, $_conf)
{
    if (empty($_post['option'])) {
        jrCore_notice_page('error', 'no form was specified - please specify the form to display');
    }

    // See if we are SAVING or DISPLAYING a form
    //------------------------------
    // FORM SAVE
    //------------------------------
    if (jrCore_checktype($_post['jr_html_form_token'], 'md5') && strpos($_post['option'], '_save')) {

        // Save data to datastore
        $nam = str_replace('_save', '', $_post['option']);

        // make sure this is a good form
        $tbl = jrCore_db_table_name('jrCustomForm', 'form');
        $req = "SELECT * FROM {$tbl} WHERE form_name = '" . jrCore_db_escape($nam) . "' LIMIT 1";
        $_rt = jrCore_db_query($req, 'SINGLE');
        if (!$_rt || !is_array($_rt)) {
            if (jrCore_is_ajax_request()) {
                jrCore_set_form_notice('error', 'invalid form');
                jrCore_form_result();
            }
            else {
                jrCore_notice_page('error', 'Invalid form');
            }
        }
        if (isset($_rt['form_login']) && $_rt['form_login'] == 'on') {
            jrUser_session_require_login();
        }

        // re-validate server side to prevent bot submission
        $_fm                = jrCore_form_get_session($_post['jr_html_form_token']);
        $_fm['form_fields'] = jrCore_get_designer_form_fields('jrCustomForm', $nam);
        jrCore_set_flag("jrcore_form_get_session_{$_post['jr_html_form_token']}", $_fm);
        jrCore_form_validate($_post);

        // We have to validate if we are human if NOT logged in
        if (!jrUser_is_logged_in()) {
            $pass = false;
            foreach ($_post as $k => $v) {
                if (strpos($k, 'form_is_human') === 0 || strpos($k, 'user_is_human') === 0) {
                    $pass = true;
                    break;
                }
            }
            if (!$pass) {
                $_ln = jrUser_load_lang_strings();
                jrCore_set_form_notice('error', $_ln['jrUser'][92]);
                jrCore_form_result();
            }
        }

        $_sv = array();
        foreach ($_post as $k => $v) {
            if (strpos($k, 'form_') === 0 && !strpos($k, 'is_human')) {
                $_sv[$k] = $v;
            }
        }
        $_sv['form_name']    = $nam;
        $_sv['form_user_ip'] = jrCore_get_ip();

        // Check for banned items
        if (jrCore_run_module_function('jrBanned_is_banned', 'ip', $_sv['form_user_ip'])) {
            // This is a banned IP address
            jrCore_set_form_notice('error', 3);
            jrCore_form_result();
        }
        foreach ($_sv as $k => $v) {
            if (strpos($k, '_email')) {
                if (jrCore_run_module_function('jrBanned_is_banned', 'email', $v)) {
                    // This is a banned Email address
                    jrCore_set_form_notice('error', 3);
                    jrCore_form_result();
                }
            }
        }

        if (jrUser_is_logged_in()) {

            // Check for form unique
            if (isset($_rt['form_unique']) && $_rt['form_unique'] == 'on') {
                // Make sure they have not submitted before
                $_sp = array(
                    'search'        => array(
                        "_user_id = {$_user['_user_id']}",
                        "form_name = {$nam}"
                    ),
                    'return_count'  => true,
                    'skip_triggers' => true,
                    'privacy_check' => false // disable privacy check
                );
                $cnt = jrCore_db_search_items('jrCustomForm', $_sp);
                if ($cnt && $cnt > 0) {
                    if (jrCore_is_ajax_request()) {
                        jrCore_set_form_notice('error', 5);
                        jrCore_form_result();
                    }
                    else {
                        jrCore_notice_page('error', 5);
                    }
                }
            }
            $_cr = null;
        }
        else {
            // User is NOT logged in
            $_cr = array(
                '_user_id'    => 0,
                '_profile_id' => 0
            );
        }
        $fid = jrCore_db_create_item('jrCustomForm', $_sv, $_cr);
        if ($fid && jrCore_checktype($fid, 'number_nz')) {

            // Save any uploaded media files added in by our
            if (jrUser_is_logged_in()) {
                jrCore_save_all_media_files('jrCustomForm', $nam, $_user['user_active_profile_id'], $fid);
            }

            // Update response count
            $req = "UPDATE {$tbl} SET form_responses = (form_responses + 1) WHERE form_id = '{$_rt['form_id']}' LIMIT 1";
            jrCore_db_query($req);

            // Check for notifications
            switch ($_rt['form_notify']) {

                case 'master_email':
                case 'admin_email':
                    $_sp = array(
                        'search'        => array(
                            "user_group = master",
                        ),
                        'order_by'      => array(
                            'user_name' => 'desc'
                        ),
                        'limit'         => 100,
                        'return_keys'   => array('_user_id'),
                        'skip_triggers' => true,
                        'privacy_check' => false // disable privacy check
                    );
                    if ($_rt['form_notify'] == 'admin_email') {
                        $_sp['search'][0] = 'user_group IN master,admin';
                    }
                    $_us = jrCore_db_search_items('jrUser', $_sp);
                    if (isset($_us) && isset($_us['_items']) && is_array($_us['_items'])) {
                        foreach ($_sv as $k => $v) {
                            if ((strpos($k, '_created') || strpos($k, '_updated')) && is_numeric($v)) {
                                $_sv[$k] = jrCore_format_time($v);
                            }
                        }
                        $_rp = array(
                            'system_name'      => $_conf['jrCore_system_name'],
                            'form_browser_url' => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browser_item_update/id={$fid}",
                            'user_ip'          => $_sv['form_user_ip'],
                            '_save'            => $_sv
                        );
                        $_rp = array_merge($_rt, $_rp);
                        list($sub, $msg) = jrCore_parse_email_templates('jrCustomForm', 'form_received', $_rp);
                        foreach ($_us['_items'] as $_v) {
                            jrUser_notify($_v['_user_id'], 0, 'jrCustomForm', 'form_response', $sub, $msg);
                        }
                    }
                    break;
            }

            jrCore_form_delete_session();
            if (jrCore_is_ajax_request()) {
                jrCore_set_form_notice('success', 2);
                jrCore_form_result();
            }
            else {
                jrCore_notice_page('success', 2, $_conf['jrCore_base_url'], 4);
            }
        }
        else {
            if (jrCore_is_ajax_request()) {
                jrCore_set_form_notice('error', 3);
                jrCore_form_result();
            }
            else {
                jrCore_notice_page('error', 3);
            }
        }
    }

    //------------------------------
    // FORM DISPLAY
    //------------------------------
    else {

        // Check for form
        $tbl = jrCore_db_table_name('jrCustomForm', 'form');
        $req = "SELECT * FROM {$tbl} WHERE form_name = '" . jrCore_db_escape($_post['option']) . "' LIMIT 1";
        $_rt = jrCore_db_query($req, 'SINGLE');
        if (!isset($_rt) || !is_array($_rt)) {
            jrCore_notice_page('error', 'Invalid form');
        }
        if (isset($_rt['form_login']) && $_rt['form_login'] == 'on') {
            jrUser_session_require_login();
        }
        if (jrUser_is_logged_in() && isset($_rt['form_unique']) && $_rt['form_unique'] == 'on') {
            // Make sure they have not submitted before
            $_sp = array(
                'search'        => array(
                    "form_user_id = {$_user['_user_id']}",
                    "form_name = {$_post['option']}"
                ),
                'return_count'  => true,
                'skip_triggers' => true,
                'privacy_check' => false // disable privacy check
            );
            $cnt = jrCore_db_search_items('jrCustomForm', $_sp);
            if (isset($cnt) && $cnt > 0) {
                jrCore_notice_page('error', 5);
            }
        }
        jrCore_register_module_feature('jrCore', 'designer_form', 'jrCustomForm', $_post['option']);
        $_lng = jrUser_load_lang_strings();

        jrCore_page_banner($_rt['form_title']);
        if (!empty($_rt['form_message'])) {
            jrCore_page_note($_rt['form_message']);
        }

        // Form init
        $_tmp = array(
            'submit_value'     => 1,
            'cancel'           => jrCore_is_profile_referrer(),
            'form_ajax_submit' => false
        );
        jrCore_form_create($_tmp);

        $_fields = jrCore_get_designer_form_fields('jrCustomForm', $_post['option']);
        if (!$_fields || !is_array($_fields)) {
            jrCore_notice_page('error', 'This form has not been setup yet');
        }
        foreach ($_fields as $_tmp) {
            // If we have any file based form types, user must be logged in
            switch ($_tmp['type']) {
                case 'file':
                case 'audio':
                case 'video':
                case 'image':
                    if (jrUser_is_logged_in()) {
                        jrCore_form_field_create($_tmp);
                    }
                    break;
                default:
                    jrCore_form_field_create($_tmp);
                    break;
            }
        }

        // See if we need to add a Spam Bot Checkbox
        $tmp = jrCore_get_flag('jrcore_form_field_checkbox_spambot');
        if (!$tmp && !jrUser_is_logged_in()) {
            // Spam Bot Check
            $_tmp = array(
                'name'          => 'form_is_human',
                'label'         => $_lng['jrUser'][90],
                'help'          => $_lng['jrUser'][91],
                'type'          => 'checkbox_spambot',
                'error_msg'     => $_lng['jrUser'][92],
                'validate'      => 'onoff',
                'form_designer' => false
            );
            jrCore_form_field_create($_tmp);
        }
        jrCore_page_display();
    }
}
