<?php
 /**
 * Jamroom Simple Custom Forms module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCustomForm_create($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCustomForm');

    jrCore_page_banner('create new custom form');

    // Form init
    $_tmp = array(
        'submit_value' => 'create form',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse"
    );
    jrCore_form_create($_tmp);

    // Form Name
    $_tmp = array(
        'name'     => 'form_name',
        'label'    => 'form name',
        'help'     => 'Enter a unique form name for this new form. It should be lowercase and consist of letters and underscores only.',
        'type'     => 'text',
        'validate' => 'core_string',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Form Title
    $_tmp = array(
        'name'     => 'form_title',
        'label'    => 'form title',
        'help'     => 'Enter a title for this form - it will be used in the form header as well as the page title.',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Form Message
    $_tmp = array(
        'name'     => 'form_message',
        'label'    => 'form message',
        'help'     => 'Enter an optional message for this form - it will appear above the form and can be used for form instructions, etc.',
        'type'     => 'textarea',
        'validate' => 'allowed_html',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    // Form Login
    $_tmp = array(
        'name'     => 'form_login',
        'label'    => 'form login',
        'help'     => 'Check this option to only allow logged in users to view this form.',
        'type'     => 'checkbox',
        'default'  => 'off',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Form Unique
    $_tmp = array(
        'name'     => 'form_unique',
        'label'    => 'form unique',
        'help'     => 'Check this option to ensure that a user can only fill out this form one time (only works if <b>form login</b> is checked too)',
        'type'     => 'checkbox',
        'default'  => 'off',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Form Notification
    $_sel = array(
        'master_email' => 'Send email to Master Admins',
        'admin_email'  => 'Send email to Admin Users',
        'none'         => 'Store in DataStore only'
    );
    $_tmp = array(
        'name'     => 'form_notify',
        'label'    => 'form notify',
        'help'     => 'Select the type of Notification you would like to be sent out on a successful form submission',
        'type'     => 'select',
        'default'  => 'master_email',
        'options'  => $_sel,
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Display page with form in it
    jrCore_page_display();
}
