<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: search
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_search($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();

    $_tabs['results'] = array(
        'label'  => 'search results',
        'url'    => jrCore_get_current_url(),
        'active' => 1
    );
    jrCore_page_tab_bar($_tabs);

    if (!isset($_post['ss']) || strlen($_post['ss']) === 0) {
        jrCore_page_banner('search results');
        jrCore_set_form_notice('error', 'You forgot to enter a search string');
        jrCore_get_form_notice();
    }
    else {
        $fnd = false;
        $src = jrCore_db_escape($_post['ss']);

        // Check if we are searching modules or skins
        $_mi = array();
        $tbl = jrCore_db_table_name('jrCore', 'setting');
        if (isset($_post['sa']) && $_post['sa'] == 'skin') {
            $_sk = jrCore_get_skins();
            $req = "SELECT * FROM {$tbl} WHERE (`module` LIKE '%{$src}%' OR `name` LIKE '%{$src}%' OR `label` LIKE '%{$src}%' OR `help` LIKE '%{$src}%') AND `type` != 'hidden' AND module IN('" . implode("','", $_sk) . "') ORDER BY `module` ASC, `label` ASC";
            // See if we have matching skins
            $_ms = jrCore_get_skins();
            if ($_ms && is_array($_ms)) {
                foreach ($_ms as $sd => $sn) {
                    $_mt = jrCore_skin_meta_data($sd);
                    if (stripos(' ' . $sd, $_post['ss']) || (isset($_mt['title']) && stripos(' ' . $_mt['title'], $_post['ss']))) {
                        $_mi[$sd] = (isset($_mt['title'])) ? $_mt['title'] : $sd;
                    }
                }
            }
        }
        else {
            $req = "SELECT * FROM {$tbl} WHERE (`module` LIKE '%{$src}%' OR `name` LIKE '%{$src}%' OR `label` LIKE '%{$src}%' OR `help` LIKE '%{$src}%') AND `type` != 'hidden' AND module IN('" . implode("','", array_keys($_mods)) . "') ORDER BY `module` ASC, `label` ASC";
            foreach ($_mods as $sd => $sn) {
                if (stripos(' ' . $sd, $_post['ss']) || stripos(' ' . $sn['module_name'], $_post['ss'])) {
                    $_mi[$sd] = $sn['module_name'];
                }
            }
        }
        $_cf = jrCore_db_query($req, 'NUMERIC');

        jrCore_page_banner("search results for &quot;" . jrCore_entity_string($_post['ss']) . '&quot;');
        jrCore_page_title('search results');
        if (is_array($_cf) || count($_mi) > 0) {
            $fnd = true;
        }

        // Show DASHBOARD tools
        $prurl = jrCore_get_module_url('jrProfile');

        if (!isset($_post['sa']) || $_post['sa'] != 'skin') {
            $_dmss = array();
            $_dash = array(
                'Dashboard'     => array("{$_post['module_url']}/dashboard", 'The System Dashboard &quot;BigView&quot;'),
                'Users Online'  => array("{$_post['module_url']}/dashboard/online", 'View Users that are currently active on your system'),
                'Pending Users' => array("{$_post['module_url']}/dashboard/pending_users", 'Viewing Pending User Accounts'),
                'Pending Items' => array("{$_post['module_url']}/dashboard/pending", 'View Pending Items created by Users'),
                'Activity Log'  => array("{$_post['module_url']}/dashboard/activity", "View the system Activity Logs, including Debug and Error logs"),
                'Data Browser'  => array("{$prurl}/dashboard/browser", 'View the DataStore browser for active modules on the system'),
                'Recycle Bin'   => array("{$_post['module_url']}/dashboard/recycle_bin", 'View, delete and restore deleted items in the system Recycle Bin'),
                'Queue Viewer'  => array("{$_post['module_url']}/dashboard/queue_viewer", 'View the system Queue and any active Queue Workers')
            );
            foreach ($_dash as $db => $_view) {
                if (stripos(' ' . $db, $_post['ss']) || stripos(' ' . $_view[1], $_post['ss'])) {
                    $_dmss[$db] = $_view;
                }
            }
            if (count($_dmss) > 0) {

                $dat             = array();
                $dat[1]['title'] = 'module';
                $dat[1]['width'] = '5%';
                $dat[2]['title'] = 'dashboard';
                $dat[2]['width'] = '35%;';
                $dat[3]['title'] = 'help';
                $dat[3]['width'] = '50%';
                $dat[4]['title'] = 'view';
                $dat[4]['width'] = '10%';
                jrCore_page_table_header($dat);

                foreach ($_dmss as $db => $_view) {
                    $dat             = array();
                    $dat[1]['title'] = jrCore_get_module_icon_html('jrCore', 48);
                    $dat[2]['title'] = "<h3>{$db}</h3>";
                    $dat[3]['title'] = $_view[1];
                    $dat[4]['title'] = jrCore_page_button("s{$db}", 'view', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_view[0]}')");
                    $dat[4]['class'] = 'center';
                    jrCore_page_table_row($dat, null, $_view);
                }
                jrCore_page_table_footer();
            }
        }

        // Show matching modules or skins
        if (count($_mi) > 0) {
            $dat = array();
            if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                $dat[1]['title'] = 'skin';
                $tag             = 'skin name';
            }
            else {
                $dat[1]['title'] = 'module';
                $tag             = 'module name';
            }
            $dat[1]['width'] = '5%';
            $dat[2]['title'] = $tag;
            $dat[2]['width'] = '35%';
            $dat[3]['title'] = 'description';
            $dat[3]['width'] = '50%';
            $dat[4]['title'] = 'info';
            $dat[4]['width'] = '10%';
            jrCore_page_table_header($dat);

            foreach ($_mi as $dir => $name) {
                $dat             = array();
                $dat[2]['title'] = "<h3>{$name}</h3>";
                $dat[3]['title'] = $_mods[$dir]['module_description'];
                if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                    $dat[1]['title'] = jrCore_get_skin_icon_html($dir, 48);
                    $dat[4]['title'] = jrCore_page_button("v{$dir}", 'info', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_mods['jrCore']['module_url']}/skin_admin/info/skin={$dir}')");
                }
                else {
                    $dat[1]['title'] = jrCore_get_module_icon_html($dir, 48);
                    $dat[4]['title'] = jrCore_page_button("v{$dir}", 'info', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_mods[$dir]['module_url']}/admin/info')");
                }
                $dat[4]['class'] = 'center';
                jrCore_page_table_row($dat, null, $_mods[$dir]);
            }
            jrCore_page_table_footer();
        }

        if ($_cf && is_array($_cf)) {

            // Prune out ones we are not going to show
            foreach ($_cf as $k => $_fld) {
                if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                    if (!is_dir(APP_DIR . "/skins/{$_fld['module']}")) {
                        unset($_cf[$k]);
                    }
                }
                else {
                    if (!is_dir(APP_DIR . "/modules/{$_fld['module']}") || !jrCore_module_is_active($_fld['module'])) {
                        unset($_cf[$k]);
                    }
                }
            }
            if (count($_cf) > 0) {

                $dat = array();
                if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                    $dat[1]['title'] = 'skin';
                }
                else {
                    $dat[1]['title'] = 'module';
                }
                $dat[1]['width'] = '5%;';
                $dat[2]['title'] = 'config option';
                $dat[2]['width'] = '35%;';
                $dat[3]['title'] = 'help';
                $dat[3]['width'] = '50%;';
                $dat[4]['title'] = 'modify';
                $dat[4]['width'] = '10%;';
                jrCore_page_table_header($dat);

                foreach ($_cf as $_fld) {

                    if (!isset($_fld['section']) || strlen($_fld['section']) === 0) {
                        $_fld['section'] = 'general settings';
                    }
                    $dat = array();
                    if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                        if (!is_dir(APP_DIR . "/skins/{$_fld['module']}")) {
                            continue;
                        }
                        $dat[1]['title'] = '<img src="' . jrCore_get_base_url() . '/skins/' . $_fld['module'] . '/icon.png" alt="' . $_fld['module'] . '" title="' . $_fld['module'] . '" width="48" height="48">';
                        $dat[4]['title'] = jrCore_page_button("m{$_fld['name']}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/global/skin={$_fld['module']}/section=" . urlencode($_fld['section']) . "/hl={$_fld['name']}')");
                    }
                    else {
                        if (!is_dir(APP_DIR . "/modules/{$_fld['module']}") || !jrCore_module_is_active($_fld['module'])) {
                            continue;
                        }
                        $murl            = jrCore_get_module_url($_fld['module']);
                        $dat[1]['title'] = jrCore_get_module_icon_html($_fld['module'], 48);
                        $dat[4]['title'] = jrCore_page_button("m{$_fld['name']}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$murl}/admin/global/section=" . urlencode($_fld['section']) . "/hl={$_fld['name']}')");
                    }
                    $dat[1]['class'] = 'center';
                    if (isset($_fld['section'])) {
                        $dat[2]['title'] = '<h3>' . ucwords($_fld['section']) . ' &raquo; ' . ucwords($_fld['label']) . '</h3>';
                    }
                    else {
                        $dat[2]['title'] = '<h3>' . ucwords($_fld['label']) . '</h3>';
                    }
                    $dat[3]['title'] = $_fld['help'];
                    $dat[4]['class'] = 'center';
                    jrCore_page_table_row($dat, null, $_fld);
                }
                jrCore_page_table_footer();
            }
        }

        if (!isset($_post['sa']) || $_post['sa'] != 'skin') {
            $tbl = jrCore_db_table_name('jrProfile', 'quota_setting');
            $req = "SELECT * FROM {$tbl} WHERE (`module` LIKE '%{$src}%' OR `name` LIKE '%{$src}%' OR `label` LIKE '%{$src}%' OR `help` LIKE '%{$src}%') AND `type` != 'hidden' AND module IN('" . implode("','", array_keys($_mods)) . "') ORDER BY `module` ASC, `label` ASC";
            $_cf = jrCore_db_query($req, 'NUMERIC');

            if ($_cf && is_array($_cf) && count($_cf) > 0) {

                // Prune out ones we are not going to show
                foreach ($_cf as $k => $_fld) {
                    if (isset($_post['sa']) && $_post['sa'] == 'skin') {
                        if (!is_dir(APP_DIR . "/skins/{$_fld['module']}")) {
                            unset($_cf[$k]);
                        }
                    }
                    else {
                        if (!is_dir(APP_DIR . "/modules/{$_fld['module']}") || !jrCore_module_is_active($_fld['module'])) {
                            unset($_cf[$k]);
                        }
                    }
                }
                if (count($_cf) > 0) {
                    $dat             = array();
                    $dat[1]['title'] = 'module';
                    $dat[1]['width'] = '5%;';
                    $dat[2]['title'] = 'quota option';
                    $dat[2]['width'] = '35%;';
                    $dat[3]['title'] = 'help';
                    $dat[3]['width'] = '50%;';
                    $dat[4]['title'] = 'modify';
                    $dat[4]['width'] = '10%;';
                    jrCore_page_table_header($dat);

                    foreach ($_cf as $_fld) {
                        if (!is_dir(APP_DIR . "/modules/{$_fld['module']}") || !jrCore_module_is_active($_fld['module'])) {
                            continue;
                        }
                        $fnd             = true;
                        $dat             = array();
                        $dat[1]['title'] = jrCore_get_module_icon_html($_fld['module'], 48);
                        $dat[1]['class'] = 'center';
                        $dat[2]['title'] = '<h3>' . ucwords($_fld['label']) . '</h3>';
                        $dat[3]['title'] = $_fld['help'];
                        $murl            = jrCore_get_module_url($_fld['module']);
                        $dat[4]['title'] = jrCore_page_button("m{$_fld['name']}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$murl}/admin/quota/hl={$_fld['name']}#ff-{$_fld['name']}')");
                        $dat[4]['class'] = 'center';
                        jrCore_page_table_row($dat, null, $_fld);
                    }
                    jrCore_page_table_footer();
                }
            }

            // Tools
            if (!isset($_post['sa']) || $_post['sa'] != 'skin') {
                $_tool = jrCore_get_registered_module_features('jrCore', 'tool_view');
                $_show = array();
                if ($_tool && is_array($_tool)) {
                    foreach ($_tool as $tool_mod => $_tools) {
                        foreach ($_tools as $view => $_inf) {
                            if (stristr($_inf[0], $_post['ss']) || stristr($_inf[1], $_post['ss'])) {
                                $fnd     = true;
                                $_show[] = array(
                                    'module' => $tool_mod,
                                    'view'   => $view,
                                    'label'  => $_inf[0],
                                    'help'   => $_inf[1]
                                );
                            }
                        }
                    }
                    if (count($_show) > 0) {

                        $dat             = array();
                        $dat[1]['title'] = 'module';
                        $dat[1]['width'] = '5%;';
                        $dat[2]['title'] = 'tool name';
                        $dat[2]['width'] = '35%;';
                        $dat[3]['title'] = 'help';
                        $dat[3]['width'] = '50%;';
                        $dat[4]['title'] = 'view';
                        $dat[4]['width'] = '10%;';
                        jrCore_page_table_header($dat);

                        foreach ($_show as $k => $_fld) {
                            if (!is_dir(APP_DIR . "/modules/{$_fld['module']}") || !jrCore_module_is_active($_fld['module'])) {
                                continue;
                            }
                            $dat             = array();
                            $dat[1]['title'] = jrCore_get_module_icon_html($_fld['module'], 48);
                            $dat[1]['class'] = 'center';
                            $dat[2]['title'] = '<h3>' . ucwords($_fld['label']) . '</h3>';
                            $dat[3]['title'] = $_fld['help'];
                            $murl            = jrCore_get_module_url($_fld['module']);
                            if (strpos($_fld['view'], 'http') !== 0) {
                                $dat[4]['title'] = jrCore_page_button("m{$k}", 'view', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$murl}/{$_fld['view']}')");
                            }
                            else {
                                $dat[4]['title'] = jrCore_page_button("m{$k}", 'view', "jrCore_window_location('{$_fld['view']}')");
                            }
                            $dat[4]['class'] = 'center';
                            jrCore_page_table_row($dat, null, $_fld);
                        }
                        jrCore_page_table_footer();
                    }
                }
            }
        }

        if (!$fnd) {
            $dat             = array();
            $dat[1]['title'] = 'No results found to match your search criteria';
            $dat[1]['class'] = 'p20 center';
            jrCore_page_table_row($dat);
            jrCore_page_table_footer();
        }
    }
    jrCore_page_display();
}
