<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: performance_check
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_performance_check($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');

    // See if we have an existing value
    $btn = jrCore_page_button('help', 'performance check details', '$(\'#performance_notice\').slideToggle(300)');

    $tbl = jrCore_db_table_name('jrCore', 'performance');
    $req = "SELECT * FROM {$tbl} ORDER BY p_id DESC LIMIT 1";
    $_tm = jrCore_db_query($req, 'SINGLE');
    if ($_tm && is_array($_tm)) {
        $btn .= jrCore_page_button('performance', 'history', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/performance_history');");
    }

    $share = false;
    // If we are properly configured for the Marketplace, let the user submit a result
    if (jrCore_module_is_active('jrMarket')) {
        if ($_mkt = jrMarket_get_active_release_system()) {
            if (isset($_mkt['system_url']) && strpos($_mkt['system_url'], 'jamroom.net')) {
                $share = true;
            }
        }
    }

    jrCore_page_banner('performance check', $btn);
    jrCore_set_form_notice('notice', "The Performance Check will run a series of performance tests to assess how well Jamroom is likely to<br>perform on your server - it is recommended to run this test at a low traffic time on your server.", false);
    jrCore_get_form_notice();

    $note = '<div id="performance_notice" class="notice" style="padding: 10px 20px;display:none"><div class="item rounded p20">The Performance Check tests 3 separate components of your server to try and give you an idea of how well Jamroom will run on your server:<br><br><strong>Processor Test</strong> &nbsp;&bull;&nbsp; The Processor Test runs a series of calculations on your server processor (CPU) to see how quickly it can finish.  Processor speed is important as it determines how quickly the Jamroom PHP code can be executed.<br><br><strong>Database Test</strong> &nbsp;&bull;&nbsp; The Database Test executes 10,000 separate queries on the database server using the DataStore format.  This test is an important indicator of how fast Jamroom will run on your server.<br><br><strong>Filesystem Test</strong> &nbsp;&bull;&nbsp; The Filesystem Test tests how quickly files can be created and deleted on the Filesystem (the server hard drive).  Having a high speed SSD disk for your server filesystem can really boost Jamroom performance.</div></div>';
    jrCore_page_custom($note);

    if ($_tm && is_array($_tm)) {

        $_tm = json_decode($_tm['p_val'], true);

        $_inf = jrCore_get_proc_info();
        $pnum = count($_inf);

        $type = 'MySQL';
        $_db  = jrCore_db_query("SHOW VARIABLES WHERE Variable_name = 'version'", 'SINGLE');
        if ($_db && is_array($_db) && isset($_db['Value'])) {
            $ver = $_db['Value'];
            if (stripos($ver, 'maria')) {
                $type = 'MariaDB';
            }
        }
        else {
            $msi = jrCore_db_connect();
            $ver = mysqli_get_server_info($msi);
        }
        if (strpos($ver, '-')) {
            list($ver,) = explode('-', $ver);
        }
        $_dsk = jrCore_get_disk_usage();

        // Our "baseline" for a high performance systems is 6.00
        // $_tm = array( cpu, db, fs, total)
        $bonus = '';
        $total = round((10 / $_tm['total']) * 800);
        if ($pnum > 1) {
            $bonus = round(($total / (8 + $pnum)) * ($pnum / 2));
            $total += $bonus;
            $bonus = '<br>includes ' . jrCore_number_format($bonus) . ' point multiple processor bonus<br>';
        }

        // Baselines...
        $_bs = array(
            'cpu' => '0.5',
            'db'  => '6.5',
            'fs'  => '1.0'
        );

        // baselines:
        // cpu = 2
        // db = 6
        // fs = 4

        $cpu       = round($_tm['cpu'], 2);
        $cpu_class = '';
        if ($cpu > ($_bs['cpu'] * 4)) {
            $cpu_class = ' bigsystem-maj';
        }
        $db_class = '';
        $db       = round($_tm['db'], 2);
        if ($db > ($_bs['db'] * 4)) {
            $db_class = ' bigsystem-maj';
        }
        $fs_class = '';
        $fs       = round($_tm['fs'], 2);
        if ($fs > ($_bs['fs'] * 4)) {
            $fs_class = ' bigsystem-maj';
        }

        $msg = 'success';
        $txt = 'Jamroom should run <strong>excellent</strong> on your server!';
        if ($total < 200) {
            $msg = 'error';
            $txt = 'Jamroom will run <strong>very slowly</strong> on your server - check out hosting alternatives';
        }
        elseif ($total < 300) {
            $msg = 'error';
            $txt = 'Jamroom is <strong>likely to run slowly</strong> on your server - check out hosting alternatives';
        }
        elseif ($total < 500) {
            $msg = 'notice';
            $txt = 'Jamroom <strong>may run slowly</strong> on your server - check out tips on improving performance';
        }
        elseif ($total < 750) {
            $msg = 'notice';
            $txt = 'Jamroom <strong>may run a bit slower than optimal</strong> on your server';
        }
        $btn = '';
        if ($share) {
            $btn = jrCore_page_button('share', 'share your results', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/performance_share');");
        }
        $htm = '<div style="padding:12px;">
        <table class="page_table bigtable" style="width:100%">
        <tr><th class="page_table_header" style="width:20%">Test</th>
            <th class="page_table_header" style="width:35%">Test Time in Seconds<br><small style="font-weight:normal">Lower is Better</small></th>
            <th class="page_table_header" style="width:45%">Overall Score<br><small style="font-weight:normal">Higher is Better</small></th></tr>
        <tr><td class="page_table_header">Processor<br><span style="color:#888;font-weight:normal">' . $pnum . ' @' . $_inf[1]['mhz'] . '</span></td><td class="page_table_cell bignum bignum2' . $cpu_class . '">' . $cpu . '<br><span>Baseline: ' . $_bs['cpu'] . ' seconds</td>
        <td class="page_table_cell bignum bignum1" rowspan="3"><big>' . jrCore_number_format($total) . '</big><span>' . $bonus . '<br>' . $btn . '</span></td></tr>
        <tr><td class="page_table_header">Database<br><span style="color:#888;font-weight:normal">' . $type . ' ' . $ver . '</span></td><td class="page_table_cell bignum bignum3' . $db_class . '">' . $db . '<br><span>Baseline: ' . $_bs['db'] . ' seconds</span></td></tr>
        <tr><td class="page_table_header">Filesystem<br><span style="color:#888;font-weight:normal">In Use: ' . $_dsk['percent_used'] . '%</span></td><td class="page_table_cell bignum bignum4' . $fs_class . '">' . $fs . '<br><span>Baseline: ' . $_bs['fs'] . ' seconds</span></td></tr>
        </table>' . $txt . '<br><small>Baseline is a <a href="http://www.jamroom.net/hosting"><u>Jamroom Hosted</u></a> Server with 1 CPU @ 2.5GHz, 1 GB RAM and Fast SSD Disk</small></div>';
        jrCore_set_form_notice($msg, $htm, false);
        jrCore_get_form_notice();
    }

    $_tmp = array(
        'submit_value'  => 'run performance check',
        'cancel'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'submit_prompt' => 'Please be patient - depending on the speed of your servers this could take a few minutes to run'
    );
    jrCore_form_create($_tmp);

    // New Menu Entry
    $_tmp = array(
        'name'  => 'hidden',
        'type'  => 'hidden',
        'value' => 1
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
