<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: pending_item_reject_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_pending_item_reject_save($_post, $_user, $_conf)
{
    jrUser_admin_only();
    if (!isset($_post['pending_id']) || !jrCore_checktype($_post['pending_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid pending_id');
        jrCore_form_result();
    }
    $pid = (int) $_post['pending_id'];
    $tbl = jrCore_db_table_name('jrCore', 'pending');
    $req = "SELECT * FROM {$tbl} WHERE pending_id = {$pid}";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid pending_id - data not found');
        jrCore_form_result();
    }
    // Get item
    $_it = jrCore_db_get_item($_rt['pending_module'], $_rt['pending_item_id']);
    if (!$_it || !is_array($_it)) {
        jrCore_set_form_notice('error', 'Invalid item - unable to retrieve data from DataStore');
        jrCore_form_result();
    }

    // Save any new reject message
    $_rs = array();
    if (isset($_post['new_reject_reason']) && strlen($_post['new_reject_reason']) > 0) {
        $rsn = jrCore_db_escape($_post['new_reject_reason']);
        $tb2 = jrCore_db_table_name('jrCore', 'pending_reason');
        $req = "INSERT INTO {$tb2} (reason_key,reason_text) VALUES ('" . md5($_post['new_reject_reason']) . "','{$rsn}')";
        $cnt = jrCore_db_query($req, 'COUNT');
        if ($cnt !== 1) {
            jrCore_set_form_notice('error', 'Unable to store new pending reason - please try again');
            jrCore_form_result();
        }
        $_rs[] = jrCore_strip_html($_post['new_reject_reason']);
    }

    // See if we received any canned rejection notices
    $tb2 = jrCore_db_table_name('jrCore', 'pending_reason');
    $req = "SELECT * FROM {$tb2}";
    $_pr = jrCore_db_query($req, 'reason_key', false, 'reason_text');
    foreach ($_post as $k => $v) {
        if (strpos($k, 'reject_reason_') === 0 && $v == 'on') {
            $key = substr($k, 14);
            if (isset($_pr[$key])) {
                $_rs[] = $_pr[$key];
            }
        }
    }
    $reason = implode("\n", $_rs);

    // Trigger reject pending event
    $_args = array(
        'module'   => $_rt['pending_module'],
        '_item_id' => $_rt['pending_item_id'],
        '_item'    => $_it
    );
    jrCore_trigger_event('jrCore', 'reject_pending_item', $_rt, $_args);

    // Update item with rejected info
    $pfx = jrCore_db_get_prefix($_rt['pending_module']);
    $_up = array(
        "{$pfx}_pending"        => 2,
        "{$pfx}_pending_reason" => $reason
    );
    if (isset($_post['reject_message']) && strlen($_post['reject_message']) > 1) {
        $_up["{$pfx}_pending_reason"] .= "\n{$_post['reject_message']}";
    }
    jrCore_db_update_item($_rt['pending_module'], $_rt['pending_item_id'], $_up);

    // [pending_id] => 17
    // [reject_reason_d86c579c827fec297d69e58e4c06cfa2] => on
    // [reject_reason_e37bbbb8065ecdc1d34cf3e98f37e8a3] => on
    // [new_reject_reason] => NEW REASON
    // [reject_message] => MESSAGE

    // Send Reject email
    $deleted = '';
    if (isset($_it['_profile_id']) && jrCore_checktype($_it['_profile_id'], 'number_nz')) {

        switch ($_rt['pending_module']) {
            // this is an ACTION it is deleted (since they cannot be edited)
            case 'jrAction':
                $_post['reject_delete'] = 'on';
                $email_template         = 'pending_reject_deleted';
                $deleted                = ' and deleted';
                break;
            default:
                if (isset($_post['reject_delete']) && $_post['reject_delete'] == 'on') {
                    $email_template = 'pending_reject_deleted';
                    $deleted        = ' and deleted';
                }
                else {
                    $email_template = 'pending_reject';
                }
                break;
        }
        $_em = jrProfile_get_owner_email($_it['_profile_id']);
        if ($_em && is_array($_em)) {
            $_mi                   = jrCore_get_module_info($_rt['pending_module']);
            $url                   = jrCore_get_item_url('detail', $_rt['pending_module'], $_it);
            $_rp                   = $_it;
            $_rp['system_name']    = jrCore_get_config_value('jrCore', 'system_name', '');
            $_rp['module']         = $_rt['pending_module'];
            $_rp['module_name']    = $_mi['module_name'];
            $_rp['item_title']     = jrCore_get_item_title($_rt['pending_module'], $_it);
            $_rp['item_url']       = $url;
            $_rp['reject_reason']  = $reason;
            $_rp['reject_message'] = jrCore_strip_html($_post['reject_message']);
            $_rp['reject_url']     = $url;  // @deprecated don't use in template - use item_url
            list($sub, $msg) = jrCore_parse_email_templates('jrCore', $email_template, $_rp);
            foreach ($_em as $email) {
                jrCore_send_email($email, $sub, $msg);
            }
        }
    }

    // Cleanup pending entry
    $req = "DELETE FROM {$tbl} WHERE pending_id = '{$_rt['pending_id']}' LIMIT 1";
    jrCore_db_query($req, 'COUNT');

    // Delete item if needed
    if (isset($_post['reject_delete']) && $_post['reject_delete'] == 'on') {
        jrCore_db_delete_item($_rt['pending_module'], $_rt['pending_item_id']);
        jrCore_db_delete_pending_item_ids_cache($_rt['pending_module']);
    }
    jrCore_form_delete_session();

    // Refresh
    $url = jrCore_get_module_url($_rt['pending_module']);
    if (isset($reason) && isset($_rp)) {
        unset($_rp['system_name']);
        jrCore_logger('INF', "core: {$_it['profile_url']}/{$url}/{$_it['_item_id']} has been rejected{$deleted}", array('reason' => $reason, '_data' => $_rp));
    }
    else {
        jrCore_logger('INF', "core: {$_it['profile_url']}/{$url}/{$_it['_item_id']} has been rejected{$deleted}");
    }
    jrCore_set_form_notice('success', 'The item was successfully rejected');
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/dashboard/pending/m={$_rt['pending_module']}");
}
