<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: module_detail_feature_order
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_module_detail_feature_order($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    // [_1] => jrTags~item_tags
    // [_2] => 1 (current order)
    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_set_form_notice('error', 'Invalid item detail feature');
        jrCore_location('referrer');
    }
    $nam = trim($_post['_1']);
    list($mod, $feat) = explode('~', $nam);
    $_tmp = jrCore_get_registered_module_features('jrCore', 'item_detail_feature');
    if (!$_tmp || !is_array($_tmp) || !isset($_tmp[$mod]) || !isset($_tmp[$mod][$feat])) {
        jrCore_set_form_notice('error', 'Invalid item feature - feature is not registered');
        jrCore_location('referrer');
    }
    $idx  = (int) $_post['_2'];
    $_cfg = array();
    $_don = array();
    if (isset($_conf['jrCore_detail_feature_order']) && strlen($_conf['jrCore_detail_feature_order']) > 0) {
        $_cfg = explode(',', $_conf['jrCore_detail_feature_order']);
        if (isset($_cfg) && is_array($_cfg)) {
            foreach ($_cfg as $k => $v) {
                $_don[$v] = 1;
                $tmp      = ($idx - 1);
                if ($k == $tmp) {
                    // We have found our swap
                    $_cfg[$idx] = $v;
                    $_cfg[$tmp] = $nam;
                }
            }
        }
    }
    // Add in reset of detail features
    foreach ($_tmp as $mod => $_ft) {
        foreach ($_ft as $name => $_ftr) {
            $nam = "{$mod}~{$name}";
            if (!isset($_don[$nam])) {
                $_cfg[] = $nam;
            }
        }
    }
    jrCore_set_setting_value('jrCore', 'detail_feature_order', implode(',', $_cfg));
    jrCore_delete_config_cache();
    if (jrCore_checktype($_conf['jrCore_default_cache_seconds'], 'number_nz')) {
        jrCore_set_form_notice('success', 'The item feature order has been updated.<br>Make sure and <a href="' . jrCore_get_base_url() . '/' . $_post['module_url'] . '/cache_reset"><u>Reset Caches</u></a> for your changes to take effect', false);
    }
    else {
        jrCore_set_form_notice('success', 'The item feature order has been updated');
    }
    jrCore_location('referrer');
}
