<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: live_search_options
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_live_search_options($_post, $_user, $_conf)
{
    $_rp = array();
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_json_response($_rp);
    }
    if (!isset($_post['o']) || strlen($_post['o']) === 0) {
        jrCore_json_response($_rp);
    }
    if (!isset($_post['n']) || strlen($_post['n']) === 0) {
        jrCore_json_response($_rp);
    }
    $_fl = jrCore_get_designer_form_fields($_post['m'], $_post['o']);
    if ($_fl && isset($_fl["{$_post['n']}"]) && isset($_fl["{$_post['n']}"]['options']) && strlen($_fl["{$_post['n']}"]['options']) > 0) {
        $opt = $_fl["{$_post['n']}"]['options'];
        if (function_exists($opt)) {
            $_rp = $opt($_post['q']);
        }
        else {
            $opt = explode("\n", $opt);
            if ($opt && is_array($opt)) {
                foreach ($opt as $v) {
                    if (stripos(' ' . $v, $_post['q'])) {
                        if (strpos($v, '|')) {
                            list($kk, $kv) = explode('|', $v);
                            $kk       = trim($kk);
                            $_rp[$kk] = trim($kv);
                        }
                        else {
                            $v       = trim($v);
                            $_rp[$v] = $v;
                        }
                    }
                }
            }
        }
    }
    return jrCore_live_search_results($_post['n'], $_rp);
}
