<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: integrity_check_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_integrity_check_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    @ini_set('max_execution_time', 28800); // 8 hours max
    @ini_set('memory_limit', '1024M');

    jrCore_logger('INF', 'core: integrity check started');

    // Check for Repair Tables first
    if (isset($_post['repair_tables']) && $_post['repair_tables'] == 'on') {
        $_rt = jrCore_db_query('SHOW TABLES', 'NUMERIC');
        if ($_rt && is_array($_rt)) {
            $_dn = array();
            foreach ($_rt as $tbl) {
                $tbl = reset($tbl);
                if (!isset($_dn[$tbl])) {
                    jrCore_form_modal_notice('update', "repairing table: {$tbl}");
                    jrCore_db_query("REPAIR TABLE {$tbl}");
                    $_dn[$tbl] = 1;
                }
            }
            unset($_dn);
        }
    }
    // Did we select individual modules for repair?
    elseif (!empty($_post['repair_tables_module'])) {
        if ($_modules = explode(',', $_post['repair_tables_module'])) {
            $_rt = jrCore_db_query('SHOW TABLES', 'NUMERIC');
            foreach ($_modules as $mod_dir) {
                foreach ($_rt as $tbl) {
                    $tbl = reset($tbl);
                    if (!isset($_dn[$tbl]) && strpos($tbl, '_' . strtolower($mod_dir) . '_')) {
                        jrCore_form_modal_notice('update', "repairing table: {$tbl}");
                        jrCore_db_query("REPAIR TABLE {$tbl}");
                        $_dn[$tbl] = 1;
                    }
                }
            }
            unset($_dn);
        }
    }

    // Database schema validation - comes first
    if (isset($_post['validate_schema']) && $_post['validate_schema'] == 'on') {
        jrCore_validate_module_schema('jrCore');
        foreach ($_mods as $mod_dir => $_inf) {
            if ($mod_dir !== 'jrCore') {
                jrCore_form_modal_notice('update', "verifying database schema: " . $_inf['module_name']);
                jrCore_validate_module_schema($mod_dir);
            }
        }
    }

    // Module install validation
    if (isset($_post['validate_modules']) && $_post['validate_modules'] == 'on') {
        jrCore_check_for_dead_queue_workers();
        jrCore_validate_queue_info();
        jrCore_validate_queue_data();
        foreach ($_mods as $mod_dir => $_inf) {
            jrCore_form_modal_notice('update', "verifying module: " . $_inf['module_name']);
            jrCore_verify_module($mod_dir, null, false, true, false, false);
        }
    }

    // Skin install validation
    if (isset($_post['validate_skins']) && $_post['validate_skins'] == 'on') {
        if ($_rt = jrCore_get_skins()) {
            foreach ($_rt as $skin_dir) {
                $_mta = jrCore_skin_meta_data($skin_dir);
                $name = (isset($_mta['title'])) ? $_mta['title'] : $skin_dir;
                jrCore_form_modal_notice('update', "verifying skin: {$name}");
                jrCore_verify_skin($skin_dir);
            }
        }
    }

    // Verify languages
    if (isset($_post['validate_language']) && $_post['validate_language'] == 'on') {
        foreach ($_mods as $mod_dir => $_inf) {
            if (is_dir(APP_DIR . "/modules/{$mod_dir}/lang")) {
                jrCore_form_modal_notice('update', "verify module languages: " . $_inf['module_name']);
                jrUser_install_lang_strings('module', $mod_dir);
            }
        }
        if ($_rt = jrCore_get_skins(true)) {
            foreach ($_rt as $skin_dir => $skin_name) {
                if (is_dir(APP_DIR . "/skins/{$skin_dir}/lang")) {
                    jrCore_form_modal_notice('update', "verifying skin languages: " . $skin_name);
                    jrUser_install_lang_strings('skin', $skin_dir);
                }
            }
        }
    }

    // Module repair
    if (isset($_post['repair_modules']) && $_post['repair_modules'] == 'on') {
        foreach ($_mods as $mod_dir => $_inf) {
            jrCore_form_modal_notice('update', "repairing module: " . $_inf['module_name']);
            // Repair module DS
            if (jrCore_is_datastore_module($mod_dir)) {
                jrCore_db_repair_datastore($mod_dir);
            }
            jrCore_trigger_event('jrCore', 'repair_module', $_post, $_inf, $mod_dir);
        }

        // Kick of db repair queue
        $_queue = array('_post' => $_post);
        jrCore_queue_create('jrCore', 'repair_module_db', $_queue, 0, null, 1);
    }

    // Did we select individual modules for repair?
    elseif (!empty($_post['repair_modules_module'])) {
        if ($_modules = explode(',', $_post['repair_modules_module'])) {
            foreach ($_modules as $mod_dir) {
                jrCore_form_modal_notice('update', "repairing module: " . $_mods[$mod_dir]['module_name']);
                if (jrCore_is_datastore_module($mod_dir)) {
                    jrCore_db_repair_datastore($mod_dir);
                }
                jrCore_trigger_event('jrCore', 'repair_module', $_post, $_mods[$mod_dir], $mod_dir);
            }
        }
    }

    // Optimize Tables
    if (isset($_post['optimize_tables']) && $_post['optimize_tables'] == 'on') {
        $_rt = jrCore_db_query('SHOW TABLES', 'NUMERIC');
        if ($_rt && is_array($_rt)) {
            $_dn = array();
            foreach ($_rt as $tbl) {
                $tbl = reset($tbl);
                if (!isset($_dn[$tbl])) {
                    jrCore_form_modal_notice('update', "optimizing table: {$tbl}");
                    jrCore_db_query("OPTIMIZE TABLE {$tbl}");
                    $_dn[$tbl] = 1;
                }
            }
            unset($_dn);
        }
    }

    // Reset Caches
    if (isset($_post['reset_caches']) && $_post['reset_caches'] == 'on') {

        // Rebuild master CSS and JS
        jrCore_create_master_css($_conf['jrCore_active_skin']);
        jrCore_create_master_javascript($_conf['jrCore_active_skin']);

        jrCore_delete_all_cache_entries();
        jrCore_reset_template_cache();

        jrCore_form_modal_notice('update', "cache reset: database and template caches reset");
    }

    jrCore_form_delete_session();
    jrCore_logger('INF', 'core: integrity check completed');
    jrCore_form_modal_notice('complete', 'The integrity check options were successfully completed');
    jrCore_send_response_and_detach();
}
