<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: download_file
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_download($_post, $_user, $_conf)
{
    // When a download request comes in, it will look like:
    // http://www.site.com/song/download/audio_file/5
    // so we have URL / module / option / _1 / _2
    if (!isset($_post['_2']) || !is_numeric($_post['_2'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id');
    }

    // Make sure this is a DataStore module
    if (!$pfx = jrCore_db_get_prefix($_post['module'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid module - no datastore');
    }

    // Get DS item
    // @note: jrListParams has been deprecated
    if (!$_rt = jrCore_db_get_item($_post['module'], $_post['_2'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id - item not found', false);
    }

    if (!isset($_rt["{$_post['_1']}_size"]) || $_rt["{$_post['_1']}_size"] < 1) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id - item size is empty');
    }

    // Build download file
    $_rt['download_file'] = "{$_post['module']}_{$_post['_2']}_{$_post['_1']}." . $_rt["{$_post['_1']}_extension"];

    // "download_file" event trigger
    $_args = array(
        'module'    => $_post['module'],
        'file_name' => $_post['_1'],
        'item_id'   => $_post['_2'],
        'file'      => $_rt['download_file']
    );
    $_rt   = jrCore_trigger_event('jrCore', 'download_file', $_rt, $_args);
    if (isset($_rt['download_block']) && jrCore_checktype($_rt['download_block'], 'is_true')) {
        // We have been blocked by the listener
        jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
        jrCore_set_custom_header('Connection: close');
        jrCore_notice('Error', 'you do not have permission to download this file');
    }

    // Non admin checks
    if (!jrUser_can_edit_item($_rt)) {

        // Make sure file is NOT for sale
        if (isset($_rt["{$_post['_1']}_item_price"]) && $_rt["{$_post['_1']}_item_price"] > 0) {
            jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
            jrCore_notice('Error', 'invalid media item - item must be purchased to be downloaded');
        }

        // Privacy Checking for this profile
        if (isset($_rt['profile_private']) && $_rt['profile_private'] != '1') {
            // Privacy Check (Sub Select) - non admin users
            // 0 = Private
            // 1 = Global
            // 2 = Shared
            if ($_rt['profile_private'] == '0') {
                if (!jrProfile_is_profile_owner($_rt['_profile_id'])) {
                    // We have a private profile and this is not the owner
                    jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                    jrCore_set_custom_header('Connection: close');
                    jrCore_notice('Error', 'you do not have permission to download this file (2)');
                }
            }

            // We're shared - viewer must be a follower of the profile
            elseif (jrCore_module_is_active('jrFollower')) {
                if (jrFollower_is_follower($_user['_user_id'], $_rt['_profile_id']) === false) {
                    // We are not a follower of this profile - not allowed
                    jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                    jrCore_set_custom_header('Connection: close');
                    jrCore_notice('Error', 'you do not have permission to download this file');
                }
            }
            else {
                // Shared by followers not enabled
                jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                jrCore_set_custom_header('Connection: close');
                jrCore_notice('Error', 'you do not have permission to download this file');
            }
        }
    }

    // Check that file exists
    if (!jrCore_media_file_exists($_rt['_profile_id'], $_rt['download_file'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id - no file found');
    }

    $fname = $_rt['download_file'];
    $field = $_post['_1'];
    // Did our listener changed the download file name?
    if (!empty($_rt['download_file_name'])) {
        $fname = $_rt['download_file_name'];
    }
    elseif (isset($_rt["{$pfx}_title_url"]) && strlen($_rt["{$pfx}_title_url"]) > 0 && !empty($_rt["{$field}_extension"])) {
        $fname = str_replace('.' . $_rt["{$field}_extension"], '', $_rt["{$pfx}_title_url"]) . '-' . jrCore_url_string($field) . '.' . $_rt["{$_post['_1']}_extension"];
    }
    elseif (isset($_rt["{$field}_name"]) && strlen($_rt["{$field}_name"]) > 0) {
        $fname = jrCore_url_string($_rt["{$field}_name"], '.');
    }
    elseif (isset($_rt["{$field}_original_name"]) && strlen($_rt["{$field}_original_name"]) > 0) {
        $fname = jrCore_url_string($_rt["{$field}_original_name"], '.');
    }

    // Increment our counter
    if (!isset($_rt['skip_download_count'])) {
        jrCore_counter($_post['module'], $_post['_2'], "{$field}_download");
    }

    // Download the file to the client
    jrCore_media_file_download($_rt['_profile_id'], $_rt['download_file'], $fname);
    jrCore_exit();
}
