<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browser_item_update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_browser_item_update_save($_post, $_user, $_conf)
{
    jrUser_admin_only();
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid item id');
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item($_post['module'], $_post['id'], SKIP_TRIGGERS);
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Unable to retrieve item from DataStore - please try again');
        jrCore_form_result();
    }
    $refresh = false;
    $_upd    = array();
    foreach ($_post as $k => $v) {
        if (strpos($k, 'ds_key_') === 0) {
            switch ($k) {
                // Only the Master Admin can change the user_group
                case 'ds_key_user_group':
                    if (!jrUser_is_master()) {
                        continue 2;
                    }
                    break;
                case 'ds_key_user_password':
                    continue 2;
            }
            $k = substr($k, 7);
            if (isset($_rt[$k]) && ($_rt[$k] != $v || strlen($v) === 0)) {
                // See if we are removing fields....
                if (strlen($v) === 0) {
                    // Remove field
                    $refresh = true;
                    jrCore_db_delete_item_key($_post['module'], $_post['id'], $k);
                }
                else {
                    $_upd[$k] = $v;
                }
            }
        }
    }

    // Check for new Value..
    if (!empty($_post['ds_browser_new_key'])) {
        // Make sure it begins with our DS prefix
        $pfx = jrCore_db_get_prefix($_post['module']);
        if (strpos($_post['ds_browser_new_key'], $pfx) !== 0) {
            jrCore_set_form_notice('error', "Invalid new key name - must begin with <strong>{$pfx}_</strong>", false);
            jrCore_form_field_hilight('ds_browser_new_key');
            jrCore_form_result();
        }
        elseif (!jrCore_checktype($_post['ds_browser_new_key'], 'core_string')) {
            $err = jrCore_checktype_core_string(null, true);
            jrCore_set_form_notice('error', "Invalid new key name - must contain {$err} only");
            jrCore_form_field_hilight('ds_browser_new_key');
            jrCore_form_result();
        }
        // Make sure it is NOT a restricted key
        switch ($_post['ds_browser_new_key']) {
            case 'user_group':
            case 'user_password':
                jrCore_set_form_notice('error', "Invalid new key name - {$_post['ds_browser_new_key']} cannot be set using the Data Browser");
                jrCore_form_field_hilight('ds_browser_new_key');
                jrCore_form_result();
                break;
        }
        $_upd["{$_post['ds_browser_new_key']}"] = $_post['ds_browser_new_value'];
        $refresh                                = true;
    }

    if (isset($_upd) && count($_upd) > 0) {
        if (!jrCore_db_update_item($_post['module'], $_post['id'], $_upd)) {
            jrCore_set_form_notice('error', 'An error was encountered saving the updates to the item - please try again');
            jrCore_form_result();
        }
    }
    jrCore_set_form_notice('success', 'The changes were successfully saved');
    if ($refresh) {
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/browser_item_update/id={$_post['id']}");
    }
    else {
        jrCore_form_result();
    }
}
