<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2003 - 2023 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// Set start time flag for process
$GLOBALS['__JR_FLAGS'] = array(
    'jrcore_process_start_time'      => microtime(true),
    'jrcore_register_module_feature' => array(),
    'jrcore_event_listeners'         => array(),
    'jrcore_event_triggers'          => array()
);

// Define our base dir - DO NOT USE __DIR__ here
define('APP_DIR', dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME']))));

// prep our PHP environment
ini_set('always_populate_raw_post_data', -1);
ini_set('session.auto_start', 0);
ini_set('session.use_trans_sid', 0);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', APP_DIR . '/data/logs/error_log');
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING | E_DEPRECATED));

// Bring in the core
require APP_DIR . '/modules/jrCore/include.php';

// Custom error handling
register_shutdown_function('jrCore_check_for_fatal_error');

$_mods = array();
$_conf = array();
$_urls = array();

// Init Core - $_mods, $_conf and $_urls will be set after
// All module functions in include.php files will be active
jrCore_init();

// Parse out URL
$_post = jrCore_parse_url();

// Start User session
$_user = jrUser_session_start();

// Trigger routing init
$_post = jrCore_trigger_event('jrCore', 'router_init', $_post, $_user);

// Maintenance Mode Check
if (jrCore_is_maintenance_mode($_conf, $_post)) {
    $out = jrCore_parse_template('maintenance.tpl', $_post, 'jrCore');
}

// Everything but the system index
elseif (!empty($_post['module']) || !empty($_post['option']) || !empty($_post['module_url'])) {

    // Module controller
    /** @noinspection PhpArrayIsAlwaysEmptyInspection */
    if (!empty($_post['module']) && !empty($_mods["{$_post['module']}"])) {

        // If we are NOT the admin user, and a request comes in
        // for an inactive module, show error
        if (!jrCore_module_is_active($_post['module']) && !jrUser_is_master()) {
            jrCore_page_not_found();
        }

        // Trigger our module view
        $out = jrCore_trigger_event('jrCore', 'module_view', $_post);
        if (empty($out) || is_array($out)) {

            // Our order of precedence is:
            // - EXACT MATCH on view_[module]_[option]
            // - MAGIC VIEW on view_magic_[option]
            // - Template @ Skin/[module]_[option].tpl
            // - Default view view_[module]_default
            // - Not Found (404.tpl)

            // Check for module controlled View (exact match)
            $out = false;
            if (!empty($_post['option'])) {

                if (jrCore_load_view_function($_post['module'], $_post['option'])) {
                    $out = jrCore_run_module_view_function("view_{$_post['module']}_{$_post['option']}");
                }
            }

            // Check for registered Magic View function
            if (!$out && !empty($_post['option'])) {

                if ($_vw = jrCore_get_registered_module_features('jrCore', 'magic_view')) {
                    foreach ($_vw as $m => $_e) {
                        if (isset($_e["{$_post['option']}"])) {
                            $func = $_e["{$_post['option']}"];
                            if (function_exists($func)) {
                                // Function is already loaded - located in module's include.php
                                jrCore_set_flag('jrcore_is_magic_view', 1);
                                $out = jrCore_run_module_view_function($func);
                            }
                            else {
                                if (jrCore_load_view_function($m, $_post['option'], $func)) {
                                    jrCore_set_flag('jrcore_is_magic_view', 1);
                                    $out = jrCore_run_module_view_function($func);
                                }
                                else {
                                    // If this function was not named "view_" then it may not be found
                                    // However, jrCore_load_view_function will have sourced the module
                                    // index.php file, so the function COULD exist now
                                    if (function_exists($func)) {
                                        jrCore_set_flag('jrcore_is_magic_view', 1);
                                        $out = jrCore_run_module_view_function($func);
                                    }
                                    else {
                                        // log error and show 404
                                        jrCore_logger('CRI', "core: magic view function: {$_e["{$_post['option']}"]} registered in module: {$m} does not exist!");
                                        jrCore_page_not_found();
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }

            // Module must be active
            if (jrCore_module_is_active($_post['module']) || (isset($_post['_1']) && $_post['_1'] == 'info')) {

                // Skin Template
                if (!$out && !empty($_post['option'])) {
                    // Check for Skin Template specific to this module/view
                    $skin = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
                    if (is_file(APP_DIR . "/skins/{$skin}/{$_post['module']}_{$_post['option']}.tpl")) {
                        $out = jrCore_get_parsed_or_cached_template($skin, "{$_post['module']}_{$_post['option']}.tpl", $_post);
                    }
                }

                // Module Default View
                if (!$out) {
                    jrCore_page_title($_post['module_url']);
                    if (jrCore_load_view_function($_post['module'], 'default')) {
                        $out = jrCore_run_module_view_function("view_{$_post['module']}_default");
                    }
                    else {
                        $skin = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
                        if (is_file(APP_DIR . "/skins/{$skin}/{$_post['module']}_index.tpl")) {
                            // default module index (note skin override in parse_template)
                            $out = jrCore_get_parsed_or_cached_template($skin, "{$_post['module']}_index.tpl", $_post);
                        }
                        elseif (is_file(APP_DIR . "/modules/{$_post['module']}/templates/index.tpl")) {
                            // default module index (note skin override in parse_template)
                            $out = jrCore_get_parsed_or_cached_template($_post['module'], 'index.tpl', $_post);
                        }
                        else {
                            // page/module/option not found
                            jrCore_page_not_found();
                        }
                    }
                }
            }
            else {
                jrCore_page_not_found();
            }
        }
    }

    // Skin Template OR Profile View
    if (empty($out)) {

        // Fall through after modules have had their chance means we are loading a skin or profile index.
        // Note that skin templates always take precedence.
        $skin = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
        if (!empty($_post['module_url']) && is_file(APP_DIR . "/skins/{$skin}/{$_post['module_url']}.tpl")) {
            // This is a SKIN template call
            $_st = array(
                'template_path' => APP_DIR . "/skins/{$skin}/{$_post['module_url']}.tpl",
                'template_name' => "{$_post['module_url']}.tpl",
            );
            $out = jrCore_trigger_event('jrCore', 'skin_template', $_post, $_st);
            if (empty($out) || is_array($out)) {
                $out = jrCore_get_parsed_or_cached_template($skin, "{$_post['module_url']}.tpl", $_post);
            }
        }
        // Profile...
        else {
            $out = jrCore_trigger_event('jrCore', 'profile_template', $_post);
            if (empty($out) || is_array($out)) {
                // This is a profile call - load profile info and display
                $out = jrProfile_show_profile($_post, $_user, $_conf);
            }
        }
    }
}

// System Index
else {

    // Check cache
    $out = jrCore_trigger_event('jrCore', 'index_template', $_post);
    if (empty($out) || is_array($out)) {
        $skn = jrCore_get_config_value('jrCore', 'active_skin', 'jrElastic2');
        $out = jrCore_get_parsed_or_cached_template($skn, 'index.tpl', $_post);
    }
}

// Send view_results trigger
$out = jrCore_trigger_event('jrCore', 'view_results', $out);

// Send output
jrCore_send_response_and_detach($out);
?>
