<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrCore_config()
{
    global $_conf;
    // System Name
    $_tmp = array(
        'name'     => 'system_name',
        'default'  => $_SERVER['HTTP_HOST'],
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => 'on',
        'label'    => 'system name',
        'help'     => 'This is the name of your system.',
        'section'  => 'general',
        'order'    => 1
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Maintenance Mode
    $_tmp = array(
        'name'     => 'maintenance_mode',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'maintenance mode',
        'help'     => 'Enabling this option will place your system in Maintenance Mode.  While in maintenance mode, only admin users will be able to log into the site - all others will see the Maintenance Message.',
        'section'  => 'general',
        'order'    => 2
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Maintenance Notice
    $_tmp = array(
        'name'     => 'maintenance_notice',
        'default'  => 'The System is currently undergoing system maintenance. We are working to get the system back online as soon as possible. Thank you for your patience.',
        'type'     => 'textarea',
        'validate' => 'false',
        'required' => 'off',
        'label'    => 'maintenance message',
        'help'     => 'If you have enabled &quot;Maintenance Mode&quot; you can enter a message that is shown on the login page.',
        'section'  => 'general',
        'order'    => 3
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Default Cache length
    $_tmp = array(
        'name'     => 'default_cache_seconds',
        'default'  => 300,
        'type'     => 'text',
        'required' => 'on',
        'min'      => 0,
        'max'      => 86400,
        'validate' => 'number_nn',
        'label'    => 'cache seconds',
        'help'     => 'Cached items will be cached for the number of seconds entered here. Set to "0" (zero) to disable template caching.<br><br><b>NOTE:</b> It is <b>highly recommended</b> that caching is enabled on a live system - disabling caching will have a significant performance impact.',
        'section'  => 'caching',
        'order'    => 10
    );
    jrCore_register_setting('jrCore', $_tmp);

    $_opt = jrCore_get_cache_system_plugins();
    if (is_array($_opt) && count($_opt) > 1) {
        $_tmp = array(
            'name'     => 'active_cache_system',
            'default'  => 'jrCore_mysql',
            'type'     => 'select',
            'options'  => $_opt,
            'validate' => 'core_string',
            'required' => 'on',
            'label'    => 'active data cache',
            'help'     => 'What Cache plugin should be the active cache system?',
            'section'  => 'caching',
            'order'    => 11
        );
        jrCore_register_setting('jrCore', $_tmp);
    }
    else {
        // Active Cache System (hidden)
        $_tmp = array(
            'name'     => 'active_cache_system',
            'default'  => 'jrCore_mysql',
            'type'     => 'hidden',
            'required' => 'on',
            'validate' => 'not_empty',
            'label'    => 'active data cache',
            'help'     => 'this hidden field holds the name of the active caching sub system - do not modify by hand'
        );
        jrCore_register_setting('jrCore', $_tmp);
    }

    // Enabled
    $_opt = array(
        'cri' => '<span class="log-cri" style="font-family:monospace;padding:0 2px"><b>CRI</b></span> Critical',
        'maj' => '<span class="log-maj" style="font-family:monospace;padding:0 2px"><b>MAJ</b></span> Major',
        'min' => '<span class="log-min" style="font-family:monospace;padding:0 2px"><b>MIN</b></span> Minor',
        'inf' => '<span class="log-inf" style="font-family:monospace;padding:0 2px"><b>INF</b></span> Informational',
        'dbg' => '<span class="log-dbg" style="font-family:monospace;padding:0 2px"><b>DBG</b></span> Developer / Debug'
    );
    $_tmp = array(
        'name'     => 'enabled',
        'default'  => 'cri,maj,min,inf',
        'type'     => 'optionlist',
        'options'  => $_opt,
        'required' => 'off',
        'label'    => 'log priorities',
        'sublabel' => 'unchecked are discarded',
        'help'     => 'Select the Priority of Log Messages that will be stored in the Activity Log.  If a priority is NOT checked, messages of that type will be discarded.',
        'section'  => 'activity log',
        'order'    => 20
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Purge Logs
    $_dys = array(
        0   => 'Never',
        1   => 'After 1 day',
        2   => 'After 2 days',
        3   => 'After 3 days',
        4   => 'After 4 days',
        5   => 'After 5 days',
        6   => 'After 6 days',
        7   => 'After 7 days',
        10  => 'After 10 days',
        12  => 'After 12 days',
        15  => 'After 15 days',
        20  => 'After 20 days',
        30  => 'After 30 days',
        40  => 'After 40 days',
        50  => 'After 50 days',
        60  => 'After 60 days',
        90  => 'After 90 days',
        120 => 'After 120 days',
        150 => 'After 150 days',
        180 => 'After 180 days',
        220 => 'After 220 days',
        270 => 'After 270 days',
        320 => 'After 320 days',
        365 => 'After 1 year'
    );
    $_tmp = array(
        'name'     => 'purge_log_days',
        'default'  => 60,
        'upgrade'  => 0,
        'type'     => 'select',
        'options'  => $_dys,
        'required' => 'on',
        'label'    => 'purge activity logs',
        'help'     => 'How many days after an Activity Log is recorded should it be deleted?',
        'section'  => 'activity log',
        'order'    => 21
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Log 404 Not Found
    $_tmp = array(
        'name'     => 'log_404',
        'default'  => 'off',
        'type'     => 'checkbox',
        'required' => 'on',
        'validate' => 'onoff',
        'label'    => 'log 404 not found',
        'help'     => 'Check this option to enable logging of 404 not found pages to the Activity Log.',
        'section'  => 'activity log',
        'order'    => 22
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Server Time Zone
    $_tmp = array(
        'name'     => 'system_timezone',
        'default'  => 'Europe/Dublin',
        'type'     => 'select',
        'options'  => 'jrCore_get_timezone_strings',
        'required' => 'on',
        'label'    => 'system time zone',
        'help'     => 'Setting the System Time Zone will adjust all of the output Date and Time stamps to the specified time zone, regardless of where your actual server may be physically located.  All Time Zones except UTC will be adjusted for Daylight Savings.',
        'section'  => 'date and time',
        'order'    => 10
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Hour Format
    $_hrs = array(
        'h:i:sA' => '12 hour format (with AM/PM)',
        'H:i:s'  => '24 hour format'
    );
    $_tmp = array(
        'name'     => 'hour_format',
        'default'  => 'h:i:sA',
        'type'     => 'select',
        'options'  => $_hrs,
        'required' => 'on',
        'label'    => 'hour format',
        'help'     => 'This option allows you to define how Hours of the Day will be displayed.',
        'section'  => 'date and time',
        'order'    => 11
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Date Format
    $_edf = array(
        'm/d/y' => 'mm/dd/yy',
        'd/m/y' => 'dd/mm/yy',
        'd M Y' => 'dd mmm yyyy'
    );
    $_tmp = array(
        'name'     => 'date_format',
        'default'  => 'm/d/y',
        'type'     => 'select',
        'options'  => $_edf,
        'required' => 'on',
        'label'    => 'date format',
        'help'     => 'Select the Date Format to use for dates.',
        'section'  => 'date and time',
        'order'    => 12
    );
    jrCore_register_setting('jrCore', $_tmp);

    $_opt = jrCore_get_datastore_plugins();
    if (is_array($_opt) && count($_opt) > 1) {
        // Active DataStore (hidden)
        $_tmp = array(
            'name'     => 'active_datastore_system',
            'default'  => 'jrCore',
            'type'     => 'select',
            'options'  => $_opt,
            'required' => 'on',
            'validate' => 'not_empty',
            'label'    => 'active datastore system',
            'help'     => 'this hidden field holds the name of the active DataStore sub system - do not modify by hand',
            'section'  => 'content',
            'order'    => 30
        );
        jrCore_register_setting('jrCore', $_tmp);
    }
    else {
        // Active DataStore (hidden)
        $_tmp = array(
            'name'     => 'active_datastore_system',
            'default'  => 'jrCore',
            'type'     => 'hidden',
            'required' => 'on',
            'validate' => 'not_empty',
            'label'    => 'active datastore system',
            'help'     => 'this hidden field holds the name of the active DataStore sub system - do not modify by hand'
        );
        jrCore_register_setting('jrCore', $_tmp);
    }

    // Pager Limit
    $_tmp = array(
        'name'     => 'pager_limit',
        'default'  => 'on',
        'type'     => 'checkbox',
        'required' => 'on',
        'validate' => 'onoff',
        'label'    => 'use optimized pager',
        'help'     => 'Checking this option will disable the Page Jumper on listing pages when the core determines the resulting SQL COUNT() query would slow down the system.<br><br>Leave this option enabled - disabling this on large systems can result in slow page generation.',
        'section'  => 'content',
        'order'    => 31
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Pager Limit
    $_tmp = array(
        'name'     => 'optimize_order',
        'default'  => 'on',
        'type'     => 'checkbox',
        'required' => 'on',
        'validate' => 'onoff',
        'label'    => 'use optimized ordering',
        'help'     => 'Checking this option allows the core to determine if it can optimize the ordering of list items.<br><br>Leave this option enabled unless you feel the time-ordering of list items is incorrect (which can happen on imported items).',
        'section'  => 'content',
        'order'    => 32
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Max SQL run time
    $_tmp = array(
        0     => 'Disabled',
        1000  => '1 Second',
        2000  => '2 Seconds',
        3000  => '3 Seconds',
        4000  => '4 Seconds',
        5000  => '5 Seconds',
        6000  => '6 Seconds',
        7000  => '7 Seconds',
        8000  => '8 Seconds',
        9000  => '9 Seconds',
        10000 => '10 Seconds',
        12000 => '12 Seconds',
        15000 => '15 Seconds',
        20000 => '20 Seconds',
        25000 => '25 Seconds',
        30000 => '30 Seconds',
        45000 => '45 Seconds',
        60000 => '60 Seconds'
    );
    $_tmp = array(
        'name'     => 'max_sql_run_time',
        'default'  => 0,
        'type'     => 'select',
        'options'  => $_tmp,
        'required' => 'on',
        'validate' => 'number_nn',
        'label'    => 'max query run time',
        'help'     => 'Enabling this option will set a maximum time (in seconds) that an SQL query is allowed to run for.  Requires MySQL 5.7+.<br><br><b>Note:</b> Individual SQL queries in modules can override this setting to enable loger running queries.<br><br><b>Warning!</b> Setting this value too low for your system could make your system inaccessible!',
        'section'  => 'content',
        'order'    => 33
    );
    jrCore_register_setting('jrCore', $_tmp);

    $_tmp = array(
        'name'     => 'active_media_system',
        'default'  => 'jrCore_local',
        'type'     => 'select',
        'options'  => 'jrCore_get_media_system_plugins',
        'validate' => 'core_string',
        'required' => 'on',
        'label'    => 'active media system',
        'help'     => 'What Media system should be the active system for storing profile media items (images, audio, video, files, etc.)?',
        'section'  => 'content',
        'order'    => 35
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Recycle Bin
    $_tmp = array(
        'name'     => 'recycle_bin',
        'default'  => 'on',
        'type'     => 'checkbox',
        'required' => 'on',
        'validate' => 'onoff',
        'label'    => 'enable recycle bin',
        'help'     => 'With this option checked when a module DataStore item (such as a Profile, a User, a Blog entry, etc.) is deleted it will be saved in the system Recycle Bin where it can be restored if needed.',
        'section'  => 'recycle bin',
        'order'    => 50
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Expired Items
    $_dys = array(
        0  => 'Never - Recycle Bin must be manually emptied',
        1  => '1 Day',
        2  => '2 Days',
        3  => '3 Days',
        4  => '4 Days',
        5  => '5 Days',
        6  => '6 Days',
        7  => '7 Days',
        8  => '8 Days',
        9  => '9 Days',
        10 => '10 Days',
        14 => '14 Days',
        21 => '21 Days',
        28 => '28 Days',
        60 => '60 Days',
    );
    $_tmp = array(
        'name'     => 'recycle_bin_expire',
        'default'  => 3,
        'type'     => 'select',
        'options'  => $_dys,
        'valdiate' => 'number_nn',
        'required' => 'on',
        'label'    => 'delete after',
        'help'     => 'How many days after an item has been added to the Recycle Bin will it be permanently deleted?',
        'section'  => 'recycle bin',
        'order'    => 51
    );
    jrCore_register_setting('jrCore', $_tmp);

    //---------------------------------
    // Internal settings
    //---------------------------------

    // Active Skin (hidden)
    $_tmp = array(
        'name'     => 'active_skin',
        'default'  => 'jrElastic2',
        'type'     => 'hidden',
        'validate' => 'not_empty',
        'required' => 'on',
        'label'    => 'active skin',
        'help'     => 'this hidden field keeps track of the Active Skin.',
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Detail Feature Order (hidden)
    $_tmp = array(
        'name'     => 'detail_feature_order',
        'default'  => '',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'printable',
        'label'    => 'detail feature order',
        'help'     => 'this hidden field keeps track of the module detail feature order - do not modify or remove'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Dashboard Config (hidden)
    $_tmp = array(
        'name'     => 'dashboard_config',
        'default'  => '',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'printable',
        'label'    => 'dashboard config',
        'help'     => 'this hidden field holds config options for the Dashboard - do not modify'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Unique String
    $_tmp = array(
        'name'     => 'unique_string',
        'default'  => '0',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'md5',
        'label'    => 'unique system string',
        'help'     => 'this hidden field holds a unique string value for use in hashing - do not modify'
    );
    jrCore_register_setting('jrCore', $_tmp);
    if (isset($_conf['jrCore_unique_string']) && $_conf['jrCore_unique_string'] == '0') {
        jrCore_set_setting_value('jrCore', 'unique_string', md5(microtime() . mt_rand()));
    }

    // Last Ten Minute Run (hidden)
    $_tmp = array(
        'name'     => 'last_ten_min_maint_run',
        'default'  => '0',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'number_nn',
        'label'    => 'last ten minute maintenance run',
        'help'     => 'this hidden field keeps track of the last time the ten minute maintenance was run - do not modify by hand.'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Last Hourly Run (hidden)
    $_tmp = array(
        'name'     => 'last_hourly_maint_run',
        'default'  => '0',
        'type'     => 'hidden',
        'required' => 'on',
        'min'      => 2012080101,
        'max'      => 2099123123,
        'validate' => 'number_nn',
        'label'    => 'last hourly maintenance run',
        'help'     => 'this hidden field keeps track of the last time the hourly maintenance was run - do not modify by hand.'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Last Daily Run (hidden)
    $_tmp = array(
        'name'     => 'last_daily_maint_run',
        'default'  => '0',
        'type'     => 'hidden',
        'required' => 'on',
        'min'      => 20120801,
        'max'      => 20991231,
        'validate' => 'number_nn',
        'label'    => 'last daily maintenance run',
        'help'     => 'this hidden field keeps track of the last time the daily maintenance was run - do not modify by hand.'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Index Keys (hidden)
    $_tmp = array(
        'name'     => 'index_keys',
        'default'  => '',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'printable',
        'label'    => 'DS index key tables',
        'help'     => 'this hidden field keeps track of dedicated DS index tables - do not modify by hand.'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Pager Limit Modules
    $_tmp = array(
        'name'     => 'ds_row_counts',
        'default'  => '',
        'type'     => 'hidden',
        'required' => 'on',
        'validate' => 'printable',
        'label'    => 'DS pager limit tables',
        'help'     => 'this hidden field keeps track of DataStore row counts - do not modify by hand.'
    );
    jrCore_register_setting('jrCore', $_tmp);

    // Settings no longer used
    jrCore_delete_setting('jrCore', 'enable_precache');
    jrCore_delete_setting('jrCore', 'precache_workers');
    jrCore_delete_setting('jrCore', 'dls_adjust');
    jrCore_delete_setting('jrCore', 'queues_active');
    jrCore_delete_setting('jrCore', 'last_minute_maint_run');
    jrCore_delete_setting('jrCore', 'allowed_domains');
    jrCore_delete_setting('jrCore', 'stream_login');
    jrCore_delete_setting('jrCore', 'download_login');
    jrCore_delete_setting('jrCore', 'full_page');

    // If we are set for America/Tegucigalpa timezone, change to America/Chicago
    if (!empty($_conf['jrCore_system_timezone']) && $_conf['jrCore_system_timezone'] == 'America/Tegucigalpa') {
        jrCore_set_setting_value('jrCore', 'system_timezone', 'America/Chicago');
    }

    return true;
}

/**
 * Validate
 * @param array $_post Posted data
 */
function jrCore_config_validate($_post)
{
    // The default jrCore datastore system is just "jrCore"
    if (isset($_post['active_datastore_system']) && $_post['active_datastore_system'] == 'jrCore_mysql') {
        $_post['active_datastore_system'] = 'jrCore';
    }
    return $_post;
}

/**
 * Advanced Config keys
 */
function jrCore_advanced_config()
{
    jrCore_register_advanced_config_key('jrCore', 'disable_counter_ip_check', '', "Ignore unique checking of IP Addresses when counting a streamed file. Value is a comma seperated list of modules.");
    jrCore_register_advanced_config_key('jrCore', 'disable_db_templates', 'off', "Disable checking for database template overrides.");
    jrCore_register_advanced_config_key('jrCore', 'max_system_queue_workers', 12, "Maximum number of queue workers system wide.");
    jrCore_register_advanced_config_key('jrCore', 'queue_worker_ratio', 100, "Percent chance any single process can become a queue worker.");
    jrCore_register_advanced_config_key('jrCore', 'queue_skip_lock', 'off', "set to 'on' to use SKIP LOCKED in queue queries (MySQL 8+ only).");
    jrCore_register_advanced_config_key('jrCore', 'db_connect_timeout', 2, "Number of seconds to wait for connection to MySQL DB before timing out.");
    jrCore_register_advanced_config_key('jrCore', 'db_persistent', 'off', "set to 'on' for persistent DB connections.");
    jrCore_register_advanced_config_key('jrCore', 'sql_mode', true, "Set to requested SQL_MODE or boolean TRUE to disable.");
    jrCore_register_advanced_config_key('jrCore', 'sql_session', true, "Allows setting of SQL SESSION variables - overrides SQL_MODE");
    jrCore_register_advanced_config_key('jrCore', 'play_key_expire_hours', 8, "Hours until a play key expires.");
    jrCore_register_advanced_config_key('jrCore', 'form_session_expire_hours', 4, "Hours until form sessions expire.");
    jrCore_register_advanced_config_key('jrCore', 'bbcode_languages', '', "Comma separated list of languages supported in [code] blocks.");
    jrCore_register_advanced_config_key('jrCore', 'time_offset_seconds', '', 'additional seconds to be added or subtracted from the computed timezone value.');
    jrCore_register_advanced_config_key('jrCore', 'log_throttle_ttl', 10, 'Number of seconds to suppress duplicate activity log entries');
    jrCore_register_advanced_config_key('jrCore', 'templated_tables', true, 'Set to FALSE to generate display tables using PHP instead of templates, which can be considerably faster');

    return true;
}
