<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: view_comments
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_view_comments($_post, $_user, $_conf)
{
    if (!isset($_post['item_module']) || !jrCore_module_is_active($_post['item_module'])) {
        return 'ERROR: invalid module';
    }
    if (!isset($_post['item_id']) || !jrCore_checktype($_post['item_id'], 'number_nz')) {
        return 'ERROR: invalid item_id';
    }
    $_sp = array(
        'search'   => array(
            "comment_item_ckey = {$_post['item_id']}:{$_post['item_module']}:i"
        ),
        'order_by' => array(
            '_item_id' => (isset($_conf['jrComment_direction'])) ? $_conf['jrComment_direction'] : 'desc'
        )
    );
    if (isset($_conf['jrComment_pagebreak']) && jrCore_checktype($_conf['jrComment_pagebreak'], 'number_nz')) {
        $page = 1;
        if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
            $page = (int) $_post['p'];
        }
        $_sp['pagebreak'] = (int) $_conf['jrComment_pagebreak'];
        $_sp['page']      = $page;
    }
    else {
        $_sp['limit'] = (is_numeric($_post['limit'])) ? intval($_post['limit']) : 1000;
    }
    $_sp['jrcore_list_function_call_is_active'] = 1;   // ensures we handle threading if enabled
    if (!empty($_post['order_by']) && strpos($_post['order_by'], ' ')) {
        list($key, $val) = explode(' ', $_post['order_by']);
        $key = trim($key);
        $val = trim($val);
        if (strlen($key) > 0 && strlen($val) > 0) {
            $_sp['order_by'] = array($key => $val);
        }
    }
    $_rt = jrCore_db_search_items('jrComment', $_sp);
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        $out = '';
        jrCore_set_flag('jrprofile_view_is_active', true);
        if (isset($_post['template']) && jrCore_checktype($_post['template'], 'file_name') && $_post['template'] !== 'undefined') {
            if (file_exists(APP_DIR . '/modules/' . $_conf['jrCore_active_skin']) . '/' . $_post['template']) {
                return $out . jrCore_parse_template($_post['template'], $_rt);
            }
        }
        $out .= jrCore_parse_template('item_list.tpl', $_rt, 'jrComment');
        if (isset($_conf['jrComment_pagebreak']) && jrCore_checktype($_conf['jrComment_pagebreak'], 'number_nz')) {
            $out .= jrCore_parse_template('comment_pager.tpl', $_rt, 'jrComment');
        }
        return $out;
    }
    return 'ERROR: Unable to retrieve comments';
}
