<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_update($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrComment');

    // We should get an id on the URL
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_notice_page('error', 20);
    }
    $_rt = jrCore_db_get_item('jrComment', $_post['id']);
    if (!$_rt) {
        jrCore_notice_page('error', 21);
    }
    // Make sure the calling user has permission to edit this item
    if (!jrComment_user_can_edit_item($_rt)) {
        jrUser_not_authorized();
    }

    // Save our URL to go back to on completion of editing
    jrCore_create_memory_url("comment_edit_{$_post['id']}");

    // Start output
    jrCore_page_banner(23);

    // Form init
    $_tmp = array(
        'submit_value' => 24,
        'cancel'       => jrCore_is_profile_referrer(),
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // id
    $_tmp = array(
        'name'     => 'id',
        'type'     => 'hidden',
        'value'    => $_post['id'],
        'validate' => 'number_nz'
    );
    jrCore_form_field_create($_tmp);

    // Comment Text
    if (isset($_conf['jrComment_editor']) && $_conf['jrComment_editor'] == 'on') {
        $_tmp = array(
            'name'     => 'comment_text',
            'label'    => 'Comment Text',
            'help'     => 'Update the comment text to how you want it.',
            'type'     => 'editor',
            'validate' => 'allowed_html',
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        $_tmp = array(
            'name'     => 'comment_text',
            'label'    => 'Comment Text',
            'help'     => 'Update the comment text to how you want it.',
            'type'     => 'textarea',
            'validate' => 'printable',
            'required' => true
        );
        $rows = substr_count($_rt['comment_text'], "\n");
        $rows += ceil(strlen($_rt['comment_text']) / 75);
        if ($rows > 6) {
            $_tmp['style'] = 'height: unset';
            $_tmp['rows']  = $rows;
        }
        jrCore_form_field_create($_tmp);
    }

    if (jrUser_is_admin() || $_user['quota_jrComment_attachments'] == 'on') {

        // File Attachment
        $_tmp = array(
            'name'          => 'comment_file',
            'label'         => 31,
            'help'          => 32,
            'text'          => 33,
            'type'          => 'file',
            'extensions'    => $_user['quota_jrComment_allowed_file_types'],
            'value'         => $_rt,
            'order'         => 4,
            'max'           => (isset($_user['quota_jrCore_max_upload_size'])) ? (int) $_user['quota_jrCore_max_upload_size'] : 2097152,
            'multiple'      => true,
            'form_designer' => false
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
