<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quote
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_quote($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        $_rs = array('error' => 'invalid comment id');
        jrCore_json_response($_rs);
    }

    // NOTE: We use jrCore_db_search_items here since it gives us privacy checking!
    $_rt = array(
        'search'                       => array(
            "_item_id = {$_post['_1']}"
        ),
        'exclude_jrProfile_quota_keys' => true,
        'ignore_pending'               => true,
        'quota_check'                  => false,
        'order_by'                     => false,
        'limit'                        => 1
    );
    $_rt = jrCore_db_search_items('jrComment', $_rt);
    if (!$_rt || !is_array($_rt) || !isset($_rt['_items'])) {
        return '';
    }
    $_rt = $_rt['_items'][0];

    // Is this comment on a PRIVATE PROFILE?
    if (!jrUser_is_admin()) {
        $prv = $_rt['profile_private'];
        if ($_rt['comment_profile_id'] != $_rt['_profile_id']) {
            $prv = jrCore_db_get_item_key('jrProfile', $_rt['comment_profile_id'], 'profile_private');
        }
        switch (intval($prv)) {
            case 0:
                // Completely private profile
                if (!jrProfile_is_profile_owner($_rt['comment_profile_id'])) {
                    jrUser_not_authorized();
                }
                break;

            case 2:
            case 3:
                // Followers Only
                if (!jrFollower_is_follower($_user['_user_id'], $_rt['comment_profile_id'])) {
                    jrUser_not_authorized();
                }
                break;
        }

        // Is this a comment on a PRIVATE item that the user does not have access to?
        if (!jrProfile_is_profile_owner($_rt['comment_profile_id'])) {
            $_ids = jrCore_trigger_event('jrComment', 'private_item_ids', array(), $_rt, $_rt['comment_module']);
            if ($_ids && is_array($_ids) && isset($_ids["{$_rt['comment_module']}"]) && is_array($_ids["{$_rt['comment_module']}"]) && in_array(intval($_rt['comment_item_id']), $_ids["{$_rt['comment_module']}"])) {
                jrUser_not_authorized();
            }
        }
    }
    if (isset($_conf['jrComment_editor']) && $_conf['jrComment_editor'] == 'on') {
        $val = "[quote=\"{$_rt['user_name']}\"]\n" . trim($_rt['comment_text']) . "\n[/quote]\n";
    }
    else {
        $_rp = array('<p>' => '', '</p>' => '');
        $val = "[quote=\"{$_rt['user_name']}\"]\n" . str_replace(array_keys($_rp), $_rp, trim($_rt['comment_text'])) . "\n[/quote]\n\n";
    }
    return $val;
}
