<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_delete($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_validate_location_url();

    // Make sure we get a good id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item('jrComment', $_post['id']);

    // Make sure the calling user has permission to delete this item
    if (!jrUser_can_edit_item($_rt)) {
        // They don't own this comment - see if we are configured in their
        // quota to allow profile owners to delete comments
        if (!isset($_user['quota_jrComment_profile_delete']) || $_user['quota_jrComment_profile_delete'] != 'on') {
            jrUser_not_authorized();
        }
    }
    // See if this is a LOCKED ITEM
    if (!jrUser_is_admin() && isset($_rt['comment_locked']) && $_rt['comment_locked'] == '1') {
        jrUser_not_authorized();
    }

    // See if SAVE THREADS is on - if it is, we don't delete the comment if it has replies
    if (isset($_conf['jrComment_save_thread']) && $_conf['jrComment_save_thread'] == 'on') {

        // If this comment has replies..
        $_cm = jrCore_db_get_multiple_items_by_key('jrComment', 'comment_parent_id', $_post['id']);
        if ($_cm && is_array($_cm)) {
            $_ln = jrUser_load_lang_strings('en-US');
            $_up = array(
                'comment_text'   => $_ln['jrComment'][19],
                'comment_locked' => 1
            );
            jrCore_db_update_item('jrComment', $_post['id'], $_up);
        }
        else {
            // Delete item
            jrCore_db_delete_item('jrComment', $_post['id']);
            if ($pfx = jrCore_db_get_prefix($_rt['comment_module'])) {
                jrCore_db_decrement_key($_rt['comment_module'], $_rt['comment_item_id'], "{$pfx}_comment_count", 1);
            }
        }
    }
    else {
        // Delete comment and all replies
        // Find any comments that are in our comment thread
        $_pd = array("{$_post['id']}" => $_rt['comment_parent_id']);
        $_dn = array($_post['id'] => 1);
        $i   = 0;
        while (true) {
            $_sp = array(
                'search'        => array(
                    "comment_parent_id in " . implode(',', array_keys($_pd)),
                    "_item_id not_in " . implode(',', array_keys($_dn))
                ),
                'return_keys'   => array('_item_id', 'comment_parent_id'),
                'skip_triggers' => true,
                'limit'         => 1000,
                'no_cache'      => true
            );
            $_sp = jrCore_db_search_items('jrComment', $_sp);
            if ($_sp && is_array($_sp) && isset($_sp['_items']) && is_array($_sp['_items'])) {
                foreach ($_sp['_items'] as $_cm) {
                    $_dn["{$_cm['_item_id']}"] = 1;
                    $_pd["{$_cm['_item_id']}"] = $_cm['comment_parent_id'];
                    $i++;
                }
                if ($i > 25) {
                    // fail safe...
                    break;
                }
            }
            else {
                break;
            }
        }
        if ($_dn && count($_dn) > 0) {
            jrCore_db_delete_multiple_items('jrComment', array_keys($_dn));
            if ($pfx = jrCore_db_get_prefix($_rt['comment_module'])) {
                jrCore_db_decrement_key($_rt['comment_module'], $_rt['comment_item_id'], "{$pfx}_comment_count", count($_dn));
            }
        }
    }

    // Reset Cache
    jrProfile_reset_cache($_rt['comment_profile_id'], 'jrComment');
    if ($_rt['comment_module'] != 'jrComment') {
        jrProfile_reset_cache($_rt['comment_profile_id'], $_rt['comment_module']);
    }
    jrUser_reset_cache($_user['_user_id']);
    jrCore_form_result();
}
