<?php
 /**
 * Jamroom Comments module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: comment_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrComment_comment_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrCore_validate_location_url();

    if (!isset($_post['comment_module']) || !jrCore_module_is_active($_post['comment_module'])) {
        $_res = array('error' => 'invalid comment module or comment module is not active');
        jrCore_json_response($_res);
    }
    $pfx = jrCore_db_get_prefix($_post['comment_module']);
    if (!$pfx) {
        $_res = array('error' => 'module is not setup with a datastore - unable to save comment');
        jrCore_json_response($_res);
    }
    if (!jrCore_checktype($_post['comment_item_id'], 'number_nz')) {
        $_res = array('error' => 'invalid comment_item_id');
        jrCore_json_response($_res);
    }
    if (!jrCore_checktype($_post['comment_profile_id'], 'number_nz')) {
        $_res = array('error' => 'invalid comment_profile_id');
        jrCore_json_response($_res);
    }

    // Check for valid text
    $_ln = jrUser_load_lang_strings();
    if (!isset($_post['comment_text']) || strlen($_post['comment_text']) === 0) {
        $_res = array('error' => $_ln['jrComment'][10]);
        jrCore_json_response($_res);
    }
    // Check for Wait Timer
    if (!jrUser_is_admin() && isset($_SESSION['jrComment_last_post_timer']) && $_SESSION['jrComment_last_post_timer'] > (time() - ($_conf['jrComment_wait_time'] * 60))) {
        $_res = array('error' => $_ln['jrComment'][9] . $_conf['jrComment_wait_time'] . 'm');
        jrCore_json_response($_res);
    }
    // Check for banned words..
    if ($ban = jrCore_run_module_function('jrBanned_is_banned', 'word', $_post['comment_text'])) {
        $_res = array('error' => "{$_ln['jrCore'][67]} " . strip_tags($ban));
        jrCore_json_response($_res);
    }

    // We need to get the TITLE for this item
    $_it = jrCore_db_get_item($_post['comment_module'], $_post['comment_item_id']);
    if (!$_it || !is_array($_it)) {
        $_res = array('error' => "invalid item_id - please try again");
        jrCore_json_response($_res);
    }
    $_SESSION['jrComment_last_post_timer'] = time();

    $_tmp = array(
        'comment_module'       => $_post['comment_module'],
        'comment_item_id'      => $_post['comment_item_id'],
        'comment_profile_id'   => $_post['comment_profile_id'],
        'comment_item_ckey'    => "{$_post['comment_item_id']}:{$_post['comment_module']}:i",
        'comment_profile_ckey' => "{$_post['comment_profile_id']}:{$_post['comment_module']}:p"
    );
    if (isset($_conf['jrComment_editor']) && $_conf['jrComment_editor'] == 'on' || stripos(' ' . $_post['comment_text'], '[code]')) {
        $_tmp['comment_text'] = trim($_post['comment_text']);
    }
    else {
        $_tmp['comment_text'] = jrCore_strip_html(trim($_post['comment_text']));
    }
    if (isset($_conf['jrComment_threading']) && $_conf['jrComment_threading'] == 'on' && isset($_post['comment_parent_id']) && jrCore_checktype($_post['comment_parent_id'], 'number_nz')) {
        $_rt = jrCore_db_get_item('jrComment', $_post['comment_parent_id'], true);
        if ($_rt && is_array($_rt)) {
            $idx = 1;
            $tid = $_post['comment_parent_id'];
            if (isset($_rt['comment_thread_level']) && jrCore_checktype($_rt['comment_thread_level'], 'number_nz')) {
                $idx = ($_rt['comment_thread_level'] + 1);
                $tid = $_rt['comment_thread_id'];
            }
            $_tmp['comment_thread_id']    = (int) $tid;
            $_tmp['comment_parent_id']    = (int) $_post['comment_parent_id'];
            $_tmp['comment_thread_level'] = (int) $idx;
        }
    }

    // Get our comment title
    $curl = false;
    $murl = jrCore_get_module_url($_post['comment_module']);
    switch ($_post['comment_module']) {
        case 'jrUser':
            $_tmp['comment_item_title'] = $_it['user_name'];
            break;
        case 'jrProfile':
            $_tmp['comment_item_title'] = $_it['profile_name'];
            $curl                       = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}";
            break;
        case 'jrAction':
            $_tmp['comment_item_title'] = (isset($_it["{$pfx}_text"])) ? $_it["{$pfx}_text"] : $_mods['jrAction']['module_name'];
            $curl                       = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$murl}/{$_post['comment_item_id']}/" . jrCore_url_string($_tmp['comment_item_title']);
            break;
        default:
            $_tmp['comment_item_title'] = (isset($_it["{$pfx}_title"])) ? $_it["{$pfx}_title"] : '';
            if (isset($_it["{$pfx}_title_url"])) {
                $curl = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$murl}/{$_post['comment_item_id']}/" . $_it["{$pfx}_title_url"];
            }
            else {
                $curl = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$murl}/{$_post['comment_item_id']}";
            }
            break;
    }

    // When leaving a comment on another profile, we must use our HOME ID
    $id = jrCore_db_create_item('jrComment', $_tmp, array('_profile_id' => jrUser_get_profile_home_key('_profile_id')));
    if (!$id || !jrCore_checktype($id, 'number_nz')) {
        $_res = array('error' => $_ln['jrComment'][8]);
        jrCore_json_response($_res);
    }

    // If this comment is on a PRIVATE item, store the comment ID here
    if ($pfx = jrCore_db_get_prefix($_post['comment_module'])) {
        if ((isset($_it['group_private']) && $_it['group_private'] == 'on') || (isset($_it["{$pfx}_private"]) && $_it["{$pfx}_private"] == 'on')) {
            jrComment_create_private_id_entry($_post['comment_profile_id'], $id);
        }
    }

    $_tmp['_item_id'] = $id;

    // Increment number of comments on item
    jrCore_db_increment_key($_post['comment_module'], $_post['comment_item_id'], "{$pfx}_comment_count", 1);

    // Increment number of comments for profile
    if (jrUser_get_profile_home_key('_profile_id') != $_it['_profile_id']) {
        jrCore_db_increment_key('jrProfile', $_post['comment_profile_id'], 'profile_jrComment_home_item_count', 1);
    }

    // Add comment id to $curl
    $curl .= "#cm{$id}";

    // Add to actions - give the module the comment is being left on an opportunity to cancel
    $_it  = jrCore_trigger_event('jrComment', 'add_to_timeline', $_it, $_tmp);
    $_ids = jrCore_trigger_event('jrComment', 'private_item_ids', array(), $_tmp, $_post['comment_module']);
    if (!isset($_it['add_to_timeline']) || jrCore_checktype($_it['add_to_timeline'], 'is_true')) {

        $_sav = array(
            'action_original_module'  => $_post['comment_module'],
            'action_original_item_id' => $_post['comment_item_id']
        );
        $aid  = jrCore_run_module_function('jrAction_save', 'create', 'jrComment', $id, $_sav, false, jrUser_get_profile_home_key('_profile_id'), $_post['comment_profile_id']);
        if ($aid && $aid > 0) {
            // See if this comment is on a PRIVATE item
            if (!$_ids || !is_array($_ids) || !is_array($_ids["{$_post['comment_module']}"]) || !in_array($_post['comment_item_id'], $_ids["{$_post['comment_module']}"])) {
                jrCore_run_module_function('jrAction_process_mentions', $_tmp['comment_text'], $aid);
            }
        }
    }

    // Notify for non timeline @mentions
    if ($_post['comment_module'] != 'jrAction') {
        if (!$_ids || !is_array($_ids) || !is_array($_ids["{$_post['comment_module']}"]) || !in_array($_post['comment_item_id'], $_ids["{$_post['comment_module']}"])) {
            // Notify the @mentioned person know they were mentioned.
            jrComment_process_mentions($_tmp['comment_text'], $curl);
        }
        elseif (jrCore_checktype($_post['comment_profile_id'], 'number_nz')) {
            // send @mention notifications to profile owners only.
            $tbl = jrCore_db_table_name('jrProfile', 'profile_link');
            $req = "SELECT user_id FROM {$tbl} WHERE profile_id = {$_post['comment_profile_id']}";
            if ($_ui = jrCore_db_query($req, 'user_id', false, 'user_id')) {
                $_pr = jrCore_db_get_multiple_items('jrProfile', $_ui, array('profile_url'));
                if (!empty($_pr)) {
                    $_allowed = array();
                    foreach ($_pr as $i) {
                        $_allowed["{$i['profile_url']}"] = $i['profile_url'];
                    }
                    jrComment_process_private_mentions($_tmp['comment_text'], $curl, $_allowed);
                }
            }
        }
    }

    // Send user notifications (if commenting user's profile is active. Don't send out notifictions because the reciever will not see the comment.)
    if ($_user['profile_active'] !== "0") {
        $_owners = jrProfile_get_owner_info($_post['comment_profile_id']);
        if (is_array($_owners)) {
            $_ui = array();
            foreach ($_owners as $v) {
                $uid = (int) $v['_user_id'];
                if ($uid > 0) {
                    $_ui[$uid] = $v;
                }
            }
            if (isset($_ui["{$_user['_user_id']}"])) {
                unset($_ui["{$_user['_user_id']}"]);
            }
            if (count($_ui) > 0) {
                $_rp = array(
                    'system_name'        => $_conf['jrCore_system_name'],
                    'comment_user_name'  => $_user['user_name'],
                    'comment_text'       => $_tmp['comment_text'],
                    'comment_item_url'   => $curl,
                    'comment_item_title' => str_replace('@', '', $_tmp['comment_item_title']),
                    'comment_item_id'    => $id,
                    '_item'              => $_it
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrComment', 'new_comment', $_rp);
                jrUser_notify(array_keys($_ui), 0, 'jrComment', 'new_comment', $sub, $msg);
            }
        }

        // if threaded, send notification to parent comment user (if not self)
        if (isset($_rt) && is_array($_rt) && $_rt['_user_id'] != $_user['_user_id']) {
            $_rp = array(
                'system_name'        => $_conf['jrCore_system_name'],
                'comment_user_name'  => $_user['user_name'],
                'comment_text'       => $_tmp['comment_text'],
                'comment_item_url'   => $curl,
                'comment_item_title' => $_tmp['comment_item_title'],
                'comment_item_id'    => $id,
                '_item'              => $_it
            );
            list($sub, $msg) = jrCore_parse_email_templates('jrComment', 'new_reply', $_rp);
            jrUser_notify($_rt['_user_id'], 0, 'jrComment', 'new_reply', $sub, $msg);
        }
    }

    // Reset caches
    // We have to reset cache for:
    // - commenting user + each user that is a profile owner of the profile
    // - the profile the comment was left on
    $_po = jrProfile_get_owner_info($_post['comment_profile_id']);
    if ($_po && is_array($_po)) {
        $_ui = array();
        foreach ($_po as $o) {
            $uid       = (int) $o['_user_id'];
            $_ui[$uid] = $uid;
            if (!isset($_ui["{$_user['_user_id']}"])) {
                $_ui["{$_user['_user_id']}"] = $_user['_user_id'];
            }
        }
        jrUser_reset_cache($_ui);
    }
    else {
        jrUser_reset_cache($_user['_user_id']);
    }
    jrProfile_reset_cache(jrUser_get_profile_home_key('_profile_id'), $_post['comment_module']);
    jrProfile_reset_cache($_post['comment_profile_id'], $_post['comment_module']);

    // See if pending is on - we need to let the user know their comment is pending review by an admin user
    $_rt = jrCore_db_get_item('jrComment', $id, true);
    if (isset($_rt['comment_pending']) && $_rt['comment_pending'] == '1') {
        $_res = array('success' => $_ln['jrComment'][15]);
    }
    else {
        $_res = array('success' => $_ln['jrComment'][7]);
    }
    $_res['item_id'] = $id;
    $hl              = 'off';
    if ($_conf['jrComment_editor'] == 'on' || $_conf['jrComment_direction'] == 'desc') {
        $hl = 'on';
    }
    $_res['highlight'] = $hl;
    jrCore_json_response($_res);
}
