<?php
 /**
 * Jamroom Advanced Charts module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * lib/cache.php unit tests
 */
function test_jrCharts_history()
{
    // What library file are we testing?
    jrUnitTest_add_coverage_file(APP_DIR . "/modules/jrCharts/include.php");

    // Test chunked insert
    jrUnitTest_init_test('Insert chunked chart history');
    $dat = date('Ymd');
    $val = jrCore_create_unique_string(4000);
    if (!jrCharts_insert_history_in_chunks('test_chunk_split', $dat, $val, 256)) {
        jrCharts_unit_test_cleanup_history_test();
        jrUnitTest_exit_with_error('error inserting history');
    }

    // Make sure it is good
    $tbl = jrCore_db_table_name('jrCharts', 'history');
    $req = "SELECT chart_counts FROM {$tbl} WHERE chart_date = {$dat} AND chart_field = 'test_chunk_split'";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || $_rt['chart_counts'] != $val) {
        jrCharts_unit_test_cleanup_history_test();
        jrUnitTest_exit_with_error('retrieved value does not match original value');
    }
    jrCharts_unit_test_cleanup_history_test();
}

/**
 * Cleanup from unit test
 * @return object
 */
function jrCharts_unit_test_cleanup_history_test()
{
    $tbl = jrCore_db_table_name('jrCharts', 'history');
    $req = "DELETE FROM {$tbl} WHERE chart_field = 'test_chunk_split'";
    return jrCore_db_query($req);
}
