<?php
 /**
 * Jamroom Banned Items module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBanned_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrBanned', 'browse');

    // construct our query
    $tbl = jrCore_db_table_name('jrBanned', 'banned');
    $req = "SELECT * FROM {$tbl} ";
    $_ex = false;
    $add = '';
    $num = jrCore_db_number_rows('jrBanned', 'banned');
    if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {

        $_post['search_string'] = trim(urldecode($_post['search_string']));

        $str = jrCore_db_escape($_post['search_string']);
        $req .= "WHERE (ban_type LIKE '%{$str}%' OR ban_value LIKE '%{$str}%') ";
        $_ex = array('search_string' => $_post['search_string']);
        $add = '/search_string=' . urlencode($_post['search_string']);
        $num = false;
    }
    $req .= 'ORDER BY ban_id DESC';

    // find how many lines we are showing
    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }
    $_rt = jrCore_db_paged_query($req, $_post['p'], 12, 'NUMERIC', $num);

    // start our html output
    jrCore_page_banner('banned items');
    jrCore_get_form_notice();
    jrCore_page_search('search', "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse");

    $dat             = array();
    $dat[1]['title'] = 'type';
    $dat[1]['width'] = '20%;';
    $dat[2]['title'] = 'match value';
    $dat[2]['width'] = '25%;';
    $dat[3]['title'] = 'note';
    $dat[3]['width'] = '39%';
    $dat[4]['title'] = 'updated';
    $dat[4]['width'] = '8%;';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '8%;';
    jrCore_page_table_header($dat);
    unset($dat);

    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {

        $_ty = jrBanned_get_banned_types();
        $_rp = array(
            '(' => '<br><small>(',
            ')' => ')</small>'
        );
        // Each Entry
        foreach ($_rt['_items'] as $_ban) {

            $dat = array();
            if (strpos($_ty["{$_ban['ban_type']}"], '(')) {
                $ban_type = str_replace(array_keys($_rp), $_rp, $_ty["{$_ban['ban_type']}"]);
            }
            else {
                $ban_type = $_ty["{$_ban['ban_type']}"];
            }
            $dat[1]['title'] = $ban_type;
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = $_ban['ban_value'];
            if ($_ban['ban_partial'] == 'on') {
                $dat[2]['title'] .= "<br><small>(substring)</small>";
            }
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = nl2br($_ban['ban_note']);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_format_time($_ban['ban_updated']);
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrCore_page_button("d{$_ban['ban_id']}", 'delete', "jrCore_confirm('Delete entry?', 'Are you sure you want to delete this entry?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/ban_item_delete_save/id={$_ban['ban_id']}/p={$_post['p']}{$add}') } )");
            $dat[5]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt, $_ex);
    }
    else {
        $dat = array();
        if (!empty($_post['search_string'])) {
            $dat[1]['title'] = '<p>There were no Banned Items found to match your search criteria</p>';
        }
        else {
            $dat[1]['title'] = '<p>There are no banned items</p>';
        }
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    jrCore_page_section_header('Create a new Banned Item');

    $_tmp = array(
        'submit_value'     => 'create new banned item',
        'cancel'           => 'referrer',
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Type
    $_opt = jrBanned_get_banned_types();
    $_tmp = array(
        'name'     => 'ban_type',
        'label'    => 'type',
        'help'     => 'Select the Type of Banned Item you would like to create.',
        'type'     => 'select',
        'options'  => $_opt,
        'value'    => 'ip',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Value
    $_tmp = array(
        'name'      => 'ban_value',
        'label'     => 'match value(s)',
        'help'      => jrBanned_get_type_help(),
        'type'      => 'textarea',
        'ban_check' => false,
        'validate'  => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    // Match Sub String
    $_tmp = array(
        'name'     => 'ban_partial',
        'label'    => 'match substring',
        'help'     => 'If you have selected <b>' . $_opt['name'] . '</b>, <b>' . $_opt['email'] . '</b> or <b>' . $_opt['word'] . '</b> as the Type, check this to enable matching sub strings of the value entered.',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Admin Note
    $_tmp = array(
        'name'     => 'ban_note',
        'type'     => 'textarea',
        'validate' => 'printable',
        'label'    => 'note',
        'help'     => 'You can save a note about this banned item entry',
        'default'  => ''
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
