<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_update_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Validate all incoming posted data
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrAudio');

    // Make sure we get a good _item_id
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 20);
        jrCore_form_result();
    }

    // Get data
    if (!$_ex = jrCore_db_get_item('jrAudio', $_post['id'])) {
        // Item does not exist....
        jrCore_set_form_notice('error', 20);
        jrCore_form_result();
    }
    // Make sure the calling user has permission to edit this item
    if (!jrUser_can_edit_item($_ex)) {
        jrUser_not_authorized();
    }

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_sv = jrCore_form_get_save_data('jrAudio', 'update', $_post);

    // Add in our SEO URL names
    $_sv['audio_title_url'] = jrCore_url_string($_sv['audio_title']);
    $_sv['audio_album_url'] = jrCore_url_string($_sv['audio_album']);
    $_sv['audio_genre_url'] = jrCore_url_string($_sv['audio_genre']);

    // We don't want to show this audio file in lists and on the site if
    // it is being converted - set our active flag to 0 if we're converting
    if (jrCore_get_uploaded_media_files('jrAudio', 'audio_file')) {
        // We have a new incoming audio file - hide during conversion
        $_sv['audio_active'] = 'off';
    }

    // Save all updated fields to the Data Store
    jrCore_db_update_item('jrAudio', $_post['id'], $_sv);

    // Save any new files
    jrCore_save_all_media_files('jrAudio', 'update', $_user['user_active_profile_id'], $_post['id']);

    // Delete existing album ZIP file...
    jrAudio_delete_album_zip_file($_user['user_active_profile_id'], $_ex['audio_album_url']);

    // Check for uploaded files and convert
    // @note: We have to grab the item again here since it will now contain
    // keys for any files uploaded since jrCore_save_all_media_files has run
    if ($_rt = jrCore_db_get_item('jrAudio', $_post['id'], true)) {

        // Go through each uploaded file and see if we need to convert
        $_supported = jrAudio_get_audio_types();
        foreach ($_rt as $k => $v) {
            if (strpos($k, '_extension') && isset($_supported[$v]) && !strpos($k, 'original')) {
                // This is an uploaded media file we support - see if it is a NEW one
                // @note We skip the "original" since it will be tagged in the non-original as well
                $field  = str_replace('_extension', '', $k);
                $_queue = array(
                    'item_id' => $_post['id'],
                    'field'   => $field
                );
                if (isset($_ex[$k]) && $_ex["{$field}_time"] == $_rt["{$field}_time"]) {
                    // Looks like we are just updating
                    $_queue['update'] = 1;
                }
                jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);
            }
        }
    }
    jrCore_run_module_function('jrAction_save', 'update', 'jrAudio', $_post['id']);
    jrCore_form_delete_session();
    jrProfile_reset_cache($_user['user_active_profile_id'], 'jrAudio');
    jrCore_form_result(jrCore_get_base_url() . "/{$_user['profile_url']}/{$_post['module_url']}/{$_post['id']}/{$_sv['audio_title_url']}");
}
