<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_album_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_update_album_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrAudio');

    // get all audio entries in this album
    $_sc = array(
        'search'         => array(
            "audio_album_url = {$_post['existing_url']}",
            "_profile_id = {$_user['user_active_profile_id']}"
        ),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'limit'          => 1000
    );
    $_rt = jrCore_db_search_items('jrAudio', $_sc);
    if (!is_array($_rt) || !is_array($_rt['_items'])) {
        jrCore_set_form_notice('error', 62);
        jrCore_form_result();
    }

    // Delete existing album ZIP file...
    jrAudio_delete_album_zip_file($_user['user_active_profile_id'], $_post['existing_url']);

    // Get our posted data - the jrCore_form_get_save_data function will
    // return just those fields that were presented in the form.
    $_sv                    = jrCore_form_get_save_data('jrAudio', 'update_album', $_post);
    $_sv['audio_album_url'] = jrCore_url_string($_post['audio_album']);
    $_sv['audio_genre_url'] = jrCore_url_string($_post['audio_genre']);

    // See if we have an image
    $iid    = 0;
    $_im    = false;
    $_image = jrCore_get_uploaded_media_files('jrAudio', 'audio_image');
    foreach ($_rt['_items'] as $_af) {

        // After the image has been assigned to the first audio file
        // it will no longer be available for the remaining files - copy
        if (is_array($_im) && !isset($_sv['audio_image_size'])) {
            foreach ($_im as $k => $v) {
                if (strpos($k, 'audio_image_') === 0) {
                    $_sv[$k] = $v;
                }
            }
        }
        if (!jrCore_db_update_item('jrAudio', $_af['_item_id'], $_sv)) {
            jrCore_set_form_notice('error', 'unable to update audio file in DataStore!');
            jrCore_form_result();
        }

        // Copy image over
        if (is_array($_im)) {
            $ext = $_im['audio_image_extension'];
            jrCore_copy_media_file($_user['user_active_profile_id'], "jrAudio_{$iid}_audio_image.{$ext}", "jrAudio_{$_af['_item_id']}_audio_image.{$ext}");
        }
        else {
            // For the FIRST album file we can simply save the image for it
            if (jrCore_save_media_file('jrAudio', $_image[0], $_user['user_active_profile_id'], $_af['_item_id'])) {
                // Grab the updated audio info - we need this to create
                // the DS keys on subsequent audio files
                $_im = jrCore_db_get_item('jrAudio', $_af['_item_id'], true, true);
                $iid = $_af['_item_id'];
            }
        }

        // Pass to update queue
        $_queue = array(
            'item_id' => $_af['_item_id'],
            'field'   => 'audio_file',
            'update'  => 1
        );
        jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);

        // Add the FIRST AUDIO to our actions...
        if (!isset($action_saved)) {
            jrCore_run_module_function('jrAction_save', 'update_album', 'jrAudio', $_af['_item_id']);
            $action_saved = true;
        }
    }
    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrCore_form_result(jrCore_get_base_url() . "/{$_user['profile_url']}/{$_post['module_url']}/albums/{$_sv['audio_album_url']}");
}
