<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: tag_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_tag_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_modal_notice('update', "Tagging Audio Files - please be patient");
    ini_set('max_execution_time', 82800); // 23 hours max

    // Get Audio files and create queue entries
    $num = 0;
    $lid = 0;
    while (true) {
        $_sp = array(
            'search'              => array(
                "_item_id > {$lid}"
            ),
            'order_by'            => array(
                '_item_id' => 'asc'
            ),
            'skip_all_checks'     => true,
            'return_item_id_only' => true,
            'limit'               => 100
        );
        if (isset($_post['convert_quotas']) && jrCore_checktype($_post['convert_quotas'], 'number_nz')) {
            $_sp['search'][] = "profile_quota_id = {$_post['convert_quotas']}";
        }
        $_sg = jrCore_db_search_items('jrAudio', $_sp);
        if ($_sg && is_array($_sg)) {
            foreach ($_sg as $iid) {
                $_queue = array(
                    'item_id' => $iid,
                    'field'   => 'audio_file',
                    'update'  => 1
                );
                jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);
                $lid = (int) $iid;
                $num++;
            }
            jrCore_form_modal_notice('update', "Submitted {$num} ID3 tag queue entries");
        }
        else {
            break;
        }
    }
    jrCore_form_modal_notice('update', "Submitted {$num} ID3 tag queue entries");
    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', "{$num} audio files were submitted for tagging");
    jrCore_exit();
}
