<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: tag
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_tag($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrAudio');
    jrCore_page_banner("Update ID3 Audio Tags");

    if (!isset($_post['quota_id']) || !jrCore_checktype($_post['quota_id'], 'number_nz')) {
        $num = jrCore_db_number_rows('jrAudio', 'item');
        $qid = 0;
    }
    else {
        $_sc = array(
            'quota_id'       => (int) $_post['quota_id'],
            'return_count'   => true,
            'ignore_pending' => true,
            'privacy_check'  => false,
            'limit'          => 1000000
        );
        $num = jrCore_db_search_items('jrAudio', $_sc);
        $qid = (int) $_post['quota_id'];
    }
    if (!jrCore_checktype($num, 'number_nn')) {
        $num = 0;
    }

    $workers = jrCore_get_config_value('jrAudio', 'conversion_worker_count', 1);
    jrCore_page_note("The Audio ID3 Tag tool will create audio ID3 tag queue entries for the audio files selected.<br><br><strong>Tag Workers: {$workers} &nbsp; &nbsp; Total Audio Files Selected: {$num}</strong>");

    // Form init
    $url  = jrCore_get_module_url('jrCore');
    $url  = jrCore_get_base_url() . "/{$url}/dashboard/queue_viewer/queue_module=jrAudio/queue_name=audio_update";
    $_tmp = array(
        'submit_value'  => 'submit audio for tagging',
        'submit_prompt' => 'Are you sure you want to update the ID3 Tags on the audio files? Please be patient - on large systems this could take some time.',
        'cancel'        => 'referrer',
        'submit_modal'  => 'update',
        'modal_width'   => 600,
        'modal_height'  => 400,
        'modal_note'    => 'Creating Audio File Tag Queue Entries',
        'modal_close'   => 'view ID3 tag queue',
        'modal_onclick' => "jrCore_window_location('{$url}')"
    );
    jrCore_form_create($_tmp);

    // Select Quota
    $_qt  = array(
        '0' => 'All Quotas'
    );
    $_qt  = $_qt + jrProfile_get_quotas();
    $_tmp = array(
        'name'     => 'convert_quotas',
        'label'    => 'Quota',
        'help'     => 'If you want to tag the audio files for a specific quota, select the quota here.',
        'type'     => 'select',
        'options'  => $_qt,
        'value'    => $qid,
        'default'  => '0',
        'validate' => 'number_nn',
        'onchange' => "var v=this.options[this.selectedIndex].value; jrCore_window_location('" . jrCore_get_base_url() . "/{$_post['module_url']}/tag/quota_id='+ v)"
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
